---
title: Неявные импорты
titleTemplate: :title · Inspect · Develop · Guides · Tuist
description: Узнайте, как использовать Tuist для обнаружения неявных импортов.
---

# Неявные импорты {#implicit-imports}

Чтобы снизить сложность поддержания графа проекта Xcode, Apple спроектировала систему сборки таким образом, что зависимости могут быть определены неявно. Это означает, что продукт, например приложение, может зависеть от фреймворка, даже без явного указания этой зависимости. В небольших проектах это не вызывает проблем, но по мере увеличения сложности графа проекта неявные зависимости могут приводить к ненадежной инкрементальной сборке или проблемам в функциях редактора, таких как предварительный просмотр или автодополнение кода.

Проблема в том, что невозможно полностью предотвратить возникновение неявных зависимостей. Любой разработчик может добавить оператор `import` в свой код на Swift, и будет создана неявная зависимость. И здесь на помощь приходит Tuist. Tuist предоставляет команду для проверки неявных зависимостей посредством статического анализа кода в вашем проекте. Следующая команда выведет неявные зависимости вашего проекта:

```bash
tuist inspect implicit-imports
```

Если команда обнаружит какие-либо неявные импорты, она завершится с кодом выхода, отличным от нуля.

> [!СОВЕТ] ВАЛИДАЦИЯ В CI
> Мы настоятельно рекомендуем запускать эту команду как часть процесса<LocalizedLink href="/guides/develop/automate/continuous-integration"> непрерывной интеграции</LocalizedLink> каждый раз, когда новый код отправляется в основную ветку.

> [!ВАЖНО] НЕ ВСЕ НЕЯВНЫЕ СЛУЧАИ ОБНАРУЖИВАЮТСЯ
> Поскольку Tuist полагается на статический анализ кода для обнаружения неявных зависимостей, он может не выявить все случаи. Например, Tuist не может обработать условные импорты, которые выполняются через директивы компилятора в коде.
