---
title: Код ревью
titleTemplate: :title · Участникам проекта · Tuist
description: Узнайте, как внести вклад в Tuist, проводя ревью на пулл-реквесты
---

# Код ревью {#code-reviews}

Просмотр пулл-реквестов — это распространенный способ внесения вклада. Несмотря на то, что непрерывная интеграция (CI) гарантирует выполнение кода в соответствии с его задачами, этого всё же недостаточно. Существуют аспекты вклада, которые невозможно автоматизировать: дизайн, структура и архитектура кода, качество тестов или опечатки. Следующие разделы представляют различные аспекты процесса код ревью.

## Читаемость

Ясно ли код выражает свои намерения? **Если вам нужно потратить много времени на то, чтобы понять, что делает код, его реализацию следует улучшить.** Предложите разделить код на более мелкие абстракции, которые проще понять. В качестве альтернативы, и как крайнюю меру, они могут добавить комментарий, объясняющий логику кода. Спросите себя, сможете ли вы понять этот код в ближайшем будущем без какого-либо контекста, например, описания пулл-реквеста.

## Маленькие пулл-реквесты {#small-pull-requests}

Большие пулл-реквесты сложно рецензировать, и легче упустить детали. Если пулл-реквест становится слишком большим и неуправляемым, предложите автору разбить его на более мелкие части.

> [!NOTE] Исключения
> Существуют некоторые сценарии, когда разбить pull request невозможно, например, когда изменения тесно связаны и не могут быть разделены. В таких случаях автор должен предоставить четкое объяснение изменений и причин, стоящих за ними.

## Согласованность {#consistency}

Важно, чтобы изменения были согласованы с остальной частью проекта. Несоответствия усложняют обслуживание, поэтому их следует избегать. Если в проекте уже есть подход к выводу сообщений или показу ошибок, нам следует придерживаться его. Если автор не согласен со стандартами проекта, предложите ему открыть проблему в разделе "Issues", чтобы мы могли обсудить их более подробно.

## Тесты {#tests}

Тесты позволяют быть уверенным в написанном коде. Код в пулл-реквестах должен быть протестирован, и все тесты должны пройти успешно. Хороший тест — это тот, который стабильно дает один и тот же результат, а также является легким для понимания и сопровождения. Ревьюеры проводят большую часть времени, рассматривая код реализации, но тесты не менее важны, потому что они тоже являются кодом.

## Изменения, нарушающие обратную совместимость {#breaking-changes}

Изменения, нарушающие обратную совместимость, создают плохой пользовательский опыт для пользователей Tuist. Пулл-реквесты в проект должны избегать введения изменений, нарушающих обратную совместимость, если это не строго необходимо. Существует множество возможностей языка, которые мы можем использовать для развития интерфейса Tuist, не прибегая к изменениям, нарушающим обратную совместимость. Не всегда очевидно, нарушает ли изменение обратную совместимость. Один из способов проверить, является ли изменение нарушающим обратную совместимость, — это запустить Tuist на тестовых проектах в каталоге fixtures. Это требует от нас поставить себя на место пользователя и представить, как изменения повлияют на его работу.
