---
title: Principles
titleTemplate: :title · Contributors · Tuist
description: 이 문서는 Tuist의 개발을 위한 원칙을 설명합니다.
---

# Principles {#principles}

이 페이지는 Tuist의 디자인과 개발의 기둥이 되는 원칙을 설명합니다. 이것은 프로젝트와 함께 발전하고 프로젝트 기반과 잘 부합하는 지속 가능한 성장을 보장하기 위한 것입니다.

## 기본 규칙 {#default-to-conventions}

Tuist가 존재하는 이유 중에 하나는 Xcode가 규칙이 약해 확장과 유지 보수가 어려운 복잡한 프로젝트를 생성하기 때문입니다. 이런 이유로 Tuist는 간단하고 철저하게 설계된 규칙을 기본적으로 사용합니다. **개발자는 규칙을 제외할 수 있지만, 그것은 자연스럽지 않습니다.**

예를 들어, 제공된 인터페이스를 사용하여 타겟의 의존성을 정의하는 규칙이 있습니다. 이를 통해 Tuist는 제대로 된 구성으로 프로젝트가 생성되도록 보장합니다. 개발자는 빌드 설정으로 의존성을 정의할 수 있지만, 이것은 암묵적으로 정의하므로 일부 규칙을 따라야 하는 `tuist graph` 또는 `tuist cache` 와 같은 Tuist 기능의 규칙에 어긋납니다.

규칙을 따라야 하는 이유는 개발자를 대신해서 많은 결정을 해주면 개발자는 앱의 기능을 만드는데 더 집중할 수 있기 때문입니다. 많은 프로젝트에서 규칙이 없다면, 이전에 결정한 사항과 일관성 없는 결정을 하게 되고 결과적으로 관리하기 어렵게 됩니다.

## Manifest는 진실 공급원 {#manifests-are-the-source-of-truth}

여러 층을 가지는 구성과 그 구성 간의 계약은 프로젝트 설정을 이해하고 유지하기 어렵게 만듭니다. 일반적인 프로젝트를 생각해 봅시다. 프로젝트의 정의는 `.xcodeproj ` 디렉토리, 스크립트 (예: `Fastfiles `) 에 CLI, 파이프라인에 CI 로직이 있습니다. 이 세 가지 층은 서로의 계약을 유지해야 합니다. _프로젝트에서 무언가 변경하고 일주일 후에 릴리즈 스크립트가 손상되었다고 깨달은 적이 얼마나 자주 있었습니까?_

우리는 단일 진실 공급원 인 Manifest 파일로 이것을 단순하게 변경할 수 있습니다. 이 파일은 개발자가 Xcode 프로젝트를 생성하는데 필요한 정보를 Tuist에 제공합니다. 게다가, 로컬 또는 CI 환경에서 프로젝트를 빌드하기 위한 표준 명령어를 사용할 수 있습니다.

**Tuist는 복잡한 설정을 관리하고 가능한 프로젝트를 명확하게 설명하기 위해 간단하고 안전하며 즐거운 인터페이스를 제공해야 합니다.**

## 암시적인 것을 명시적으로 만들기 {#make-the-implicit-explicit}

Xcode는 함축적 구성을 제공합니다. 그 좋은 예는 암시적으로 정의된 의존성을 유추하는 것입니다. 암시성은 구성이 간단한 작은 프로젝트에서는 좋지만, 프로젝트가 커질 수록 느리거나 이상한 동작을 야기 시킵니다.

Tuist는 Xcode의 함축적 동작에 대해 명시적으로 API를 제공해야 합니다. 또한, Xcode 암시적 정의를 지원하지만 개발자가 명시적 접근 방식을 선택하도록 구현해야 합니다. Xcode 암시성과 복잡성을 모두 제공하면 Tuist 채택이 용이해지고, 나중에 팀은 암시성을 제거하는 시간을 할애할 수 있습니다.

이것의 좋은 예는 의존성 정의입니다. 개발자는 Build Settings과 Build Phases에서 의존성 정의를 할 수 있지만, Tuist는 더 좋은 API를 제공합니다.

**API를 명시적으로 설계하면 그렇지 않은 프로젝트에서 불가능한 일부 검사와 최적화를 Tuist가 수행할 수 있습니다.** 게다가, 의존성 그래프를 표현하는 `tuist graph` 또는 바이너리로 모든 타겟을 캐시하는 `tuist cache` 와 같은 기능을 사용할 수 있습니다.

> [!TIP]\
> Xcode의 기능을 이식해 달라는 요청은 간단하고 명확한 API를 통해 개념을 단순화할 수 있는 기회로 여겨야 합니다.

## 단순함을 유지 {#keep-it-simple}

Xcode 프로젝트를 확장할 때 주요 과제 중 하나는 **Xcode가 사용자에게 많은 복잡성을 보인다는** 사실에서 비롯됩니다. 이로 인해, 팀은 높은 버스 팩터를 가지고 팀에 일부 인원만 프로젝트와 빌드 시스템에서 발생하는 오류를 이해합니다. 이러한 상황은 팀이 소수 인원에 의지하게 되므로 좋지 않은 상황입니다.

Xcode는 훌륭한 툴이지만, 수 년간의 개선과 새로운 플랫폼, 그리고 프로그래밍 언어가 반영되면서 단순함을 유지하는데 어려움을 겪었습니다.

Tuist는 간단한 업무는 재미와 동기부여를 하기 때문에 단순함을 유지해야 합니다. 어느 누구도 컴파일 마지막에 발생한 오류를 디버깅 하거나 단말에 앱이 실행되지 않는 이유를 이해하는데 시간을 할애하고 싶어 하지 않습니다. Xcode는 해당 작업을 빌드 시스템에 위임하고 어떤 경우에는 오류를 실행 가능하도록 변환하는데 매우 형편 없습니다. _"framework X not found"_ 오류가 발생하여 어떻게 해야 할지 모르는 경우가 있었습니까? 해당 버그에 대해 가능한 근본 원인을 받았다고 상상해 보시기 바랍니다.

## 개발자의 경험에서 시작 {#start-from-the-developers-experience}

Xcode의 혁신이 부족하거나 다른 프로그래밍 환경보다 많지 않은 이유 중 하나는 **기존 해결책에서 문제 분석을 시작하기** 때문입니다. 그 결과로 오늘날 찾은 대부분의 해결책은 동일한 아이디어와 워크플로우를 중심으로 돌아갑니다. 기존 해결책을 포함하는 것은 좋지만, 이것이 우리의 창의성을 제한하면 안됩니다.

우리는 [Tom Preston](https://tom.preston-werner.com/)이 [팟캐스트](https://tom.preston-werner.com/)에서 말한 것처럼 생각하고 싶어합니다: _"대부분의 일은 머릿속에 있는 것은 무엇이든 우주의 제약 내에서 코드로 이룰 수 있습니다"._ **개발자 경험이 어떤지 상상한다면** 실현하는 것은 시간 문제입니다 — 개발자 경험으로 문제를 분석하기 시작하면 사용자가 사용하고 싶은 해결책을 찾을 수 있습니다.

모든 사람이 계속해서 불평을 가지는 불편함이더라도 우리는 모두가 하는 것을 따르고 싶은 유혹을 느낄 수 있습니다. 그러면 안됩니다. 앱을 아카이브 한다고 상상해 보시기 바랍니다. 어떻게 해야 할까요? 코드 서명은 어떻게 하면 좋을까요? Tuist로 어떤 프로세스를 간소화 할 수 있을까요? 예를 들어, [Fastlane](https://fastlane.tools/)을 추가하는 것은 이 문제에 대한 해결책 입니다. 우리는 "왜"라는 질문을 통해 문제의 근원을 찾을 수 있습니다. 이 질문으로 범위가 좁혀지면 Tuist가 어떻게 도움을 줄 수 있는지 생각해 볼 수 있습니다. 해결책이 Fastlane과 통합하는 것일 수도 있지만, 절충안을 결정하기 전에 제시할 수 있는 다른 해결책을 무시하지 않는 것이 중요합니다.

## 오류 발생 가능성 {#errors-can-and-will-happen}

개발자들은 오류가 발생 여부를 무시하고 싶은 유혹이 있습니다. 그 결과, 이상적인 시나리오로 소프트웨어를 설계하고 테스트 합니다.

Swift와 잘 설계된 코드는 일부 오류를 막는데 도움을 주지만, 일부 오류는 제어가 불가능하기 때문에 모든 오류를 막을 수는 없습니다. 사용자가 항상 인터넷이 연결되어 있거나 시스템 명령이 성공적으로 반환할 것이라고 생각할 수 없습니다. Tuist가 실행되는 환경은 우리가 제어할 수 있는 샌드박스 환경이 아니므로 Tuist가 어떻게 변경되고 영향을 받을 수 있는지 이해해야 합니다.

오류를 제대로 처리하지 못하면 사용자에게 안좋은 경험을 제공하고, 프로젝트의 신뢰를 잃을 수 있습니다. 우리는 Tuist의 오류를 표현하는 방식을 포함하여 모든 부분을 사용자가 즐기길 바랍니다.

우리는 사용자의 입장에서 생각해야 하고, 무슨 오류가 나타날지 생각해야 합니다. 프로그래밍 언어는 오류를 전파하는 통신 채널이고 오류의 목적지가 사용자라면 오류는 타겟 (사용자) 이 사용하는 언어로 작성되어야 합니다. 무엇이 일어나는지 알 수 있게 충분한 정보를 포함해야 하며 상관없는 정보는 숨겨야 합니다. 또한 사용자에게 복구하기 위해 취할 수 있는 단계를 알려줌으로써 조치가 가능해야 합니다.

그리고 마지막으로 테스트 케이스로 실패 시나리오를 고려해야 합니다. 그것은 오류를 제대로 처리하는지 확인할 뿐만 아니라, 개발자가 해당 논리를 깨는 것을 방지합니다.
