---
title: Directory structure
titleTemplate: :title · Projects · Develop · Guides · Tuist
description: Learn about the structure of Tuist projects and how to organize them.
---

# Directory structure {#directory-structure}

Although Tuist projects are commonly used to supersede Xcode projects, they are not limited to this use case. Tuist projects are also used to generate other types of projects, such as SPM packages, templates, plugins, and tasks. This document describes the structure of Tuist projects and how to organize them. In later sections, we'll cover how to define templates, plugins, and tasks.

## Standard Tuist projects {#standard-tuist-projects}

Tuist projects are **the most common type of project generated by Tuist.** They are used to build apps, frameworks, and libraries among others. Unlike Xcode projects, Tuist projects are defined in Swift, which makes them more flexible and easier to maintain. Tuist projects are also more declarative, which makes them easier to understand and reason about. The following structure shows a typical Tuist project that generates an Xcode project:

```bash
Tuist.swift
Tuist/
  Package.swift
  ProjectDescriptionHelpers/
Projects/
  App/
    Project.swift
  Feature/
    Project.swift
Workspace.swift
```

- **Tuist directory:** This directory has two purposes. First, it signals **where the root of the project is**. This allows constructing paths relative to the root of the project, and also also running Tuist commands from any directory within the project. Second, it's the container for the following files:
  - **ProjectDescriptionHelpers:** This directory contains Swift code that's shared across all the manifest files. Manifest files can `import ProjectDescriptionHelpers` to use the code defined in this directory. Sharing code is useful to avoid duplications and ensure consistency across the projects.
  - **Package.swift:** This file contains Swift Package dependencies for Tuist to integrate them using Xcode projects and targets (like [CocoaPods](https://cococapods)) that are configurable and optimizable. Learn more <LocalizedLink href="/guides/develop/projects/dependencies">here</LocalizedLink>.

- **Root directory**: The root directory of your project that also contains the `Tuist` directory.
  - <LocalizedLink href="/guides/develop/projects/manifests#tuistswift"><bold>Tuist.swift:</bold></LocalizedLink> This file contains configuration for Tuist that's shared across all the projects, workspaces, and environments. For example, it can be used to disable automatic generation of schemes, or to define the deployment target of the projects.
  - <LocalizedLink href="/guides/develop/projects/manifests#workspace-swift"><bold>Workspace.swift:</bold></LocalizedLink> This manifest represents an Xcode workspace. It's used to group other projects and can also add additional files and schemes.
  - <LocalizedLink href="/guides/develop/projects/manifests#project-swift"><bold>Project.swift:</bold></LocalizedLink> This manifest represents an Xcode project. It's used to define the targets that are part of the project, and their dependencies.

When interacting with the above project, commands expect to find either a `Workspace.swift` or a `Project.swift` file in the working directory or the directory indicated via the `--path` flag. The manifest should be in a directory or subdirectory of a directory containing a `Tuist` directory, which represents the root of the project.

> [!TIP]
> Xcode workspaces allowed splitting projects into multiple Xcode projects to reduce the likelihood of merge conflicts. If that's what you were using workspaces for, you don't need them in Tuist. Tuist auto-generates a workspace containing a project and its dependencies' projects.

## Swift Package <Badge type="warning" text="beta" /> {#swift-package-badge-typewarning-textbeta-}

Tuist also supports SPM package projects. If you are working on an SPM package, you shouldn't need to update anything. Tuist automatically picks up on your root `Package.swift` and all the features of Tuist work as if it was a `Project.swift` manifest.

To get started, run `tuist install` and `tuist generate` in your SPM package. Your project should now have all the same schemes and files that you would see in the vanilla Xcode SPM integration. However, now you can also run <LocalizedLink href="/guides/develop/build/cache">`tuist cache`</LocalizedLink> and have majority of your SPM dependencies and modules precompiled, making subsequent builds extremely fast.
