import Foundation
import Path
import ProjectDescription
import TuistCore
import TuistSupport
import XcodeGraph
import XCTest

@testable import TuistLoader
@testable import TuistSupportTesting

final class CodeCoverageManifestMapperTests: TuistUnitTestCase {
    private typealias Manifest = ProjectDescription.Workspace.GenerationOptions.AutogeneratedWorkspaceSchemes.CodeCoverageMode

    func test_from_returnsTheCorrectValue_whenManifestIsAll() throws {
        // Given
        let temporaryPath = try temporaryPath()
        let rootDirectory = temporaryPath
        let generatorPaths = GeneratorPaths(
            manifestDirectory: temporaryPath,
            rootDirectory: rootDirectory
        )
        let manifest = Manifest.all

        // When
        let got = try XcodeGraph.Workspace.GenerationOptions.AutogeneratedWorkspaceSchemes.CodeCoverageMode
            .from(manifest: manifest, generatorPaths: generatorPaths)

        // Then
        XCTAssertEqual(.all, got)
    }

    func test_from_returnsTheCorrectValue_whenManifestIsRelevant() throws {
        // Given
        let temporaryPath = try temporaryPath()
        let rootDirectory = temporaryPath
        let generatorPaths = GeneratorPaths(
            manifestDirectory: temporaryPath,
            rootDirectory: rootDirectory
        )
        let manifest = Manifest.relevant

        // When
        let got = try XcodeGraph.Workspace.GenerationOptions.AutogeneratedWorkspaceSchemes.CodeCoverageMode
            .from(manifest: manifest, generatorPaths: generatorPaths)

        // Then
        XCTAssertEqual(.relevant, got)
    }

    func test_from_returnsTheCorrectValue_whenManifestIsTargets() throws {
        // Given
        let temporaryPath = try temporaryPath()
        let rootDirectory = temporaryPath
        let generatorPaths = GeneratorPaths(
            manifestDirectory: temporaryPath,
            rootDirectory: rootDirectory
        )
        let targetRef = ProjectDescription.TargetReference.target("Target")
        let manifest = Manifest.targets([targetRef])

        // When
        let got = try XcodeGraph.Workspace.GenerationOptions.AutogeneratedWorkspaceSchemes.CodeCoverageMode
            .from(manifest: manifest, generatorPaths: generatorPaths)

        // Then
        XCTAssertEqual(
            got,
            .targets([
                TargetReference(
                    projectPath: try generatorPaths.resolveSchemeActionProjectPath(nil),
                    name: "Target"
                ),
            ])
        )
    }
}
