import Foundation
import Path
import TSCUtility
import TuistAutomation
import TuistCore
import TuistDependencies
import TuistGenerator
import XcodeGraph

protocol WorkspaceMapperFactorying {
    /// Returns the default workspace mapper.
    /// - Returns: A workspace mapping instance.
    func `default`() -> [WorkspaceMapping]

    /// Returns a mapper for automation commands like build and test.
    /// - Parameter config: The project configuration.
    /// - Returns: A workspace mapping instance.
    func automation() -> [WorkspaceMapping]
}

public final class WorkspaceMapperFactory: WorkspaceMapperFactorying {
    private let projectMapper: ProjectMapping

    public init(projectMapper: ProjectMapping) {
        self.projectMapper = projectMapper
    }

    func automation() -> [WorkspaceMapping] {
        var mappers: [WorkspaceMapping] = []
        mappers += self.default(forceWorkspaceSchemes: true)

        return mappers
    }

    func `default`() -> [WorkspaceMapping] {
        self.default(forceWorkspaceSchemes: false)
    }

    public func `default`(forceWorkspaceSchemes: Bool) -> [WorkspaceMapping] {
        var mappers: [WorkspaceMapping] = []

        mappers.append(
            ProjectWorkspaceMapper(mapper: projectMapper)
        )

        mappers.append(
            TuistWorkspaceIdentifierMapper()
        )

        mappers.append(
            TuistWorkspaceRenderMarkdownReadmeMapper()
        )

        mappers.append(
            IDETemplateMacrosMapper()
        )

        mappers.append(
            AutogeneratedWorkspaceSchemeWorkspaceMapper(forceWorkspaceSchemes: forceWorkspaceSchemes)
        )

        mappers.append(
            LastUpgradeVersionWorkspaceMapper()
        )

        mappers.append(ExternalDependencyPathWorkspaceMapper())

        return mappers
    }
}
