/// Options to configure testing of autogenerated schemes.
public struct TestingOptions: OptionSet, Codable, Equatable, Sendable {
    public let rawValue: Int

    public init(rawValue: Int) {
        self.rawValue = rawValue
    }

    /// Run tests on multiple destinations in parallel
    public static let parallelizable = TestingOptions(rawValue: 1 << 0)
    /// Execute tests in random order
    public static let randomExecutionOrdering = TestingOptions(rawValue: 1 << 1)
}
