<div align="center">
  <div>
    <a href="https://tuist.io" target="_blank"><img src="assets/header.jpg" alt="header"/></a>
  </div>
  <img src="https://api.codemagic.io/apps/65ca555c190cfbe9f5dd792f/unit_tests/status_badge.svg" alt="CI status">
  <img src="https://img.shields.io/github/commit-activity/w/tuist/tuist?style=flat-square&label=commits" alt="Commit Activity">
  <a href="https://fosstodon.org/@tuist"><img src="https://img.shields.io/badge/tuist-gray.svg?logo=mastodon&logoColor=f5f5f5" alt="Mastodon badge"></a>
  <a href="https://bsky.app/profile/tuist.dev"><img src="https://img.shields.io/badge/tuist-gray.svg?logo=bluesky" alt="Bluesky badge"></a>
  <a href="https://join.slack.com/t/tuistapp/shared_invite/zt-1lqw355mp-zElRwLeoZ2EQsgGEkyaFgg"><img src="https://img.shields.io/badge/tuist-gray.svg?logo=slack" alt="Slack Workspace"></a>
  <a href="https://t.me/tuist"><img src="https://img.shields.io/badge/tuist-gray.svg?logo=telegram" alt="Slack Workspace"></a>
  <div>
    <a href="https://cal.com/team/tuist/cloud?utm_source=banner&utm_campaign=oss" target="_blank"><img alt="Book us with Cal.com" src="https://cal.com/book-with-cal-dark.svg" width="150"/></a>
  </div>
  <a title="Crowdin" target="_blank" href="https://crowdin.com/project/tuist-documentation"><img src="https://badges.crowdin.net/tuist-documentation/localized.svg"></a>
</div>

## 🕺 What's Tuist

Tuist is a command line tool that leverages **_project generation_** to abstract intricacies of Xcode projects, and uses it as a foundation to help teams **_maintain_** and **_optimize_** their large modular projects.

It's open source and written in Swift.

## ⬇️ Install

The recommended installation method is to [install mise](https://mise.jdx.dev/getting-started.html#quickstart) and then run `mise install tuist` to install Tuist.

You can check out [the documentation](https://docs.tuist.io/guides/quick-start/install-tuist) to learn more about the rationale behind our installation approach and alternative approaches.

## 🌀 Bootstrap your first project

```bash
tuist init --platform ios
tuist edit # Customize your project manifest
tuist generate # Generates Xcode project & workspace
tuist build # Builds your project
```

Check out [the project "Create a new project" guide](https://docs.tuist.io/guides/start/new-project) to learn more about Tuist and all its features.

## 📝 Documentation

Do you want to know more about what Tuist can offer you? Or perhaps want to contribute to the project and you need a starting point?

You can check out [the project documentation](https://docs.tuist.io).

### 🔬 Sample projects

You can find some sample projects in the [fixtures folder](fixtures) or the [awesome Tuist repo](https://github.com/tuist/awesome-tuist)! 🎉

## ✅ CI Sponsor

<a href="https://www.codemagic.io?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_term=tuist" target="_blank">
  <img width="140" src="assets/companies/codemagic.svg" alt="codemagic_logo"/>
</a>

[Codemagic](https://codemagic.io), a CI/CD tool for building world-class mobile apps, supports the development of Tuist by providing fast and reliable CI environments.

## 💰 Sponsors

The financial sustainability of the project is possible thanks to the ongoing contributions from our [GitHub Sponsors](https://github.com/sponsors/tuist) and [Open Collective Backers](https://opencollective.com/tuistapp). From them, we'd like to give a special mention to the following sponsors:

### 🥇 Gold Sponsors

<table>
  <tbody>
    <tr>
      <td width="30%" align="center">
        <a href="https://monday.com?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&&utm_term=tuist" target="_blank">
          <img width="300" src="assets/companies/monday.com.svg" alt="mondaycom_logo"/>
        </a>
      </td>
      <td><a href="https://monday.com?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&&utm_term=tuist">Monday.com</a> is a cloud-based work operating system (Work OS) that empowers teams to run projects and workflows with confidence. It's a versatile platform that combines features of project management, workflow automation, and team collaboration to streamline the way teams work together.</td>
    </tr>
    <tr>
      <td width="30%" align="center">
        <a href="https://lapse.com?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&&utm_term=tuist" target="_blank">
          <img width="200" src="assets/companies/lapse.svg" alt="lapse_logo"/>
        </a>
      </td>
      <td><a href="https://lapse.com?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&&utm_term=tuist">Lapse</a> is an app designed to reclaim how we take and share memories. A camera for living in the moment and a private photo journal for friends, not followers.</td>
    </tr>
  </tbody>
</table>

### 🥈 Silver sponsors

<table>
  <tbody>
    <tr>
      <td width="30%" align="center">
        <a href="https://getstream.io/chat/sdk/ios/?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_campaign=Github_Jan2022_SwiftSDK&utm_term=tuist" target="_blank">
          <picture>
            <source
            srcset="assets/companies/stream-darkmode.png"
            media="(prefers-color-scheme: dark)">
            <img src="assets/companies/stream.png" alt="stream_logo"/>
          </picture>
        </a>
      </td>
      <td><a href="https://getstream.io/chat/sdk/ios/?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_campaign=Github_Jan2022_SwiftSDK&utm_term=tuist">Stream</a> helps build scalable in-app chat or activity feeds in days. Product teams trust Stream to launch faster, iterate more often, and ship a better user experience.</td>
    </tr>
    <tr>
      <td width="30%" align="center">
        <a href="https://runway.team?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_term=tuist" target="_blank">
          <img width="140" src="https://global-uploads.webflow.com/5edfa38a1bd219267bdf69b7/60959952ed332b8e9613a0c4_wordmark-runway-black.svg" alt="runway_logo"/>
        </a>
      </td>
      <td><a href="https://www.runway.team">Runway</a> streamlines collaboration and automation for mobile app releases, from kickoff to rollout.</td>
    </tr>
    <tr>
      <td width="30%" align="center">
        <a href="https://www.emergetools.com?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_term=tuist" target="_blank">
          <picture>
            <source
              srcset="assets/companies/emergetools-darkmode.svg"
              media="(prefers-color-scheme: dark)">
            <img width="140" src="assets/companies/emergetools.svg" alt="emerge_logo"/>
          </picture>
        </a>
      </td>
      <td><a href="https://www.emergetools.com">Emerge Tools</a> is a suite of revolutionary products designed to supercharge mobile apps and the teams that build them.</td>
    </tr>
  </tbody>
</table>

### 🥉 Bronze sponsors

<table>
  <tbody>
    <tr>
      <td width="50%" align="center">
        <a href="https://macpaw.com" target="_blank">
          <img src="assets/companies/macpaw.png" alt="macpaw_logo"/>
        </a>
      </td>
      <td width="50%" align="center">
        <a href="https://asana.com" target="_blank">
          <img src="assets/companies/asana.png" alt="asana_logo"/>
        </a>
      </td>
    </tr>
  </tbody>
</table>

## 💪 Companies using Tuist

<table>
  <tbody>
    <tr>
      <td width="20%" align="center">
        <a href="https://play.tv2.no" target="_blank">
          <img src="assets/companies/tv2.svg" alt="tv2_logo" height="75"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://www.depop.com" target="_blank">
          <img src="assets/companies/depop.svg" alt="depop_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://bendingspoons.com" target="_blank">
          <picture>
            <source
              srcset="assets/companies/bendingspoons-darkmode.png"
              media="(prefers-color-scheme: dark)">
            <img src="assets/companies/bendingspoons.png" alt="bendingspoons_logo"/>
          </picture>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://globekeeper.com" target="_blank">
          <img src="assets/companies/globekeeper.png" alt="globekeeper_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://getyourguide.com" target="_blank">
          <img src="assets/companies/getyourguide.png" alt="getyourguide_logo" height="75"/>
        </a>
      </td>
    </tr>
    <tr>
      <td width="20%" align="center">
        <a href="https://emplate.it" target="_blank">
          <img src="assets/companies/emplate.svg" alt="emplate_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://www.trendyol.com" target="_blank">
          <img src="assets/companies/Trendyol.png" alt="trendyol_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://angrynerds.co" target="_blank">
          <img src="assets/companies/angrynerds.svg" alt="angrynerds_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://www.compass.com" target="_blank">
          <img src="assets/companies/compass.png" alt="compass_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://www.wefox.com" target="_blank">
          <img src="assets/companies/wefox.png" alt="wefox_logo"/>
        </a>
      </td>
    </tr>
    <tr>
      <td width="20%" align="center">
        <a href="https://www.hedvig.com" target="_blank">
            <img src="assets/companies/hedvig.svg" alt="hedvig_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://www.takeoutcentral.com" target="_blank">
          <img src="assets/companies/takeoutcentral.svg" alt="takeoutcentral_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://www.olx.com.br" target="_blank">
          <img src="assets/companies/olx.png" alt="olx_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://www.justeattakeaway.com" target="_blank">
          <img src="assets/companies/justeattakeaway.svg" alt="justeattakeaway_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://qnips.io" target="_blank">
          <img src="assets/companies/qnips.svg" alt="qnips_logo"/>
        </a>
      </td>
    </tr>
    <tr>
      <td width="20%" align="center">
        <a href="https://www.telepass.com" target="_blank">
          <img src="assets/companies/telepass.svg" alt="telepass_logo"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://www.crunchyroll.com" target="_blank">
          <img src="assets/companies/crunchyroll.svg" alt="crunchyroll_logo" height="75"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://altel.kz" target="_blank">
          <img src="assets/companies/altel.svg" alt="altel_logo" height="75"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://tele2.kz" target="_blank">
          <img src="assets/companies/tele2.svg" alt="altel_logo" height="75"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://izi.me/kz" target="_blank">
          <img src="assets/companies/izi.svg" alt="izi_logo" height="75"/>
        </a>
      </td>
    </tr>
    <tr>
      <td width="20%" align="center">
        <a href="https://wise.com" target="_blank">
          <img src="assets/companies/wise.png" alt="wise_logo" height="75"/>
        </a>
      </td>
      <td width="20%" align="center">
        <a href="https://zapis.kz/" target="_blank">
          <img src="assets/companies/zapis.svg" alt="wise_logo" height="75"/>
        </a>
      </td>
    </tr>
  </tbody>
</table>

## 🙇‍ ️Supported by great companies

Great companies support the project by giving us access to their service through an open-source program.

<table>
  <tbody>
    <tr>
      <td width="25%" align="center">
        <img src="assets/1Password.png" alt="1password_logo" height="75"/>
      </td>
      <td width="25%" align="center">
        <img src="https://images.typeform.com/images/QKuaAssrFCq7/image/default" alt="bugsnag_logo"/>
      </td>
      <td width="25%" align="center">
        <img src="assets/cal-com.svg" alt="calcom_logo"/>
      </td>
      <td width="25%" align="center">
        <img src="assets/companies/codemagic.svg" alt="codemagic_logo"/>
      </td>
    </tr>
  </tbody>
</table>

## 🧑‍💻 Want to contribute?

You can use our [contribution docs](https://docs.tuist.io/documentation/tuist/get-started-as-contributor) to get started. If you don't have a specific issue in mind, we are more than happy to help you, just ask for help in a given issue or on our [Slack](https://join.slack.com/t/tuistapp/shared_invite/zt-1lqw355mp-zElRwLeoZ2EQsgGEkyaFgg). You can find good issues for first-time contributors [here](https://github.com/tuist/tuist/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22). We also offer [issue bounties](https://console.algora.io/org/tuist) for some highly-valued issues.

## ✨ Core Team

<table>
  <tr>
    <td align="center"><a href="https://github.com/pepicrft"><img src="https://avatars1.githubusercontent.com/u/663605?v=4" width="100px;" alt=""/><br /><sub><b>Pedro Piñera</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/fortmarek"><img src="https://avatars0.githubusercontent.com/u/9371695?v=4" width="100px;" alt=""/><br /><sub><b>Marek Fořt</b></sub></a><br /></td>
    <td align="center"><a href="http://www.matrixprojects.net"><img src="https://avatars3.githubusercontent.com/u/11914919?v=4" width="100px;" alt=""/><br /><sub><b>Kas</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/danyf90"><img src="https://avatars.githubusercontent.com/u/2794031?v=4" width="100px;" alt=""/><br /><sub><b>Daniele Formichelli</b></sub></a><br /></td>
    <td align="center" valign="top" width="14.28%"><a href="https://github.com/waltflanagan"><img src="https://avatars.githubusercontent.com/u/398293?v=4" width="100px;" alt=""/><br /><sub><b>Mike Simons</b></sub></a></td>
  </tr>
</table>

## 🚀 Core Alumni

The following people were once core contributors helping steer the project in the right direction and ensuring we have a reliable foundation we can build new features upon:

<table>
  <tr>
    <td align="center"><a href="http://natanrolnik.me"><img src="https://avatars3.githubusercontent.com/u/1164565?v=4" width="100px;" alt=""/><br /><sub><b>Natan Rolnik</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/andreacipriani"><img src="https://avatars3.githubusercontent.com/u/536929?v=4" width="100px;" alt=""/><br /><sub><b>Andrea Cipriani</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/ollieatkinson"><img src="https://avatars1.githubusercontent.com/u/1382565?v=4" width="100px;" alt=""/><br /><sub><b>Oliver Atkinson</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/RomainBoulay"><img src="https://avatars1.githubusercontent.com/u/169323?v=4" width="100px;" alt=""/><br /><sub><b>Romain Boulay</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/laxmorek"><img src="https://avatars1.githubusercontent.com/u/4774319?v=4" width="100px;" alt=""/><br /><sub><b>Kamil Harasimowicz</b></sub></a><br /></td>
    <td align="center"><a href="http://www.luispadron.com"><img src="https://avatars3.githubusercontent.com/u/13840545?v=4" width="100px;" alt=""/><br /><sub><b>Luis Padron</b></sub></a></td>
    <td align="center"><a href="https://github.com/adellibovi"><img src="https://avatars3.githubusercontent.com/u/67916?v=4" width="100px;" alt=""/><br /><sub><b>Alfredo Delli Bovi</b></sub></a><br /></td>
  </tr>
</table>

## ✨ Contributors

Thanks goes to these wonderful people:

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kalkwarf"><img src="https://avatars1.githubusercontent.com/u/1033839?v=4" width="100px;" alt=""/><br /><sub><b>kalkwarf</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/fortmarek"><img src="https://avatars0.githubusercontent.com/u/9371695?v=4" width="100px;" alt=""/><br /><sub><b>Marek Fořt</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.matrixprojects.net"><img src="https://avatars3.githubusercontent.com/u/11914919?v=4" width="100px;" alt=""/><br /><sub><b>Kas</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://natanrolnik.me"><img src="https://avatars3.githubusercontent.com/u/1164565?v=4" width="100px;" alt=""/><br /><sub><b>Natan Rolnik</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/svastven"><img src="https://avatars0.githubusercontent.com/u/42235915?v=4" width="100px;" alt=""/><br /><sub><b>svastven</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://bhuemer.github.io"><img src="https://avatars2.githubusercontent.com/u/1212480?v=4" width="100px;" alt=""/><br /><sub><b>Bernhard Huemer</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://djankowski.dev"><img src="https://avatars0.githubusercontent.com/u/10795657?v=4" width="100px;" alt=""/><br /><sub><b>Daniel Jankowski</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/facumenzella"><img src="https://avatars1.githubusercontent.com/u/1125252?v=4" width="100px;" alt=""/><br /><sub><b>Facundo Menzella</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/eito"><img src="https://avatars3.githubusercontent.com/u/775643?v=4" width="100px;" alt=""/><br /><sub><b>Eric Ito</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/laxmorek"><img src="https://avatars2.githubusercontent.com/u/4774319?v=4" width="100px;" alt=""/><br /><sub><b>Kamil Harasimowicz</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/olejnjak"><img src="https://avatars1.githubusercontent.com/u/3148214?v=4" width="100px;" alt=""/><br /><sub><b>Jakub Olejník</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lakpa"><img src="https://avatars0.githubusercontent.com/u/389328?v=4" width="100px;" alt=""/><br /><sub><b>ldindu</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/gtsifrikas"><img src="https://avatars2.githubusercontent.com/u/8904378?v=4" width="100px;" alt=""/><br /><sub><b>George Tsifrikas</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/yurapriv"><img src="https://avatars2.githubusercontent.com/u/7814127?v=4" width="100px;" alt=""/><br /><sub><b>Privezentsev Yura</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://ferologics.github.io"><img src="https://avatars2.githubusercontent.com/u/5576161?v=4" width="100px;" alt=""/><br /><sub><b>Fero</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://heberti.com"><img src="https://avatars0.githubusercontent.com/u/103670?v=4" width="100px;" alt=""/><br /><sub><b>Heberti Almeida</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://benscheirman.com"><img src="https://avatars0.githubusercontent.com/u/59140?v=4" width="100px;" alt=""/><br /><sub><b>Ben Scheirman</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://jsorge.net"><img src="https://avatars3.githubusercontent.com/u/2585841?v=4" width="100px;" alt=""/><br /><sub><b>Jared Sorge</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://joeblau.com"><img src="https://avatars1.githubusercontent.com/u/1218847?v=4" width="100px;" alt=""/><br /><sub><b>Joe Blau</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://twitter.com/dchavezlive"><img src="https://avatars0.githubusercontent.com/u/2475932?v=4" width="100px;" alt=""/><br /><sub><b>David Chavez</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/роман-подымов-72338ab0/"><img src="https://avatars3.githubusercontent.com/u/10789692?v=4" width="100px;" alt=""/><br /><sub><b>Roman Podymov</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/marcinreliga-fn"><img src="https://avatars0.githubusercontent.com/u/76949651?v=4" width="100px;" alt=""/><br /><sub><b>Marcin Religa</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/adellibovi"><img src="https://avatars3.githubusercontent.com/u/67916?v=4" width="100px;" alt=""/><br /><sub><b>Alfredo Delli Bovi</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Jake-Prickett"><img src="https://avatars1.githubusercontent.com/u/26095410?v=4" width="100px;" alt=""/><br /><sub><b>Jake Prickett</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/danyf90"><img src="https://avatars.githubusercontent.com/u/2794031?v=4" width="100px;" alt=""/><br /><sub><b>Daniele Formichelli</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.facebook.com/PetrachkovSergey"><img src="https://avatars.githubusercontent.com/u/7995896?v=4" width="100px;" alt=""/><br /><sub><b>Sergey Petrachkov</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://jinuman.github.io/resume"><img src="https://avatars.githubusercontent.com/u/26243835?v=4" width="100px;" alt=""/><br /><sub><b>Jinwoo, Kim</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/thedavidharris"><img src="https://avatars.githubusercontent.com/u/5666250?v=4" width="100px;" alt=""/><br /><sub><b>David Harris</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/DimaMishchenko"><img src="https://avatars.githubusercontent.com/u/25247301?v=4" width="100px;" alt=""/><br /><sub><b>Dmytro Mishchenko</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.sampettersson.com"><img src="https://avatars.githubusercontent.com/u/5459507?v=4" width="100px;" alt=""/><br /><sub><b>Sam Pettersson</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.joshholtz.com"><img src="https://avatars.githubusercontent.com/u/401294?v=4" width="100px;" alt=""/><br /><sub><b>Josh Holtz</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://jierong.dev"><img src="https://avatars.githubusercontent.com/u/7414906?v=4" width="100px;" alt=""/><br /><sub><b>Jierong Li</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://twitter.com/freak4pc"><img src="https://avatars.githubusercontent.com/u/605076?v=4" width="100px;" alt=""/><br /><sub><b>Shai Mishali</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://twitter.com/FranzJBusch"><img src="https://avatars.githubusercontent.com/u/3491887?v=4" width="100px;" alt=""/><br /><sub><b>Franz Busch</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/tiarnann"><img src="https://avatars.githubusercontent.com/u/10522081?v=4" width="100px;" alt=""/><br /><sub><b>Tíarnán McGrath</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/softmaxsg"><img src="https://avatars.githubusercontent.com/u/3723817?v=4" width="100px;" alt=""/><br /><sub><b>Vitaly Chupryk</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rmnblm"><img src="https://avatars.githubusercontent.com/u/5942764?v=4" width="100px;" alt=""/><br /><sub><b>Roman Blum</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://nanotek.me"><img src="https://avatars.githubusercontent.com/u/7265334?v=4" width="100px;" alt=""/><br /><sub><b>Giovanni Filaferro</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://twitter.com/tovkal"><img src="https://avatars.githubusercontent.com/u/5960675?v=4" width="100px;" alt=""/><br /><sub><b>Andrés Pizá Bückmann</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://coutinho.dev"><img src="https://avatars.githubusercontent.com/u/17842860?v=4" width="100px;" alt=""/><br /><sub><b>Gabriel Coutinho</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://medium.com/@riccardocipolleschi"><img src="https://avatars.githubusercontent.com/u/11162307?v=4" width="100px;" alt=""/><br /><sub><b>Riccardo</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bolismauro"><img src="https://avatars.githubusercontent.com/u/771999?v=4" width="100px;" alt=""/><br /><sub><b>Mauro Bolis</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://twitter.com/iteractive_man"><img src="https://avatars.githubusercontent.com/u/461805?v=4" width="100px;" alt=""/><br /><sub><b>Peter Weishapl</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://stackoverflow.com/users/1878594/swiftycruz"><img src="https://avatars.githubusercontent.com/u/2609775?v=4" width="100px;" alt=""/><br /><sub><b>Cruz</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/svenmuennich"><img src="https://avatars.githubusercontent.com/u/1932115?v=4" width="100px;" alt=""/><br /><sub><b>Sven Münnich</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/santi-d"><img src="https://avatars.githubusercontent.com/u/993826?v=4" width="100px;" alt=""/><br /><sub><b>Santiago A. Delgado</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://wojciechkulik.pl"><img src="https://avatars.githubusercontent.com/u/3128467?v=4" width="100px;" alt=""/><br /><sub><b>Wojciech Kulik</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/iainsmith"><img src="https://avatars.githubusercontent.com/u/993745?v=4" width="100px;" alt=""/><br /><sub><b>Iain Smith</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/havebeenfitz"><img src="https://avatars.githubusercontent.com/u/31866271?v=4" width="100px;" alt=""/><br /><sub><b>Max Kraev</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mstfy"><img src="https://avatars.githubusercontent.com/u/5105861?v=4" width="100px;" alt=""/><br /><sub><b>Mustafa Yusuf</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://twitter.com/danielbarden"><img src="https://avatars.githubusercontent.com/u/104456?v=4" width="100px;" alt=""/><br /><sub><b>Daniel Barden</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/zzzkk"><img src="https://avatars.githubusercontent.com/u/12541603?v=4" width="100px;" alt=""/><br /><sub><b>Zofia Kulus</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://randombits.org/"><img src="https://avatars.githubusercontent.com/u/3589315?v=4" width="100px;" alt=""/><br /><sub><b>David Peterson</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://bandism.net/"><img src="https://avatars.githubusercontent.com/u/22633385?v=4" width="100px;" alt=""/><br /><sub><b>Ikko Ashimine</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/setoelkahfi"><img src="https://avatars.githubusercontent.com/u/1797197?v=4" width="100px;" alt=""/><br /><sub><b>Seto Elkahfi / 塞托·埃尔卡菲</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://apps4everyone.at"><img src="https://avatars.githubusercontent.com/u/1915802?v=4" width="100px;" alt=""/><br /><sub><b>apps4everyone</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/LorDisturbia"><img src="https://avatars.githubusercontent.com/u/12445776?v=4" width="100px;" alt=""/><br /><sub><b>Lorenzo</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/DarkoDamjanovic"><img src="https://avatars.githubusercontent.com/u/11902775?v=4" width="100px;" alt=""/><br /><sub><b>Darko Damjanovic</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://twitter.com/MarvinNazari"><img src="https://avatars.githubusercontent.com/u/926772?v=4" width="100px;" alt=""/><br /><sub><b>Marvin Nazari</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://twitter.com/codeOfRobin"><img src="https://avatars.githubusercontent.com/u/5009041?v=4" width="100px;" alt=""/><br /><sub><b>Robin Malhotra</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/astromonkee"><img src="https://avatars.githubusercontent.com/u/44421303?v=4" width="100px;" alt=""/><br /><sub><b>Astromonkee</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ezraberch"><img src="https://avatars.githubusercontent.com/u/49635435?v=4" width="100px;" alt=""/><br /><sub><b>ezraberch</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/cconstable"><img src="https://avatars.githubusercontent.com/u/564781?v=4" width="100px;" alt=""/><br /><sub><b>Christopher Constable</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/neakor"><img src="https://avatars.githubusercontent.com/u/1827517?v=4" width="100px;" alt=""/><br /><sub><b>Yi Wang</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.mustafadur.com"><img src="https://avatars.githubusercontent.com/u/971530?v=4" width="100px;" alt=""/><br /><sub><b>Mustafa Dur</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lucabartoletti"><img src="https://avatars.githubusercontent.com/u/838925?v=4" width="100px;" alt=""/><br /><sub><b>Luca Bartoletti</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sujata23"><img src="https://avatars.githubusercontent.com/u/1849089?v=4" width="100px;" alt=""/><br /><sub><b>Sujata Chakraborty</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.viber.com"><img src="https://avatars.githubusercontent.com/u/5096762?v=4" width="100px;" alt=""/><br /><sub><b>Pavel Trafimuk</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://alexsilva.dev/"><img src="https://avatars.githubusercontent.com/u/633535?v=4" width="100px;" alt=""/><br /><sub><b>Alejandro Silva Fernández</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.jakeadams.co"><img src="https://avatars.githubusercontent.com/u/3605966?v=4" width="100px;" alt=""/><br /><sub><b>Jake Adams</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/wattson12"><img src="https://avatars.githubusercontent.com/u/1217873?v=4" width="100px;" alt=""/><br /><sub><b>Sam Watts</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://erkekin.com"><img src="https://avatars.githubusercontent.com/u/701481?v=4" width="100px;" alt=""/><br /><sub><b>Erk Ekin</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/morozkin"><img src="https://avatars.githubusercontent.com/u/16591888?v=4" width="100px;" alt=""/><br /><sub><b>Denis Morozov</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/orbitekk"><img src="https://avatars.githubusercontent.com/u/4222449?v=4" width="100px;" alt=""/><br /><sub><b>orbitekk</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://blog.naver.com/wogus3602"><img src="https://avatars.githubusercontent.com/u/46857148?v=4" width="100px;" alt=""/><br /><sub><b>Park Jae Hyun</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/regularberry"><img src="https://avatars.githubusercontent.com/u/565192?v=4" width="100px;" alt=""/><br /><sub><b>Sean Berry</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://hisaac.net"><img src="https://avatars.githubusercontent.com/u/923876?v=4" width="100px;" alt=""/><br /><sub><b>Isaac Halvorson</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mohitsaxenaknoldus"><img src="https://avatars.githubusercontent.com/u/76725454?v=4" width="100px;" alt=""/><br /><sub><b>Mohit Saxena</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mikchmie"><img src="https://avatars.githubusercontent.com/u/15248837?v=4" width="100px;" alt=""/><br /><sub><b>Mikołaj Chmielewski</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/takinwande"><img src="https://avatars.githubusercontent.com/u/4744429?v=4" width="100px;" alt=""/><br /><sub><b>Tope Akinwande</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.theinkedengineer.com"><img src="https://avatars.githubusercontent.com/u/13349066?v=4" width="100px;" alt=""/><br /><sub><b>TheInkedEngineer</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://alexanderweiss.dev"><img src="https://avatars.githubusercontent.com/u/12934015?v=4" width="100px;" alt=""/><br /><sub><b>Alexander Weiß</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kyungpyoda"><img src="https://avatars.githubusercontent.com/u/44656036?v=4" width="100px;" alt=""/><br /><sub><b>kyungpyoda</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.villewitt.net"><img src="https://avatars.githubusercontent.com/u/522544?v=4" width="100px;" alt=""/><br /><sub><b>Ville Witt</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/paulsamuels"><img src="https://avatars.githubusercontent.com/u/527091?v=4" width="100px;" alt=""/><br /><sub><b>paul.s</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/aniltaskiran"><img src="https://avatars.githubusercontent.com/u/16738729?v=4" width="100px;" alt=""/><br /><sub><b>aniltaskiran</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/unxavi"><img src="https://avatars.githubusercontent.com/u/3817679?v=4" width="100px;" alt=""/><br /><sub><b>Javier Vieira</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/a-sarris"><img src="https://avatars.githubusercontent.com/u/78614622?v=4" width="100px;" alt=""/><br /><sub><b>Aris Sarris</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://xxw9999.notion.site/xxw9999/iOS-8585a34b2886419586960c5c02b9d845"><img src="https://avatars.githubusercontent.com/u/67373938?v=4" width="100px;" alt=""/><br /><sub><b>kimxwan0319</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://florian.codes"><img src="https://avatars.githubusercontent.com/u/7734806?v=4" width="100px;" alt=""/><br /><sub><b>Florian Fittschen</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jesus-mg-ios"><img src="https://avatars.githubusercontent.com/u/85997060?v=4" width="100px;" alt=""/><br /><sub><b>Jesus (iOS)</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nicholaskim94"><img src="https://avatars.githubusercontent.com/u/7912759?v=4" width="100px;" alt=""/><br /><sub><b>Nicholas Kim</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Smponias"><img src="https://avatars.githubusercontent.com/u/14213855?v=4" width="100px;" alt=""/><br /><sub><b>Alexandros Smponias</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mangofever"><img src="https://avatars.githubusercontent.com/u/724343?v=4" width="100px;" alt=""/><br /><sub><b>Go</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/AlbGarciam"><img src="https://avatars.githubusercontent.com/u/45308839?v=4" width="100px;" alt=""/><br /><sub><b>Alberto Garcia</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/andreascuderi/"><img src="https://avatars.githubusercontent.com/u/8319309?v=4" width="100px;" alt=""/><br /><sub><b>Andrea Scuderi</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://dogoautilio.wordpress.com/"><img src="https://avatars.githubusercontent.com/u/1487375?v=4" width="100px;" alt=""/><br /><sub><b>Diogo Autilio</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/shahzadmajeed"><img src="https://avatars.githubusercontent.com/u/1209459?v=4" width="100px;" alt=""/><br /><sub><b>Shahzad Majeed</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/danrevah"><img src="https://avatars.githubusercontent.com/u/7808742?v=4" width="100px;" alt=""/><br /><sub><b>Dan</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nivanchikov"><img src="https://avatars.githubusercontent.com/u/1830010?v=4" width="100px;" alt=""/><br /><sub><b>Nikita Ivanchikov</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/xoxo-anastasi-xoxo"><img src="https://avatars.githubusercontent.com/u/28875920?v=4" width="100px;" alt=""/><br /><sub><b>Anastasia Kazantseva</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://twitter.com/MonocularVision"><img src="https://avatars.githubusercontent.com/u/429790?v=4" width="100px;" alt=""/><br /><sub><b>Michael McGuire</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.michaelfcollins3.me"><img src="https://avatars.githubusercontent.com/u/104274?v=4" width="100px;" alt=""/><br /><sub><b>Michael Collins</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/devyhan"><img src="https://avatars.githubusercontent.com/u/45344633?v=4" width="100px;" alt=""/><br /><sub><b>YoHan Cho</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/euriasb"><img src="https://avatars.githubusercontent.com/u/3721257?v=4" width="100px;" alt=""/><br /><sub><b>euriasb</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MontakOleg"><img src="https://avatars.githubusercontent.com/u/1800899?v=4" width="100px;" alt=""/><br /><sub><b>MontakOleg</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/oozoofrog"><img src="https://avatars.githubusercontent.com/u/3011832?v=4" width="100px;" alt=""/><br /><sub><b>oozoofrog</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MartinStrambach"><img src="https://avatars.githubusercontent.com/u/11178869?v=4" width="100px;" alt=""/><br /><sub><b>Martin Strambach</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sh-a-n"><img src="https://avatars.githubusercontent.com/u/2219548?v=4" width="100px;" alt=""/><br /><sub><b>sh-a-n</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://linkedin.com/in/batuhansaka"><img src="https://avatars.githubusercontent.com/u/9626765?v=4" width="100px;" alt=""/><br /><sub><b>Batuhan Saka</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://jcsoohwancho.github.io"><img src="https://avatars.githubusercontent.com/u/51935215?v=4" width="100px;" alt=""/><br /><sub><b>SooHwanCho</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.bouncingball.mobi"><img src="https://avatars.githubusercontent.com/u/798117?v=4" width="100px;" alt=""/><br /><sub><b>Gary Riches</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://mustiikhalil.github.io/mustiikhalil/"><img src="https://avatars.githubusercontent.com/u/26250654?v=4" width="100px;" alt=""/><br /><sub><b>mustiikhalil</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/serejahh"><img src="https://avatars.githubusercontent.com/u/2575555?v=4" width="100px;" alt=""/><br /><sub><b>Serhii Butenko</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/petrukha-ivan"><img src="https://avatars.githubusercontent.com/u/93926277?v=4" width="100px;" alt=""/><br /><sub><b>Petrukha Ivan</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lo1tuma"><img src="https://avatars.githubusercontent.com/u/169170?v=4" width="100px;" alt=""/><br /><sub><b>Mathias Schreck</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Buju77"><img src="https://avatars.githubusercontent.com/u/266349?v=4" width="100px;" alt=""/><br /><sub><b>Yen-Chia Lin</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://coolmathgames.tech"><img src="https://avatars.githubusercontent.com/u/6877780?v=4" width="100px;" alt=""/><br /><sub><b>Mary </b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/woohyunjin06"><img src="https://avatars.githubusercontent.com/u/30452977?v=4" width="100px;" alt=""/><br /><sub><b>Hyunjin</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kevin58332"><img src="https://avatars.githubusercontent.com/u/47673410?v=4" width="100px;" alt=""/><br /><sub><b>Kevin Aguilar</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://andrewroan.com"><img src="https://avatars.githubusercontent.com/u/9873566?v=4" width="100px;" alt=""/><br /><sub><b>Andrew Roan</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/ibrahim-oktay-518b4939/"><img src="https://avatars.githubusercontent.com/u/36792481?v=4" width="100px;" alt=""/><br /><sub><b>ibrahim oktay</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/navartis"><img src="https://avatars.githubusercontent.com/u/7813723?v=4" width="100px;" alt=""/><br /><sub><b>Dmitriy Kulakov</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/woin2ee"><img src="https://avatars.githubusercontent.com/u/81426024?v=4" width="100px;" alt=""/><br /><sub><b>Jaewon-Yun</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/tatagrigory"><img src="https://avatars.githubusercontent.com/u/5187973?v=4" width="100px;" alt=""/><br /><sub><b>tatagrigory</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://linkedin.com/in/denilchungath"><img src="https://avatars.githubusercontent.com/u/95201442?v=4" width="100px;" alt=""/><br /><sub><b>Denil Chungath</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/victor-sarda/"><img src="https://avatars.githubusercontent.com/u/6460866?v=4" width="100px;" alt=""/><br /><sub><b>Victor Sarda</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/tzxdtc"><img src="https://avatars.githubusercontent.com/u/19767846?v=4" width="100px;" alt=""/><br /><sub><b>tzxdtc10</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ThiemeFM"><img src="https://avatars.githubusercontent.com/u/143395823?v=4" width="100px;" alt=""/><br /><sub><b>Thieme</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Lilfaen"><img src="https://avatars.githubusercontent.com/u/39119695?v=4" width="100px;" alt=""/><br /><sub><b>Clemens Beck</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://macpaw.com/"><img src="https://avatars.githubusercontent.com/u/119268?v=4" width="100px;" alt=""/><br /><sub><b>Paul Taykalo</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/in4lio"><img src="https://avatars.githubusercontent.com/u/976061?v=4" width="100px;" alt=""/><br /><sub><b>Vitaly Kravtsov</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://dc.wtf"><img src="https://avatars.githubusercontent.com/u/643865?v=4" width="100px;" alt=""/><br /><sub><b>dc</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/baekteun"><img src="https://avatars.githubusercontent.com/u/74440939?v=4" width="100px;" alt=""/><br /><sub><b>baegteun</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://vcoutasso.com"><img src="https://avatars.githubusercontent.com/u/44986513?v=4" width="100px;" alt=""/><br /><sub><b>Vinícius Couto Tasso</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://blog.jihoon.me"><img src="https://avatars.githubusercontent.com/u/68891494?v=4" width="100px;" alt=""/><br /><sub><b>안지훈</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dxmvsh"><img src="https://avatars.githubusercontent.com/u/44325936?v=4" width="100px;" alt=""/><br /><sub><b>Dimash</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/danibachar"><img src="https://avatars.githubusercontent.com/u/6380777?v=4" width="100px;" alt=""/><br /><sub><b>danibachar</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dp221125"><img src="https://avatars.githubusercontent.com/u/10572119?v=4" width="100px;" alt=""/><br /><sub><b>한석호(MilKyo)</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://medium.com/@haifengkaohaifengkao&usg=AOvVaw2_xG-ZLdBawBIyS7m-99RQ"><img src="https://avatars.githubusercontent.com/u/4080524?v=4" width="100px;" alt=""/><br /><sub><b>Hai Feng Kao</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/anlaital-oura"><img src="https://avatars.githubusercontent.com/u/133648611?v=4" width="100px;" alt=""/><br /><sub><b>Antti Laitala</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/PushedCrayon"><img src="https://avatars.githubusercontent.com/u/37077444?v=4" width="100px;" alt=""/><br /><sub><b>PushedCrayon</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://stefanomondino.com"><img src="https://avatars.githubusercontent.com/u/1691903?v=4" width="100px;" alt=""/><br /><sub><b>Stefano Mondino</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/leszko11"><img src="https://avatars.githubusercontent.com/u/23533452?v=4" width="100px;" alt=""/><br /><sub><b>Łukasz Lech</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/costapombo"><img src="https://avatars.githubusercontent.com/u/31352351?v=4" width="100px;" alt=""/><br /><sub><b>costapombo</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/isavynskyi"><img src="https://avatars.githubusercontent.com/u/18377497?v=4" width="100px;" alt=""/><br /><sub><b>Ihor Savynskyi</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kapitoshka438"><img src="https://avatars.githubusercontent.com/u/3232401?v=4" width="100px;" alt=""/><br /><sub><b>Eduard Miniakhmetov</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alexfilimon"><img src="https://avatars.githubusercontent.com/u/19904867?v=4" width="100px;" alt=""/><br /><sub><b>Alexander Filimonov</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rofle100lvl"><img src="https://avatars.githubusercontent.com/u/45801227?v=4" width="100px;" alt=""/><br /><sub><b>Gorbenko Roman</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/lucas-paim/"><img src="https://avatars.githubusercontent.com/u/7849484?v=4" width="100px;" alt=""/><br /><sub><b>Lucas Mrowskovsky Paim</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://actuallytaylor.com"><img src="https://avatars.githubusercontent.com/u/32944568?v=4" width="100px;" alt=""/><br /><sub><b>Taylor Lineman</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nandodelauni"><img src="https://avatars.githubusercontent.com/u/1938501?v=4" width="100px;" alt=""/><br /><sub><b>Miguel Ferrando</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/barredewe"><img src="https://avatars.githubusercontent.com/u/19188911?v=4" width="100px;" alt=""/><br /><sub><b>BarredEwe</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/chris-livefront"><img src="https://avatars.githubusercontent.com/u/126101032?v=4" width="100px;" alt=""/><br /><sub><b>Chris Sessions</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ajkolean"><img src="https://avatars.githubusercontent.com/u/5394701?v=4" width="100px;" alt=""/><br /><sub><b>Andy Kolean</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Binlogo"><img src="https://avatars.githubusercontent.com/u/7845507?v=4" width="100px;" alt=""/><br /><sub><b>Binlogo</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/DevilDimon"><img src="https://avatars.githubusercontent.com/u/10220441?v=4" width="100px;" alt=""/><br /><sub><b>Dmitry Serov</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://darrarski.pl"><img src="https://avatars.githubusercontent.com/u/1384684?v=4" width="100px;" alt=""/><br /><sub><b>Dariusz Rybicki</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dansinclair25"><img src="https://avatars.githubusercontent.com/u/2573447?v=4" width="100px;" alt=""/><br /><sub><b>Dan Sinclair</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.kaioelfke.de"><img src="https://avatars.githubusercontent.com/u/1190948?v=4" width="100px;" alt=""/><br /><sub><b>Kai Oelfke</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://stackoverflow.com/users/468724/inder-kumar-rathore"><img src="https://avatars.githubusercontent.com/u/352443?v=4" width="100px;" alt=""/><br /><sub><b>Inder</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kyounh12"><img src="https://avatars.githubusercontent.com/u/25301615?v=4" width="100px;" alt=""/><br /><sub><b>kyounh12</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alvar-bolt"><img src="https://avatars.githubusercontent.com/u/72379847?v=4" width="100px;" alt=""/><br /><sub><b>Alvar Hansen</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/barakwei"><img src="https://avatars.githubusercontent.com/u/5232161?v=4" width="100px;" alt=""/><br /><sub><b>Barak Weiss</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/hiltonc"><img src="https://avatars.githubusercontent.com/u/470753?v=4" width="100px;" alt=""/><br /><sub><b>Hilton Campbell</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rgnns"><img src="https://avatars.githubusercontent.com/u/811827?v=4" width="100px;" alt=""/><br /><sub><b>Gabriel Liévano</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/vijaytholpadi"><img src="https://avatars.githubusercontent.com/u/1171868?v=4" width="100px;" alt=""/><br /><sub><b>Vijay Tholpadi</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://withiosdeveloper.blogspot.com/"><img src="https://avatars.githubusercontent.com/u/27220138?v=4" width="100px;" alt=""/><br /><sub><b>Minhoi Goo</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sphanley"><img src="https://avatars.githubusercontent.com/u/1323769?v=4" width="100px;" alt=""/><br /><sub><b>Sam Hanley</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ahmdyasser"><img src="https://avatars.githubusercontent.com/u/42544598?v=4" width="100px;" alt=""/><br /><sub><b>ahmdyasser</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/minhaaan"><img src="https://avatars.githubusercontent.com/u/87178301?v=4" width="100px;" alt=""/><br /><sub><b>minhaaan</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/TamarMilchtaich"><img src="https://avatars.githubusercontent.com/u/49520876?v=4" width="100px;" alt=""/><br /><sub><b>Tamar Milchtaich Lavi</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rock88"><img src="https://avatars.githubusercontent.com/u/323908?v=4" width="100px;" alt=""/><br /><sub><b>Andrey K</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://2stable.com"><img src="https://avatars.githubusercontent.com/u/69604865?v=4" width="100px;" alt=""/><br /><sub><b>Alex Vera</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.annalisemariottini.com"><img src="https://avatars.githubusercontent.com/u/14299642?v=4" width="100px;" alt=""/><br /><sub><b>Annalise Mariottini</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/gustn3965"><img src="https://avatars.githubusercontent.com/u/48749182?v=4" width="100px;" alt=""/><br /><sub><b>HyunSu Park</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/vldalx"><img src="https://avatars.githubusercontent.com/u/13873200?v=4" width="100px;" alt=""/><br /><sub><b>Vladimir</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://rhysmorgan.co"><img src="https://avatars.githubusercontent.com/u/11096937?v=4" width="100px;" alt=""/><br /><sub><b>Rhys Morgan</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/pierrerodgers"><img src="https://avatars.githubusercontent.com/u/48193278?v=4" width="100px;" alt=""/><br /><sub><b>pierrerodgers</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/honghoker"><img src="https://avatars.githubusercontent.com/u/50417461?v=4" width="100px;" alt=""/><br /><sub><b>eunpyo hong</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://medium.com/@dbstj169"><img src="https://avatars.githubusercontent.com/u/65678579?v=4" width="100px;" alt=""/><br /><sub><b>Yunseo Kang</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ilia3546"><img src="https://avatars.githubusercontent.com/u/4445510?v=4" width="100px;" alt=""/><br /><sub><b>Ilya Kharlamov</b></sub></a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/brianvar"><img src="https://avatars.githubusercontent.com/u/115399684?v=4" width="100px;" alt=""/><br /><sub><b>brianvar</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/HossamYoussof"><img src="https://avatars.githubusercontent.com/u/6381926?v=4" width="100px;" alt=""/><br /><sub><b>Hossam Youssof</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/devMinseok"><img src="https://avatars.githubusercontent.com/u/51021614?v=4" width="100px;" alt=""/><br /><sub><b>Minseok Kang</b></sub></a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alpanyukov"><img src="https://avatars.githubusercontent.com/u/36258478?v=4" width="100px;" alt=""/><br /><sub><b>Alexander</b></sub></a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
