// Karma configuration
// Generated on Sat Apr 09 2016 22:42:44 GMT+0000 (UTC)

module.exports = function(config) {
	config.set({

		// base path that will be used to resolve all patterns (eg. files, exclude)
		basePath: '',

		// frameworks to use
		// available frameworks: https://npmjs.org/browse/keyword/karma-adapter
		frameworks: ['browserify', 'jasmine'],

		// list of files / patterns to load in the browser
		files: [{
			pattern: 'node_modules/angular/angular.min.js',
			included: true
		}, {
			pattern: 'node_modules/angular-mocks/angular-mocks.js',
			included: true
		}, {
			pattern: 'node_modules/angular-animate/angular-animate.min.js',
			included: true
		}, {
			pattern: 'node_modules/angular-cookies/angular-cookies.min.js',
			included: true
		}, {
			pattern: 'node_modules/ng-dialog/js/ngDialog.min.js',
			included: true
		}, {
			pattern: 'node_modules/angular-tooltips/dist/angular-tooltips.min.js',
			included: true
		}, {
			pattern: 'node_modules/chart.js/dist/Chart.min.js',
			included: true
		}, {
			pattern: 'node_modules/angular-chart.js/dist/angular-chart.js',
			included: true
		}, {
			pattern: 'node_modules/chartjs-plugin-annotation/chartjs-plugin-annotation.min.js',
			included: true
		}, {
			pattern: 'Frontend/jsapp/**/*.js',
			included: true
		}, {
			pattern: 'Frontend/test/**/*.js',
			included: true
		}],


		// list of files to exclude
		exclude: [],


		// preprocess matching files before serving them to the browser
		// available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
		preprocessors: {
			'Frontend/jsapp/**/*.js': ['browserify'],
			'Frontend/test/**/*.js': ['browserify']
		},

		browserify: {
			debug: true,
			transform: [ 'babelify' ]
		},


		// test results reporter to use
		// possible values: 'dots', 'progress'
		// available reporters: https://npmjs.org/browse/keyword/karma-reporter
		reporters: ['spec'],


		// web server port
		port: 9876,


		// enable / disable colors in the output (reporters and logs)
		colors: true,


		// level of logging
		// possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
		logLevel: config.LOG_INFO,


		// enable / disable watching file and executing tests whenever any file changes
		autoWatch: true,


		// start these browsers
		// available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
		browsers: ['PhantomJS'],


		// Continuous Integration mode
		// if true, Karma captures browsers, runs the tests and exits
		singleRun: true,

		// Concurrency level
		// how many browser should be started simultaneous
		concurrency: Infinity
	})
}
