
settings_table = {
    {
        name='time',
        arg='%I',
        max=12,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.6,
        x=165, y=170,
        radius=50,
        thickness=5,
        start_angle=0,
        end_angle=360
    },
    {
        name='time',
        arg='%M',
        max=60,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.6,
        x=165, y=170,
        radius=56,
        thickness=5,
        start_angle=0,
        end_angle=360
    },
    {
        name='time',
        arg='%S',
        max=60,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xD70A53,
        fg_alpha=0.9,
        x=165, y=170,
        radius=62,
        thickness=5,
        start_angle=0,
        end_angle=360
    },
    {
        name='cpu',
        arg='cpu1',
        max=100,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.3,
        x=165, y=170,
        radius=70,
        thickness=5,
        start_angle=60,
        end_angle=120
    },
    {
        name='cpu',
        arg='cpu2',
        max=100,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.3,
        x=165, y=170,
        radius=76,
        thickness=5,
        start_angle=60,
        end_angle=120
    },
    {
        name='cpu',
        arg='cpu3',
        max=100,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.3,
        x=165, y=170,
        radius=82,
        thickness=5,
        start_angle=60,
        end_angle=120
    },
    {
        name='cpu',
        arg='cpu0',
        max=100,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.3,
        x=165, y=170,
        radius=90.5,
        thickness=8,
        start_angle=60,
        end_angle=120
    },
    {
        name='battery_percent',
        arg='BAT0',
        max=100,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.3,
        x=165, y=170,
        radius=72,
        thickness=11,
        start_angle=122,
        end_angle=210,
    },
    {
        name='memperc',
        arg='',
        max=100,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.3,
        x=165, y=170,
        radius=90.5,
        thickness=8,
        start_angle=122,
        end_angle=210
    },
    {
        name='time',
        arg='%d',
        max=31,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.6,
        x=165, y=170,
        radius=70,
        thickness=5,
        start_angle=212,
        end_angle=360
    },
    {
        name='time',
        arg='%m',
        max=12,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.6,
        x=165, y=170,
        radius=76,
        thickness=5,
        start_angle=212,
        end_angle=360
    },
    {
        name='fs_used_perc',
        arg='/',
        max=150,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.4,
        x=165, y=170,
        radius=108.5,
        thickness=3,
        start_angle=-120,
        end_angle=240
    },
    {
        name='fs_used_perc',
        arg='/',
        max=100,
        bg_colour=0xffffff,
        bg_alpha=0.2,
        fg_colour=0xffffff,
        fg_alpha=0.4,
        x=165, y=170,
        radius=135,
        thickness=50,
        start_angle=-120,
        end_angle=120
    },
}

require 'cairo'

function rgb_to_r_g_b(colour,alpha)
    return ((colour / 0x10000) % 0x100) / 255., ((colour / 0x100) % 0x100) / 255., (colour % 0x100) / 255., alpha
end

function draw_ring(cr,t,pt)
    local w,h=conky_window.width,conky_window.height

    local xc,yc,ring_r,ring_w,sa,ea=pt['x'],pt['y'],pt['radius'],pt['thickness'],pt['start_angle'],pt['end_angle']
    local bgc, bga, fgc, fga=pt['bg_colour'], pt['bg_alpha'], pt['fg_colour'], pt['fg_alpha']

    local angle_0=sa*(2*math.pi/360)-math.pi/2
    local angle_f=ea*(2*math.pi/360)-math.pi/2
    local t_arc=t*(angle_f-angle_0)

    -- Draw background ring

    cairo_arc(cr,xc,yc,ring_r,angle_0,angle_f)
    cairo_set_source_rgba(cr,rgb_to_r_g_b(bgc,bga))
    cairo_set_line_width(cr,ring_w)
    cairo_stroke(cr)

    -- Draw indicator ring

    cairo_arc(cr,xc,yc,ring_r,angle_0,angle_0+t_arc)
    cairo_set_source_rgba(cr,rgb_to_r_g_b(fgc,fga))
    cairo_stroke(cr)
end

function conky_ring_stats()
    local function setup_rings(cr,pt)
        local str=''
        local value=0

        str=string.format('${%s %s}',pt['name'],pt['arg'])
        str=conky_parse(str)

        value=tonumber(str)
        pct=value/pt['max']

        draw_ring(cr,pct,pt)
    end

    if conky_window==nil then return end
    local cs=cairo_xlib_surface_create(conky_window.display,conky_window.drawable,conky_window.visual, conky_window.width,conky_window.height)

    local cr=cairo_create(cs)

    local updates=conky_parse('${updates}')
    update_num=tonumber(updates)

    if update_num>5 then
        for i in pairs(settings_table) do
            setup_rings(cr,settings_table[i])
        end
    end
end
