/**
 * Creating a sidebar enables you to:
 - create an ordered group of docs
 - render a sidebar for each doc of that group
 - provide next/previous navigation

 The sidebars can be generated from the filesystem, or explicitly defined here.

 Create as many sidebars as you want.
 */

// @ts-check

/** @type {import('@docusaurus/plugin-content-docs').SidebarsConfig} */
const sidebars = {
  sidebar: [
    {
      type: 'doc',
      id: 'intro',
    },
    {
      type: 'doc',
      id: 'quickstart',
    },
    {
      type: 'doc',
      id: 'examples',
      label: 'Examples',
    },
    {
      type: 'category',
      label: 'Guides',
      items: [
        {
          type: 'doc',
          id: 'guides/nx',
          label: 'NX Monorepo',
        },
        {
          type: 'doc',
          id: 'guides/without-backend',
          label: 'Without a Backend',
        },
        {
          type: 'doc',
          id: 'guides/non-ts-clients',
          label: 'Non-TypeScript Clients',
        },
        {
          type: 'doc',
          id: 'guides/fake-apis',
          label: 'Fake APIs for Testing',
        },
      ],
    },
    {
      type: 'category',
      label: 'Contract',
      collapsed: false,
      items: [
        { type: 'doc', id: 'core/core' },
        { type: 'doc', id: 'core/infer-types' },
        { type: 'doc', id: 'core/errors' },
        { type: 'doc', id: 'core/form-data' },
      ],
    },
    {
      type: 'category',
      label: 'Client',
      collapsed: false,
      items: [
        { type: 'doc', id: 'core/fetch' },
        { type: 'doc', id: 'core/custom' },
        {
          type: 'category',
          label: 'React Query',
          collapsed: true,
          items: [
            { type: 'doc', id: 'react-query/v5-setup' },
            { type: 'doc', id: 'react-query/query-client' },
            { type: 'doc', id: 'react-query/use-infinite-query' },
            { type: 'doc', id: 'react-query/use-queries' },
            { type: 'doc', id: 'react-query/error-handling' },
            { type: 'doc', id: 'react-query/ssr' },
            { type: 'doc', id: 'react-query/troubleshooting' },
            { type: 'doc', id: 'react-query/v4' },
          ],
        },
        { type: 'doc', id: 'vue-query' },
      ],
    },
    {
      type: 'category',
      label: 'Server',
      collapsed: false,
      items: [
        {
          type: 'category',
          label: 'NestJS',
          collapsed: true,
          items: [
            { type: 'doc', id: 'nest/nest' },
            { type: 'doc', id: 'nest/legacy' },
            { type: 'doc', id: 'nest/configuration' },
          ],
        },
        {
          type: 'doc',
          label: 'Next.js (Pages Router)',
          id: 'next',
        },
        {
          type: 'category',
          label: 'Express.js',
          collapsed: true,
          items: [
            { type: 'doc', id: 'express/express' },
            { type: 'doc', id: 'express/middleware' },
          ],
        },
        {
          type: 'doc',
          id: 'fastify',
          label: 'Fastify',
        },
        {
          type: 'category',
          label: 'Serverless',
          collapsed: true,
          items: [
            { type: 'doc', id: 'serverless/options' },
            { type: 'doc', id: 'serverless/routers' },
            { type: 'doc', id: 'serverless/fetch-runtimes' },
            { type: 'doc', id: 'serverless/aws' },
            { type: 'doc', id: 'serverless/next-serverless' },
            { type: 'doc', id: 'serverless/azure-functions' },
          ],
        },
        {
          type: 'doc',
          id: 'core/server-errors',
        },
      ],
    },
    {
      type: 'doc',
      label: 'OpenAPI',
      id: 'open-api',
    },
    {
      type: 'category',
      label: 'API Reference',
      items: [
        {
          type: 'autogenerated',
          dirName: 'api/modules',
        },
      ],
    },
    {
      type: 'category',
      label: 'Comparisons',
      collapsed: true,
      items: [
        {
          type: 'doc',
          id: 'comparisons/rpc-comparison',
        },
      ],
    },
    {
      type: 'doc',
      label: 'Troubleshoot',
      id: 'troubleshoot',
    },
  ],
};

module.exports = sidebars;
