# Contributing to mailtrap-handler
We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the configuration
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with GitHub
We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [CircleCI](https://circleci.com/product/), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (we use [CircleCI](https://circleci.com/product/)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the tests pass.
5. Make sure your code and commit lints.
6. Issue that pull request!

## Any contributions you make will be under the MIT License
In short, when you submit code changes, your submissions are understood to be under the same [MIT License](https://opensource.org/licenses/MIT) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using GitHub's issues
We use GitHub issues to track public bugs. Report a bug by opening a new issue, it's that easy!

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
    - Be specific!
    - Give sample code if you can.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People *love* thorough bug reports. I'm not even kidding.

To make your life easier there is also a handy template available so feel free to use it.

## License
By contributing, you agree that your contributions will be licensed under its MIT License.

## Developer Certificate of Origin
Every external contributor needs to sign commits with a valid DCO.

This is done by adding a Signed-off-by line to commit messages.

```
This is my commit message

Signed-off-by: Random J Developer <random@developer.example.org>
```

Git even has a -s command line option to append this automatically to your commit message:

```
git commit -s -m 'This is my commit message'
```

