# Contributions
If you are considering contributing to our repository, first thank you for doing so! </br>

Contributions from community members are more than welcome, there are a few items that you should be aware of for a smooth process </br>

## Technique Expectations
BOF supports any number of techniques.  To be included in this repository, you tool must be limited to information gathering </br>

If your tool manipulates the system, that's awesome, but this repository will not accept it.

## Code Expectations
* Your code should compile without errors when using the default makefile
* any new BOF defines for resolving functions will be placed in src/common/bofdefs.h
* Code will compile together using the default Makefile (single entry.c file)
* Code will likewise be compatible with the existing toolchain (mingw)
* Code will be written in C. This is to standardize and my personal confidence in validating the code.

## What to expect as a contributor
After your contribution is received, it will receive an in-depth code review and testing.  </br>
After testing is completed, we will have zero or more rounds of change requests based on findings until there are no issues in the code.  At that point it will be accepted into the repository, and your github username will be added to our credit list (if you would prefer not to be added or some other handle to be used, just let me know)
