import PyLora
import time

bError = False
lFreq = 433000000
nSpreadFactor = 10
nBandwidth = 125000


PyLora.set_pins(spi_device="/dev/spidev0.0", cs_pin=24, rst_pin=22, irq_pin=16)

if PyLora.init() == 1:
    PyLora.reset()
    PyLora.set_frequency(lFreq)
    PyLora.set_spreading_factor(10)
    PyLora.set_bandwidth(125000)
    PyLora.set_preamble_length(200)
    PyLora.set_sync_word(99)
    PyLora.set_coding_rate(4)
    PyLora.enable_crc()
else:
    print("Init comm failed!")
    
#PyLora.explicit_header_mode()

#while True:
#    PyLora.send_packet(bytes("Hello\0", encoding="utf-8"))
#    print ('Packet sent...')
#    time.sleep(2)

#PyLora.lora_dump_register()


while PyLora.get_frequency() != lFreq:
    print("Init failed Freq mismatch: ", PyLora.get_frequency())

    PyLora.lora_dump_register()
    PyLora.close()

    time.sleep(.5)
    
    PyLora.set_pins(spi_device="/dev/spidev0.0", cs_pin=24, rst_pin=22, irq_pin=16)
    
    if PyLora.init() == 1:
    
        PyLora.set_frequency(lFreq)
        PyLora.set_spreading_factor(10)
        PyLora.set_bandwidth(125000)
        PyLora.set_preamble_length(200)
        PyLora.set_sync_word(99)
        PyLora.set_coding_rate(4)
        PyLora.enable_crc()
    else:
        print("Init comm failed!")
    
    
print ('Init done...')    
    

while True:
    PyLora.receive()
    nPack = False
    
    while nPack == False:
        PyLora.receive()
        #wait for a package
        time.sleep(0.1)
        
        nPack = PyLora.packet_available()
        

    
    
    rec = PyLora.receive_packet()
    
    if rec is not None:
        #if len(rec) > 0:
        print ('Packet received: {}'.format(rec))
