
#ifndef __LORA_H__
#define __LORA_H__




void lora_reset(void);
void lora_explicit_header_mode(void);
void lora_implicit_header_mode(int size);
void lora_idle(void);
void lora_sleep(void); 
void lora_receive(void);
void lora_set_tx_power(int level);


void lora_set_frequency(long frequency);
long lora_get_frequency(void);

void lora_set_spreading_factor(int sf);
int lora_get_spreading_factor();

void lora_set_bandwidth(long sbw);
long lora_get_bandwidth(void);

int lora_is_receiving(void);

void lora_set_coding_rate(int denominator);
void lora_set_preamble_length(long length);
void lora_set_sync_word(int sw);
void lora_enable_crc(void);
void lora_disable_crc(void);
void lora_set_pins(char *spidev, int cs, int rst, int irq);
int lora_init(void);
void lora_send_packet(uint8_t *buf, int size);
int lora_receive_packet(uint8_t *buf, int size);
int lora_received(void);
int lora_packet_rssi(void);
float lora_packet_snr(void);
void lora_close(void);
int lora_initialized(void);
void lora_dump_registers(void);
void lora_wait_for_packet(int timeout);
void lora_on_receive(void (*cb)(void));
int lora_is_transmitting(void);


#endif
