import pandas as pd
import matplotlib.pyplot as plt
import os
from prompt_systematic_review.config_data import DataFolderPath

"""Graph the model counts generated by scripts/count_tool_mentions.py"""


def graph_tool_mentions(
    modelCitationCountInput="model_citation_counts.csv",
    datasetCitationCountInput="dataset_citation_counts.csv",
    frameworkCitationCountInput="framework_citation_counts.csv",
):
    """
    Graph the tool mentions counts generated by scripts/count_tool_mentions.py.

    This function reads the CSV files containing the citation counts for models, datasets, and frameworks,
    and generates bar graphs visualizing the top 20 most mentioned tools in each category.

    :param modelCitationCountInput: The name of the CSV file containing the model citation counts.
                                    Default is "model_citation_counts.csv".
    :type modelCitationCountInput: str
    :param datasetCitationCountInput: The name of the CSV file containing the dataset citation counts.
                                      Default is "dataset_citation_counts.csv".
    :type datasetCitationCountInput: str
    :param frameworkCitationCountInput: The name of the CSV file containing the framework citation counts.
                                         Default is "framework_citation_counts.csv".
    :type frameworkCitationCountInput: str
    :return: None
    :rtype: None
    """
    csv_file = os.path.join(
        DataFolderPath, "experiments_output" + os.sep + modelCitationCountInput
    )
    df = pd.read_csv(csv_file)

    # sort by alphabetical order
    top_20 = df.sort_values(by="count", ascending=False)

    plt.figure(figsize=(10, 6))
    plt.bar(top_20["tool_name"], top_20["count"], color="blue")
    plt.xlabel("Model Name")
    plt.ylabel("Count")
    plt.title("Counts of Model Mentions in Dataset")
    plt.xticks(rotation=45, ha="right")
    plt.tight_layout()

    plt.savefig(
        os.path.join(
            DataFolderPath,
            "experiments_output" + os.sep + "graph_model_mentions_output.png",
        )
    )

    """Graph the dataset counts generated by scripts/count_tool_mentions.py"""

    csv_file = os.path.join(
        DataFolderPath, "experiments_output" + os.sep + datasetCitationCountInput
    )
    df = pd.read_csv(csv_file)

    # sort by alphabetical order
    top_20 = df.sort_values(by="count", ascending=False)

    plt.figure(figsize=(10, 6))
    plt.bar(top_20["tool_name"], top_20["count"], color="blue")
    plt.xlabel("Dataset Name")
    plt.ylabel("Count")
    plt.title("Counts of Dataset Mentions in Dataset")
    plt.xticks(rotation=45, ha="right")
    plt.tight_layout()

    plt.savefig(
        os.path.join(
            DataFolderPath,
            "experiments_output" + os.sep + "graph_dataset_mentions_output.png",
        )
    )

    """Graph the framework counts generated by scripts/count_tool_mentions.py"""

    csv_file = os.path.join(
        DataFolderPath, "experiments_output" + os.sep + frameworkCitationCountInput
    )
    df = pd.read_csv(csv_file)

    # sort by alphabetical order
    top_20 = df.sort_values(by="count", ascending=False)

    plt.figure(figsize=(10, 6))
    plt.bar(top_20["tool_name"], top_20["count"], color="blue")
    plt.xlabel("Framework Name")
    plt.ylabel("Count")
    plt.title("Counts of Framework Mentions in Dataset")
    plt.xticks(rotation=45, ha="right")
    plt.tight_layout()

    plt.savefig(
        os.path.join(
            DataFolderPath,
            "experiments_output" + os.sep + "graph_framework_mentions_output.png",
        )
    )


class Experiment:
    def run():
        graph_tool_mentions()


if __name__ == "__main__":
    graph_tool_mentions()
