# Generated by Django 2.2.17 on 2021-02-17 14:51

from django.db import migrations, models


def copy_first_published_at_to_date_field(apps, schema_editor):
    # We can't import the Person model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    WorkPage = apps.get_model("work", "workpage")
    for workpage in WorkPage.objects.all():
        if workpage.date is None:
            workpage.date = workpage.first_published_at
            workpage.save()


class Migration(migrations.Migration):
    dependencies = [
        ("work", "0022_workpage_date"),
    ]

    operations = [
        migrations.RunPython(copy_first_published_at_to_date_field),
    ]
