# Generated by Django 3.2.18 on 2023-08-08 14:18

from django.db import migrations, models
import django.db.models.deletion
import wagtail.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
import wagtail.snippets.blocks


class Migration(migrations.Migration):

    dependencies = [
        ("images", "0004_wagtail42_images"),
        ("wagtailcore", "0083_workflowcontenttype"),
        ("propositions", "0010_merge_20230620_1607"),
    ]

    operations = [
        migrations.CreateModel(
            name="SubPropositionPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                ("social_text", models.CharField(blank=True, max_length=255)),
                (
                    "theme",
                    models.CharField(
                        choices=[
                            ("light", "Light"),
                            ("coral", "Coral"),
                            ("dark", "Dark"),
                        ],
                        default="light",
                        max_length=255,
                    ),
                ),
                (
                    "strapline",
                    models.CharField(
                        help_text="Words in <span> tag will display in a contrasting colour.",
                        max_length=255,
                    ),
                ),
                ("intro", wagtail.fields.RichTextField(blank=True)),
                (
                    "greeting_image_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("woman-left", "Woman (Left Aligned)"),
                            ("man-left", "Man (Left aligned)"),
                            ("wagtail", "Wagtail (Right aligned)"),
                        ],
                        default="woman-left",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "content",
                    wagtail.fields.StreamField(
                        [
                            (
                                "key_points",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "title",
                                            wagtail.blocks.CharBlock(
                                                default="Services",
                                                label="Key points section title",
                                                max_length=255,
                                            ),
                                        ),
                                        (
                                            "heading_for_key_points",
                                            wagtail.blocks.RichTextBlock(
                                                required=False
                                            ),
                                        ),
                                        (
                                            "key_points",
                                            wagtail.blocks.ListBlock(
                                                wagtail.blocks.StructBlock(
                                                    [
                                                        (
                                                            "text",
                                                            wagtail.blocks.CharBlock(
                                                                max_length=255
                                                            ),
                                                        ),
                                                        (
                                                            "linked_page",
                                                            wagtail.blocks.PageChooserBlock(
                                                                required=False
                                                            ),
                                                        ),
                                                    ]
                                                )
                                            ),
                                        ),
                                        (
                                            "contact",
                                            wagtail.snippets.blocks.SnippetChooserBlock(
                                                "people.Contact", required=False
                                            ),
                                        ),
                                        (
                                            "contact_reasons",
                                            wagtail.snippets.blocks.SnippetChooserBlock(
                                                "people.ContactReasonsList",
                                                required=False,
                                            ),
                                        ),
                                    ],
                                    group="Page section",
                                ),
                            ),
                            (
                                "testimonials",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "title",
                                            wagtail.blocks.CharBlock(
                                                default="Clients",
                                                label="Testimonials section title",
                                                max_length=255,
                                            ),
                                        ),
                                        (
                                            "client_logos",
                                            wagtail.blocks.ListBlock(
                                                wagtail.images.blocks.ImageChooserBlock(),
                                                required=False,
                                            ),
                                        ),
                                        (
                                            "usa_client_logos",
                                            wagtail.blocks.ListBlock(
                                                wagtail.images.blocks.ImageChooserBlock(),
                                                label="Client logos (for USA users)",
                                                required=False,
                                            ),
                                        ),
                                        (
                                            "testimonials",
                                            wagtail.blocks.ListBlock(
                                                wagtail.blocks.StructBlock(
                                                    [
                                                        (
                                                            "quote",
                                                            wagtail.blocks.TextBlock(),
                                                        ),
                                                        (
                                                            "name",
                                                            wagtail.blocks.CharBlock(
                                                                max_length=255
                                                            ),
                                                        ),
                                                        (
                                                            "role",
                                                            wagtail.blocks.CharBlock(
                                                                max_length=255
                                                            ),
                                                        ),
                                                    ]
                                                ),
                                                required=False,
                                            ),
                                        ),
                                    ],
                                    group="Page section",
                                ),
                            ),
                            (
                                "processes",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "title",
                                            wagtail.blocks.CharBlock(
                                                default="Process",
                                                label="Process section title",
                                            ),
                                        ),
                                        (
                                            "heading_for_processes",
                                            wagtail.blocks.TextBlock(required=False),
                                        ),
                                        (
                                            "use_process_block_image",
                                            wagtail.blocks.BooleanBlock(
                                                default=False, required=False
                                            ),
                                        ),
                                        (
                                            "processes_section_embed_url",
                                            wagtail.embeds.blocks.EmbedBlock(
                                                label="Embed URL", required=False
                                            ),
                                        ),
                                        (
                                            "processes",
                                            wagtail.blocks.ListBlock(
                                                wagtail.blocks.StructBlock(
                                                    [
                                                        (
                                                            "title",
                                                            wagtail.blocks.TextBlock(),
                                                        ),
                                                        (
                                                            "description",
                                                            wagtail.blocks.TextBlock(),
                                                        ),
                                                        (
                                                            "external_link",
                                                            wagtail.blocks.URLBlock(
                                                                required=False
                                                            ),
                                                        ),
                                                        (
                                                            "page_link",
                                                            wagtail.blocks.PageChooserBlock(
                                                                required=False
                                                            ),
                                                        ),
                                                        (
                                                            "link_label",
                                                            wagtail.blocks.CharBlock(
                                                                required=False
                                                            ),
                                                        ),
                                                    ]
                                                )
                                            ),
                                        ),
                                        (
                                            "process_section_cta",
                                            wagtail.blocks.RichTextBlock(
                                                help_text="An opportunity to use a more flexible call to action, if the main “Contact” fields aren’t suitable",
                                                label="Process section CTA",
                                                required=False,
                                            ),
                                        ),
                                    ],
                                    group="Page section",
                                ),
                            ),
                            (
                                "work",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "title",
                                            wagtail.blocks.CharBlock(
                                                default="Work",
                                                label="Case studies section title",
                                            ),
                                        ),
                                        (
                                            "featured_case_studies",
                                            wagtail.blocks.ListBlock(
                                                wagtail.blocks.PageChooserBlock(
                                                    page_type=["work.WorkPage"]
                                                )
                                            ),
                                        ),
                                    ],
                                    group="Page section",
                                ),
                            ),
                            (
                                "thinking",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "title",
                                            wagtail.blocks.CharBlock(
                                                default="Thinking",
                                                label="Blogs section title",
                                            ),
                                        ),
                                        (
                                            "featured_blog_posts",
                                            wagtail.blocks.ListBlock(
                                                wagtail.blocks.PageChooserBlock(
                                                    page_type=["blog.BlogPage"]
                                                )
                                            ),
                                        ),
                                    ],
                                    group="Page section",
                                ),
                            ),
                            (
                                "key_points_summary",
                                wagtail.blocks.ListBlock(
                                    wagtail.blocks.StructBlock(
                                        [
                                            ("title", wagtail.blocks.CharBlock()),
                                            ("intro", wagtail.blocks.CharBlock()),
                                            ("link", wagtail.blocks.PageChooserBlock()),
                                        ]
                                    ),
                                    group="Content block",
                                    help_text="Please add a minumum of 4 and a maximum of 6 key points.",
                                    icon="list-ul",
                                    max_num=6,
                                    min_num=4,
                                    template="patterns/molecules/streamfield/blocks/key_points_summary.html",
                                ),
                            ),
                            (
                                "core_testimonials",
                                wagtail.blocks.ListBlock(
                                    wagtail.blocks.StructBlock(
                                        [
                                            (
                                                "quote",
                                                wagtail.blocks.CharBlock(
                                                    form_classname="quote title"
                                                ),
                                            ),
                                            ("name", wagtail.blocks.CharBlock()),
                                            ("role", wagtail.blocks.CharBlock()),
                                            (
                                                "link",
                                                wagtail.blocks.StreamBlock(
                                                    [
                                                        (
                                                            "internal_link",
                                                            wagtail.blocks.StructBlock(
                                                                [
                                                                    (
                                                                        "page",
                                                                        wagtail.blocks.PageChooserBlock(),
                                                                    ),
                                                                    (
                                                                        "link_text",
                                                                        wagtail.blocks.CharBlock(
                                                                            required=False
                                                                        ),
                                                                    ),
                                                                ]
                                                            ),
                                                        ),
                                                        (
                                                            "external_link",
                                                            wagtail.blocks.StructBlock(
                                                                [
                                                                    (
                                                                        "link_url",
                                                                        wagtail.blocks.URLBlock(
                                                                            label="URL"
                                                                        ),
                                                                    ),
                                                                    (
                                                                        "link_text",
                                                                        wagtail.blocks.CharBlock(),
                                                                    ),
                                                                ]
                                                            ),
                                                        ),
                                                    ],
                                                    required=False,
                                                ),
                                            ),
                                        ]
                                    ),
                                    group="Content block",
                                    icon="openquote",
                                    label="Testimonials",
                                    template="patterns/molecules/streamfield/blocks/testimonial_block.html",
                                ),
                            ),
                            (
                                "clients",
                                wagtail.blocks.ListBlock(
                                    wagtail.blocks.StructBlock(
                                        [
                                            (
                                                "image",
                                                wagtail.images.blocks.ImageChooserBlock(),
                                            ),
                                            (
                                                "link",
                                                wagtail.blocks.StreamBlock(
                                                    [
                                                        (
                                                            "internal_link",
                                                            wagtail.blocks.StructBlock(
                                                                [
                                                                    (
                                                                        "page",
                                                                        wagtail.blocks.PageChooserBlock(),
                                                                    ),
                                                                    (
                                                                        "link_text",
                                                                        wagtail.blocks.CharBlock(
                                                                            required=False
                                                                        ),
                                                                    ),
                                                                ]
                                                            ),
                                                        ),
                                                        (
                                                            "external_link",
                                                            wagtail.blocks.StructBlock(
                                                                [
                                                                    (
                                                                        "link_url",
                                                                        wagtail.blocks.URLBlock(
                                                                            label="URL"
                                                                        ),
                                                                    ),
                                                                    (
                                                                        "link_text",
                                                                        wagtail.blocks.CharBlock(),
                                                                    ),
                                                                ]
                                                            ),
                                                        ),
                                                    ],
                                                    required=False,
                                                ),
                                            ),
                                        ]
                                    ),
                                    group="Content block",
                                    icon="site",
                                    label="Clients logo",
                                    template="patterns/molecules/streamfield/blocks/client-logo-block.html",
                                ),
                            ),
                            (
                                "embed_plus_cta",
                                wagtail.blocks.StructBlock(
                                    [
                                        ("title", wagtail.blocks.CharBlock()),
                                        ("intro", wagtail.blocks.CharBlock()),
                                        (
                                            "link",
                                            wagtail.blocks.PageChooserBlock(
                                                required=False
                                            ),
                                        ),
                                        (
                                            "external_link",
                                            wagtail.blocks.URLBlock(
                                                label="External Link", required=False
                                            ),
                                        ),
                                        ("button_text", wagtail.blocks.CharBlock()),
                                        (
                                            "image",
                                            wagtail.images.blocks.ImageChooserBlock(
                                                required=False
                                            ),
                                        ),
                                        (
                                            "embed",
                                            wagtail.embeds.blocks.EmbedBlock(
                                                label="Youtube Embed", required=False
                                            ),
                                        ),
                                    ],
                                    group="Content block",
                                    icon="code",
                                    label="Embed + CTA",
                                    template="patterns/molecules/streamfield/blocks/embed_plus_cta_block.html",
                                ),
                            ),
                            (
                                "cta",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "text",
                                            wagtail.blocks.CharBlock(
                                                help_text="Words in  &lt;span&gt; tag will display in a contrasting colour."
                                            ),
                                        ),
                                        (
                                            "link",
                                            wagtail.blocks.StreamBlock(
                                                [
                                                    (
                                                        "internal_link",
                                                        wagtail.blocks.StructBlock(
                                                            [
                                                                (
                                                                    "page",
                                                                    wagtail.blocks.PageChooserBlock(),
                                                                ),
                                                                (
                                                                    "link_text",
                                                                    wagtail.blocks.CharBlock(
                                                                        required=False
                                                                    ),
                                                                ),
                                                            ]
                                                        ),
                                                    ),
                                                    (
                                                        "external_link",
                                                        wagtail.blocks.StructBlock(
                                                            [
                                                                (
                                                                    "link_url",
                                                                    wagtail.blocks.URLBlock(
                                                                        label="URL"
                                                                    ),
                                                                ),
                                                                (
                                                                    "link_text",
                                                                    wagtail.blocks.CharBlock(),
                                                                ),
                                                            ]
                                                        ),
                                                    ),
                                                ]
                                            ),
                                        ),
                                    ],
                                    group="Content block",
                                    icon="plus-inverse",
                                    label="CTA",
                                    template="patterns/molecules/streamfield/blocks/cta.html",
                                ),
                            ),
                        ],
                        blank=True,
                        use_json_field=True,
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.customimage",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
    ]
