# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-01-18 16:42
from __future__ import unicode_literals

from django.db import migrations


def populate_authors(apps, schema_editor):
    PersonPage = apps.get_model("people.PersonPage")
    Author = apps.get_model("people.Author")

    for person_page in PersonPage.objects.all():
        Author.objects.get_or_create(
            person_page=person_page,
            defaults={
                "name": person_page.title,
                "role": person_page.role,
                "image": person_page.image,
            },
        )


def nooperation(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ("people", "0002_author"),
    ]

    operations = [
        migrations.RunPython(populate_authors, nooperation),
    ]
