# Generated by Django 4.2.8 on 2024-01-02 15:35

from django.db import migrations, models
import django.db.models.deletion
import tbx.core.blocks
import wagtail.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
import wagtailmarkdown.blocks
import wagtailmedia.blocks


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtailcore", "0089_log_entry_data_json_null_to_object"),
        ("images", "0005_alter_rendition_file"),
    ]

    operations = [
        migrations.CreateModel(
            name="CourseLandingPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                ("social_text", models.CharField(blank=True, max_length=255)),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.customimage",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.CreateModel(
            name="CourseDetailPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                ("social_text", models.CharField(blank=True, max_length=255)),
                (
                    "strapline",
                    models.CharField(
                        help_text="Words in <span> tag will display in a contrasting colour.",
                        max_length=255,
                    ),
                ),
                (
                    "sessions",
                    models.CharField(
                        blank=True, help_text="e.g. 4 sessions", max_length=25
                    ),
                ),
                (
                    "cost",
                    models.CharField(
                        blank=True,
                        help_text="e.g.£999 / $1,299 per person ",
                        max_length=255,
                    ),
                ),
                ("intro", wagtail.fields.RichTextField(blank=True)),
                (
                    "header_link",
                    models.URLField(
                        blank=True, help_text="e.g. https://www.example.com"
                    ),
                ),
                (
                    "header_link_text",
                    models.CharField(
                        blank=True,
                        help_text="e.g. Visit example.com for dates",
                        max_length=255,
                    ),
                ),
                (
                    "body",
                    wagtail.fields.StreamField(
                        [
                            (
                                "h2",
                                wagtail.blocks.CharBlock(
                                    form_classname="title",
                                    icon="title",
                                    template="patterns/molecules/streamfield/blocks/heading2_block.html",
                                ),
                            ),
                            (
                                "h3",
                                wagtail.blocks.CharBlock(
                                    form_classname="title",
                                    icon="title",
                                    template="patterns/molecules/streamfield/blocks/heading3_block.html",
                                ),
                            ),
                            (
                                "h4",
                                wagtail.blocks.CharBlock(
                                    form_classname="title",
                                    icon="title",
                                    template="patterns/molecules/streamfield/blocks/heading4_block.html",
                                ),
                            ),
                            (
                                "intro",
                                wagtail.blocks.RichTextBlock(
                                    icon="pilcrow",
                                    template="patterns/molecules/streamfield/blocks/intro_block.html",
                                ),
                            ),
                            (
                                "paragraph",
                                wagtail.blocks.RichTextBlock(
                                    icon="pilcrow",
                                    template="patterns/molecules/streamfield/blocks/paragraph_block.html",
                                ),
                            ),
                            (
                                "aligned_image",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "image",
                                            wagtail.images.blocks.ImageChooserBlock(),
                                        ),
                                        (
                                            "alignment",
                                            tbx.core.blocks.ImageFormatChoiceBlock(),
                                        ),
                                        ("caption", wagtail.blocks.CharBlock()),
                                        (
                                            "attribution",
                                            wagtail.blocks.CharBlock(required=False),
                                        ),
                                    ],
                                    label="Aligned image",
                                    template="patterns/molecules/streamfield/blocks/aligned_image_block.html",
                                ),
                            ),
                            (
                                "wide_image",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "image",
                                            wagtail.images.blocks.ImageChooserBlock(),
                                        )
                                    ],
                                    label="Wide image",
                                    template="patterns/molecules/streamfield/blocks/wide_image_block.html",
                                ),
                            ),
                            (
                                "bustout",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "image",
                                            wagtail.images.blocks.ImageChooserBlock(),
                                        ),
                                        ("text", wagtail.blocks.RichTextBlock()),
                                    ],
                                    template="patterns/molecules/streamfield/blocks/bustout_block.html",
                                ),
                            ),
                            (
                                "pullquote",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "quote",
                                            wagtail.blocks.CharBlock(
                                                form_classname="quote title"
                                            ),
                                        ),
                                        ("attribution", wagtail.blocks.CharBlock()),
                                    ],
                                    template="patterns/molecules/streamfield/blocks/pullquote_block.html",
                                ),
                            ),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(
                                    icon="code",
                                    label="Raw HTML",
                                    template="patterns/molecules/streamfield/blocks/raw_html_block.html",
                                ),
                            ),
                            (
                                "mailchimp_form",
                                wagtail.blocks.RawHTMLBlock(
                                    icon="code",
                                    label="Mailchimp embedded form",
                                    template="patterns/molecules/streamfield/blocks/mailchimp_form_block.html",
                                ),
                            ),
                            (
                                "markdown",
                                wagtailmarkdown.blocks.MarkdownBlock(
                                    icon="code",
                                    template="patterns/molecules/streamfield/blocks/markdown_block.html",
                                ),
                            ),
                            (
                                "embed",
                                wagtail.embeds.blocks.EmbedBlock(
                                    group="Media",
                                    icon="code",
                                    template="patterns/molecules/streamfield/blocks/embed_block.html",
                                ),
                            ),
                            (
                                "video_block",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "video",
                                            wagtailmedia.blocks.VideoChooserBlock(),
                                        ),
                                        (
                                            "autoplay",
                                            wagtail.blocks.BooleanBlock(
                                                default=False,
                                                help_text="Automatically start and loop the video. Please use sparingly.",
                                                required=False,
                                            ),
                                        ),
                                        (
                                            "use_original_width",
                                            wagtail.blocks.BooleanBlock(
                                                default=False,
                                                help_text="Use the original width of the video instead of the default content width. Note that videos wider than the content width will be limited to the content width.",
                                                required=False,
                                            ),
                                        ),
                                    ],
                                    group="Media",
                                ),
                            ),
                            (
                                "story_embed",
                                tbx.core.blocks.ExternalStoryEmbedBlock(
                                    icon="code",
                                    template="patterns/molecules/streamfield/blocks/external_story_block.html",
                                ),
                            ),
                            (
                                "course_outline",
                                wagtail.blocks.StructBlock(
                                    [
                                        ("heading", wagtail.blocks.CharBlock()),
                                        (
                                            "course_outline",
                                            wagtail.blocks.ListBlock(
                                                wagtail.blocks.StructBlock(
                                                    [
                                                        (
                                                            "title",
                                                            wagtail.blocks.CharBlock(),
                                                        ),
                                                        (
                                                            "text",
                                                            wagtail.blocks.RichTextBlock(),
                                                        ),
                                                    ]
                                                )
                                            ),
                                        ),
                                    ]
                                ),
                            ),
                            (
                                "external_link_cta",
                                wagtail.blocks.StructBlock(
                                    [
                                        (
                                            "link_url",
                                            wagtail.blocks.URLBlock(
                                                label="External Link"
                                            ),
                                        ),
                                        ("heading", wagtail.blocks.CharBlock()),
                                        ("text", wagtail.blocks.CharBlock()),
                                    ]
                                ),
                            ),
                        ],
                        use_json_field=True,
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.customimage",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
    ]
