# Generated by Django 3.2.18 on 2023-06-20 08:20

from django.db import connection, migrations


def cleanup_old_database_tables_and_schema(apps, schema_editor):
    """
    This migration removes the `old` database schema
    and all celery-related tables from the database.
    """
    with connection.cursor() as cursor:
        cursor.execute(
            "SELECT table_name FROM information_schema.tables WHERE table_schema = 'public' AND (table_name LIKE 'celery\_%' OR table_name LIKE 'djcelery\_%' OR table_name LIKE 'djkombu\_%')"
        )
        tables = cursor.fetchall()
        for table in tables:
            cursor.execute(f"DROP TABLE IF EXISTS {table[0]} CASCADE;")
        cursor.execute("DROP SCHEMA IF EXISTS old CASCADE;")


class Migration(migrations.Migration):
    dependencies = [
        ("torchbox", "0146_alter_standardpage_additional_content"),
    ]

    operations = [
        migrations.RunPython(cleanup_old_database_tables_and_schema),
    ]
