# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2017-03-15 13:06


from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import taggit.managers
import tbx.core.blocks
import wagtail.blocks
import wagtail.fields
import wagtail.embeds.blocks
import wagtail.images.blocks
import wagtailmarkdown.blocks


class Migration(migrations.Migration):

    dependencies = [
        ("wagtailcore", "0032_add_bulk_delete_page_permission"),
        ("torchbox", "0092_servicepage_add_logos"),
    ]

    operations = [
        migrations.CreateModel(
            name="ExpertiseTag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "content_object",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="torchbox.BlogPageTagList",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="SectorTag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "content_object",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="torchbox.BlogPageTagList",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.RemoveField(model_name="workpageauthor", name="author",),
        migrations.RemoveField(model_name="workpageauthor", name="page",),
        migrations.RemoveField(model_name="workpagetagselect", name="page",),
        migrations.RemoveField(model_name="workpagetagselect", name="tag",),
        migrations.RemoveField(model_name="workpage", name="author_left",),
        migrations.RemoveField(model_name="workpage", name="body",),
        migrations.RemoveField(model_name="workpage", name="intro",),
        migrations.RemoveField(model_name="workpage", name="summary",),
        migrations.AlterField(
            model_name="blogpage",
            name="streamfield",
            field=wagtail.fields.StreamField(
                (
                    ("h2", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("h3", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("h4", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("intro", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                    ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                    (
                        "aligned_image",
                        wagtail.blocks.StructBlock(
                            (
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                ("alignment", tbx.core.blocks.ImageFormatChoiceBlock()),
                                ("caption", wagtail.blocks.CharBlock()),
                                (
                                    "attribution",
                                    wagtail.blocks.CharBlock(required=False),
                                ),
                            ),
                            label="Aligned image",
                        ),
                    ),
                    (
                        "wide_image",
                        wagtail.blocks.StructBlock(
                            (("image", wagtail.images.blocks.ImageChooserBlock()),),
                            label="Wide image",
                        ),
                    ),
                    (
                        "bustout",
                        wagtail.blocks.StructBlock(
                            (
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                ("text", wagtail.blocks.RichTextBlock()),
                            )
                        ),
                    ),
                    (
                        "pullquote",
                        wagtail.blocks.StructBlock(
                            (
                                (
                                    "quote",
                                    wagtail.blocks.CharBlock(classname="quote title"),
                                ),
                                ("attribution", wagtail.blocks.CharBlock()),
                            )
                        ),
                    ),
                    (
                        "raw_html",
                        wagtail.blocks.RawHTMLBlock(icon="code", label="Raw HTML"),
                    ),
                    ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                    ("markdown", wagtailmarkdown.blocks.MarkdownBlock(icon="code")),
                )
            ),
        ),
        migrations.AlterField(
            model_name="mainmenu",
            name="menu",
            field=wagtail.fields.StreamField(
                (
                    (
                        "items",
                        wagtail.blocks.StructBlock(
                            (
                                ("page", wagtail.blocks.PageChooserBlock()),
                                (
                                    "subitems",
                                    wagtail.blocks.StreamBlock(
                                        (
                                            (
                                                "subitem",
                                                wagtail.blocks.PageChooserBlock(),
                                            ),
                                        )
                                    ),
                                ),
                            )
                        ),
                    ),
                ),
                blank=True,
            ),
        ),
        migrations.AlterField(
            model_name="servicepage",
            name="streamfield",
            field=wagtail.fields.StreamField(
                (
                    (
                        "case_studies",
                        wagtail.blocks.StructBlock(
                            (
                                ("title", wagtail.blocks.CharBlock(required=True)),
                                ("intro", wagtail.blocks.TextBlock(required=True)),
                                (
                                    "case_studies",
                                    wagtail.blocks.ListBlock(
                                        wagtail.blocks.StructBlock(
                                            (
                                                (
                                                    "page",
                                                    wagtail.blocks.PageChooserBlock(
                                                        "torchbox.WorkPage"
                                                    ),
                                                ),
                                                (
                                                    "title",
                                                    wagtail.blocks.CharBlock(
                                                        required=False
                                                    ),
                                                ),
                                                (
                                                    "descriptive_title",
                                                    wagtail.blocks.CharBlock(
                                                        required=False
                                                    ),
                                                ),
                                                (
                                                    "image",
                                                    wagtail.images.blocks.ImageChooserBlock(
                                                        required=False
                                                    ),
                                                ),
                                            )
                                        )
                                    ),
                                ),
                            )
                        ),
                    ),
                    (
                        "highlights",
                        wagtail.blocks.StructBlock(
                            (
                                ("title", wagtail.blocks.CharBlock(required=True)),
                                ("intro", wagtail.blocks.TextBlock(required=False),),
                                (
                                    "highlights",
                                    wagtail.blocks.ListBlock(
                                        wagtail.blocks.TextBlock()
                                    ),
                                ),
                            )
                        ),
                    ),
                    (
                        "pull_quote",
                        wagtail.blocks.StructBlock(
                            (
                                (
                                    "quote",
                                    wagtail.blocks.CharBlock(classname="quote title"),
                                ),
                                ("attribution", wagtail.blocks.CharBlock()),
                            ),
                            template="blocks/pull_quote_block.html",
                        ),
                    ),
                    (
                        "process",
                        wagtail.blocks.StructBlock(
                            (
                                ("title", wagtail.blocks.CharBlock(required=True)),
                                ("intro", wagtail.blocks.TextBlock(required=False),),
                                (
                                    "steps",
                                    wagtail.blocks.ListBlock(
                                        wagtail.blocks.StructBlock(
                                            (
                                                (
                                                    "subtitle",
                                                    wagtail.blocks.CharBlock(
                                                        required=False
                                                    ),
                                                ),
                                                (
                                                    "title",
                                                    wagtail.blocks.CharBlock(
                                                        required=True
                                                    ),
                                                ),
                                                (
                                                    "icon",
                                                    wagtail.blocks.CharBlock(
                                                        help_text="Paste SVG code here",
                                                        max_length=9000,
                                                        required=True,
                                                    ),
                                                ),
                                                (
                                                    "description",
                                                    wagtail.blocks.TextBlock(
                                                        required=True
                                                    ),
                                                ),
                                            )
                                        )
                                    ),
                                ),
                            )
                        ),
                    ),
                    (
                        "people",
                        wagtail.blocks.StructBlock(
                            (
                                ("title", wagtail.blocks.CharBlock(required=True)),
                                ("intro", wagtail.blocks.TextBlock(required=True)),
                                (
                                    "people",
                                    wagtail.blocks.ListBlock(
                                        wagtail.blocks.PageChooserBlock()
                                    ),
                                ),
                            )
                        ),
                    ),
                    (
                        "featured_pages",
                        wagtail.blocks.StructBlock(
                            (
                                ("title", wagtail.blocks.CharBlock()),
                                (
                                    "pages",
                                    wagtail.blocks.ListBlock(
                                        wagtail.blocks.StructBlock(
                                            (
                                                (
                                                    "page",
                                                    wagtail.blocks.PageChooserBlock(),
                                                ),
                                                (
                                                    "image",
                                                    wagtail.images.blocks.ImageChooserBlock(),
                                                ),
                                                ("text", wagtail.blocks.TextBlock(),),
                                                (
                                                    "sub_text",
                                                    wagtail.blocks.CharBlock(
                                                        max_length=100
                                                    ),
                                                ),
                                            )
                                        )
                                    ),
                                ),
                            )
                        ),
                    ),
                    (
                        "sign_up_form_page",
                        wagtail.blocks.StructBlock(
                            (
                                (
                                    "page",
                                    wagtail.blocks.PageChooserBlock(
                                        "torchbox.SignUpFormPage"
                                    ),
                                ),
                            )
                        ),
                    ),
                    (
                        "logos",
                        wagtail.blocks.StructBlock(
                            (
                                ("title", wagtail.blocks.CharBlock()),
                                ("intro", wagtail.blocks.CharBlock()),
                                (
                                    "logos",
                                    wagtail.blocks.ListBlock(
                                        wagtail.blocks.StructBlock(
                                            (
                                                (
                                                    "image",
                                                    wagtail.images.blocks.ImageChooserBlock(),
                                                ),
                                                (
                                                    "link_page",
                                                    wagtail.blocks.PageChooserBlock(
                                                        required=False
                                                    ),
                                                ),
                                                (
                                                    "link_external",
                                                    wagtail.blocks.URLBlock(
                                                        required=False
                                                    ),
                                                ),
                                            )
                                        )
                                    ),
                                ),
                            )
                        ),
                    ),
                )
            ),
        ),
        migrations.AlterField(
            model_name="standardpage",
            name="streamfield",
            field=wagtail.fields.StreamField(
                (
                    ("h2", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("h3", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("h4", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("intro", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                    ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                    (
                        "aligned_image",
                        wagtail.blocks.StructBlock(
                            (
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                ("alignment", tbx.core.blocks.ImageFormatChoiceBlock()),
                                ("caption", wagtail.blocks.CharBlock()),
                                (
                                    "attribution",
                                    wagtail.blocks.CharBlock(required=False),
                                ),
                            ),
                            label="Aligned image",
                        ),
                    ),
                    (
                        "wide_image",
                        wagtail.blocks.StructBlock(
                            (("image", wagtail.images.blocks.ImageChooserBlock()),),
                            label="Wide image",
                        ),
                    ),
                    (
                        "bustout",
                        wagtail.blocks.StructBlock(
                            (
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                ("text", wagtail.blocks.RichTextBlock()),
                            )
                        ),
                    ),
                    (
                        "pullquote",
                        wagtail.blocks.StructBlock(
                            (
                                (
                                    "quote",
                                    wagtail.blocks.CharBlock(classname="quote title"),
                                ),
                                ("attribution", wagtail.blocks.CharBlock()),
                            )
                        ),
                    ),
                    (
                        "raw_html",
                        wagtail.blocks.RawHTMLBlock(icon="code", label="Raw HTML"),
                    ),
                    ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                    ("markdown", wagtailmarkdown.blocks.MarkdownBlock(icon="code")),
                )
            ),
        ),
        migrations.AlterField(
            model_name="workpage",
            name="streamfield",
            field=wagtail.fields.StreamField(
                (
                    ("h2", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("h3", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("h4", wagtail.blocks.CharBlock(classname="title", icon="title"),),
                    ("intro", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                    ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                    (
                        "aligned_image",
                        wagtail.blocks.StructBlock(
                            (
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                ("alignment", tbx.core.blocks.ImageFormatChoiceBlock()),
                                ("caption", wagtail.blocks.CharBlock()),
                                (
                                    "attribution",
                                    wagtail.blocks.CharBlock(required=False),
                                ),
                            ),
                            label="Aligned image",
                        ),
                    ),
                    (
                        "wide_image",
                        wagtail.blocks.StructBlock(
                            (("image", wagtail.images.blocks.ImageChooserBlock()),),
                            label="Wide image",
                        ),
                    ),
                    (
                        "bustout",
                        wagtail.blocks.StructBlock(
                            (
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                ("text", wagtail.blocks.RichTextBlock()),
                            )
                        ),
                    ),
                    (
                        "pullquote",
                        wagtail.blocks.StructBlock(
                            (
                                (
                                    "quote",
                                    wagtail.blocks.CharBlock(classname="quote title"),
                                ),
                                ("attribution", wagtail.blocks.CharBlock()),
                            )
                        ),
                    ),
                    (
                        "raw_html",
                        wagtail.blocks.RawHTMLBlock(icon="code", label="Raw HTML"),
                    ),
                    ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                    ("markdown", wagtailmarkdown.blocks.MarkdownBlock(icon="code")),
                )
            ),
        ),
        migrations.DeleteModel(name="WorkPageAuthor",),
        migrations.DeleteModel(name="WorkPageTagSelect",),
        migrations.AddField(
            model_name="workpage",
            name="expertises",
            field=taggit.managers.TaggableManager(
                blank=True,
                help_text="A comma-separated list of tags.",
                through="torchbox.ExpertiseTag",
                to="torchbox.BlogPageTagList",
                verbose_name="expertises",
            ),
        ),
        migrations.AddField(
            model_name="workpage",
            name="sectors",
            field=taggit.managers.TaggableManager(
                blank=True,
                help_text="A comma-separated list of tags.",
                through="torchbox.SectorTag",
                to="torchbox.BlogPageTagList",
                verbose_name="sectors",
            ),
        ),
    ]
