# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-06-01 15:30


from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields


class Migration(migrations.Migration):

    dependencies = [
        ("wagtailcore", "0023_alter_page_revision_on_delete_behaviour"),
        ("wagtaildocs", "0004_capitalizeverbose"),
        ("torchbox", "0028_auto_20160531_1640"),
    ]

    operations = [
        migrations.CreateModel(
            name="MarketingLandingPageHeaderRelatedLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "link_external",
                    models.URLField(blank=True, verbose_name="External link"),
                ),
                ("title", models.CharField(help_text="Link title", max_length=255)),
                (
                    "email_link",
                    models.EmailField(
                        blank=True,
                        help_text="Enter email address only, without 'mailto:'",
                        max_length=254,
                        verbose_name="Email link",
                    ),
                ),
                (
                    "link_document",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtaildocs.Document",
                    ),
                ),
                (
                    "link_page",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtailcore.Page",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="MarketingLandingPageIntroRelatedLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "link_external",
                    models.URLField(blank=True, verbose_name="External link"),
                ),
                ("title", models.CharField(help_text="Link title", max_length=255)),
                (
                    "email_link",
                    models.EmailField(
                        blank=True,
                        help_text="Enter email address only, without 'mailto:'",
                        max_length=254,
                        verbose_name="Email link",
                    ),
                ),
                (
                    "link_document",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtaildocs.Document",
                    ),
                ),
                (
                    "link_page",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtailcore.Page",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.RemoveField(
            model_name="marketinglandingpagerelatedlink", name="link_document",
        ),
        migrations.RemoveField(
            model_name="marketinglandingpagerelatedlink", name="link_page",
        ),
        migrations.RemoveField(
            model_name="marketinglandingpagerelatedlink", name="page",
        ),
        migrations.AddField(
            model_name="marketinglandingpage",
            name="intro_subtitle",
            field=models.CharField(
                blank=True, max_length=255, verbose_name="intro subtitle"
            ),
        ),
        migrations.AlterField(
            model_name="marketinglandingpage",
            name="intro",
            field=models.TextField(blank=True, verbose_name="header text"),
        ),
        migrations.DeleteModel(name="MarketingLandingPageRelatedLink",),
        migrations.AddField(
            model_name="marketinglandingpageintrorelatedlink",
            name="page",
            field=modelcluster.fields.ParentalKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="intro_related_links",
                to="torchbox.MarketingLandingPage",
            ),
        ),
        migrations.AddField(
            model_name="marketinglandingpageheaderrelatedlink",
            name="page",
            field=modelcluster.fields.ParentalKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="header_related_links",
                to="torchbox.MarketingLandingPage",
            ),
        ),
    ]
