# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-04-13 10:09


from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import wagtail.fields


class Migration(migrations.Migration):

    dependencies = [
        ("wagtailcore", "0023_alter_page_revision_on_delete_behaviour"),
        ("wagtaildocs", "0004_capitalizeverbose"),
        ("torchbox", "0021_auto_20160412_1508"),
    ]

    operations = [
        migrations.CreateModel(
            name="SignUpFormPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "formatted_title",
                    models.CharField(
                        blank=True,
                        help_text="This is the title displayed on the page, not the document title tag. HTML is permitted. Be careful.",
                        max_length=255,
                    ),
                ),
                ("intro", wagtail.fields.RichTextField()),
                (
                    "call_to_action_text",
                    models.CharField(
                        help_text="Displayed above the email submission form.",
                        max_length=255,
                    ),
                ),
                ("form_button_text", models.CharField(max_length=255)),
                (
                    "thank_you_text",
                    models.CharField(
                        help_text="Displayed on successful form submission.",
                        max_length=255,
                    ),
                ),
                (
                    "email_subject",
                    models.CharField(max_length=100, verbose_name="subject"),
                ),
                ("email_body", models.TextField(verbose_name="body")),
                (
                    "email_from_address",
                    models.EmailField(
                        help_text="Anything ending in @torchbox.com is good.",
                        max_length=254,
                        verbose_name="from address",
                    ),
                ),
                (
                    "call_to_action_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="torchbox.TorchboxImage",
                    ),
                ),
                (
                    "email_attachment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="wagtaildocs.Document",
                        verbose_name="attachment",
                    ),
                ),
            ],
            options={"abstract": False,},
            bases=("wagtailcore.page",),
        ),
        migrations.CreateModel(
            name="SignUpFormPageBullet",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "icon",
                    models.CharField(
                        choices=[
                            ("torchbox/includes/svg/bulb-svg.html", "Light bulb"),
                            ("torchbox/includes/svg/pro-svg.html", "Chart"),
                            ("torchbox/includes/svg/tick-svg.html", "Tick"),
                        ],
                        max_length=100,
                    ),
                ),
                ("title", models.CharField(max_length=100)),
                ("body", models.TextField()),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="bullet_points",
                        to="torchbox.SignUpFormPage",
                    ),
                ),
            ],
            options={"ordering": ["sort_order"], "abstract": False,},
        ),
        migrations.CreateModel(
            name="SignUpFormPageLogo",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "logo",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="torchbox.TorchboxImage",
                    ),
                ),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="logos",
                        to="torchbox.SignUpFormPage",
                    ),
                ),
            ],
            options={"ordering": ["sort_order"], "abstract": False,},
        ),
        migrations.CreateModel(
            name="SignUpFormPageQuote",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                ("quote", models.TextField()),
                ("author", models.CharField(max_length=100)),
                ("organisation", models.CharField(max_length=100)),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="quotes",
                        to="torchbox.SignUpFormPage",
                    ),
                ),
            ],
            options={"ordering": ["sort_order"], "abstract": False,},
        ),
        migrations.CreateModel(
            name="SignUpFormPageResponse",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date", models.DateTimeField(auto_now_add=True)),
                ("email", models.EmailField(max_length=254)),
            ],
            options={"ordering": ["-date"],},
        ),
    ]
