# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-01-21 12:56
from __future__ import unicode_literals

import json
from uuid import UUID, uuid3

from django.db import migrations

from wagtail.blocks import StreamValue
from wagtail.rich_text import RichText


UUID_NAMESPACE = UUID("eac1f6e4-1d92-468f-8896-37086343ae0d")


def migrate_blog_body_to_streamfield(apps, schema_editor):
    BlogPage = apps.get_model("blog.BlogPage")
    stream_block = BlogPage._meta.get_field("streamfield").stream_block

    # Update model
    for blog_page in (
        BlogPage.objects.exclude(body="")
        .exclude(body="<p></p>")
        .exclude(body="<p><br/></p>")
    ):
        # Add body as first block so it appears in the same place on the template
        blog_page.streamfield = StreamValue(
            stream_block,
            [
                (
                    "paragraph",
                    RichText(blog_page.body),
                    str(uuid3(UUID_NAMESPACE, blog_page.body)),
                ),
            ]
            + [
                (child.block_type, child.value, child.id)
                for child in blog_page.streamfield
            ],
        )

        blog_page.save()

    # Update revisions
    PageRevision = apps.get_model("wagtailcore.PageRevision")
    ContentType = apps.get_model("contenttypes.ContentType")
    blog_page_content_type = ContentType.objects.get(app_label="blog", model="blogpage")

    for revision in PageRevision.objects.filter(
        page__content_type=blog_page_content_type
    ):
        content = json.loads(revision.content_json)

        if content["body"] and content["body"] not in ["<p></p>", "<p><br/></p>"]:
            streamfield_json = content.get("streamfield", "")

            if streamfield_json:
                streamfield = json.loads(streamfield_json)
            else:
                streamfield = []

            streamfield.insert(
                0,
                {
                    "type": "paragraph",
                    "value": content["body"],
                    "id": str(uuid3(UUID_NAMESPACE, content["body"])),
                },
            )

            content["streamfield"] = json.dumps(streamfield)

            revision.content_json = json.dumps(content)
            revision.save()


def nooperation(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ("blog", "0007_rename_related_author_to_authors"),
    ]

    operations = [
        migrations.RunPython(migrate_blog_body_to_streamfield, nooperation),
        migrations.RemoveField(model_name="blogpage", name="body",),
    ]
