# Developing new books

This is a "guide" to develop mechanics for new books.

## Previous steps
* Download the code (or clone the git repository)
* Be sure the book you want to develop is listed at the file /src/ts/model/projectAon.ts. If it's not
  here, the book will not be downloaded from the PAON
* Setup the web part (compile Typescript, download books, etc), as it's described at ../README.md, 
  at sections "Setup" and "Setup web site". The Android part will not be needed
* Get a Good XML Editor (I use Visual Studio Code, to develop the application and to edit the XML files)
* Get a Good Browser (ex. Chrome or Firefox)

## Start the work session

* Open the XML files to edit (/www/data/mechanics-[BOOKNUMBER].xml and /www/data/objects.xml) with your
  Good XML Editor
* Open the browser
* Open the browser developer tools (F12)
* Open the application URL, with debug options (ex. http://localhost/kai/?debug=true)
* Start a new game with the book to develop

## Debug functions

If you play the game with the debug options ("?debug=true"), on the page bottom there are some useful
functions to debug and test the book:

* **Jump to section** : Move to that section (id on the book XML, usually "sectXXX" for numbered sections)
* **Go to disciplines** : Link to move to the disciplines section (to change your current disciplines)
* **Set next random number** : Sets the next number to pick on the random table if it's generated by the computer.
  For development it's better to use the "manual" random table
* **Switch language** : Switch between English and Spanish
* **Project AON section page**: Link to the PAON page for the current section. Only to debug HTML rendering, not needed
* **Reset section state**: This will reset the section state, as it's the first time you visit it
* **Origin sections**: Sections where you come from to this section
* **Tests**: Open a page to make some tests to validate the game mechanics.
* Also there are buttons to move to the previous and next section

Other actions for debug can be done at the console of the Developer Tools of the browser. The namespace for this
aaplication is "kai". Usually, you will need only the "actionChartController" object:

* kai.actionChartController.pick( objectId )
* kai.actionChartController.increaseMoney( amount )
* etc. (increaseArrows, increaseCombatSkill, increaseEndurance, increaseMeals, increaseMoney, increaseArrows,...). Look at
  actionChartController.ts file for details

## Develop sections

So, for each book section, sequentially , do this:

* Read the section
* If the section needs some mechanics, write them on the XML, and:
    * On the browser press Ctrl + F5 to reload the web / mechanics XMLs
    * Test the section mechanics. Use the "Reset section state" to re-test, if you don't have changed the XMLs (it's faster)
* Move to the next section

The implemented rules covers usually the 90% of the book, but there exceptions (a lot). If don't know how to implement a
rule or it's directly not implemented, put a "TODO:" comment on the XML and it' will be implemented later by me.

I have a rule: Don't be restrictive with choices. If a choice text explains a condition, and this condition is not satisfied, disable the choice. Otherwise, don't do interpretations, and don't disable the choice, let the player choose. Ex.:

* If you have completed the Lore-circle of the Spirit, turn to 25.
* If you wish to pick up the Silver Sceptre, turn to 223.
* If you wish to leave it where it is and continue, turn to 308.

If don't have the "Lore-circle of the Spirit", disable 25.  If you have the "Lore-circle of the Spirit", 
DON'T disable choices 223 and 308. I know this is subjective, and probably wrong, but let some freedom to the player. 

Other example:

* If you have any Fireseeds, turn to 10.
* If you possess the Sommerswerd, turn to 317.
* If you have neither of these Special Items, turn to 331.

If you don't have Fireseeds, disable 10. If you don't have Sommerswerd, disable 317. If you have Fireseeds OR Sommerswerd, disable 331, because the choice text say it explicitly.

Other example:

* If you possess the Sommerswerd turn to 308.
* If you do not possess this Special Item, turn to 248.

If you have the Sommerswerd, disable 248. If you don't have the Sommerswerd, disable 308 (both texts are explicit)

Other example:

* If you have the Magnakai Discipline of Invisibility, turn to 95.
* If you do not possess this skill, turn to 210.

If you have Invisibility discipline, disable 210. If you don't have it, disable 95 (explicit texts)

## Reminders and tricks

Sections with bow shots with a Random Table link to check if you hit, should contain this:
```xml
<randomTableIncrement increment="[BOWBONUS]" />
```
This will add the bonuses to the shot (Weaponmastery, bow object, etc.). Remember this bonus can be negative.

## Documentation

Cough Cough. Sources for mechanics documentation:
* /doc/README-objects.md and /doc/README-objects.md (unfinished)
* Already implemented production books XML
* The mechanicsEngine.ts source file
* The /www/data/mechanics.xsd file describes and validates the mechanics file format
