# Mohave Typefaces


## A Titling Display Fonts

Initially designed by [Gumpita Rahayu](https://www.tokotypefaces.com). as all-caps display fonts in 2013, it was expanded into a 4 weights family including matched italic in 2018.

Mohave is a titling display typeface, built with smooth height and dynamic glyph. This typeface is designed for large points setting and contains four weights. with each letterform is nearly monolinear, with fewer corrections applied to stroke and joints to maintain the typefaces structure remain visible. The new version has new body shapes, with more neutral and modulated forms, including some alternates in the uppercase and lowercase and equipped with OpenType Pro encoding.

The Latin designed by Gumpita Rahayu.
To contribute, see <a href="https://github.com/tokotype/Mohave-Typefaces">github.com/tokotype/mohave-typefaces</a>

## Current Version
- Version 2.002 is the latest stable version. Work in progress Cyrillic and Greek language.
- Version 1.800 reworked glyphs shape, adding lowercase, alternates, etc.
- Version 1.000 initial released with all caps version as published on Behance (2013).

## Language Coverage
Afrikaans, Albanian, Asu, Basque, Bemba, Bena, Bosnian, Catalan, Chiga, Colognian, Cornish, Croatian, Czech, Danish, Embu, English, Esperanto, Estonian, Faroese, Filipino, Finnish, French, Friulian, Galician, German, Gusii, Hungarian, Icelandic, Indonesian, Irish, Italian, Kabuverdianu, Kalaallisut, Kalenjin, Kamba, Kikuyu, Kinyarwanda, Latvian, Lithuanian, Luo, Luyia, Machame, Makhuwa-Meetto, Makonde, Malagasy, Malay, Maltese, Manx, Meru, Morisyen, North Ndebele, Norwegian Bokmål, Norwegian Nynorsk, Nyankole, Oromo, Polish, Portuguese, Romanian, Rombo, Rundi, Rwa, Samburu, Sango, Sangu, Sena, Shambala, Shona, Slovak, Slovenian, Soga, Somali, Spanish, Swahili, Swedish, Swiss German, Taita, Teso, Vunjo, Walser, Zulu

## Formats
* OpenType (.otf)
* TrueType (.ttf)
* Webfonts (.eot, .woff and .woff2)
* Source File (.glyphs)


## Building

Fonts are built automatically by GitHub Actions - take a look in the "Actions" tab for the latest build.

If you particularly want to build fonts manually on your own computer, you will need to install the [`yq` utility](https://github.com/mikefarah/yq). On OS X with Homebrew, type `brew install yq`; on Linux, try `snap install yq`; if all else fails, try the instructions on the linked page.

Then:

* `make build` will produce font files.
* `make test` will run [FontBakery](https://github.com/googlefonts/fontbakery)'s quality assurance tests.
* `make proof` will generate HTML proof files.

## License

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is copied below, and is also available with a FAQ at
http://scripts.sil.org/OFL

## Repository Layout

This font repository structure is inspired by [Unified Font Repository v0.3](https://github.com/unified-font-repository/Unified-Font-Repository), modified for the Google Fonts workflow.


## Authors
[Gumpita Rahayu - Tokotype](https://www.tokotypefaces.com)  


## Links
* [tokotypefaces.com](https://www.tokotypefaces.com)
* [Behance](https://www.behance.net/gallery/8668939/Mohave-Typefaces)

## Images

![/documentation/img/mohave-1.png](/documentation/img/mohave-1.png)|![/documentation/img/mohave-2.png](/documentation/img/mohave-2.png)|![/documentation/img/mohave-3](/documentation/img/mohave-3.png)
----|---- |----
![/documentation/img/mohave-4.png](/documentation/img/mohave-4.png)|![/documentation/img/mohave-5.png](/documentation/img/mohave-5.png)|![/documentation/img/mohave-6.png](/documentation/img/mohave-6.png)
![/documentation/img/mohave-7.png](/documentation/img/mohave-7.png)|![/documentation/img/mohave-8.png](/documentation/img/mohave-8.png)|![/documentation/img/mohave-9.png](/documentation/img/mohave-9.png)
