每次面试多多少少都会被问到 HTTP、HTTPS、TCP、Socket、 OAuth 等等之类协议，协议相关的问题也可以说是面试必备，所以我把这些知识单独收集成了一篇文章。

- 网络协议有哪些？

> - 应用层：HTTP、FTP、SSH、SMTP
> - 表示层
> - 会话层
> - 传输层：TCP、UDP
> - 网络层：IP
> - 数据链路层
> - 物理层

- 简述 HTTP 协议的工作流程

> 1. 地址解析;  
> 在浏览器中输入 URL，浏览器会从中分解出协议名、主机名、端口、对象路径等部分
> 2. 封装 HTTP 请求数据包
> 3. 浏览器获取主机 IP 地址，建立 TCP 链接（TCP 的三次握手）
> 4. TCP 链接建立后发送 HTTP 请求  
> 请求方式的格式为：统一资源标识符（URL）、协议版本号，后边是 MIME 信息包括请求修饰符、客户机信息和可内容。
> 5. 服务器接到请求后，给予相应的响应信息  
> 其格式为一个状态行，包括信息的协议版本号、一个成功或错误的代码，后边是 MIME 信息包括服务器信息、实体信息和可能的内容
> 6. 服务器断开 TCP 连接

- 什么是 HTTPS？实现过程是什么？ 

> HTTPS（超文本传输安全协议）是一种通过计算机网络进行安全通信的传输协议，提供对网站服务器的身份认证，保护数据传输的完整性、安全性。
> 
> 实现过程：
> 1. 客户端发起一个 https 的请求
> 2. 服务端接收客户端请求，返回数字证书相关信息
> 3. 客户端收到服务端响应
>    1. 验证证书的合法性  
>    2. 如果证书受信任，生成随机数的密码
>    3. 使用约定好的 HASH 算法计算握手消息，并使用生成的随机数对消息进行加密，然后发送给服务端
> 4. 网站接收浏览器发来的密文后
>    1. 使用私钥来解密握手消息取出随机数密码，再用随机数密码解密，握手消息与 HASH 值，并与传过来的HASH值做对比确认是否一致
>    2. 使用密码加密一段握手消息，发送给浏览器
> 5. 浏览器解密并计算握手消息的 HASH，如果与服务端发来的 HASH 一致，此时握手过程结束，之后所有的通信数据，将由之前浏览器生成的随机密码，并利用对称加密算法进行加密。

![HTTPS实现流程图](http://img.blog.csdn.net/20130924102812796)

- 数字证书都包含那些信息？

> - 证书的版本信息；
> - 证书的序列号，每个证书都有一个唯一的证书序列号；
> - 证书所使用的签名算法；
> - 证书的发行机构名称；
> - 证书的有效期；
> - 证书所有人的名称、公开密钥；
> - 证书发行者对证书的签名

- TCP 三次握手的流程

1. 客户端发送一个 SYN 标志位置 1 的包，指明客户端要连接服务器端的接口，发送完毕后，客户端进入 SYN_SEND 状态
2. 服务器发回确认包 (ACK) 应答。即 SYN 标志位和 ACK 标志位均为1。服务器端选择自己 ISN 序列号，放到 Seq 域里，同时将确认序号(Acknowledgement Number)设置为客户的 ISN 加1，即X+1。 发送完毕后，服务器端进入 SYN_RCVD 状态。
3. 客户端再次发送确认包(ACK)，SYN 标志位为0，ACK 标志位为1，并且把服务器发来 ACK 的序号字段+1，放在确定字段中发送给对方，并且在数据段放写ISN的+1

发送完毕后，客户端进入 ESTABLISHED 状态，当服务器端接收到这个包时，也进入 ESTABLISHED 状态，TCP 握手结束。

- 什么是 Socket？工作流程是怎样的？

> Socket 又称网络套接字，是一种操作系统提供的进程间通信机制。
> 
> 工作流程：
> 
> 1. 服务端先用 socket 函数来建立一个套接字，并调用 listen 函数，使服务端的这个端口和 IP 处于监听状态，等待客户端的连接
> 2. 客户端用 socket 函数建立一个套接字，设定远程 IP 和端口，并调用 connect 函数
> 3. 服务端用 accept 函数来接受远程计算机的连接，建立起与客户端之间的通信
> 4. 完成通信以后，最后使用 close 函数关闭 socket 连接。

- HTTP1.1 与 WebSocket 的区别？

> - HTTP 是一个单链接，只能做单向通讯，而 WebSocket 是一个持久链接，可用作双向通讯。
> - WebSocket 是基于 HTTP 来建立连接的，但在建立连接之后，真正的数据传输阶段是不需要 HTTP 协议参与的
> - WebSocket 的请求的头部和 HTTP 请求头部不同
> - WebSocket 传输的数据是二进制流，是以帧为单位，HTTP 是明文字符串传输

- 什么是 OAuth2.0 协议？运行流程是怎样的？

OAuth(Open Authorization) 协议为用户资源的授权提供了一个安全的、开放而又简易的标准，第三方无需使用用户的用户名与密码，就可以申请获得该用户资源的授权。

运行流程：

1. 用户打开客户端以后，客户端要求用户给予授权。
2. 用户同意给予客户端授权
3. 客户端使用上一步获得的授权，向认证服务器申请令牌。
4. 认证服务器对客户端进行认证以后，确认无误，同意发放令牌。
5. 客户端使用令牌，向资源服务器申请获取资源。
6. 资源服务器确认令牌无误，同意向客户端开放资源

OAuth 2.0 定义了四种授权方式，授权码模式、简化模式、密码模式、客户端模式，具体的授权流程，请看阮一峰老师的文章[理解OAuth 2.0](http://www.ruanyifeng.com/blog/2014/05/oauth_2_0.html)。

### 扩展阅读

- [https 原理](http://blog.csdn.net/clh604/article/details/22179907)
- [HTTPS 原理解析](https://juejin.im/entry/59f1b593f265da430b7a7898)
- [HTTPS 的工作原理](https://www.cnblogs.com/ttltry-air/archive/2012/08/20/2647898.html)
- [socket](https://baike.baidu.com/item/socket/281150)
- [HTTP与WebSocket的区别](http://blog.csdn.net/baiye_xing/article/details/73938360)
- [理解OAuth 2.0](http://www.ruanyifeng.com/blog/2014/05/oauth_2_0.html)