- MyISAM 和 InnoDB 的区别

> 1. MyISAM 查询效率更高，但是不支持事物
> 2. InnoDB 插入、更新较高，支持事物处理
> 3. MyISAM 支持表锁， InnoDb 支持行锁

- 什么是索引，作用是什么？常见索引类型有那些？Mysql 建立索引的原则？

> 索引是一种特殊的文件,它们包含着对数据表里所有记录的引用指针，相当于书本的目录。其作用就是加快数据的检索效率。常见索引类型有主键、唯一索引、复合索引、全文索引。
> 
> - 索引创建的原则
>   - 最左前缀原理
>   - 尽量的去扩展索引，而不是重复的新建新索引

- SQL 语句的优化方式？

> 1. 避免使用 Like 模糊查询
> 2. 只列出需要查询的字段，而不是所有
> 3. 不在 MySQL 中进行运算，减轻 MySQL 的压力
> 4. 经常查询的字段，创建合适的索引，提高查询效率

- 数据库的优化方式？

> 1. 合理的设计表结构、表索引
> 2. 不在数据库中做运算
> 3. 控制单表数据量
> 4. 数据量过大进行读写分离，使用INNODB存储引擎
> 5. 不再数据表中存储图片

- 什么是 MySQL 慢查询？又该如何优化？

> MySQL 中查询超过指定时间的语句，被称之为「慢查询」。该如何优化呢？优化 SQL 语句，创建合适的索引，如以上两个问题。

- MySQL 分库分表怎么设计

> 1. 垂直分表
> 
> 垂直分表在日常开发和设计中比较常见，通俗的说法叫做“大表拆小表”，某个表中的字段比较多，可以新建立一张“扩展表”，将不经常使用或者长度较大的字段，拆分出去放到“扩展表”中。
> 
> 2. 垂直分库
> 
> 基本的思路就是按照业务模块来划分出不同的数据库，而不是像早期一样将所有的数据表都放到同一个数据库中。  
> 
> 3. 水平分表
> 
> 水平分表也称为横向分表，比较容易理解，就是将表中不同的数据行按照一定规律分布到不同的数据库表中（这些表保存在同一个数据库中），这样来降低单表数据量，优化查询性能。 
> 
> 4. 水平分库分表
> 
> 水平分库分表与上面讲到的水平分表的思想相同，唯一不同的就是将这些拆分出来的表保存在不同的数据库中。

- 什么是 MySQL 死锁？如何有效降低死锁？

> 死锁：死锁一般是事务相互等待对方资源，最后形成环路，而无法继续运行。
> 
> 产生死锁的原因：
> 
> 1. 系统资源不足；
> 2. 进程运行推进的顺序不合适；
> 3. 资源分配不当等；
> 
> 如何有效降低死锁：
> 
> 1. 按同一顺序访问资源；
> 2. 避免事务中的用户交互；
> 3. 保持事务简短并在一个批处理中；
> 4. 使用低隔离级别；
> 5. 使用绑定连接；

- 什么是 MySQL 的事务？事务都有那些特性？

> 事务是一个序列操作，其中的操作要么都执行，要么都不执行，它是一个不可分割的工作单位，ACID 四大特性是事务的基础。
> 
> -  **原子性**：一个事务（transaction）中的所有操作，要么全部完成，要么全部不完成，不会结束在中间某个环节。
> - **一致性**：在事务开始之前和事务结束以后，数据库的完整性没有被破坏。
> - **隔离性**：数据库允许多个并发事务同时对其数据进行读写和修改的能力，隔离性可以防止多个事务并发执行时由于交叉执行而导致数据的不一致。
> - **持久性**：事务处理结束后，对数据的修改就是永久的，即便系统故障也不会丢失。

说起 MySQL 的事物，就会谈起并行事物而引发的问题，比如脏读、幻读和不可重复读。

- 什么是脏读、幻读和不可重复读？会产生什么问题？该如何解决？

> - **脏读** ：脏读就是指当一个事务正在访问数据，并且对数据进行了修改，而这种修改还没有提交到数据库中，这时，另外一个事务也访问这个数据，然后使用了这个数据。
> - **不可重复读** ：是指在一个事务内，多次读同一数据。在这个事务还没有结束时，另外一个事务再修改数据。那么第一个事务两次读到的的数据可能是不一样的，因此称为是不可重复读。
> - **幻读**：当某事物正在执行插入或删除操作同时，第二个事物也在操作此表的数据，就会显示有一行还未存在的数据，就像发生了幻觉一样。
> 
> 解决办法：如果在操作事务完成数据处理之前，任何其他事务都不可以操作此数据，则可避免该问题。

### 扩展阅读

- [MySQL索引入门简述](https://www.awaimai.com/531.html)
- [MySQL索引原理及慢查询优化](https://tech.meituan.com/mysql-index.html)
- [分库分表的几种常见形式](http://www.infoq.com/cn/articles/key-steps-and-likely-problems-of-split-table)
- [大众点评订单系统分库分表实践](https://tech.meituan.com/dianping_order_db_sharding.html)
- [MySQL 死锁问题及解决](http://onwise.xyz/2017/04/20/mysql-%E6%AD%BB%E9%94%81%E9%97%AE%E9%A2%98%E5%8F%8A%E8%A7%A3%E5%86%B3/)
- [MySQL索引背后的数据结构及算法原理](https://www.kancloud.cn/kancloud/theory-of-mysql-index/41846)
- [MySQL存储引擎InnoDB与Myisam的六大区别](https://my.oschina.net/junn/blog/183341)
- [MySQL存储引擎MyISAM与InnoDB的区别比较](https://www.awaimai.com/557.html)
- [『浅入深出』MySQL 中事务的实现](https://draveness.me/mysql-transaction#)
- [脏读、幻读和不可重复读](http://blog.sina.com.cn/s/blog_8020e4110101bfc6.html)
