Laravel 作为现在最流行的 PHP 框架，其中的知识较多，所以单独拿出来写一篇。

- 简述 Laravel 的生命周期

> Laravel 采用了单一入口模式，应用的所有请求入口都是 public/index.php 文件。
> 
> 1. 注册类文件自动加载器 : Laravel通过 composer 进行依赖管理，无需开发者手动导入各种类文件，而由自动加载器自行导入。
> 
> 2. 创建服务容器：从 bootstrap/app.php 文件中取得 Laravel 应用实例 $app (服务容器)
> 
> 3. 创建 HTTP / Console 内核：传入的请求会被发送给 HTTP 内核或者 console 内核进行处理
> 
> 4. 载入服务提供者至容器：  
> 在内核引导启动的过程中最重要的动作之一就是载入服务提供者到你的应用，服务提供者负责引导启动框架的全部各种组件，例如数据库、队列、验证器以及路由组件。
> 
> 5. 分发请求：一旦应用完成引导和所有服务提供者都注册完成，Request 将会移交给路由进行分发。路由将分发请求给一个路由或控制器，同时运行路由指定的中间件

- 服务提供者是什么？

> 服务提供者是所有 Laravel 应用程序引导启动的中心, Laravel 的核心服务器、注册服务容器绑定、事件监听、中间件、路由注册以及我们的应用程序都是由服务提供者引导启动的。

- IoC 容器是什么？

> IoC（Inversion of Control）译为 「控制反转」，也被叫做「依赖注入」(DI)。什么是「控制反转」？对象 A 功能依赖于对象 B，但是控制权由对象 A 来控制，控制权被颠倒，所以叫做「控制反转」，而「依赖注入」是实现 IoC 的方法，就是由 IoC 容器在运行期间，动态地将某种依赖关系注入到对象之中。
> 
> 其作用简单来讲就是利用依赖关系注入的方式，把复杂的应用程序分解为互相合作的对象，从而降低解决问题的复杂度，实现应用程序代码的低耦合、高扩展。
> 
> Laravel 中的服务容器是用于管理类的依赖和执行依赖注入的工具。

- Facades 是什么？

> Facades（一种设计模式，通常翻译为外观模式）提供了一个"static"（静态）接口去访问注册到 IoC 容器中的类。提供了简单、易记的语法，而无需记住必须手动注入或配置的长长的类名。此外，由于对 PHP 动态方法的独特用法，也使测试起来非常容易。

- Contract 是什么？

> Contract（契约）是 laravel  定义框架提供的核心服务的接口。Contract 和 Facades 并没有本质意义上的区别，其作用就是使接口低耦合、更简单。


- 依赖注入的原理？
 
> 这个不解释，这是理解 IoC 容器的前提。

- 谈谈 Laravel 和 YII 框架的区别

> 1. 在 YII 框架中的路由是通过书写 Controller、Action 间接定义路由，而 Laravel 中是在 route 路由文件中直接定义路由入口
> 2. Laravel 提供 ORM 对象关系映射，使读写数据库的操作更加简单
> 3. Laravel 提供更多的 Artisan 命令和脚手架开发
> 4. Laravel 的 Composer 扩展包比 Yii 框架更多，开发更加高效