DocTo Examples
==

Here is a list of examples on how to use DocTo.  You should find details of what you would like to do somewhere here.


Convert Word Document to another file type
==

 - [How do I Convert a Microsoft Word Doc to a Windows Rich Text Format?](ConvertDocToFileRTF.md)
 - [How do I Convert a Microsoft Word Doc to a Adobe PDF Format?](ConvertDocToFilePDF.md)
 - [How do I Convert a Microsoft Word Doc to a Text File?](ConvertDocToFileTXT.md)
 - [How do I Convert a Microsoft Word Doc to a Open Document Text Format?](ConvertDocToFileODD.md)
 - [How do I Convert a Microsoft Word Doc to a XML Document Format?](ConvertDocToFileXML.md)
 - [How do I Convert a Microsoft Word Doc to a HTML File?](ConvertDocToFileHTML.md)
 - [How do I Convert a Microsoft Word Doc to a Microsoft XPS Format?](ConvertDocToFileXPS.md)
 - [How do I Convert a Microsoft Word Doc to a Latest Microsoft Office Word 365 Version Format ?](ConvertDocToFileDOC.md)


Convert all Word Documents in a Directory
==

 - [How do I Convert a Folder full of Microsoft Word Documents to Windows Rich Text Format? ](ConvertDirDocToFileRTF.md)
 - [How do I Convert a Folder full of Microsoft Word Documents to Adobe PDF Format? ](ConvertDirDocToFilePDF.md)
 - [How do I Convert a Folder full of Microsoft Word Documents to HTML File? ](ConvertDirDocToFileHTML.md)
 - [How do I Convert a Folder full of Microsoft Word Documents to Latest Microsoft Office Word 365 Version Format ? ](ConvertDirDocToFileDOC.md)


Convert all RTF Documents in a Directory
==

 - [How do I Convert a Folder full of RTF (Rich Text) documents to Microsoft Word Document? ](ConvertDirRTFToFileDoc.md)
 - [How do I Convert a Folder full of RTF (Rich Text) documents to Adobe PDF Format? ](ConvertDirRTFToFilePDF.md)
 - [How do I Convert a Folder full of RTF (Rich Text) documents to Text File? ](ConvertDirRTFToFileTXT.md)
 - [How do I Convert a Folder full of RTF (Rich Text) documents to HTML File? ](ConvertDirRTFToFileHTML.md)


Convert all Text Files in a Directory
==

 - [How do I Convert a Folder full of text files to Microsoft Word Document? ](ConvertDirTXTToFileDoc.md)
 - [How do I Convert a Folder full of text files to Adobe PDF Format? ](ConvertDirTXTToFilePDF.md)


Convert all Word Documents in a Directory and remove after conversion
==

 - [How do I delete a file after Converting it to  RTF? ](ConvertDirToFileRemoveRTF.md)
 - [How do I delete a file after Converting it to  PDF? ](ConvertDirToFileRemovePDF.md)
 - [How do I delete a file after Converting it to  TXT? ](ConvertDirToFileRemoveTXT.md)
 - [How do I delete a file after Converting it to  ODD? ](ConvertDirToFileRemoveODD.md)
 - [How do I delete a file after Converting it to  XML? ](ConvertDirToFileRemoveXML.md)
 - [How do I delete a file after Converting it to  HTML? ](ConvertDirToFileRemoveHTML.md)
 - [How do I delete a file after Converting it to  HTML? ](ConvertDirToFileRemoveFilteredHTML.md)
 - [How do I delete a file after Converting it to  XPS? ](ConvertDirToFileRemoveXPS.md)
 - [How do I delete a file after Converting it to  DOC? ](ConvertDirToFileRemoveDOC.md)


Convert all Word Documents in a Directory and save with differnt extension
==

 - [ConvertDirDocToFile_NewExtDOC.md](ConvertDirDocToFile_NewExtDOC.md)


Convert Excel Spreadsheet to another file type
==

 - [How do I Convert a Microsoft Excel Spreadsheet to a CSV? ](ConvertXLSToFileCSV.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a PDF? ](ConvertXLSToFilePDF.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a TXT? ](ConvertXLSToFileTXT.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a TXT? ](ConvertXLSToFileUnicodeTXT.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a ODS? ](ConvertXLSToFileODS.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a XML? ](ConvertXLSToFileXML.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a HTML? ](ConvertXLSToFileHTML.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a xls? ](ConvertXLSToFile9795xls.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a XPS? ](ConvertXLSToFileXPS.md)


Convert Excel Spreadsheet to another file type and save to UNC path
==

 - [How do I Convert a Microsoft Excel Spreadsheet to a CSV and save it to a UNC network Drive? ](ConvertXLSToFileUNCCSV.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a PDF and save it to a UNC network Drive? ](ConvertXLSToFileUNCPDF.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a TXT and save it to a UNC network Drive? ](ConvertXLSToFileUNCTXT.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a HTML and save it to a UNC network Drive? ](ConvertXLSToFileUNCHTML.md)
 - [How do I Convert a Microsoft Excel Spreadsheet to a xls and save it to a UNC network Drive? ](ConvertXLSToFileUNC9795xls.md)


Convert Microsoft PowerPoint Presentation to another file type
==

 - [ConvertPPTToFilePDF.md](ConvertPPTToFilePDF.md)
 - [ConvertPPTToFileRTF.md](ConvertPPTToFileRTF.md)
 - [ConvertPPTToFileJPG.md](ConvertPPTToFileJPG.md)
 - [ConvertPPTToFilepptx.md](ConvertPPTToFilepptx.md)
 - [ConvertPPTToFilepng.md](ConvertPPTToFilepng.md)
 - [ConvertPPTToFilegif.md](ConvertPPTToFilegif.md)
 - [ConvertPPTToFileFilteredHTML.md](ConvertPPTToFileFilteredHTML.md)
 - [ConvertPPTToFileXPS.md](ConvertPPTToFileXPS.md)
 - [ConvertPPTToFilePPTX.md](ConvertPPTToFilePPTX.md)


Output Log values while Converting Word Document to PDF
==

 - [ConvertDocToFileLogL1PDF.md](ConvertDocToFileLogL1PDF.md)
 - [ConvertDocToFileLogL2PDF.md](ConvertDocToFileLogL2PDF.md)
 - [ConvertDocToFileLogL5PDF.md](ConvertDocToFileLogL5PDF.md)
 - [ConvertDocToFileLogL9PDF.md](ConvertDocToFileLogL9PDF.md)
 - [ConvertDocToFileLogL10PDF.md](ConvertDocToFileLogL10PDF.md)


Convert Word Document to another file type then fire a Webhook
==

 - [ConvertDocToFileWithWebhookRTF.md](ConvertDocToFileWithWebhookRTF.md)
 - [ConvertDocToFileWithWebhookPDF.md](ConvertDocToFileWithWebhookPDF.md)
 - [ConvertDocToFileWithWebhookODD.md](ConvertDocToFileWithWebhookODD.md)
 - [ConvertDocToFileWithWebhookHTML.md](ConvertDocToFileWithWebhookHTML.md)
 - [ConvertDocToFileWithWebhookFilteredHTML.md](ConvertDocToFileWithWebhookFilteredHTML.md)
 - [ConvertDocToFileWithWebhookXPS.md](ConvertDocToFileWithWebhookXPS.md)
 - [ConvertDocToFileWithWebhookDOC.md](ConvertDocToFileWithWebhookDOC.md)


Show Version of DocTo
==

 - [ShowVersionVersion.md](ShowVersionVersion.md)


Convert Word Docs for upload to Onedrive
==

 - [OneDriveConversionOneDrive.md](OneDriveConversionOneDrive.md)


Show boomarks from Word document in PDF
==

 - [BookmarksFromSourceWordBookmarkspdf.md](BookmarksFromSourceWordBookmarkspdf.md)
 - [BookmarksFromSourceNonepdf.md](BookmarksFromSourceNonepdf.md)


Show comments from Word document in PDF
==

 - [CommentsFromWordWordCommentspdf.md](CommentsFromWordWordCommentspdf.md)
 - [CommentsFromWordNoCommentspdf.md](CommentsFromWordNoCommentspdf.md)


Do not recurse SubDirs
==

 - [ConvertWithoutSubdirspdf.md](ConvertWithoutSubdirspdf.md)


Convert Word Document to PDF Files at <a href='https://www.iso.org/standard/38920.html'>ISO 19005-1</a> standard (PDF/A) format.
==

 - [ConvertToPDFArchiveiso19005-1pdf.md](ConvertToPDFArchiveiso19005-1pdf.md)


Convert Visio Document to another file type
==

 - [How do I Convert a Microsoft Visio Document to a Adobe PDF Format?](ConvertVSDToFilePDF.md)
 - [How do I Convert a Microsoft Visio Document to a Microsoft XPS Format?](ConvertVSDToFileXPS.md)


Help Text
--

DocTo outputs a [help file](HelpLog.md) which provides details of all options. 

Generated 20:20:29 20211211