# 🚀 Google AI Streaming Example with LangChain Go

Hello there, Go enthusiasts and AI adventurers! 👋 Welcome to this exciting example that showcases how to use Google AI's Gemini model with streaming capabilities using LangChain Go!

## 🎭 What This Example Does

This nifty little program does the following:

1. 🔑 It uses your Google API key to authenticate with Google AI services.
2. 🤖 It sets up a connection to the Gemini 1.5 Pro model.
3. 🧙‍♂️ It creates a fun scenario where the AI acts as a "company branding design wizard".
4. 💬 It asks the AI to suggest a good company name for a business that produces Go-backed LLM tools.
5. 🌊 It streams the AI's response in real-time, printing each chunk as it arrives.

## 🚀 How to Run

1. Make sure you have Go installed on your system.
2. Set your Google API key as an environment variable:
   ```
   export GOOGLE_API_KEY=your_api_key_here
   ```
3. Run the example:
   ```
   go run googleai-streaming-example.go
   ```

## 🎉 What to Expect

When you run this example, you'll see the AI's response streaming in real-time to your console. It's like watching a creative genius at work, coming up with a brilliant company name right before your eyes!

## 🛠 Customization

Feel free to modify the system message or the question to explore different scenarios. You can also change the model by updating the `WithDefaultModel` parameter.

Happy coding, and may your Go-backed LLM tools company have the coolest name in town! 🎊
