/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the w64 mingw-runtime package.
 * No warranty is given; refer to the file DISCLAIMER within this package.
 */
#ifndef _MSADERR_H_
#define _MSADERR_H_
#ifndef FACILITY_WINDOWS

#define FACILITY_WINDOWS 0x8
#define FACILITY_STORAGE 0x3
#define FACILITY_ITF 0x4

#define STATUS_SEVERITY_SUCCESS 0x0
#define STATUS_SEVERITY_COERROR 0x2

#define DB_E_BOGUS ((HRESULT)0x80040EFFL)
#endif

#ifndef OLEDBVER
#define OLEDBVER 0x0270
#endif

#define DB_E_BADACCESSORHANDLE ((HRESULT)0x80040E00L)
#define DB_E_ROWLIMITEXCEEDED ((HRESULT)0x80040E01L)
#define DB_E_READONLYACCESSOR ((HRESULT)0x80040E02L)
#define DB_E_SCHEMAVIOLATION ((HRESULT)0x80040E03L)
#define DB_E_BADROWHANDLE ((HRESULT)0x80040E04L)
#define DB_E_OBJECTOPEN ((HRESULT)0x80040E05L)

#if (OLEDBVER >= 0x0150)
#define DB_E_BADCHAPTER ((HRESULT)0x80040E06L)
#endif

#define DB_E_CANTCONVERTVALUE ((HRESULT)0x80040E07L)
#define DB_E_BADBINDINFO ((HRESULT)0x80040E08L)
#define DB_SEC_E_PERMISSIONDENIED ((HRESULT)0x80040E09L)
#define DB_E_NOTAREFERENCECOLUMN ((HRESULT)0x80040E0AL)

#if (OLEDBVER >= 0x0250)
#define DB_E_LIMITREJECTED ((HRESULT)0x80040E0BL)
#endif

#define DB_E_NOCOMMAND ((HRESULT)0x80040E0CL)

#if (OLEDBVER >= 0x0250)
#define DB_E_COSTLIMIT ((HRESULT)0x80040E0DL)
#endif

#define DB_E_BADBOOKMARK ((HRESULT)0x80040E0EL)
#define DB_E_BADLOCKMODE ((HRESULT)0x80040E0FL)
#define DB_E_PARAMNOTOPTIONAL ((HRESULT)0x80040E10L)
#define DB_E_BADCOLUMNID ((HRESULT)0x80040E11L)
#define DB_E_BADRATIO ((HRESULT)0x80040E12L)

#if (OLEDBVER >= 0x0200)
#define DB_E_BADVALUES ((HRESULT)0x80040E13L)
#endif

#define DB_E_ERRORSINCOMMAND ((HRESULT)0x80040E14L)
#define DB_E_CANTCANCEL ((HRESULT)0x80040E15L)
#define DB_E_DIALECTNOTSUPPORTED ((HRESULT)0x80040E16L)
#define DB_E_DUPLICATEDATASOURCE ((HRESULT)0x80040E17L)
#define DB_E_CANNOTRESTART ((HRESULT)0x80040E18L)
#define DB_E_NOTFOUND ((HRESULT)0x80040E19L)
#define DB_E_NEWLYINSERTED ((HRESULT)0x80040E1BL)

#if (OLEDBVER >= 0x0250)
#define DB_E_CANNOTFREE ((HRESULT)0x80040E1AL)
#define DB_E_GOALREJECTED ((HRESULT)0x80040E1CL)
#endif

#define DB_E_UNSUPPORTEDCONVERSION ((HRESULT)0x80040E1DL)
#define DB_E_BADSTARTPOSITION ((HRESULT)0x80040E1EL)

#if (OLEDBVER >= 0x0200)
#define DB_E_NOQUERY ((HRESULT)0x80040E1FL)
#endif

#define DB_E_NOTREENTRANT ((HRESULT)0x80040E20L)
#define DB_E_ERRORSOCCURRED ((HRESULT)0x80040E21L)
#define DB_E_NOAGGREGATION ((HRESULT)0x80040E22L)
#define DB_E_DELETEDROW ((HRESULT)0x80040E23L)
#define DB_E_CANTFETCHBACKWARDS ((HRESULT)0x80040E24L)
#define DB_E_ROWSNOTRELEASED ((HRESULT)0x80040E25L)
#define DB_E_BADSTORAGEFLAG ((HRESULT)0x80040E26L)

#if (OLEDBVER >= 0x0150)
#define DB_E_BADCOMPAREOP ((HRESULT)0x80040E27L)
#endif

#define DB_E_BADSTATUSVALUE ((HRESULT)0x80040E28L)
#define DB_E_CANTSCROLLBACKWARDS ((HRESULT)0x80040E29L)

#if (OLEDBVER >= 0x0250)
#define DB_E_BADREGIONHANDLE ((HRESULT)0x80040E2AL)
#define DB_E_NONCONTIGUOUSRANGE ((HRESULT)0x80040E2BL)
#define DB_E_INVALIDTRANSITION ((HRESULT)0x80040E2CL)
#define DB_E_NOTASUBREGION ((HRESULT)0x80040E2DL)
#endif

#define DB_E_MULTIPLESTATEMENTS ((HRESULT)0x80040E2EL)
#define DB_E_INTEGRITYVIOLATION ((HRESULT)0x80040E2FL)
#define DB_E_BADTYPENAME ((HRESULT)0x80040E30L)
#define DB_E_ABORTLIMITREACHED ((HRESULT)0x80040E31L)

#if (OLEDBVER >= 0x0200)
#define DB_E_ROWSETINCOMMAND ((HRESULT)0x80040E32L)
#define DB_E_CANTTRANSLATE ((HRESULT)0x80040E33L)
#endif

#define DB_E_DUPLICATEINDEXID ((HRESULT)0x80040E34L)
#define DB_E_NOINDEX ((HRESULT)0x80040E35L)
#define DB_E_INDEXINUSE ((HRESULT)0x80040E36L)
#define DB_E_NOTABLE ((HRESULT)0x80040E37L)
#define DB_E_CONCURRENCYVIOLATION ((HRESULT)0x80040E38L)
#define DB_E_BADCOPY ((HRESULT)0x80040E39L)
#define DB_E_BADPRECISION ((HRESULT)0x80040E3AL)
#define DB_E_BADSCALE ((HRESULT)0x80040E3BL)
#define DB_E_BADTABLEID ((HRESULT)0x80040E3CL)
#define DB_E_BADID DB_E_BADTABLEID
#define DB_E_BADTYPE ((HRESULT)0x80040E3DL)
#define DB_E_DUPLICATECOLUMNID ((HRESULT)0x80040E3EL)
#define DB_E_DUPLICATETABLEID ((HRESULT)0x80040E3FL)
#define DB_E_TABLEINUSE ((HRESULT)0x80040E40L)
#define DB_E_NOLOCALE ((HRESULT)0x80040E41L)
#define DB_E_BADRECORDNUM ((HRESULT)0x80040E42L)
#define DB_E_BOOKMARKSKIPPED ((HRESULT)0x80040E43L)
#define DB_E_BADPROPERTYVALUE ((HRESULT)0x80040E44L)
#define DB_E_INVALID ((HRESULT)0x80040E45L)
#define DB_E_BADACCESSORFLAGS ((HRESULT)0x80040E46L)
#define DB_E_BADSTORAGEFLAGS ((HRESULT)0x80040E47L)
#define DB_E_BYREFACCESSORNOTSUPPORTED ((HRESULT)0x80040E48L)
#define DB_E_NULLACCESSORNOTSUPPORTED ((HRESULT)0x80040E49L)
#define DB_E_NOTPREPARED ((HRESULT)0x80040E4AL)
#define DB_E_BADACCESSORTYPE ((HRESULT)0x80040E4BL)
#define DB_E_WRITEONLYACCESSOR ((HRESULT)0x80040E4CL)
#define DB_SEC_E_AUTH_FAILED ((HRESULT)0x80040E4DL)
#define DB_E_CANCELED ((HRESULT)0x80040E4EL)

#if (OLEDBVER >= 0x0200)
#define DB_E_CHAPTERNOTRELEASED ((HRESULT)0x80040E4FL)
#endif

#define DB_E_BADSOURCEHANDLE ((HRESULT)0x80040E50L)
#define DB_E_PARAMUNAVAILABLE ((HRESULT)0x80040E51L)
#define DB_E_ALREADYINITIALIZED ((HRESULT)0x80040E52L)
#define DB_E_NOTSUPPORTED ((HRESULT)0x80040E53L)
#define DB_E_MAXPENDCHANGESEXCEEDED ((HRESULT)0x80040E54L)
#define DB_E_BADORDINAL ((HRESULT)0x80040E55L)
#define DB_E_PENDINGCHANGES ((HRESULT)0x80040E56L)
#define DB_E_DATAOVERFLOW ((HRESULT)0x80040E57L)
#define DB_E_BADHRESULT ((HRESULT)0x80040E58L)
#define DB_E_BADLOOKUPID ((HRESULT)0x80040E59L)
#define DB_E_BADDYNAMICERRORID ((HRESULT)0x80040E5AL)
#define DB_E_PENDINGINSERT ((HRESULT)0x80040E5BL)
#define DB_E_BADCONVERTFLAG ((HRESULT)0x80040E5CL)
#define DB_E_BADPARAMETERNAME ((HRESULT)0x80040E5DL)
#define DB_E_MULTIPLESTORAGE ((HRESULT)0x80040E5EL)
#define DB_E_CANTFILTER ((HRESULT)0x80040E5FL)
#define DB_E_CANTORDER ((HRESULT)0x80040E60L)

#if (OLEDBVER >= 0x0200)
#define MD_E_BADTUPLE ((HRESULT)0x80040E61L)
#define MD_E_BADCOORDINATE ((HRESULT)0x80040E62L)
#define MD_E_INVALIDAXIS ((HRESULT)0x80040E63L)
#define MD_E_INVALIDCELLRANGE ((HRESULT)0x80040E64L)
#define DB_E_NOCOLUMN ((HRESULT)0x80040E65L)
#define DB_E_COMMANDNOTPERSISTED ((HRESULT)0x80040E67L)
#define DB_E_DUPLICATEID ((HRESULT)0x80040E68L)
#define DB_E_OBJECTCREATIONLIMITREACHED ((HRESULT)0x80040E69L)
#define DB_E_BADINDEXID ((HRESULT)0x80040E72L)
#define DB_E_BADINITSTRING ((HRESULT)0x80040E73L)
#define DB_E_NOPROVIDERSREGISTERED ((HRESULT)0x80040E74L)
#define DB_E_MISMATCHEDPROVIDER ((HRESULT)0x80040E75L)
#define DB_E_BADCOMMANDID ((HRESULT)0x80040E76L)
#endif

#if (OLEDBVER >= 0x0210)
#define SEC_E_PERMISSIONDENIED DB_SEC_E_PERMISSIONDENIED
#define SEC_E_BADTRUSTEEID ((HRESULT)0x80040E6AL)
#define SEC_E_NOTRUSTEEID ((HRESULT)0x80040E6BL)
#define SEC_E_NOMEMBERSHIPSUPPORT ((HRESULT)0x80040E6CL)
#define SEC_E_INVALIDOBJECT ((HRESULT)0x80040E6DL)
#define SEC_E_NOOWNER ((HRESULT)0x80040E6EL)
#define SEC_E_INVALIDACCESSENTRYLIST ((HRESULT)0x80040E6FL)
#define SEC_E_INVALIDOWNER ((HRESULT)0x80040E70L)
#define SEC_E_INVALIDACCESSENTRY ((HRESULT)0x80040E71L)
#define DB_E_BADCONSTRAINTTYPE ((HRESULT)0x80040E77L)
#define DB_E_BADCONSTRAINTFORM ((HRESULT)0x80040E78L)
#define DB_E_BADDEFERRABILITY ((HRESULT)0x80040E79L)
#define DB_E_BADMATCHTYPE ((HRESULT)0x80040E80L)
#define DB_E_BADUPDATEDELETERULE ((HRESULT)0x80040E8AL)
#define DB_E_BADCONSTRAINTID ((HRESULT)0x80040E8BL)
#define DB_E_BADCOMMANDFLAGS ((HRESULT)0x80040E8CL)
#define DB_E_OBJECTMISMATCH ((HRESULT)0x80040E8DL)
#define DB_E_NOSOURCEOBJECT ((HRESULT)0x80040E91L)
#define DB_E_RESOURCELOCKED ((HRESULT)0x80040E92L)
#define DB_E_NOTCOLLECTION ((HRESULT)0x80040E93L)
#define DB_E_READONLY ((HRESULT)0x80040E94L)
#define DB_E_ASYNCNOTSUPPORTED ((HRESULT)0x80040E95L)
#define DB_E_CANNOTCONNECT ((HRESULT)0x80040E96L)
#define DB_E_TIMEOUT ((HRESULT)0x80040E97L)
#define DB_E_RESOURCEEXISTS ((HRESULT)0x80040E98L)
#define DB_E_RESOURCEOUTOFSCOPE ((HRESULT)0x80040E8EL)
#define DB_E_DROPRESTRICTED ((HRESULT)0x80040E90L)
#define DB_E_DUPLICATECONSTRAINTID ((HRESULT)0x80040E99L)
#define DB_E_OUTOFSPACE ((HRESULT)0x80040E9AL)
#define SEC_E_PERMISSIONDENIED DB_SEC_E_PERMISSIONDENIED
#endif

#if (OLEDBVER >= 0x0250)
#define DB_SEC_E_SAFEMODE_DENIED ((HRESULT)0x80040E9BL)
#endif

#if (OLEDBVER >= 0x0260)
#define DB_E_NOSTATISTIC ((HRESULT)0x80040E9CL)
#define DB_E_ALTERRESTRICTED ((HRESULT)0x80040E9DL)
#define DB_E_RESOURCENOTSUPPORTED ((HRESULT)0x80040E9EL)
#define DB_E_NOCONSTRAINT ((HRESULT)0x80040E9FL)
#define DB_E_COLUMNUNAVAILABLE ((HRESULT)0x80040EA0L)
#endif

#define DB_S_ROWLIMITEXCEEDED ((HRESULT)0x00040EC0L)
#define DB_S_COLUMNTYPEMISMATCH ((HRESULT)0x00040EC1L)
#define DB_S_TYPEINFOOVERRIDDEN ((HRESULT)0x00040EC2L)
#define DB_S_BOOKMARKSKIPPED ((HRESULT)0x00040EC3L)

#if (OLEDBVER >= 0x0200)
#define DB_S_NONEXTROWSET ((HRESULT)0x00040EC5L)
#endif

#define DB_S_ENDOFROWSET ((HRESULT)0x00040EC6L)
#define DB_S_COMMANDREEXECUTED ((HRESULT)0x00040EC7L)
#define DB_S_BUFFERFULL ((HRESULT)0x00040EC8L)
#define DB_S_NORESULT ((HRESULT)0x00040EC9L)
#define DB_S_CANTRELEASE ((HRESULT)0x00040ECAL)

#if (OLEDBVER >= 0x0250)
#define DB_S_GOALCHANGED ((HRESULT)0x00040ECBL)
#endif

#if (OLEDBVER >= 0x0150)
#define DB_S_UNWANTEDOPERATION ((HRESULT)0x00040ECCL)
#endif

#define DB_S_DIALECTIGNORED ((HRESULT)0x00040ECDL)
#define DB_S_UNWANTEDPHASE ((HRESULT)0x00040ECEL)
#define DB_S_UNWANTEDREASON ((HRESULT)0x00040ECFL)

#if (OLEDBVER >= 0x0150)
#define DB_S_ASYNCHRONOUS ((HRESULT)0x00040ED0L)
#endif

#define DB_S_COLUMNSCHANGED ((HRESULT)0x00040ED1L)
#define DB_S_ERRORSRETURNED ((HRESULT)0x00040ED2L)
#define DB_S_BADROWHANDLE ((HRESULT)0x00040ED3L)
#define DB_S_DELETEDROW ((HRESULT)0x00040ED4L)

#if (OLEDBVER >= 0x0250)
#define DB_S_TOOMANYCHANGES ((HRESULT)0x00040ED5L)
#endif

#define DB_S_STOPLIMITREACHED ((HRESULT)0x00040ED6L)
#define DB_S_LOCKUPGRADED ((HRESULT)0x00040ED8L)
#define DB_S_PROPERTIESCHANGED ((HRESULT)0x00040ED9L)
#define DB_S_ERRORSOCCURRED ((HRESULT)0x00040EDAL)
#define DB_S_PARAMUNAVAILABLE ((HRESULT)0x00040EDBL)
#define DB_S_MULTIPLECHANGES ((HRESULT)0x00040EDCL)

#if (OLEDBVER >= 0x0210)
#define DB_S_NOTSINGLETON ((HRESULT)0x00040ED7L)
#define DB_S_NOROWSPECIFICCOLUMNS ((HRESULT)0x00040EDDL)
#endif

#ifdef MESSAGESANDHEADERS
#define STG_E_FILENOTFOUND ((HRESULT)0x80030002L)
#define STG_E_PATHNOTFOUND ((HRESULT)0x80030003L)
#define STG_E_FILEALREADYEXISTS ((HRESULT)0x80030050L)
#define STG_E_INVALIDHEADER ((HRESULT)0x800300FBL)
#define STG_E_INVALIDNAME ((HRESULT)0x800300FCL)
#define STG_E_OLDFORMAT ((HRESULT)0x80030104L)
#define STG_E_OLDDLL ((HRESULT)0x80030105L)
#endif
#endif
