

"use strict"

class projectqueue
{
  constructor( name, queues )
  {
    this.name = name
    this.calls = []
    this.callsbycallid = {}
    this.queues = queues
  }

  queue( call )
  {
    call.metadata.queue = {}
    call.metadata.queue.state = "waiting"
    call.metadata.queue.position = this.calls.length + 1
    call.history = "Call queued at position " + call.metadata.queue.position

    this.calls.push( call )
    this.callsbycallid[ call.info.callid ] = call

    call.onhangup = () =>
    {
      if( call.info.callid in this.callsbycallid )
      {
        call.history = "Call abandoned from queue"
        call.metadata.queue.state = "abandoned"
        this.calls.splice( call.metadata.queue.position - 1, 1 )
        delete this.callsbycallid[ call.info.callid ]
        this.queueposchanged()
      }
    }

    for( let cb of this.queues.onposchangecb )
    {
      cb( call )
    }
  }

  queueposchanged()
  {
    var pos = 1
    for( let call of this.calls )
    {
      call.metadata.queue.position = pos
      for( let cb of this.queues.onposchangecb )
      {
        cb( call )
      }
      call.history = "Call queue position changed to " + call.metadata.queue.position
      pos++
    }
  }

  /* When the call has been taken out (and answered) mark it so (delivered to an agent) */
  delivered( call )
  {
    delete this.callsbycallid[ call.info.callid ]
    call.metadata.queue.state = "talking"
  }
}

class projectqueues
{
  constructor()
  {
    this.queues = {}
    this.onposchangecb = []
  }

  find( name )
  {
    if( !( name in this.queues ) )
    {
      this.queues[ name ] = new projectqueue( name, this )
    }
    return this.queues[ name ]
  }

  set onpositionchange( cb )
  {
    this.onposchangecb.push( cb )
  }
}

module.exports = new projectqueues()