
@interface MaterialDesignSymbol : NSObject

+ (instancetype)iconWithCode:(NSString *)code fontSize:(CGFloat)fontSize;
- (UIImage *)imageWithSize:(CGSize)imageSize;
- (UIImage *)image;

- (void)addAttributes:(NSDictionary *)attributes;
- (void)addAttribute:(NSString *)name value:(id)value;
- (id)attribute:(NSString *)attributeName;

@end

extern const struct MaterialDesignIconCode {
    __unsafe_unretained NSString *threeDRotation24px;
    __unsafe_unretained NSString *threeDRotation48px;
    __unsafe_unretained NSString *accessibility24px;
    __unsafe_unretained NSString *accessibility48px;
    __unsafe_unretained NSString *accountBalance24px;
    __unsafe_unretained NSString *accountBalance48px;
    __unsafe_unretained NSString *accountBalanceWallet24px;
    __unsafe_unretained NSString *accountBalanceWallet48px;
    __unsafe_unretained NSString *accountBox18px;
    __unsafe_unretained NSString *accountBox24px;
    __unsafe_unretained NSString *accountBox48px;
    __unsafe_unretained NSString *accountChild24px;
    __unsafe_unretained NSString *accountChild48px;
    __unsafe_unretained NSString *accountCircle18px;
    __unsafe_unretained NSString *accountCircle24px;
    __unsafe_unretained NSString *accountCircle48px;
    __unsafe_unretained NSString *addShoppingCart24px;
    __unsafe_unretained NSString *addShoppingCart48px;
    __unsafe_unretained NSString *alarm24px;
    __unsafe_unretained NSString *alarm48px;
    __unsafe_unretained NSString *alarmAdd24px;
    __unsafe_unretained NSString *alarmAdd48px;
    __unsafe_unretained NSString *alarmOff24px;
    __unsafe_unretained NSString *alarmOff48px;
    __unsafe_unretained NSString *alarmOn24px;
    __unsafe_unretained NSString *alarmOn48px;
    __unsafe_unretained NSString *android24px;
    __unsafe_unretained NSString *android48px;
    __unsafe_unretained NSString *announcement24px;
    __unsafe_unretained NSString *announcement48px;
    __unsafe_unretained NSString *aspectRatio24px;
    __unsafe_unretained NSString *aspectRatio48px;
    __unsafe_unretained NSString *assessment24px;
    __unsafe_unretained NSString *assessment48px;
    __unsafe_unretained NSString *assignment24px;
    __unsafe_unretained NSString *assignment48px;
    __unsafe_unretained NSString *assignmentInd24px;
    __unsafe_unretained NSString *assignmentInd48px;
    __unsafe_unretained NSString *assignmentLate24px;
    __unsafe_unretained NSString *assignmentLate48px;
    __unsafe_unretained NSString *assignmentReturn24px;
    __unsafe_unretained NSString *assignmentReturn48px;
    __unsafe_unretained NSString *assignmentReturned24px;
    __unsafe_unretained NSString *assignmentReturned48px;
    __unsafe_unretained NSString *assignmentTurnedIn24px;
    __unsafe_unretained NSString *assignmentTurnedIn48px;
    __unsafe_unretained NSString *autorenew24px;
    __unsafe_unretained NSString *autorenew48px;
    __unsafe_unretained NSString *backup24px;
    __unsafe_unretained NSString *backup48px;
    __unsafe_unretained NSString *book24px;
    __unsafe_unretained NSString *book48px;
    __unsafe_unretained NSString *bookmark24px;
    __unsafe_unretained NSString *bookmark48px;
    __unsafe_unretained NSString *bookmarkOutline24px;
    __unsafe_unretained NSString *bookmarkOutline48px;
    __unsafe_unretained NSString *bugReport24px;
    __unsafe_unretained NSString *bugReport48px;
    __unsafe_unretained NSString *cached24px;
    __unsafe_unretained NSString *cached48px;
    __unsafe_unretained NSString *class24px;
    __unsafe_unretained NSString *class48px;
    __unsafe_unretained NSString *creditCard24px;
    __unsafe_unretained NSString *creditCard48px;
    __unsafe_unretained NSString *dashboard24px;
    __unsafe_unretained NSString *dashboard48px;
    __unsafe_unretained NSString *delete24px;
    __unsafe_unretained NSString *delete48px;
    __unsafe_unretained NSString *description24px;
    __unsafe_unretained NSString *description48px;
    __unsafe_unretained NSString *dns24px;
    __unsafe_unretained NSString *dns48px;
    __unsafe_unretained NSString *done24px;
    __unsafe_unretained NSString *done48px;
    __unsafe_unretained NSString *doneAll24px;
    __unsafe_unretained NSString *doneAll48px;
    __unsafe_unretained NSString *event18px;
    __unsafe_unretained NSString *event24px;
    __unsafe_unretained NSString *event48px;
    __unsafe_unretained NSString *exitToApp24px;
    __unsafe_unretained NSString *exitToApp48px;
    __unsafe_unretained NSString *explore24px;
    __unsafe_unretained NSString *explore48px;
    __unsafe_unretained NSString *extension24px;
    __unsafe_unretained NSString *extension48px;
    __unsafe_unretained NSString *faceUnlock24px;
    __unsafe_unretained NSString *faceUnlock48px;
    __unsafe_unretained NSString *favorite24px;
    __unsafe_unretained NSString *favorite48px;
    __unsafe_unretained NSString *favoriteOutline24px;
    __unsafe_unretained NSString *favoriteOutline48px;
    __unsafe_unretained NSString *findInPage24px;
    __unsafe_unretained NSString *findInPage48px;
    __unsafe_unretained NSString *findReplace24px;
    __unsafe_unretained NSString *findReplace48px;
    __unsafe_unretained NSString *flipToBack24px;
    __unsafe_unretained NSString *flipToBack48px;
    __unsafe_unretained NSString *flipToFront24px;
    __unsafe_unretained NSString *flipToFront48px;
    __unsafe_unretained NSString *getApp24px;
    __unsafe_unretained NSString *getApp48px;
    __unsafe_unretained NSString *grade24px;
    __unsafe_unretained NSString *grade48px;
    __unsafe_unretained NSString *groupWork24px;
    __unsafe_unretained NSString *groupWork48px;
    __unsafe_unretained NSString *help24px;
    __unsafe_unretained NSString *help48px;
    __unsafe_unretained NSString *highlightRemove24px;
    __unsafe_unretained NSString *highlightRemove48px;
    __unsafe_unretained NSString *history24px;
    __unsafe_unretained NSString *history48px;
    __unsafe_unretained NSString *home24px;
    __unsafe_unretained NSString *home48px;
    __unsafe_unretained NSString *https24px;
    __unsafe_unretained NSString *https48px;
    __unsafe_unretained NSString *info24px;
    __unsafe_unretained NSString *info48px;
    __unsafe_unretained NSString *infoOutline24px;
    __unsafe_unretained NSString *infoOutline48px;
    __unsafe_unretained NSString *input24px;
    __unsafe_unretained NSString *input48px;
    __unsafe_unretained NSString *invertColors24px;
    __unsafe_unretained NSString *invertColors48px;
    __unsafe_unretained NSString *label24px;
    __unsafe_unretained NSString *label48px;
    __unsafe_unretained NSString *labelOutline24px;
    __unsafe_unretained NSString *labelOutline48px;
    __unsafe_unretained NSString *language24px;
    __unsafe_unretained NSString *language48px;
    __unsafe_unretained NSString *launch24px;
    __unsafe_unretained NSString *launch48px;
    __unsafe_unretained NSString *list24px;
    __unsafe_unretained NSString *list48px;
    __unsafe_unretained NSString *lock24px;
    __unsafe_unretained NSString *lock48px;
    __unsafe_unretained NSString *lockOpen24px;
    __unsafe_unretained NSString *lockOpen48px;
    __unsafe_unretained NSString *lockOutline24px;
    __unsafe_unretained NSString *lockOutline48px;
    __unsafe_unretained NSString *loyalty24px;
    __unsafe_unretained NSString *loyalty48px;
    __unsafe_unretained NSString *markunreadMailbox24px;
    __unsafe_unretained NSString *markunreadMailbox48px;
    __unsafe_unretained NSString *noteAdd24px;
    __unsafe_unretained NSString *noteAdd48px;
    __unsafe_unretained NSString *openInBrowser24px;
    __unsafe_unretained NSString *openInBrowser48px;
    __unsafe_unretained NSString *openInNew24px;
    __unsafe_unretained NSString *openInNew48px;
    __unsafe_unretained NSString *openWith24px;
    __unsafe_unretained NSString *openWith48px;
    __unsafe_unretained NSString *pageview24px;
    __unsafe_unretained NSString *pageview48px;
    __unsafe_unretained NSString *payment24px;
    __unsafe_unretained NSString *payment48px;
    __unsafe_unretained NSString *permCameraMic24px;
    __unsafe_unretained NSString *permCameraMic48px;
    __unsafe_unretained NSString *permContactCal24px;
    __unsafe_unretained NSString *permContactCal48px;
    __unsafe_unretained NSString *permDataSetting24px;
    __unsafe_unretained NSString *permDataSetting48px;
    __unsafe_unretained NSString *permDeviceInfo24px;
    __unsafe_unretained NSString *permDeviceInfo48px;
    __unsafe_unretained NSString *permIdentity24px;
    __unsafe_unretained NSString *permIdentity48px;
    __unsafe_unretained NSString *permMedia24px;
    __unsafe_unretained NSString *permMedia48px;
    __unsafe_unretained NSString *permPhoneMsg24px;
    __unsafe_unretained NSString *permPhoneMsg48px;
    __unsafe_unretained NSString *permScanWifi24px;
    __unsafe_unretained NSString *permScanWifi48px;
    __unsafe_unretained NSString *pictureInPicture24px;
    __unsafe_unretained NSString *pictureInPicture48px;
    __unsafe_unretained NSString *polymer24px;
    __unsafe_unretained NSString *polymer48px;
    __unsafe_unretained NSString *print24px;
    __unsafe_unretained NSString *print48px;
    __unsafe_unretained NSString *queryBuilder24px;
    __unsafe_unretained NSString *queryBuilder48px;
    __unsafe_unretained NSString *questionAnswer24px;
    __unsafe_unretained NSString *questionAnswer48px;
    __unsafe_unretained NSString *receipt24px;
    __unsafe_unretained NSString *receipt48px;
    __unsafe_unretained NSString *redeem24px;
    __unsafe_unretained NSString *redeem48px;
    __unsafe_unretained NSString *reorder24px;
    __unsafe_unretained NSString *reportProblem24px;
    __unsafe_unretained NSString *reportProblem48px;
    __unsafe_unretained NSString *restore24px;
    __unsafe_unretained NSString *restore48px;
    __unsafe_unretained NSString *room24px;
    __unsafe_unretained NSString *room48px;
    __unsafe_unretained NSString *schedule24px;
    __unsafe_unretained NSString *schedule48px;
    __unsafe_unretained NSString *search24px;
    __unsafe_unretained NSString *search48px;
    __unsafe_unretained NSString *settings24px;
    __unsafe_unretained NSString *settings48px;
    __unsafe_unretained NSString *settingsApplications24px;
    __unsafe_unretained NSString *settingsApplications48px;
    __unsafe_unretained NSString *settingsBackupRestore24px;
    __unsafe_unretained NSString *settingsBackupRestore48px;
    __unsafe_unretained NSString *settingsBluetooth24px;
    __unsafe_unretained NSString *settingsBluetooth48px;
    __unsafe_unretained NSString *settingsCell24px;
    __unsafe_unretained NSString *settingsCell48px;
    __unsafe_unretained NSString *settingsDisplay24px;
    __unsafe_unretained NSString *settingsDisplay48px;
    __unsafe_unretained NSString *settingsEthernet24px;
    __unsafe_unretained NSString *settingsEthernet48px;
    __unsafe_unretained NSString *settingsInputAntenna24px;
    __unsafe_unretained NSString *settingsInputAntenna48px;
    __unsafe_unretained NSString *settingsInputComponent24px;
    __unsafe_unretained NSString *settingsInputComponent48px;
    __unsafe_unretained NSString *settingsInputComposite24px;
    __unsafe_unretained NSString *settingsInputComposite48px;
    __unsafe_unretained NSString *settingsInputHdmi24px;
    __unsafe_unretained NSString *settingsInputHdmi48px;
    __unsafe_unretained NSString *settingsInputSvideo24px;
    __unsafe_unretained NSString *settingsInputSvideo48px;
    __unsafe_unretained NSString *settingsOverscan24px;
    __unsafe_unretained NSString *settingsOverscan48px;
    __unsafe_unretained NSString *settingsPhone24px;
    __unsafe_unretained NSString *settingsPhone48px;
    __unsafe_unretained NSString *settingsPower24px;
    __unsafe_unretained NSString *settingsPower48px;
    __unsafe_unretained NSString *settingsRemote24px;
    __unsafe_unretained NSString *settingsRemote48px;
    __unsafe_unretained NSString *settingsVoice24px;
    __unsafe_unretained NSString *settingsVoice48px;
    __unsafe_unretained NSString *shop24px;
    __unsafe_unretained NSString *shop48px;
    __unsafe_unretained NSString *shopTwo24px;
    __unsafe_unretained NSString *shopTwo48px;
    __unsafe_unretained NSString *shoppingBasket24px;
    __unsafe_unretained NSString *shoppingBasket48px;
    __unsafe_unretained NSString *shoppingCart24px;
    __unsafe_unretained NSString *shoppingCart48px;
    __unsafe_unretained NSString *speakerNotes24px;
    __unsafe_unretained NSString *speakerNotes48px;
    __unsafe_unretained NSString *spellcheck24px;
    __unsafe_unretained NSString *spellcheck48px;
    __unsafe_unretained NSString *starRate24px;
    __unsafe_unretained NSString *starRate48px;
    __unsafe_unretained NSString *stars24px;
    __unsafe_unretained NSString *stars48px;
    __unsafe_unretained NSString *store24px;
    __unsafe_unretained NSString *store48px;
    __unsafe_unretained NSString *subject24px;
    __unsafe_unretained NSString *subject48px;
    __unsafe_unretained NSString *supervisorAccount24px;
    __unsafe_unretained NSString *swapHoriz24px;
    __unsafe_unretained NSString *swapHoriz48px;
    __unsafe_unretained NSString *swapVert24px;
    __unsafe_unretained NSString *swapVert48px;
    __unsafe_unretained NSString *swapVertCircle24px;
    __unsafe_unretained NSString *swapVertCircle48px;
    __unsafe_unretained NSString *systemUpdateTv24px;
    __unsafe_unretained NSString *systemUpdateTv48px;
    __unsafe_unretained NSString *tab24px;
    __unsafe_unretained NSString *tab48px;
    __unsafe_unretained NSString *tabUnselected24px;
    __unsafe_unretained NSString *tabUnselected48px;
    __unsafe_unretained NSString *theaters24px;
    __unsafe_unretained NSString *theaters48px;
    __unsafe_unretained NSString *thumbDown24px;
    __unsafe_unretained NSString *thumbDown48px;
    __unsafe_unretained NSString *thumbUp24px;
    __unsafe_unretained NSString *thumbUp48px;
    __unsafe_unretained NSString *thumbsUpDown24px;
    __unsafe_unretained NSString *thumbsUpDown48px;
    __unsafe_unretained NSString *toc24px;
    __unsafe_unretained NSString *toc48px;
    __unsafe_unretained NSString *today24px;
    __unsafe_unretained NSString *today48px;
    __unsafe_unretained NSString *trackChanges24px;
    __unsafe_unretained NSString *trackChanges48px;
    __unsafe_unretained NSString *translate24px;
    __unsafe_unretained NSString *translate48px;
    __unsafe_unretained NSString *trendingDown24px;
    __unsafe_unretained NSString *trendingDown48px;
    __unsafe_unretained NSString *trendingNeutral24px;
    __unsafe_unretained NSString *trendingNeutral48px;
    __unsafe_unretained NSString *trendingUp24px;
    __unsafe_unretained NSString *trendingUp48px;
    __unsafe_unretained NSString *turnedIn24px;
    __unsafe_unretained NSString *turnedIn48px;
    __unsafe_unretained NSString *turnedInNot24px;
    __unsafe_unretained NSString *turnedInNot48px;
    __unsafe_unretained NSString *verifiedUser24px;
    __unsafe_unretained NSString *verifiedUser48px;
    __unsafe_unretained NSString *viewAgenda24px;
    __unsafe_unretained NSString *viewAgenda48px;
    __unsafe_unretained NSString *viewArray24px;
    __unsafe_unretained NSString *viewArray48px;
    __unsafe_unretained NSString *viewCarousel24px;
    __unsafe_unretained NSString *viewCarousel48px;
    __unsafe_unretained NSString *viewColumn24px;
    __unsafe_unretained NSString *viewColumn48px;
    __unsafe_unretained NSString *viewDay24px;
    __unsafe_unretained NSString *viewDay48px;
    __unsafe_unretained NSString *viewHeadline24px;
    __unsafe_unretained NSString *viewHeadline48px;
    __unsafe_unretained NSString *viewList24px;
    __unsafe_unretained NSString *viewList48px;
    __unsafe_unretained NSString *viewModule24px;
    __unsafe_unretained NSString *viewModule48px;
    __unsafe_unretained NSString *viewQuilt24px;
    __unsafe_unretained NSString *viewQuilt48px;
    __unsafe_unretained NSString *viewStream24px;
    __unsafe_unretained NSString *viewStream48px;
    __unsafe_unretained NSString *viewWeek24px;
    __unsafe_unretained NSString *viewWeek48px;
    __unsafe_unretained NSString *visibility24px;
    __unsafe_unretained NSString *visibility48px;
    __unsafe_unretained NSString *visibilityOff24px;
    __unsafe_unretained NSString *visibilityOff48px;
    __unsafe_unretained NSString *walletGiftcard24px;
    __unsafe_unretained NSString *walletGiftcard48px;
    __unsafe_unretained NSString *walletMembership24px;
    __unsafe_unretained NSString *walletMembership48px;
    __unsafe_unretained NSString *walletTravel24px;
    __unsafe_unretained NSString *walletTravel48px;
    __unsafe_unretained NSString *work24px;
    __unsafe_unretained NSString *work48px;
    __unsafe_unretained NSString *error18px;
    __unsafe_unretained NSString *error24px;
    __unsafe_unretained NSString *error36px;
    __unsafe_unretained NSString *error48px;
    __unsafe_unretained NSString *warning18px;
    __unsafe_unretained NSString *warning24px;
    __unsafe_unretained NSString *warning36px;
    __unsafe_unretained NSString *warning48px;
    __unsafe_unretained NSString *album24px;
    __unsafe_unretained NSString *album48px;
    __unsafe_unretained NSString *avTimer24px;
    __unsafe_unretained NSString *avTimer48px;
    __unsafe_unretained NSString *closedCaption24px;
    __unsafe_unretained NSString *closedCaption48px;
    __unsafe_unretained NSString *equalizer24px;
    __unsafe_unretained NSString *equalizer48px;
    __unsafe_unretained NSString *explicit24px;
    __unsafe_unretained NSString *explicit48px;
    __unsafe_unretained NSString *fastForward24px;
    __unsafe_unretained NSString *fastForward48px;
    __unsafe_unretained NSString *fastRewind24px;
    __unsafe_unretained NSString *fastRewind48px;
    __unsafe_unretained NSString *games24px;
    __unsafe_unretained NSString *games48px;
    __unsafe_unretained NSString *hearing24px;
    __unsafe_unretained NSString *hearing48px;
    __unsafe_unretained NSString *highQuality24px;
    __unsafe_unretained NSString *highQuality48px;
    __unsafe_unretained NSString *loop24px;
    __unsafe_unretained NSString *loop48px;
    __unsafe_unretained NSString *mic24px;
    __unsafe_unretained NSString *mic48px;
    __unsafe_unretained NSString *micNone24px;
    __unsafe_unretained NSString *micNone48px;
    __unsafe_unretained NSString *micOff24px;
    __unsafe_unretained NSString *micOff48px;
    __unsafe_unretained NSString *movie24px;
    __unsafe_unretained NSString *movie48px;
    __unsafe_unretained NSString *myLibraryAdd24px;
    __unsafe_unretained NSString *myLibraryAdd48px;
    __unsafe_unretained NSString *myLibraryBooks24px;
    __unsafe_unretained NSString *myLibraryBooks48px;
    __unsafe_unretained NSString *myLibraryMusic24px;
    __unsafe_unretained NSString *myLibraryMusic48px;
    __unsafe_unretained NSString *newReleases24px;
    __unsafe_unretained NSString *newReleases48px;
    __unsafe_unretained NSString *notInterested24px;
    __unsafe_unretained NSString *notInterested48px;
    __unsafe_unretained NSString *pause24px;
    __unsafe_unretained NSString *pause48px;
    __unsafe_unretained NSString *pauseCircleFill24px;
    __unsafe_unretained NSString *pauseCircleFill48px;
    __unsafe_unretained NSString *pauseCircleOutline24px;
    __unsafe_unretained NSString *pauseCircleOutline48px;
    __unsafe_unretained NSString *playArrow24px;
    __unsafe_unretained NSString *playArrow48px;
    __unsafe_unretained NSString *playCircleFill24px;
    __unsafe_unretained NSString *playCircleFill48px;
    __unsafe_unretained NSString *playCircleOutline24px;
    __unsafe_unretained NSString *playCircleOutline48px;
    __unsafe_unretained NSString *playShoppingBag24px;
    __unsafe_unretained NSString *playShoppingBag48px;
    __unsafe_unretained NSString *playlistAdd24px;
    __unsafe_unretained NSString *playlistAdd48px;
    __unsafe_unretained NSString *queue24px;
    __unsafe_unretained NSString *queue48px;
    __unsafe_unretained NSString *queueMusic24px;
    __unsafe_unretained NSString *queueMusic48px;
    __unsafe_unretained NSString *radio24px;
    __unsafe_unretained NSString *radio48px;
    __unsafe_unretained NSString *recentActors24px;
    __unsafe_unretained NSString *recentActors48px;
    __unsafe_unretained NSString *repeat24px;
    __unsafe_unretained NSString *repeat48px;
    __unsafe_unretained NSString *repeatOne24px;
    __unsafe_unretained NSString *repeatOne48px;
    __unsafe_unretained NSString *replay24px;
    __unsafe_unretained NSString *replay48px;
    __unsafe_unretained NSString *shuffle24px;
    __unsafe_unretained NSString *shuffle48px;
    __unsafe_unretained NSString *skipNext24px;
    __unsafe_unretained NSString *skipNext48px;
    __unsafe_unretained NSString *skipPrevious24px;
    __unsafe_unretained NSString *skipPrevious48px;
    __unsafe_unretained NSString *snooze24px;
    __unsafe_unretained NSString *snooze48px;
    __unsafe_unretained NSString *stop24px;
    __unsafe_unretained NSString *stop48px;
    __unsafe_unretained NSString *subtitles24px;
    __unsafe_unretained NSString *subtitles48px;
    __unsafe_unretained NSString *surroundSound24px;
    __unsafe_unretained NSString *surroundSound48px;
    __unsafe_unretained NSString *videoCollection24px;
    __unsafe_unretained NSString *videoCollection48px;
    __unsafe_unretained NSString *videocam24px;
    __unsafe_unretained NSString *videocam48px;
    __unsafe_unretained NSString *videocamOff24px;
    __unsafe_unretained NSString *videocamOff48px;
    __unsafe_unretained NSString *volumeDown18px;
    __unsafe_unretained NSString *volumeDown24px;
    __unsafe_unretained NSString *volumeDown48px;
    __unsafe_unretained NSString *volumeMute18px;
    __unsafe_unretained NSString *volumeMute24px;
    __unsafe_unretained NSString *volumeMute48px;
    __unsafe_unretained NSString *volumeOff24px;
    __unsafe_unretained NSString *volumeOff48px;
    __unsafe_unretained NSString *volumeUp18px;
    __unsafe_unretained NSString *volumeUp24px;
    __unsafe_unretained NSString *volumeUp48px;
    __unsafe_unretained NSString *web24px;
    __unsafe_unretained NSString *web48px;
    __unsafe_unretained NSString *business24px;
    __unsafe_unretained NSString *business48px;
    __unsafe_unretained NSString *call24px;
    __unsafe_unretained NSString *call48px;
    __unsafe_unretained NSString *callEnd24px;
    __unsafe_unretained NSString *callEnd48px;
    __unsafe_unretained NSString *callMade24px;
    __unsafe_unretained NSString *callMade48px;
    __unsafe_unretained NSString *callMerge24px;
    __unsafe_unretained NSString *callMerge48px;
    __unsafe_unretained NSString *callMissed24px;
    __unsafe_unretained NSString *callMissed48px;
    __unsafe_unretained NSString *callReceived24px;
    __unsafe_unretained NSString *callReceived48px;
    __unsafe_unretained NSString *callSplit24px;
    __unsafe_unretained NSString *callSplit48px;
    __unsafe_unretained NSString *chat24px;
    __unsafe_unretained NSString *chat48px;
    __unsafe_unretained NSString *clearAll24px;
    __unsafe_unretained NSString *clearAll48px;
    __unsafe_unretained NSString *comment24px;
    __unsafe_unretained NSString *comment48px;
    __unsafe_unretained NSString *contacts24px;
    __unsafe_unretained NSString *contacts48px;
    __unsafe_unretained NSString *dialerSip24px;
    __unsafe_unretained NSString *dialerSip48px;
    __unsafe_unretained NSString *dialpad24px;
    __unsafe_unretained NSString *dialpad48px;
    __unsafe_unretained NSString *dndOn24px;
    __unsafe_unretained NSString *dndOn48px;
    __unsafe_unretained NSString *email24px;
    __unsafe_unretained NSString *email48px;
    __unsafe_unretained NSString *forum24px;
    __unsafe_unretained NSString *forum48px;
    __unsafe_unretained NSString *importExport24px;
    __unsafe_unretained NSString *importExport48px;
    __unsafe_unretained NSString *invertColorsOff24px;
    __unsafe_unretained NSString *invertColorsOff48px;
    __unsafe_unretained NSString *invertColorsOn24px;
    __unsafe_unretained NSString *invertColorsOn48px;
    __unsafe_unretained NSString *liveHelp24px;
    __unsafe_unretained NSString *liveHelp48px;
    __unsafe_unretained NSString *locationOff24px;
    __unsafe_unretained NSString *locationOff48px;
    __unsafe_unretained NSString *locationOn24px;
    __unsafe_unretained NSString *locationOn48px;
    __unsafe_unretained NSString *message24px;
    __unsafe_unretained NSString *message48px;
    __unsafe_unretained NSString *messenger24px;
    __unsafe_unretained NSString *messenger48px;
    __unsafe_unretained NSString *noSim24px;
    __unsafe_unretained NSString *noSim48px;
    __unsafe_unretained NSString *phone24px;
    __unsafe_unretained NSString *phone48px;
    __unsafe_unretained NSString *portableWifiOff24px;
    __unsafe_unretained NSString *portableWifiOff48px;
    __unsafe_unretained NSString *quickContactsDialer24px;
    __unsafe_unretained NSString *quickContactsDialer48px;
    __unsafe_unretained NSString *quickContactsMail24px;
    __unsafe_unretained NSString *quickContactsMail48px;
    __unsafe_unretained NSString *ringVolume24px;
    __unsafe_unretained NSString *ringVolume48px;
    __unsafe_unretained NSString *stayCurrentLandscape24px;
    __unsafe_unretained NSString *stayCurrentLandscape48px;
    __unsafe_unretained NSString *stayCurrentPortrait24px;
    __unsafe_unretained NSString *stayCurrentPortrait48px;
    __unsafe_unretained NSString *stayPrimaryLandscape24px;
    __unsafe_unretained NSString *stayPrimaryLandscape48px;
    __unsafe_unretained NSString *stayPrimaryPortrait24px;
    __unsafe_unretained NSString *stayPrimaryPortrait48px;
    __unsafe_unretained NSString *swapCalls24px;
    __unsafe_unretained NSString *swapCalls48px;
    __unsafe_unretained NSString *textsms24px;
    __unsafe_unretained NSString *textsms48px;
    __unsafe_unretained NSString *voicemail24px;
    __unsafe_unretained NSString *voicemail48px;
    __unsafe_unretained NSString *vpnKey24px;
    __unsafe_unretained NSString *vpnKey48px;
    __unsafe_unretained NSString *add24px;
    __unsafe_unretained NSString *add48px;
    __unsafe_unretained NSString *addBox24px;
    __unsafe_unretained NSString *addBox48px;
    __unsafe_unretained NSString *addCircle24px;
    __unsafe_unretained NSString *addCircle48px;
    __unsafe_unretained NSString *addCircleOutline24px;
    __unsafe_unretained NSString *addCircleOutline48px;
    __unsafe_unretained NSString *archive24px;
    __unsafe_unretained NSString *archive48px;
    __unsafe_unretained NSString *backspace24px;
    __unsafe_unretained NSString *backspace48px;
    __unsafe_unretained NSString *block24px;
    __unsafe_unretained NSString *block48px;
    __unsafe_unretained NSString *clear24px;
    __unsafe_unretained NSString *clear48px;
    __unsafe_unretained NSString *contentCopy24px;
    __unsafe_unretained NSString *contentCopy48px;
    __unsafe_unretained NSString *contentCut24px;
    __unsafe_unretained NSString *contentCut48px;
    __unsafe_unretained NSString *contentPaste24px;
    __unsafe_unretained NSString *contentPaste48px;
    __unsafe_unretained NSString *create24px;
    __unsafe_unretained NSString *create48px;
    __unsafe_unretained NSString *drafts24px;
    __unsafe_unretained NSString *drafts48px;
    __unsafe_unretained NSString *filterList24px;
    __unsafe_unretained NSString *filterList48px;
    __unsafe_unretained NSString *flag24px;
    __unsafe_unretained NSString *flag48px;
    __unsafe_unretained NSString *forward24px;
    __unsafe_unretained NSString *forward48px;
    __unsafe_unretained NSString *gesture24px;
    __unsafe_unretained NSString *gesture48px;
    __unsafe_unretained NSString *inbox24px;
    __unsafe_unretained NSString *inbox48px;
    __unsafe_unretained NSString *link24px;
    __unsafe_unretained NSString *link48px;
    __unsafe_unretained NSString *mail24px;
    __unsafe_unretained NSString *mail48px;
    __unsafe_unretained NSString *markunread24px;
    __unsafe_unretained NSString *markunread48px;
    __unsafe_unretained NSString *redo24px;
    __unsafe_unretained NSString *redo48px;
    __unsafe_unretained NSString *remove24px;
    __unsafe_unretained NSString *remove48px;
    __unsafe_unretained NSString *removeCircle24px;
    __unsafe_unretained NSString *removeCircle48px;
    __unsafe_unretained NSString *removeCircleOutline24px;
    __unsafe_unretained NSString *removeCircleOutline48px;
    __unsafe_unretained NSString *reply24px;
    __unsafe_unretained NSString *reply48px;
    __unsafe_unretained NSString *replyAll24px;
    __unsafe_unretained NSString *replyAll48px;
    __unsafe_unretained NSString *report24px;
    __unsafe_unretained NSString *report48px;
    __unsafe_unretained NSString *save24px;
    __unsafe_unretained NSString *save48px;
    __unsafe_unretained NSString *selectAll24px;
    __unsafe_unretained NSString *selectAll48px;
    __unsafe_unretained NSString *send24px;
    __unsafe_unretained NSString *send48px;
    __unsafe_unretained NSString *sort24px;
    __unsafe_unretained NSString *sort48px;
    __unsafe_unretained NSString *textFormat24px;
    __unsafe_unretained NSString *textFormat48px;
    __unsafe_unretained NSString *undo24px;
    __unsafe_unretained NSString *undo48px;
    __unsafe_unretained NSString *accessAlarm24px;
    __unsafe_unretained NSString *accessAlarm48px;
    __unsafe_unretained NSString *accessAlarms24px;
    __unsafe_unretained NSString *accessAlarms48px;
    __unsafe_unretained NSString *accessTime24px;
    __unsafe_unretained NSString *accessTime48px;
    __unsafe_unretained NSString *addAlarm24px;
    __unsafe_unretained NSString *addAlarm48px;
    __unsafe_unretained NSString *airplanemodeOff24px;
    __unsafe_unretained NSString *airplanemodeOff48px;
    __unsafe_unretained NSString *airplanemodeOn24px;
    __unsafe_unretained NSString *airplanemodeOn48px;
    __unsafe_unretained NSString *battery2018px;
    __unsafe_unretained NSString *battery2024px;
    __unsafe_unretained NSString *battery2048px;
    __unsafe_unretained NSString *battery3018px;
    __unsafe_unretained NSString *battery3024px;
    __unsafe_unretained NSString *battery3048px;
    __unsafe_unretained NSString *battery5018px;
    __unsafe_unretained NSString *battery5024px;
    __unsafe_unretained NSString *battery5048px;
    __unsafe_unretained NSString *battery6018px;
    __unsafe_unretained NSString *battery6024px;
    __unsafe_unretained NSString *battery6048px;
    __unsafe_unretained NSString *battery8018px;
    __unsafe_unretained NSString *battery8024px;
    __unsafe_unretained NSString *battery8048px;
    __unsafe_unretained NSString *battery9018px;
    __unsafe_unretained NSString *battery9024px;
    __unsafe_unretained NSString *battery9048px;
    __unsafe_unretained NSString *batteryAlert18px;
    __unsafe_unretained NSString *batteryAlert24px;
    __unsafe_unretained NSString *batteryAlert48px;
    __unsafe_unretained NSString *batteryCharging2018px;
    __unsafe_unretained NSString *batteryCharging2024px;
    __unsafe_unretained NSString *batteryCharging2048px;
    __unsafe_unretained NSString *batteryCharging3018px;
    __unsafe_unretained NSString *batteryCharging3024px;
    __unsafe_unretained NSString *batteryCharging3048px;
    __unsafe_unretained NSString *batteryCharging5018px;
    __unsafe_unretained NSString *batteryCharging5024px;
    __unsafe_unretained NSString *batteryCharging5048px;
    __unsafe_unretained NSString *batteryCharging6018px;
    __unsafe_unretained NSString *batteryCharging6024px;
    __unsafe_unretained NSString *batteryCharging6048px;
    __unsafe_unretained NSString *batteryCharging8018px;
    __unsafe_unretained NSString *batteryCharging8024px;
    __unsafe_unretained NSString *batteryCharging8048px;
    __unsafe_unretained NSString *batteryCharging9018px;
    __unsafe_unretained NSString *batteryCharging9024px;
    __unsafe_unretained NSString *batteryCharging9048px;
    __unsafe_unretained NSString *batteryChargingFull18px;
    __unsafe_unretained NSString *batteryChargingFull24px;
    __unsafe_unretained NSString *batteryChargingFull48px;
    __unsafe_unretained NSString *batteryFull18px;
    __unsafe_unretained NSString *batteryFull24px;
    __unsafe_unretained NSString *batteryFull48px;
    __unsafe_unretained NSString *batteryStd18px;
    __unsafe_unretained NSString *batteryStd24px;
    __unsafe_unretained NSString *batteryStd48px;
    __unsafe_unretained NSString *batteryUnknown18px;
    __unsafe_unretained NSString *batteryUnknown24px;
    __unsafe_unretained NSString *batteryUnknown48px;
    __unsafe_unretained NSString *bluetooth24px;
    __unsafe_unretained NSString *bluetooth48px;
    __unsafe_unretained NSString *bluetoothConnected24px;
    __unsafe_unretained NSString *bluetoothConnected48px;
    __unsafe_unretained NSString *bluetoothDisabled24px;
    __unsafe_unretained NSString *bluetoothDisabled48px;
    __unsafe_unretained NSString *bluetoothSearching24px;
    __unsafe_unretained NSString *bluetoothSearching48px;
    __unsafe_unretained NSString *brightnessAuto24px;
    __unsafe_unretained NSString *brightnessAuto48px;
    __unsafe_unretained NSString *brightnessHigh24px;
    __unsafe_unretained NSString *brightnessHigh48px;
    __unsafe_unretained NSString *brightnessLow24px;
    __unsafe_unretained NSString *brightnessLow48px;
    __unsafe_unretained NSString *brightnessMedium24px;
    __unsafe_unretained NSString *brightnessMedium48px;
    __unsafe_unretained NSString *dataUsage24px;
    __unsafe_unretained NSString *dataUsage48px;
    __unsafe_unretained NSString *developerMode24px;
    __unsafe_unretained NSString *developerMode48px;
    __unsafe_unretained NSString *devices24px;
    __unsafe_unretained NSString *devices48px;
    __unsafe_unretained NSString *dvr24px;
    __unsafe_unretained NSString *dvr48px;
    __unsafe_unretained NSString *gpsFixed24px;
    __unsafe_unretained NSString *gpsFixed48px;
    __unsafe_unretained NSString *gpsNotFixed24px;
    __unsafe_unretained NSString *gpsNotFixed48px;
    __unsafe_unretained NSString *gpsOff24px;
    __unsafe_unretained NSString *gpsOff48px;
    __unsafe_unretained NSString *locationDisabled24px;
    __unsafe_unretained NSString *locationDisabled48px;
    __unsafe_unretained NSString *locationSearching24px;
    __unsafe_unretained NSString *locationSearching48px;
    __unsafe_unretained NSString *multitrackAudio24px;
    __unsafe_unretained NSString *multitrackAudio48px;
    __unsafe_unretained NSString *networkCell18px;
    __unsafe_unretained NSString *networkCell24px;
    __unsafe_unretained NSString *networkCell48px;
    __unsafe_unretained NSString *networkWifi18px;
    __unsafe_unretained NSString *networkWifi24px;
    __unsafe_unretained NSString *networkWifi48px;
    __unsafe_unretained NSString *nfc24px;
    __unsafe_unretained NSString *nfc48px;
    __unsafe_unretained NSString *nowWallpaper18px;
    __unsafe_unretained NSString *nowWallpaper24px;
    __unsafe_unretained NSString *nowWallpaper48px;
    __unsafe_unretained NSString *nowWidgets18px;
    __unsafe_unretained NSString *nowWidgets24px;
    __unsafe_unretained NSString *nowWidgets48px;
    __unsafe_unretained NSString *screenLockLandscape24px;
    __unsafe_unretained NSString *screenLockLandscape48px;
    __unsafe_unretained NSString *screenLockPortrait24px;
    __unsafe_unretained NSString *screenLockPortrait48px;
    __unsafe_unretained NSString *screenLockRotation24px;
    __unsafe_unretained NSString *screenLockRotation48px;
    __unsafe_unretained NSString *screenRotation24px;
    __unsafe_unretained NSString *screenRotation48px;
    __unsafe_unretained NSString *sdStorage24px;
    __unsafe_unretained NSString *sdStorage48px;
    __unsafe_unretained NSString *settingsSystemDaydream24px;
    __unsafe_unretained NSString *settingsSystemDaydream48px;
    __unsafe_unretained NSString *signalCellular0Bar18px;
    __unsafe_unretained NSString *signalCellular0Bar24px;
    __unsafe_unretained NSString *signalCellular0Bar48px;
    __unsafe_unretained NSString *signalCellular1Bar18px;
    __unsafe_unretained NSString *signalCellular1Bar24px;
    __unsafe_unretained NSString *signalCellular1Bar48px;
    __unsafe_unretained NSString *signalCellular2Bar18px;
    __unsafe_unretained NSString *signalCellular2Bar24px;
    __unsafe_unretained NSString *signalCellular2Bar48px;
    __unsafe_unretained NSString *signalCellular3Bar18px;
    __unsafe_unretained NSString *signalCellular3Bar24px;
    __unsafe_unretained NSString *signalCellular3Bar48px;
    __unsafe_unretained NSString *signalCellular4Bar18px;
    __unsafe_unretained NSString *signalCellular4Bar24px;
    __unsafe_unretained NSString *signalCellular4Bar48px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet0Bar18px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet0Bar24px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet0Bar48px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet1Bar18px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet1Bar24px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet1Bar48px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet2Bar18px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet2Bar24px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet2Bar48px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet3Bar18px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet3Bar24px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet3Bar48px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet4Bar18px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet4Bar24px;
    __unsafe_unretained NSString *signalCellularConnectedNoInternet4Bar48px;
    __unsafe_unretained NSString *signalCellularNoSim24px;
    __unsafe_unretained NSString *signalCellularNoSim48px;
    __unsafe_unretained NSString *signalCellularNull18px;
    __unsafe_unretained NSString *signalCellularNull24px;
    __unsafe_unretained NSString *signalCellularNull48px;
    __unsafe_unretained NSString *signalCellularOff18px;
    __unsafe_unretained NSString *signalCellularOff24px;
    __unsafe_unretained NSString *signalCellularOff48px;
    __unsafe_unretained NSString *signalWifi0Bar18px;
    __unsafe_unretained NSString *signalWifi0Bar24px;
    __unsafe_unretained NSString *signalWifi0Bar48px;
    __unsafe_unretained NSString *signalWifi1Bar18px;
    __unsafe_unretained NSString *signalWifi1Bar24px;
    __unsafe_unretained NSString *signalWifi1Bar48px;
    __unsafe_unretained NSString *signalWifi2Bar18px;
    __unsafe_unretained NSString *signalWifi2Bar24px;
    __unsafe_unretained NSString *signalWifi2Bar48px;
    __unsafe_unretained NSString *signalWifi3Bar18px;
    __unsafe_unretained NSString *signalWifi3Bar24px;
    __unsafe_unretained NSString *signalWifi3Bar48px;
    __unsafe_unretained NSString *signalWifi4Bar18px;
    __unsafe_unretained NSString *signalWifi4Bar24px;
    __unsafe_unretained NSString *signalWifi4Bar48px;
    __unsafe_unretained NSString *signalWifiOff18px;
    __unsafe_unretained NSString *signalWifiOff24px;
    __unsafe_unretained NSString *signalWifiOff48px;
    __unsafe_unretained NSString *signalWifiStatusbar1Bar26x24px;
    __unsafe_unretained NSString *signalWifiStatusbar2Bar26x24px;
    __unsafe_unretained NSString *signalWifiStatusbar3Bar26x24px;
    __unsafe_unretained NSString *signalWifiStatusbar4Bar26x24px;
    __unsafe_unretained NSString *signalWifiStatusbarConnectedNoInternet126x24px;
    __unsafe_unretained NSString *signalWifiStatusbarConnectedNoInternet226x24px;
    __unsafe_unretained NSString *signalWifiStatusbarConnectedNoInternet326x24px;
    __unsafe_unretained NSString *signalWifiStatusbarConnectedNoInternet426x24px;
    __unsafe_unretained NSString *signalWifiStatusbarConnectedNoInternet26x24px;
    __unsafe_unretained NSString *signalWifiStatusbarNotConnected26x24px;
    __unsafe_unretained NSString *signalWifiStatusbarNull26x24px;
    __unsafe_unretained NSString *storage24px;
    __unsafe_unretained NSString *storage48px;
    __unsafe_unretained NSString *usb18px;
    __unsafe_unretained NSString *usb24px;
    __unsafe_unretained NSString *usb48px;
    __unsafe_unretained NSString *wifiLock24px;
    __unsafe_unretained NSString *wifiLock48px;
    __unsafe_unretained NSString *wifiTethering24px;
    __unsafe_unretained NSString *wifiTethering48px;
    __unsafe_unretained NSString *attachFile18px;
    __unsafe_unretained NSString *attachFile24px;
    __unsafe_unretained NSString *attachFile48px;
    __unsafe_unretained NSString *attachMoney18px;
    __unsafe_unretained NSString *attachMoney24px;
    __unsafe_unretained NSString *attachMoney48px;
    __unsafe_unretained NSString *borderAll18px;
    __unsafe_unretained NSString *borderAll24px;
    __unsafe_unretained NSString *borderAll48px;
    __unsafe_unretained NSString *borderBottom18px;
    __unsafe_unretained NSString *borderBottom24px;
    __unsafe_unretained NSString *borderBottom48px;
    __unsafe_unretained NSString *borderClear18px;
    __unsafe_unretained NSString *borderClear24px;
    __unsafe_unretained NSString *borderClear48px;
    __unsafe_unretained NSString *borderColor18px;
    __unsafe_unretained NSString *borderColor24px;
    __unsafe_unretained NSString *borderColor48px;
    __unsafe_unretained NSString *borderHorizontal18px;
    __unsafe_unretained NSString *borderHorizontal24px;
    __unsafe_unretained NSString *borderHorizontal48px;
    __unsafe_unretained NSString *borderInner18px;
    __unsafe_unretained NSString *borderInner24px;
    __unsafe_unretained NSString *borderInner48px;
    __unsafe_unretained NSString *borderLeft18px;
    __unsafe_unretained NSString *borderLeft24px;
    __unsafe_unretained NSString *borderLeft48px;
    __unsafe_unretained NSString *borderOuter18px;
    __unsafe_unretained NSString *borderOuter24px;
    __unsafe_unretained NSString *borderOuter48px;
    __unsafe_unretained NSString *borderRight18px;
    __unsafe_unretained NSString *borderRight24px;
    __unsafe_unretained NSString *borderRight48px;
    __unsafe_unretained NSString *borderStyle18px;
    __unsafe_unretained NSString *borderStyle24px;
    __unsafe_unretained NSString *borderStyle48px;
    __unsafe_unretained NSString *borderTop18px;
    __unsafe_unretained NSString *borderTop24px;
    __unsafe_unretained NSString *borderTop48px;
    __unsafe_unretained NSString *borderVertical18px;
    __unsafe_unretained NSString *borderVertical24px;
    __unsafe_unretained NSString *borderVertical48px;
    __unsafe_unretained NSString *formatAlignCenter18px;
    __unsafe_unretained NSString *formatAlignCenter24px;
    __unsafe_unretained NSString *formatAlignCenter48px;
    __unsafe_unretained NSString *formatAlignJustify18px;
    __unsafe_unretained NSString *formatAlignJustify24px;
    __unsafe_unretained NSString *formatAlignJustify48px;
    __unsafe_unretained NSString *formatAlignLeft18px;
    __unsafe_unretained NSString *formatAlignLeft24px;
    __unsafe_unretained NSString *formatAlignLeft48px;
    __unsafe_unretained NSString *formatAlignRight18px;
    __unsafe_unretained NSString *formatAlignRight24px;
    __unsafe_unretained NSString *formatAlignRight48px;
    __unsafe_unretained NSString *formatBold18px;
    __unsafe_unretained NSString *formatBold24px;
    __unsafe_unretained NSString *formatBold48px;
    __unsafe_unretained NSString *formatClear18px;
    __unsafe_unretained NSString *formatClear24px;
    __unsafe_unretained NSString *formatClear48px;
    __unsafe_unretained NSString *formatColorFill18px;
    __unsafe_unretained NSString *formatColorFill24px;
    __unsafe_unretained NSString *formatColorFill48px;
    __unsafe_unretained NSString *formatColorReset18px;
    __unsafe_unretained NSString *formatColorReset24px;
    __unsafe_unretained NSString *formatColorReset48px;
    __unsafe_unretained NSString *formatColorText18px;
    __unsafe_unretained NSString *formatColorText24px;
    __unsafe_unretained NSString *formatColorText48px;
    __unsafe_unretained NSString *formatIndentDecrease18px;
    __unsafe_unretained NSString *formatIndentDecrease24px;
    __unsafe_unretained NSString *formatIndentDecrease48px;
    __unsafe_unretained NSString *formatIndentIncrease18px;
    __unsafe_unretained NSString *formatIndentIncrease24px;
    __unsafe_unretained NSString *formatIndentIncrease48px;
    __unsafe_unretained NSString *formatItalic18px;
    __unsafe_unretained NSString *formatItalic24px;
    __unsafe_unretained NSString *formatItalic48px;
    __unsafe_unretained NSString *formatLineSpacing18px;
    __unsafe_unretained NSString *formatLineSpacing24px;
    __unsafe_unretained NSString *formatLineSpacing48px;
    __unsafe_unretained NSString *formatListBulleted18px;
    __unsafe_unretained NSString *formatListBulleted24px;
    __unsafe_unretained NSString *formatListBulleted48px;
    __unsafe_unretained NSString *formatListNumbered18px;
    __unsafe_unretained NSString *formatListNumbered24px;
    __unsafe_unretained NSString *formatListNumbered48px;
    __unsafe_unretained NSString *formatPaint18px;
    __unsafe_unretained NSString *formatPaint24px;
    __unsafe_unretained NSString *formatPaint48px;
    __unsafe_unretained NSString *formatQuote18px;
    __unsafe_unretained NSString *formatQuote24px;
    __unsafe_unretained NSString *formatQuote48px;
    __unsafe_unretained NSString *formatSize18px;
    __unsafe_unretained NSString *formatSize24px;
    __unsafe_unretained NSString *formatSize48px;
    __unsafe_unretained NSString *formatStrikethrough18px;
    __unsafe_unretained NSString *formatStrikethrough24px;
    __unsafe_unretained NSString *formatStrikethrough48px;
    __unsafe_unretained NSString *formatTextdirectionLToR18px;
    __unsafe_unretained NSString *formatTextdirectionLToR24px;
    __unsafe_unretained NSString *formatTextdirectionLToR48px;
    __unsafe_unretained NSString *formatTextdirectionRToL18px;
    __unsafe_unretained NSString *formatTextdirectionRToL24px;
    __unsafe_unretained NSString *formatTextdirectionRToL48px;
    __unsafe_unretained NSString *formatUnderline18px;
    __unsafe_unretained NSString *formatUnderline24px;
    __unsafe_unretained NSString *formatUnderline48px;
    __unsafe_unretained NSString *functions18px;
    __unsafe_unretained NSString *functions24px;
    __unsafe_unretained NSString *functions48px;
    __unsafe_unretained NSString *insertChart18px;
    __unsafe_unretained NSString *insertChart24px;
    __unsafe_unretained NSString *insertChart48px;
    __unsafe_unretained NSString *insertComment18px;
    __unsafe_unretained NSString *insertComment24px;
    __unsafe_unretained NSString *insertComment48px;
    __unsafe_unretained NSString *insertDriveFile18px;
    __unsafe_unretained NSString *insertDriveFile24px;
    __unsafe_unretained NSString *insertDriveFile48px;
    __unsafe_unretained NSString *insertEmoticon18px;
    __unsafe_unretained NSString *insertEmoticon24px;
    __unsafe_unretained NSString *insertEmoticon48px;
    __unsafe_unretained NSString *insertInvitation18px;
    __unsafe_unretained NSString *insertInvitation24px;
    __unsafe_unretained NSString *insertInvitation48px;
    __unsafe_unretained NSString *insertLink18px;
    __unsafe_unretained NSString *insertLink24px;
    __unsafe_unretained NSString *insertLink48px;
    __unsafe_unretained NSString *insertPhoto18px;
    __unsafe_unretained NSString *insertPhoto24px;
    __unsafe_unretained NSString *insertPhoto48px;
    __unsafe_unretained NSString *mergeType18px;
    __unsafe_unretained NSString *mergeType24px;
    __unsafe_unretained NSString *mergeType48px;
    __unsafe_unretained NSString *modeComment18px;
    __unsafe_unretained NSString *modeComment24px;
    __unsafe_unretained NSString *modeComment48px;
    __unsafe_unretained NSString *modeEdit18px;
    __unsafe_unretained NSString *modeEdit24px;
    __unsafe_unretained NSString *modeEdit48px;
    __unsafe_unretained NSString *publish18px;
    __unsafe_unretained NSString *publish24px;
    __unsafe_unretained NSString *publish48px;
    __unsafe_unretained NSString *verticalAlignBottom18px;
    __unsafe_unretained NSString *verticalAlignBottom24px;
    __unsafe_unretained NSString *verticalAlignBottom48px;
    __unsafe_unretained NSString *verticalAlignCenter18px;
    __unsafe_unretained NSString *verticalAlignCenter24px;
    __unsafe_unretained NSString *verticalAlignCenter48px;
    __unsafe_unretained NSString *verticalAlignTop18px;
    __unsafe_unretained NSString *verticalAlignTop24px;
    __unsafe_unretained NSString *verticalAlignTop48px;
    __unsafe_unretained NSString *wrapText18px;
    __unsafe_unretained NSString *wrapText24px;
    __unsafe_unretained NSString *wrapText48px;
    __unsafe_unretained NSString *attachment18px;
    __unsafe_unretained NSString *attachment24px;
    __unsafe_unretained NSString *attachment48px;
    __unsafe_unretained NSString *cloud24px;
    __unsafe_unretained NSString *cloud48px;
    __unsafe_unretained NSString *cloudCircle18px;
    __unsafe_unretained NSString *cloudCircle24px;
    __unsafe_unretained NSString *cloudCircle48px;
    __unsafe_unretained NSString *cloudDone24px;
    __unsafe_unretained NSString *cloudDone48px;
    __unsafe_unretained NSString *cloudDownload24px;
    __unsafe_unretained NSString *cloudDownload48px;
    __unsafe_unretained NSString *cloudOff24px;
    __unsafe_unretained NSString *cloudOff48px;
    __unsafe_unretained NSString *cloudQueue24px;
    __unsafe_unretained NSString *cloudQueue48px;
    __unsafe_unretained NSString *cloudUpload24px;
    __unsafe_unretained NSString *cloudUpload48px;
    __unsafe_unretained NSString *fileDownload24px;
    __unsafe_unretained NSString *fileDownload48px;
    __unsafe_unretained NSString *fileUpload24px;
    __unsafe_unretained NSString *fileUpload48px;
    __unsafe_unretained NSString *folder18px;
    __unsafe_unretained NSString *folder24px;
    __unsafe_unretained NSString *folder48px;
    __unsafe_unretained NSString *folderOpen18px;
    __unsafe_unretained NSString *folderOpen24px;
    __unsafe_unretained NSString *folderOpen48px;
    __unsafe_unretained NSString *folderShared18px;
    __unsafe_unretained NSString *folderShared24px;
    __unsafe_unretained NSString *folderShared48px;
    __unsafe_unretained NSString *cast24px;
    __unsafe_unretained NSString *cast48px;
    __unsafe_unretained NSString *castConnected24px;
    __unsafe_unretained NSString *castConnected48px;
    __unsafe_unretained NSString *computer24px;
    __unsafe_unretained NSString *computer48px;
    __unsafe_unretained NSString *desktopMac24px;
    __unsafe_unretained NSString *desktopMac48px;
    __unsafe_unretained NSString *desktopWindows24px;
    __unsafe_unretained NSString *desktopWindows48px;
    __unsafe_unretained NSString *dock24px;
    __unsafe_unretained NSString *dock48px;
    __unsafe_unretained NSString *gamepad24px;
    __unsafe_unretained NSString *gamepad48px;
    __unsafe_unretained NSString *headset24px;
    __unsafe_unretained NSString *headset48px;
    __unsafe_unretained NSString *headsetMic24px;
    __unsafe_unretained NSString *headsetMic48px;
    __unsafe_unretained NSString *keyboard24px;
    __unsafe_unretained NSString *keyboard48px;
    __unsafe_unretained NSString *keyboardAlt24px;
    __unsafe_unretained NSString *keyboardAlt48px;
    __unsafe_unretained NSString *keyboardArrowDown24px;
    __unsafe_unretained NSString *keyboardArrowDown48px;
    __unsafe_unretained NSString *keyboardArrowLeft24px;
    __unsafe_unretained NSString *keyboardArrowLeft48px;
    __unsafe_unretained NSString *keyboardArrowRight24px;
    __unsafe_unretained NSString *keyboardArrowRight48px;
    __unsafe_unretained NSString *keyboardArrowUp24px;
    __unsafe_unretained NSString *keyboardArrowUp48px;
    __unsafe_unretained NSString *keyboardBackspace24px;
    __unsafe_unretained NSString *keyboardBackspace48px;
    __unsafe_unretained NSString *keyboardCapslock24px;
    __unsafe_unretained NSString *keyboardCapslock48px;
    __unsafe_unretained NSString *keyboardControl24px;
    __unsafe_unretained NSString *keyboardControl48px;
    __unsafe_unretained NSString *keyboardHide24px;
    __unsafe_unretained NSString *keyboardHide48px;
    __unsafe_unretained NSString *keyboardReturn24px;
    __unsafe_unretained NSString *keyboardReturn48px;
    __unsafe_unretained NSString *keyboardTab24px;
    __unsafe_unretained NSString *keyboardTab48px;
    __unsafe_unretained NSString *keyboardVoice24px;
    __unsafe_unretained NSString *keyboardVoice48px;
    __unsafe_unretained NSString *laptop24px;
    __unsafe_unretained NSString *laptop48px;
    __unsafe_unretained NSString *laptopChromebook24px;
    __unsafe_unretained NSString *laptopChromebook48px;
    __unsafe_unretained NSString *laptopMac24px;
    __unsafe_unretained NSString *laptopMac48px;
    __unsafe_unretained NSString *laptopWindows24px;
    __unsafe_unretained NSString *laptopWindows48px;
    __unsafe_unretained NSString *memory24px;
    __unsafe_unretained NSString *memory48px;
    __unsafe_unretained NSString *mouse24px;
    __unsafe_unretained NSString *mouse48px;
    __unsafe_unretained NSString *phoneAndroid24px;
    __unsafe_unretained NSString *phoneAndroid48px;
    __unsafe_unretained NSString *phoneIphone24px;
    __unsafe_unretained NSString *phoneIphone48px;
    __unsafe_unretained NSString *phonelink24px;
    __unsafe_unretained NSString *phonelink48px;
    __unsafe_unretained NSString *phonelinkOff24px;
    __unsafe_unretained NSString *phonelinkOff48px;
    __unsafe_unretained NSString *security24px;
    __unsafe_unretained NSString *security48px;
    __unsafe_unretained NSString *simCard24px;
    __unsafe_unretained NSString *simCard48px;
    __unsafe_unretained NSString *smartphone24px;
    __unsafe_unretained NSString *smartphone48px;
    __unsafe_unretained NSString *speaker24px;
    __unsafe_unretained NSString *speaker48px;
    __unsafe_unretained NSString *tablet24px;
    __unsafe_unretained NSString *tablet48px;
    __unsafe_unretained NSString *tabletAndroid24px;
    __unsafe_unretained NSString *tabletAndroid48px;
    __unsafe_unretained NSString *tabletMac24px;
    __unsafe_unretained NSString *tabletMac48px;
    __unsafe_unretained NSString *tv24px;
    __unsafe_unretained NSString *tv48px;
    __unsafe_unretained NSString *watch24px;
    __unsafe_unretained NSString *watch48px;
    __unsafe_unretained NSString *addToPhotos24px;
    __unsafe_unretained NSString *addToPhotos48px;
    __unsafe_unretained NSString *adjust24px;
    __unsafe_unretained NSString *adjust48px;
    __unsafe_unretained NSString *assistantPhoto24px;
    __unsafe_unretained NSString *assistantPhoto48px;
    __unsafe_unretained NSString *audiotrack24px;
    __unsafe_unretained NSString *audiotrack48px;
    __unsafe_unretained NSString *blurCircular24px;
    __unsafe_unretained NSString *blurCircular48px;
    __unsafe_unretained NSString *blurLinear24px;
    __unsafe_unretained NSString *blurLinear48px;
    __unsafe_unretained NSString *blurOff24px;
    __unsafe_unretained NSString *blurOff48px;
    __unsafe_unretained NSString *blurOn24px;
    __unsafe_unretained NSString *blurOn48px;
    __unsafe_unretained NSString *brightness124px;
    __unsafe_unretained NSString *brightness148px;
    __unsafe_unretained NSString *brightness224px;
    __unsafe_unretained NSString *brightness248px;
    __unsafe_unretained NSString *brightness324px;
    __unsafe_unretained NSString *brightness348px;
    __unsafe_unretained NSString *brightness424px;
    __unsafe_unretained NSString *brightness448px;
    __unsafe_unretained NSString *brightness524px;
    __unsafe_unretained NSString *brightness548px;
    __unsafe_unretained NSString *brightness624px;
    __unsafe_unretained NSString *brightness648px;
    __unsafe_unretained NSString *brightness724px;
    __unsafe_unretained NSString *brightness748px;
    __unsafe_unretained NSString *brush24px;
    __unsafe_unretained NSString *brush48px;
    __unsafe_unretained NSString *camera24px;
    __unsafe_unretained NSString *camera48px;
    __unsafe_unretained NSString *cameraAlt24px;
    __unsafe_unretained NSString *cameraAlt48px;
    __unsafe_unretained NSString *cameraFront24px;
    __unsafe_unretained NSString *cameraFront48px;
    __unsafe_unretained NSString *cameraRear24px;
    __unsafe_unretained NSString *cameraRear48px;
    __unsafe_unretained NSString *cameraRoll24px;
    __unsafe_unretained NSString *cameraRoll48px;
    __unsafe_unretained NSString *centerFocusStrong24px;
    __unsafe_unretained NSString *centerFocusStrong48px;
    __unsafe_unretained NSString *centerFocusWeak24px;
    __unsafe_unretained NSString *centerFocusWeak48px;
    __unsafe_unretained NSString *collections24px;
    __unsafe_unretained NSString *collections48px;
    __unsafe_unretained NSString *colorLens24px;
    __unsafe_unretained NSString *colorLens48px;
    __unsafe_unretained NSString *colorize24px;
    __unsafe_unretained NSString *colorize48px;
    __unsafe_unretained NSString *compare24px;
    __unsafe_unretained NSString *compare48px;
    __unsafe_unretained NSString *controlPoint24px;
    __unsafe_unretained NSString *controlPoint48px;
    __unsafe_unretained NSString *controlPointDuplicate24px;
    __unsafe_unretained NSString *controlPointDuplicate48px;
    __unsafe_unretained NSString *crop3224px;
    __unsafe_unretained NSString *crop3248px;
    __unsafe_unretained NSString *crop5424px;
    __unsafe_unretained NSString *crop5448px;
    __unsafe_unretained NSString *crop7524px;
    __unsafe_unretained NSString *crop7548px;
    __unsafe_unretained NSString *crop16924px;
    __unsafe_unretained NSString *crop16948px;
    __unsafe_unretained NSString *crop24px;
    __unsafe_unretained NSString *crop48px;
    __unsafe_unretained NSString *cropDin24px;
    __unsafe_unretained NSString *cropDin48px;
    __unsafe_unretained NSString *cropFree24px;
    __unsafe_unretained NSString *cropFree48px;
    __unsafe_unretained NSString *cropLandscape24px;
    __unsafe_unretained NSString *cropLandscape48px;
    __unsafe_unretained NSString *cropOriginal24px;
    __unsafe_unretained NSString *cropOriginal48px;
    __unsafe_unretained NSString *cropPortrait24px;
    __unsafe_unretained NSString *cropPortrait48px;
    __unsafe_unretained NSString *cropSquare24px;
    __unsafe_unretained NSString *cropSquare48px;
    __unsafe_unretained NSString *dehaze24px;
    __unsafe_unretained NSString *dehaze48px;
    __unsafe_unretained NSString *details24px;
    __unsafe_unretained NSString *details48px;
    __unsafe_unretained NSString *edit24px;
    __unsafe_unretained NSString *edit48px;
    __unsafe_unretained NSString *exposure24px;
    __unsafe_unretained NSString *exposure48px;
    __unsafe_unretained NSString *exposureMinus124px;
    __unsafe_unretained NSString *exposureMinus148px;
    __unsafe_unretained NSString *exposureMinus224px;
    __unsafe_unretained NSString *exposureMinus248px;
    __unsafe_unretained NSString *exposurePlus124px;
    __unsafe_unretained NSString *exposurePlus148px;
    __unsafe_unretained NSString *exposurePlus224px;
    __unsafe_unretained NSString *exposurePlus248px;
    __unsafe_unretained NSString *exposureZero24px;
    __unsafe_unretained NSString *exposureZero48px;
    __unsafe_unretained NSString *filter124px;
    __unsafe_unretained NSString *filter148px;
    __unsafe_unretained NSString *filter224px;
    __unsafe_unretained NSString *filter248px;
    __unsafe_unretained NSString *filter324px;
    __unsafe_unretained NSString *filter348px;
    __unsafe_unretained NSString *filter424px;
    __unsafe_unretained NSString *filter448px;
    __unsafe_unretained NSString *filter524px;
    __unsafe_unretained NSString *filter548px;
    __unsafe_unretained NSString *filter624px;
    __unsafe_unretained NSString *filter648px;
    __unsafe_unretained NSString *filter724px;
    __unsafe_unretained NSString *filter748px;
    __unsafe_unretained NSString *filter824px;
    __unsafe_unretained NSString *filter848px;
    __unsafe_unretained NSString *filter924px;
    __unsafe_unretained NSString *filter948px;
    __unsafe_unretained NSString *filter9Plus24px;
    __unsafe_unretained NSString *filter9Plus48px;
    __unsafe_unretained NSString *filter24px;
    __unsafe_unretained NSString *filter48px;
    __unsafe_unretained NSString *filterBAndW24px;
    __unsafe_unretained NSString *filterBAndW48px;
    __unsafe_unretained NSString *filterCenterFocus24px;
    __unsafe_unretained NSString *filterCenterFocus48px;
    __unsafe_unretained NSString *filterDrama24px;
    __unsafe_unretained NSString *filterDrama48px;
    __unsafe_unretained NSString *filterFrames24px;
    __unsafe_unretained NSString *filterFrames48px;
    __unsafe_unretained NSString *filterHdr24px;
    __unsafe_unretained NSString *filterHdr48px;
    __unsafe_unretained NSString *filterNone24px;
    __unsafe_unretained NSString *filterNone48px;
    __unsafe_unretained NSString *filterTiltShift24px;
    __unsafe_unretained NSString *filterTiltShift48px;
    __unsafe_unretained NSString *filterVintage24px;
    __unsafe_unretained NSString *filterVintage48px;
    __unsafe_unretained NSString *flare24px;
    __unsafe_unretained NSString *flare48px;
    __unsafe_unretained NSString *flashAuto24px;
    __unsafe_unretained NSString *flashAuto48px;
    __unsafe_unretained NSString *flashOff24px;
    __unsafe_unretained NSString *flashOff48px;
    __unsafe_unretained NSString *flashOn24px;
    __unsafe_unretained NSString *flashOn48px;
    __unsafe_unretained NSString *flip24px;
    __unsafe_unretained NSString *flip48px;
    __unsafe_unretained NSString *gradient24px;
    __unsafe_unretained NSString *gradient48px;
    __unsafe_unretained NSString *grain24px;
    __unsafe_unretained NSString *grain48px;
    __unsafe_unretained NSString *gridOff24px;
    __unsafe_unretained NSString *gridOff48px;
    __unsafe_unretained NSString *gridOn24px;
    __unsafe_unretained NSString *gridOn48px;
    __unsafe_unretained NSString *hdrOff24px;
    __unsafe_unretained NSString *hdrOff48px;
    __unsafe_unretained NSString *hdrOn24px;
    __unsafe_unretained NSString *hdrOn48px;
    __unsafe_unretained NSString *hdrStrong24px;
    __unsafe_unretained NSString *hdrStrong48px;
    __unsafe_unretained NSString *hdrWeak24px;
    __unsafe_unretained NSString *hdrWeak48px;
    __unsafe_unretained NSString *healing24px;
    __unsafe_unretained NSString *healing48px;
    __unsafe_unretained NSString *image24px;
    __unsafe_unretained NSString *image48px;
    __unsafe_unretained NSString *imageAspectRatio24px;
    __unsafe_unretained NSString *imageAspectRatio48px;
    __unsafe_unretained NSString *iso24px;
    __unsafe_unretained NSString *iso48px;
    __unsafe_unretained NSString *landscape24px;
    __unsafe_unretained NSString *landscape48px;
    __unsafe_unretained NSString *leakAdd24px;
    __unsafe_unretained NSString *leakAdd48px;
    __unsafe_unretained NSString *leakRemove24px;
    __unsafe_unretained NSString *leakRemove48px;
    __unsafe_unretained NSString *lens24px;
    __unsafe_unretained NSString *lens48px;
    __unsafe_unretained NSString *looks324px;
    __unsafe_unretained NSString *looks348px;
    __unsafe_unretained NSString *looks424px;
    __unsafe_unretained NSString *looks448px;
    __unsafe_unretained NSString *looks524px;
    __unsafe_unretained NSString *looks548px;
    __unsafe_unretained NSString *looks624px;
    __unsafe_unretained NSString *looks648px;
    __unsafe_unretained NSString *looks24px;
    __unsafe_unretained NSString *looks48px;
    __unsafe_unretained NSString *looksOne24px;
    __unsafe_unretained NSString *looksOne48px;
    __unsafe_unretained NSString *looksTwo24px;
    __unsafe_unretained NSString *looksTwo48px;
    __unsafe_unretained NSString *loupe24px;
    __unsafe_unretained NSString *loupe48px;
    __unsafe_unretained NSString *movieCreation24px;
    __unsafe_unretained NSString *movieCreation48px;
    __unsafe_unretained NSString *nature24px;
    __unsafe_unretained NSString *nature48px;
    __unsafe_unretained NSString *naturePeople24px;
    __unsafe_unretained NSString *naturePeople48px;
    __unsafe_unretained NSString *navigateBefore24px;
    __unsafe_unretained NSString *navigateBefore48px;
    __unsafe_unretained NSString *navigateNext24px;
    __unsafe_unretained NSString *navigateNext48px;
    __unsafe_unretained NSString *palette24px;
    __unsafe_unretained NSString *palette48px;
    __unsafe_unretained NSString *panorama24px;
    __unsafe_unretained NSString *panorama48px;
    __unsafe_unretained NSString *panoramaFisheye24px;
    __unsafe_unretained NSString *panoramaFisheye48px;
    __unsafe_unretained NSString *panoramaHorizontal24px;
    __unsafe_unretained NSString *panoramaHorizontal48px;
    __unsafe_unretained NSString *panoramaVertical24px;
    __unsafe_unretained NSString *panoramaVertical48px;
    __unsafe_unretained NSString *panoramaWideAngle24px;
    __unsafe_unretained NSString *panoramaWideAngle48px;
    __unsafe_unretained NSString *photo24px;
    __unsafe_unretained NSString *photo48px;
    __unsafe_unretained NSString *photoAlbum24px;
    __unsafe_unretained NSString *photoAlbum48px;
    __unsafe_unretained NSString *photoCamera24px;
    __unsafe_unretained NSString *photoCamera48px;
    __unsafe_unretained NSString *photoLibrary24px;
    __unsafe_unretained NSString *photoLibrary48px;
    __unsafe_unretained NSString *portrait24px;
    __unsafe_unretained NSString *portrait48px;
    __unsafe_unretained NSString *removeRedEye24px;
    __unsafe_unretained NSString *removeRedEye48px;
    __unsafe_unretained NSString *rotateLeft24px;
    __unsafe_unretained NSString *rotateLeft48px;
    __unsafe_unretained NSString *rotateRight24px;
    __unsafe_unretained NSString *rotateRight48px;
    __unsafe_unretained NSString *slideshow24px;
    __unsafe_unretained NSString *slideshow48px;
    __unsafe_unretained NSString *straighten24px;
    __unsafe_unretained NSString *straighten48px;
    __unsafe_unretained NSString *style24px;
    __unsafe_unretained NSString *style48px;
    __unsafe_unretained NSString *switchCamera24px;
    __unsafe_unretained NSString *switchCamera48px;
    __unsafe_unretained NSString *switchVideo24px;
    __unsafe_unretained NSString *switchVideo48px;
    __unsafe_unretained NSString *tagFaces24px;
    __unsafe_unretained NSString *tagFaces48px;
    __unsafe_unretained NSString *texture24px;
    __unsafe_unretained NSString *texture48px;
    __unsafe_unretained NSString *timelapse24px;
    __unsafe_unretained NSString *timelapse48px;
    __unsafe_unretained NSString *timer324px;
    __unsafe_unretained NSString *timer348px;
    __unsafe_unretained NSString *timer1024px;
    __unsafe_unretained NSString *timer1048px;
    __unsafe_unretained NSString *timer24px;
    __unsafe_unretained NSString *timer48px;
    __unsafe_unretained NSString *timerAuto24px;
    __unsafe_unretained NSString *timerAuto48px;
    __unsafe_unretained NSString *timerOff24px;
    __unsafe_unretained NSString *timerOff48px;
    __unsafe_unretained NSString *tonality24px;
    __unsafe_unretained NSString *tonality48px;
    __unsafe_unretained NSString *transform24px;
    __unsafe_unretained NSString *transform48px;
    __unsafe_unretained NSString *tune24px;
    __unsafe_unretained NSString *tune48px;
    __unsafe_unretained NSString *wbAuto24px;
    __unsafe_unretained NSString *wbAuto48px;
    __unsafe_unretained NSString *wbCloudy24px;
    __unsafe_unretained NSString *wbCloudy48px;
    __unsafe_unretained NSString *wbIncandescent24px;
    __unsafe_unretained NSString *wbIncandescent48px;
    __unsafe_unretained NSString *wbIrradescent24px;
    __unsafe_unretained NSString *wbIrradescent48px;
    __unsafe_unretained NSString *wbSunny24px;
    __unsafe_unretained NSString *wbSunny48px;
    __unsafe_unretained NSString *checkBox24px;
    __unsafe_unretained NSString *checkBox48px;
    __unsafe_unretained NSString *checkBoxOutlineBlank24px;
    __unsafe_unretained NSString *checkBoxOutlineBlank48px;
    __unsafe_unretained NSString *radioButtonOff24px;
    __unsafe_unretained NSString *radioButtonOff48px;
    __unsafe_unretained NSString *radioButtonOn24px;
    __unsafe_unretained NSString *radioButtonOn48px;
    __unsafe_unretained NSString *star24px;
    __unsafe_unretained NSString *starHalf24px;
    __unsafe_unretained NSString *starOutline24px;
    __unsafe_unretained NSString *beenhere24px;
    __unsafe_unretained NSString *beenhere48px;
    __unsafe_unretained NSString *directions24px;
    __unsafe_unretained NSString *directions48px;
    __unsafe_unretained NSString *directionsBike24px;
    __unsafe_unretained NSString *directionsBike48px;
    __unsafe_unretained NSString *directionsBus24px;
    __unsafe_unretained NSString *directionsBus48px;
    __unsafe_unretained NSString *directionsCar24px;
    __unsafe_unretained NSString *directionsCar48px;
    __unsafe_unretained NSString *directionsFerry24px;
    __unsafe_unretained NSString *directionsFerry48px;
    __unsafe_unretained NSString *directionsSubway24px;
    __unsafe_unretained NSString *directionsSubway48px;
    __unsafe_unretained NSString *directionsTrain24px;
    __unsafe_unretained NSString *directionsTrain48px;
    __unsafe_unretained NSString *directionsTransit24px;
    __unsafe_unretained NSString *directionsTransit48px;
    __unsafe_unretained NSString *directionsWalk24px;
    __unsafe_unretained NSString *directionsWalk48px;
    __unsafe_unretained NSString *flight24px;
    __unsafe_unretained NSString *flight48px;
    __unsafe_unretained NSString *hotel24px;
    __unsafe_unretained NSString *hotel48px;
    __unsafe_unretained NSString *layers24px;
    __unsafe_unretained NSString *layers48px;
    __unsafe_unretained NSString *layersClear24px;
    __unsafe_unretained NSString *layersClear48px;
    __unsafe_unretained NSString *localAirport24px;
    __unsafe_unretained NSString *localAirport48px;
    __unsafe_unretained NSString *localAtm24px;
    __unsafe_unretained NSString *localAtm48px;
    __unsafe_unretained NSString *localAttraction24px;
    __unsafe_unretained NSString *localAttraction48px;
    __unsafe_unretained NSString *localBar24px;
    __unsafe_unretained NSString *localBar48px;
    __unsafe_unretained NSString *localCafe24px;
    __unsafe_unretained NSString *localCafe48px;
    __unsafe_unretained NSString *localCarWash24px;
    __unsafe_unretained NSString *localCarWash48px;
    __unsafe_unretained NSString *localConvenienceStore24px;
    __unsafe_unretained NSString *localConvenienceStore48px;
    __unsafe_unretained NSString *localDrink24px;
    __unsafe_unretained NSString *localDrink48px;
    __unsafe_unretained NSString *localFlorist24px;
    __unsafe_unretained NSString *localFlorist48px;
    __unsafe_unretained NSString *localGasStation24px;
    __unsafe_unretained NSString *localGasStation48px;
    __unsafe_unretained NSString *localGroceryStore24px;
    __unsafe_unretained NSString *localGroceryStore48px;
    __unsafe_unretained NSString *localHospital24px;
    __unsafe_unretained NSString *localHospital48px;
    __unsafe_unretained NSString *localHotel24px;
    __unsafe_unretained NSString *localHotel48px;
    __unsafe_unretained NSString *localLaundryService24px;
    __unsafe_unretained NSString *localLaundryService48px;
    __unsafe_unretained NSString *localLibrary24px;
    __unsafe_unretained NSString *localLibrary48px;
    __unsafe_unretained NSString *localMall24px;
    __unsafe_unretained NSString *localMall48px;
    __unsafe_unretained NSString *localMovies24px;
    __unsafe_unretained NSString *localMovies48px;
    __unsafe_unretained NSString *localOffer24px;
    __unsafe_unretained NSString *localOffer48px;
    __unsafe_unretained NSString *localParking24px;
    __unsafe_unretained NSString *localParking48px;
    __unsafe_unretained NSString *localPharmacy24px;
    __unsafe_unretained NSString *localPharmacy48px;
    __unsafe_unretained NSString *localPhone24px;
    __unsafe_unretained NSString *localPhone48px;
    __unsafe_unretained NSString *localPizza24px;
    __unsafe_unretained NSString *localPizza48px;
    __unsafe_unretained NSString *localPlay24px;
    __unsafe_unretained NSString *localPlay48px;
    __unsafe_unretained NSString *localPostOffice24px;
    __unsafe_unretained NSString *localPostOffice48px;
    __unsafe_unretained NSString *localPrintShop24px;
    __unsafe_unretained NSString *localPrintShop48px;
    __unsafe_unretained NSString *localRestaurant24px;
    __unsafe_unretained NSString *localRestaurant48px;
    __unsafe_unretained NSString *localSee24px;
    __unsafe_unretained NSString *localSee48px;
    __unsafe_unretained NSString *localShipping24px;
    __unsafe_unretained NSString *localShipping48px;
    __unsafe_unretained NSString *localTaxi24px;
    __unsafe_unretained NSString *localTaxi48px;
    __unsafe_unretained NSString *locationHistory24px;
    __unsafe_unretained NSString *locationHistory48px;
    __unsafe_unretained NSString *map24px;
    __unsafe_unretained NSString *map48px;
    __unsafe_unretained NSString *myLocation24px;
    __unsafe_unretained NSString *myLocation48px;
    __unsafe_unretained NSString *navigation24px;
    __unsafe_unretained NSString *navigation48px;
    __unsafe_unretained NSString *pinDrop24px;
    __unsafe_unretained NSString *pinDrop48px;
    __unsafe_unretained NSString *place24px;
    __unsafe_unretained NSString *place48px;
    __unsafe_unretained NSString *rateReview24px;
    __unsafe_unretained NSString *rateReview48px;
    __unsafe_unretained NSString *restaurantMenu24px;
    __unsafe_unretained NSString *restaurantMenu48px;
    __unsafe_unretained NSString *satellite24px;
    __unsafe_unretained NSString *satellite48px;
    __unsafe_unretained NSString *storeMallDirectory24px;
    __unsafe_unretained NSString *storeMallDirectory48px;
    __unsafe_unretained NSString *terrain24px;
    __unsafe_unretained NSString *terrain48px;
    __unsafe_unretained NSString *traffic24px;
    __unsafe_unretained NSString *traffic48px;
    __unsafe_unretained NSString *apps18px;
    __unsafe_unretained NSString *apps24px;
    __unsafe_unretained NSString *apps36px;
    __unsafe_unretained NSString *apps48px;
    __unsafe_unretained NSString *arrowBack18px;
    __unsafe_unretained NSString *arrowBack24px;
    __unsafe_unretained NSString *arrowBack36px;
    __unsafe_unretained NSString *arrowBack48px;
    __unsafe_unretained NSString *arrowDropDown18px;
    __unsafe_unretained NSString *arrowDropDown24px;
    __unsafe_unretained NSString *arrowDropDown36px;
    __unsafe_unretained NSString *arrowDropDown48px;
    __unsafe_unretained NSString *arrowDropDownCircle24px;
    __unsafe_unretained NSString *arrowDropDownCircle48px;
    __unsafe_unretained NSString *arrowDropUp18px;
    __unsafe_unretained NSString *arrowDropUp24px;
    __unsafe_unretained NSString *arrowDropUp36px;
    __unsafe_unretained NSString *arrowDropUp48px;
    __unsafe_unretained NSString *arrowForward18px;
    __unsafe_unretained NSString *arrowForward24px;
    __unsafe_unretained NSString *arrowForward36px;
    __unsafe_unretained NSString *arrowForward48px;
    __unsafe_unretained NSString *cancel18px;
    __unsafe_unretained NSString *cancel24px;
    __unsafe_unretained NSString *cancel36px;
    __unsafe_unretained NSString *cancel48px;
    __unsafe_unretained NSString *check18px;
    __unsafe_unretained NSString *check24px;
    __unsafe_unretained NSString *check36px;
    __unsafe_unretained NSString *check48px;
    __unsafe_unretained NSString *chevronLeft18px;
    __unsafe_unretained NSString *chevronLeft24px;
    __unsafe_unretained NSString *chevronLeft36px;
    __unsafe_unretained NSString *chevronLeft48px;
    __unsafe_unretained NSString *chevronRight18px;
    __unsafe_unretained NSString *chevronRight24px;
    __unsafe_unretained NSString *chevronRight36px;
    __unsafe_unretained NSString *chevronRight48px;
    __unsafe_unretained NSString *close18px;
    __unsafe_unretained NSString *close24px;
    __unsafe_unretained NSString *close36px;
    __unsafe_unretained NSString *close48px;
    __unsafe_unretained NSString *expandLess18px;
    __unsafe_unretained NSString *expandLess24px;
    __unsafe_unretained NSString *expandLess36px;
    __unsafe_unretained NSString *expandLess48px;
    __unsafe_unretained NSString *expandMore18px;
    __unsafe_unretained NSString *expandMore24px;
    __unsafe_unretained NSString *expandMore36px;
    __unsafe_unretained NSString *expandMore48px;
    __unsafe_unretained NSString *fullscreen18px;
    __unsafe_unretained NSString *fullscreen24px;
    __unsafe_unretained NSString *fullscreen36px;
    __unsafe_unretained NSString *fullscreen48px;
    __unsafe_unretained NSString *fullscreenExit18px;
    __unsafe_unretained NSString *fullscreenExit24px;
    __unsafe_unretained NSString *fullscreenExit36px;
    __unsafe_unretained NSString *fullscreenExit48px;
    __unsafe_unretained NSString *menu18px;
    __unsafe_unretained NSString *menu24px;
    __unsafe_unretained NSString *menu36px;
    __unsafe_unretained NSString *menu48px;
    __unsafe_unretained NSString *moreHoriz18px;
    __unsafe_unretained NSString *moreHoriz24px;
    __unsafe_unretained NSString *moreHoriz36px;
    __unsafe_unretained NSString *moreHoriz48px;
    __unsafe_unretained NSString *moreVert18px;
    __unsafe_unretained NSString *moreVert24px;
    __unsafe_unretained NSString *moreVert36px;
    __unsafe_unretained NSString *moreVert48px;
    __unsafe_unretained NSString *refresh18px;
    __unsafe_unretained NSString *refresh24px;
    __unsafe_unretained NSString *refresh36px;
    __unsafe_unretained NSString *refresh48px;
    __unsafe_unretained NSString *unfoldLess18px;
    __unsafe_unretained NSString *unfoldLess24px;
    __unsafe_unretained NSString *unfoldLess36px;
    __unsafe_unretained NSString *unfoldLess48px;
    __unsafe_unretained NSString *unfoldMore18px;
    __unsafe_unretained NSString *unfoldMore24px;
    __unsafe_unretained NSString *unfoldMore36px;
    __unsafe_unretained NSString *unfoldMore48px;
    __unsafe_unretained NSString *adb18px;
    __unsafe_unretained NSString *adb24px;
    __unsafe_unretained NSString *adb48px;
    __unsafe_unretained NSString *bluetoothAudio24px;
    __unsafe_unretained NSString *bluetoothAudio48px;
    __unsafe_unretained NSString *discFull24px;
    __unsafe_unretained NSString *discFull48px;
    __unsafe_unretained NSString *dndForwardslash24px;
    __unsafe_unretained NSString *dndForwardslash48px;
    __unsafe_unretained NSString *doNotDisturb24px;
    __unsafe_unretained NSString *doNotDisturb48px;
    __unsafe_unretained NSString *driveEta24px;
    __unsafe_unretained NSString *driveEta48px;
    __unsafe_unretained NSString *eventAvailable24px;
    __unsafe_unretained NSString *eventAvailable48px;
    __unsafe_unretained NSString *eventBusy24px;
    __unsafe_unretained NSString *eventBusy48px;
    __unsafe_unretained NSString *eventNote18px;
    __unsafe_unretained NSString *eventNote24px;
    __unsafe_unretained NSString *eventNote48px;
    __unsafe_unretained NSString *folderSpecial24px;
    __unsafe_unretained NSString *folderSpecial48px;
    __unsafe_unretained NSString *mms24px;
    __unsafe_unretained NSString *mms48px;
    __unsafe_unretained NSString *more24px;
    __unsafe_unretained NSString *more48px;
    __unsafe_unretained NSString *networkLocked24px;
    __unsafe_unretained NSString *networkLocked48px;
    __unsafe_unretained NSString *phoneBluetoothSpeaker24px;
    __unsafe_unretained NSString *phoneBluetoothSpeaker48px;
    __unsafe_unretained NSString *phoneForwarded24px;
    __unsafe_unretained NSString *phoneForwarded48px;
    __unsafe_unretained NSString *phoneInTalk24px;
    __unsafe_unretained NSString *phoneInTalk48px;
    __unsafe_unretained NSString *phoneLocked24px;
    __unsafe_unretained NSString *phoneLocked48px;
    __unsafe_unretained NSString *phoneMissed24px;
    __unsafe_unretained NSString *phoneMissed48px;
    __unsafe_unretained NSString *phonePaused24px;
    __unsafe_unretained NSString *phonePaused48px;
    __unsafe_unretained NSString *playDownload24px;
    __unsafe_unretained NSString *playDownload48px;
    __unsafe_unretained NSString *playInstall24px;
    __unsafe_unretained NSString *playInstall48px;
    __unsafe_unretained NSString *sdCard24px;
    __unsafe_unretained NSString *sdCard48px;
    __unsafe_unretained NSString *simCardAlert24px;
    __unsafe_unretained NSString *simCardAlert48px;
    __unsafe_unretained NSString *sms24px;
    __unsafe_unretained NSString *sms48px;
    __unsafe_unretained NSString *smsFailed24px;
    __unsafe_unretained NSString *smsFailed48px;
    __unsafe_unretained NSString *sync24px;
    __unsafe_unretained NSString *sync48px;
    __unsafe_unretained NSString *syncDisabled24px;
    __unsafe_unretained NSString *syncDisabled48px;
    __unsafe_unretained NSString *syncProblem24px;
    __unsafe_unretained NSString *syncProblem48px;
    __unsafe_unretained NSString *systemUpdate24px;
    __unsafe_unretained NSString *systemUpdate48px;
    __unsafe_unretained NSString *tapAndPlay24px;
    __unsafe_unretained NSString *tapAndPlay48px;
    __unsafe_unretained NSString *timeToLeave24px;
    __unsafe_unretained NSString *timeToLeave48px;
    __unsafe_unretained NSString *vibration18px;
    __unsafe_unretained NSString *vibration24px;
    __unsafe_unretained NSString *vibration48px;
    __unsafe_unretained NSString *voiceChat24px;
    __unsafe_unretained NSString *voiceChat48px;
    __unsafe_unretained NSString *vpnLock24px;
    __unsafe_unretained NSString *vpnLock48px;
    __unsafe_unretained NSString *cake18px;
    __unsafe_unretained NSString *cake24px;
    __unsafe_unretained NSString *cake48px;
    __unsafe_unretained NSString *domain18px;
    __unsafe_unretained NSString *domain24px;
    __unsafe_unretained NSString *domain48px;
    __unsafe_unretained NSString *group18px;
    __unsafe_unretained NSString *group24px;
    __unsafe_unretained NSString *group48px;
    __unsafe_unretained NSString *groupAdd18px;
    __unsafe_unretained NSString *groupAdd24px;
    __unsafe_unretained NSString *groupAdd48px;
    __unsafe_unretained NSString *locationCity18px;
    __unsafe_unretained NSString *locationCity24px;
    __unsafe_unretained NSString *locationCity48px;
    __unsafe_unretained NSString *mood18px;
    __unsafe_unretained NSString *mood24px;
    __unsafe_unretained NSString *mood48px;
    __unsafe_unretained NSString *notifications24px;
    __unsafe_unretained NSString *notifications48px;
    __unsafe_unretained NSString *notificationsNone24px;
    __unsafe_unretained NSString *notificationsNone48px;
    __unsafe_unretained NSString *notificationsOff24px;
    __unsafe_unretained NSString *notificationsOff48px;
    __unsafe_unretained NSString *notificationsOn24px;
    __unsafe_unretained NSString *notificationsOn48px;
    __unsafe_unretained NSString *notificationsPaused24px;
    __unsafe_unretained NSString *notificationsPaused48px;
    __unsafe_unretained NSString *pages18px;
    __unsafe_unretained NSString *pages24px;
    __unsafe_unretained NSString *pages48px;
    __unsafe_unretained NSString *partyMode24px;
    __unsafe_unretained NSString *partyMode48px;
    __unsafe_unretained NSString *people18px;
    __unsafe_unretained NSString *people24px;
    __unsafe_unretained NSString *people48px;
    __unsafe_unretained NSString *peopleOutline24px;
    __unsafe_unretained NSString *peopleOutline48px;
    __unsafe_unretained NSString *person18px;
    __unsafe_unretained NSString *person24px;
    __unsafe_unretained NSString *person48px;
    __unsafe_unretained NSString *personAdd18px;
    __unsafe_unretained NSString *personAdd24px;
    __unsafe_unretained NSString *personAdd48px;
    __unsafe_unretained NSString *personOutline18px;
    __unsafe_unretained NSString *personOutline24px;
    __unsafe_unretained NSString *personOutline48px;
    __unsafe_unretained NSString *plusOne24px;
    __unsafe_unretained NSString *plusOne48px;
    __unsafe_unretained NSString *poll18px;
    __unsafe_unretained NSString *poll24px;
    __unsafe_unretained NSString *poll48px;
    __unsafe_unretained NSString *public24px;
    __unsafe_unretained NSString *public48px;
    __unsafe_unretained NSString *school24px;
    __unsafe_unretained NSString *school48px;
    __unsafe_unretained NSString *share24px;
    __unsafe_unretained NSString *share48px;
    __unsafe_unretained NSString *whatshot18px;
    __unsafe_unretained NSString *whatshot24px;
    __unsafe_unretained NSString *whatshot48px;
} MaterialDesignIconCode;

