# Awesome Search Engine Optimization Ideas [![License](http://img.shields.io/badge/license-Apache-brightgreen.svg?style=flat)](http://www.apache.org/licenses/LICENSE-2.0.txt) [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
[![LinkedIn](images/linkedin_32.png)](https://www.linkedin.com/in/thomasfuller/) [![Twitter](images/twitter_32.png)](https://twitter.com/ThosPFuller) [![GitHub](images/github_32.png)](https://github.com/thospfuller) [![Email](images/email_32.png)](http://eepurl.com/b5jPPj) [![Coherent Logic Limited](images/CLSocialIconDarkBlue.png)](https://coherentlogic.com?utm_source=abl_on_gh) [<img src="images/meetupcom_social_media_circled_network_64x64.png" height="32" width="32">](https://www.meetup.com/Washington-DC-CTO-Meetup-Group/)

A curated list of backlink, social signal opportunities, social media marketing, referral traffic generation, writing ideas, and more.

🤔 Do you need help with SEO? Visit [my website](https://thospfuller.com/) for more information and to schedule a meeting with me. 🔍

🚀 Check out the [My Content Engineering Specialist GPT](https://github.com/thospfuller/my-content-engineering-specialist/) project if you use [ChatGPT](https://chatgpt.com/) -- this is [available as a GPT](https://chatgpt.com/g/g-SA2LB9tLz-my-content-engineering-specialist).

⭐ If you find this site to be useful, please star and/or watch it. ⭐

👍 If you have an idea not included here, pull requests are welcomed! 👍

# General Search Engine Optimization (SEO) Articles
- [Ahrefs: 124 SEO Statistics for 2024](https://ahrefs.com/blog/seo-statistics/)
- [Google announced that Search Console only reports on 35% of your website's performance data](https://x.com/mikeginleyseo/status/1823396936939909197)
- [How Google handles JavaScript throughout the indexing process](https://vercel.com/blog/how-google-handles-javascript-throughout-the-indexing-process)
- [Learn how to create Pillar Pages](https://www.linkedin.com/posts/lmckenzie16_how-to-create-a-pillar-page-activity-7216404846399102977-G0-F)
- [Search Engine Land: HUGE Google Search document leak reveals inner workings of ranking algorithm](https://searchengineland.com/google-search-document-leak-ranking-442617) see also [Slashdot: Huge Google Search Document Leak Reveals Inner Workings of Ranking Algorithm](https://tech.slashdot.org/story/24/05/28/2236255/huge-google-search-document-leak-reveals-inner-workings-of-ranking-algorithm) and see also [@hridoyreh: 13 things found](https://x.com/hridoyreh/status/1795394077510517217)
- [@hridoyreh: 10 best SEO Case Studies.](https://twitter.com/hridoyreh/status/1660898339414765568)
- [John Mueller Of Google: SEO Lives & Dies With Consistency](https://www.seroundtable.com/google-seo-lives-dies-with-consistency-31319.html) "In 2015, John Mueller said this at SMX conference. He said his top SEO advice is be consistent. He reiterated it again in 2019 and 2018 and numerous times before and after this."
- [Consistency Is King In SEO](https://searchengineland.com/consistency-is-king-in-seo-52171) While this article was written in 2010, it's still very much worth a read: "In SEO, the small stuff truly matters, and consistency is especially powerful. At the enterprise level things like page titles, internal links and duplicate content may seem almost trivial compared to the overall complexity of the site. But they are hugely important, and when well-optimized in sum can literally make or break a site’s SEO potential."
- [Google Search Essentials](https://developers.google.com/search/docs/essentials) -- "The Google Search Essentials make up the core parts of what makes your web-based content (web pages, images, videos, or other publicly-available material that Google finds on the web) eligible to appear and perform well on Google Search"
- [Why Does Your Search Traffic Suck? The 7 Most Likely Reasons - Moz](https://moz.com/blog/why-does-your-search-traffic-suck-the-6-most-likely-reasons)
- [Holy Grail SEO: High Volume, Low Competition Keywords](https://www.searchenginejournal.com/keyword-competition/313815/) -- "Instead of targeting keywords or topics that have high volume, we need to target keywords and topics that we actually have a chance to rank for, making the best use of our time and SEO efforts."
- [Long-tail Keywords: What They Are and How to Get Search Traffic From Them](https://ahrefs.com/blog/long-tail-keywords/)
- [Ultimate SEO Guide for Startups](https://getspexia.com/blog/seo-for-startups) (18 chapters)
- [Structured data markup that Google Search supports](https://developers.google.com/search/docs/appearance/structured-data/search-gallery)

# Link Building Strategies, Internal Linking, and Backlinking Ideas
- [BuiltIn](https://builtin.com/) -- "Built In is a national community united around a shared passion for tech, offering content and career opportunities, whether you want to work at home or in office." -- see, for example, [companies built in Washington, DC](https://builtin.com/washington-dc). The [BuiltIn Expert Contributor Network](https://builtin.com/expert-contributors) allows for article submissions by experts and boasts 3mm+ readers. BuiltIn author profiles allow for a follow backlink to their website.
- [Techopedia: Write for Techopedia](https://www.techopedia.com/about/contributors)
- [Codementor: Write new and import existing posts.](https://www.codementor.io/write) Links added to articles posted on CodeMentor are nofollow.
- [Code Project](https://www.codeproject.com/info/Submit.aspx) Allows cross-posting articles.
- [SitePoint](https://www.sitepoint.com/write-for-us/)
- [Leigh McKenzie on LinkedIn : Every marketer wants more backlinks. But, you’ve got to earn them. Nine strategies used at Backlinko.](https://www.linkedin.com/posts/lmckenzie16_9-top-strategies-to-get-high-quality-backlinks-activity-7210986982707990528-VmIt)
- [@JackCulpan: Build a Google Chrome Extension](https://x.com/JackCulpan/status/1802083669643014148)
- [How to Build SEO Backlinks with Google Search Data](https://www.linkedin.com/feed/update/urn:li:activity:7193927301238046721/) by [Connor Gillivan](https://www.linkedin.com/in/connorgillivan/) on LinkedIn.
- [ITNEXT](https://itnext.io/) and see also [Write for ITNEXT](https://itnext.io/write-for-itnext-4dea1fd3adf)
- [freeCodeCamp.org](https://www.freecodecamp.org/) includes a follow backlink in the profile settings -- if you're developing content around software development consider checking this website out.
- [23 Million Internal Links – SEO Case Study](https://zyppy.com/seo/internal-links/seo-study/)
- [@ConnorShowler: Sneaky Backlink #49: ](https://twitter.com/ConnorShowler/status/1775722543179018451) from [HashNode](https://hashnode.com/) Software developers who manage their own blogs may benefit from earning a backlink from HashNode (HN) since it should be contextually relevant; HN may also serve as an excellent platform for cross-posting content (requires further investigation).
- [@ConnorShowler: Build backlinks with Evernote.](https://twitter.com/ConnorShowler/status/1734389868778738175) I've only looked into this idea breifly however so far it makes sense and may be a good idea too but that's TBC. Evernote is not free however considering what other solutions in this space cost it could be a very attractive option. 
- [@ConnorShowler: Link Tree landing pages](https://twitter.com/ConnorShowler/status/1728252631154319609) Not confirmed however if everyone is doing this the backlink is probably not worth much, if anything at all. We can look at this from a different angle though and that is how many backlinks a site like [Link Tree](https://linktr.ee/) has and, as of 25.Nov.2023, this is 162M from 551K referring websites as per [ahrefs website authority checker](https://ahrefs.com/website-authority-checker).
- [@illyism: I got 2400 backlinks from 170 domains in 1 week](https://twitter.com/illyism/status/1725092535796642166) Possibly gray hat SEO so I'm not sure about this one and requires further investigation.
- [GoDaddy Auctions](https://auctions.godaddy.com/)
- [@SearchForRyan: Five things you HAVE to do to build internal links correctly](https://twitter.com/SearchForRyan/status/1722524766139990467)
- [Articles with dead external links on Wikipedia](https://en.wikipedia.org/wiki/Category:Articles_with_dead_external_links)
- [Link rot on Wikipedia](https://en.wikipedia.org/wiki/Wikipedia:Link_rot)
- [@FeryKaszoni: Link building plan for every budget](https://twitter.com/FeryKaszoni/status/1718893154743529799)
- [Unveiling the Dark Art of Parasite SEO: Risks and Rewards](https://www.linkedin.com/pulse/unveiling-dark-art-parasite-seo-risks-rewards-azam-javed/)
- [How to use HARO](https://jaserodley.com/how-to-use-haro/)
- [featured.com / previously terkel](https://featured.com/)
- [SourceBottle](https://www.sourcebottle.com/)
- [Help A B2B Writer](https://helpab2bwriter.com/)
- [HARO: Help A Reporter Out](https://www.helpareporter.com/)
- [Write for the GoDaddy blog](https://ae.godaddy.com/blog/contribute/)
- [@webjuice_ie: How to get a dofollow backlink from Flickr (DR 94)](https://twitter.com/webjuice_ie/status/1705906605194166353)
- [@serpinsider: 3 ways to find expired domains for backlinks, new niche sites, or just to flip for profit](https://twitter.com/serpinsider/status/1690052507765293056)
- [Which Question-Optimized Queries Perform Well?](https://thospfuller.com/2021/04/19/question-based-keywords/#which-question-optimized-queries-perform-well) -- this section talks about building a backlink magnet using "How To" style questions.
- [Guess which Content Types Get the Most Backlinks?](https://www.spyfu.com/blog/which-types-of-content-gain-the-most-backlinks-original-data/)
- [@Adoubleagent: Nine public internal linking case studies from SEOs to help SEO professionals identify what works.](https://twitter.com/Adoubleagent/status/1683758102095757312)
- [@seochatterblog: 10 Internal Linking Best Practices for SEO](https://twitter.com/seochatterblog/status/1668243638298484738)
- [@hridoyreh: best-of posts](https://twitter.com/hridoyreh/status/1657322642205179905)
- [@hridoyreh: X vs. Y posts](https://twitter.com/hridoyreh/status/1659133817515560960)
- [pressrelease.com: paid service, see pricing](https://www.pressrelease.com/)
- [@hridoyreh: Dead links on Wikipedia](https://twitter.com/hridoyreh/status/1656234792357355521)
- [terkel.io: Grow your Brand Answer Questions, Get Featured in Articles.](https://terkel.io/) see also [Markitors: Introducing Terkel](https://markitors.com/introducing-terkel/)
- [@Nick_zv_: No-BS Guide to Link-Building](https://twitter.com/Nick_zv_/status/1651208757190483968)
- [Andrew Holland on LinkedIn: 19 Secrets to Generating Massive Website Traffic](https://www.linkedin.com/posts/andrew-holland-seo_seo-activity-7054354929213161472-gGeg)
- [@ericlancheres: Here are some of my favorite link baits](https://twitter.com/ericlancheres/status/1648027963651129347)
- [@RyanJones: My best backlink secret?](https://twitter.com/RyanJones/status/1635662027002638336)
- [@Nick_zv_: Want to build a LOT of backlinks fast?](https://twitter.com/Nick_zv_/status/1635657034338287616)
- [@Nick_zv_: Your competitor has 2,000 backlinks...](https://twitter.com/Nick_zv_/status/1635626081142325249)
- [Pet niche statistics backlink strategy using Ahrefs](https://twitter.com/Ldnbox/status/1524642256996741120)
- [@Nick_zv_: These pages were ENGINEERED to drive thousands of backlinks.](https://twitter.com/Nick_zv_/status/1645772943824412672)
- [Backlinko: Link Bait / linkbait](https://backlinko.com/hub/seo/linkbait) "the process of creating content designed to attract backlinks. Common types of Link Bait content include controversial content, data, guides and newsworthy pieces."
- [How I Mastered FREE Backlinks with ChatGPT (Link Magnets)](https://twitter.com/JulianGoldieSEO/status/1678606189859581952)
- [5 Types of Link Magnets that Can Skyrocket Your SEO](https://jarvee.com/5-types-of-link-magnets-that-can-skyrocket-your-seo/)
- [Search Engine Journal: Reciprocal Links: Do They Help Or Hurt Your SEO? Reciprocal link building isn't bad for SEO, but only if you do it right. Learn the right and wrong ways to build reciprocal links.](https://www.searchenginejournal.com/link-building-guide/reciprocal-links/)
- [How to Perform a Competitor Link Analysis in 3 Steps](https://ahrefs.com/blog/competitor-backlink-analysis/) "A competitor link analysis is an assessment of the link profiles of major competitors where you look at their link building strategies to gain insights. Implementing some of the same strategies in your own link building can lead to higher rankings in search engines and increased business outcomes."
- [11 Creative (But 100% White Hat!) Ways to Earn Backlinks in 2022](https://blog.hubspot.com/marketing/backlink-strategies)
- [Help a Reporter Out (HARO)](https://www.helpareporter.com/), see also [How to Get Backlinks: 11 Strategies](https://www.semrush.com/blog/how-to-get-backlinks/)
- Register with your local Chamber of Commerce -- the business directory may offer a backlink opportunity.
- [Are Link Exchanges a Legitimate SEO Strategy in 2021?](https://linkbuilder.io/link-exchange/)
- [Google Search Central -> Link schemes](https://developers.google.com/search/docs/advanced/guidelines/link-schemes) note "[e]xcessive link exchanges"
- [An easy way to build links (no fluff)](https://www.linkedin.com/pulse/easy-way-build-links-fluff-liam-fallen/)
- Further research required, mentioned but not endorsed: Engage a link-building service (RhinoRank, Authority Builders, Crowdo).
- Create an infographic (a dated strategy) -- from [What Type of Backlinks Does Your Business Really Need Right Now?](https://neilpatel.com/blog/what-type-of-backlinks-does-your-business-really-need-right-now/) : "[a]t the old KISSMetrics site, 47 infographics generated 2,512,596 visitors and 41,142 backlinks from 3,741 unique domains" and "...at Quicksprout, every infographic I published generated 41,487 visitors and 469 backlinks from 38 unique domains" -- when we're talking ROI creating an infographic, at least insofar as these numbers go, probably has the highest potential return. See also [12 Infographic Tips That You Wish You Knew Years Ago](https://neilpatel.com/blog/12-infographic-tips/). See also [Canva: Free infographic maker](https://www.canva.com/create/infographics/).
- Create an image and release it on a site such as Flickr under creative commons distribute with attribution as a backlink to your website (source: [Creative Commons Image Link Building Strategy — Free Template](https://www.notion.so/Creative-Commons-Image-Link-Building-Strategy-Free-Template-29f63a81a12b4ceb88f7e7f6d94c1e23)). See also [Using Flickr To Help Generate Backlinks](https://kexino.com/marketing/using-flickr-to-help-generate-backlinks/).
- Add a link on a page from your company website to the project
- Add a link on a page from your blog to the project
- Twitter (social signal)
- LinkedIn Company Updates - Add a URL to the project will be available for indexing (shortened links are considered redirects by Google).
- LinkedIn Group Posts - Do NOT count as backlinks but may help to bring awareness to a project.
- LinkedIn Personal Posts - Do NOT count as backlinks but may help to bring awareness to a project.
- Write an article on _____ and backlink to the project.
  * [Medium.com](https://medium.com)
    Medium publications may publish an your article if it meets their criteria. This would expand the audience size considerably, for example: 
    - [HackerNoon.com](HackerNoon.com) has ~484k subscribers (FYI no longer on medium.com)
    - [PM Insider](https://medium.com/pminsider) has ~18k members
    - [Startup Grind](https://medium.com/startup-grind) has ~414k members
    - [Better Programming](https://medium.com/better-programming) has ~ 168k followers.
    - [WANTED: Other publications here]
  * [DZone.com](https://dzone.com/) has ~1mm+ subscribers (TBC)
  * [A List Apart](https://alistapart.com/) allows follow backlinks.
  * [dev.to](https://dev.to/)
  * [reddit.com](https://www.reddit.com/)
  * [theserverside.com](https://www.theserverside.com/)
  * [DevToolsDigest](https://www.devtoolsdigest.com/)
  * [StackOverflow](https://stackoverflow.com/) -- Note that (from StackOverflow), "A link to a solution is welcome, but please ensure your answer is useful without it: add context around the link so your fellow users will have some idea what it is and why it’s there, then quote the most relevant part of the page you're linking to in case the target page is unavailable"
  * [Tumblr](https://www.tumblr.com/), see also [Do Tumblr links still work for SEO in 2019?](https://www.quora.com/Do-Tumblr-links-still-work-for-SEO-in-2019)
  * [InformIT](https://www.informit.com/about/write_for_us.aspx) (TBC)
  * [WANTED: Other sites here]
- Answer questions on [Quora](https://www.quora.com/) and link to the project.
  * Answer questions
  * For content generation opportunities look for questions with a large number of views and/or upvotes and develop content around that subject.
- Send email to group mailing lists (project awareness, may be indexed if the mailing list is is archived and publicly available).
- Create a video and release it on [YouTube](https://youtube.com) and link to the project in the description.
- Find appropriate awesome-[x] lists and add a link to your project there.
  * [Awesome Java](https://java-lang.github.io/awesome-java/)
  * [Awesome R Packages](https://github.com/qinwf/awesome-R)
  * [Awesome C#](https://github.com/uhub/awesome-c-sharp)
  * [Awesome COBOL](https://github.com/mickaelandrieu/awesome-cobol)
  * [Awesome Data Engineering](https://github.com/igorbarinov/awesome-data-engineering)
- Find complimentary projects and add the backlink to the README in a "See Also" section or where appropriate. Note that reciprocity is likely welcomed.
- Talk about the project in a podcast and request that the project backlink be added in the details.
  * [Podcasts WANTED]
- Talk at a [meetup.com event](https://meetup.com) and request that the project backlink be added in the details.
- Post on Facebook (for referral traffic, see also [https://monitorbacklinks.com/blog/seo/facebook-backlinks](https://monitorbacklinks.com/blog/seo/facebook-backlinks) )
- Showcase the project including the backlink on [Google My Business](https://www.google.com/business/)
- To be confirmed: Link from a document which was released for Amazon Kindle back to your website.
- Create a document with a backlink and upload it to Scribd.
- Convert your content into a YouTube educational video and submit it to the [FreeCodeCamp.org channel](https://www.youtube.com/channel/UC8butISFwT-Wl7EV0hUK0BQ), which has ~2.4mm subscribers.
- Present your content via [EventBright](https://www.eventbrite.com/) (TBC if this idea has merit)
- [AWS IQ](https://iq.aws.amazon.com/) members can add links to other sites in their biography -- you can see an example [in my AWS IQ profile](https://iq.aws.amazon.com/e/thospfuller).
- In the "About" section of a project on GitHub you can add a link to your website or to the project website if it's hosted elsewhere -- see also [How do I get a dofollow backlink from GitHub?](https://www.quora.com/How-do-I-get-a-dofollow-backlink-from-GitHub).

# B2B / B2C / Money-related Articles
- [Sam Dunning on LinkedIn: I've outranked Cognism, Semrush & Webflow as a 6mnth old company using my BLOW OUT THE WATER SEO strategy](https://www.linkedin.com/posts/samdunning_ive-outranked-cognism-semrush-webflow-activity-7234185459415875584-rMt8)

# Guest Posting, Writing, Blogging, Syndication Ideas
- [The Ultimate Guide to Guest Posting in 2021](https://www.quicksprout.com/guest-posting-guide/)
- [Show up in Google News](https://support.google.com/news/publisher-center/answer/9607025?hl=en)
- [Bing PubHub](https://www.bing.com/webmasters/pubhub) -- Note that "[b]oth news and non-news supported!"; see also [Bing’s New PubHub Offers Millions Of New Site Visitors](https://www.searchenginejournal.com/bings-new-pubhub-offers-millions-of-new-site-visitors/437067/).

# Podcasts
- [Dev.to Podcasts](https://dev.to/pod)
- [Google Podcasts](https://podcasts.google.com/)
- [Loren Baker](https://www.linkedin.com/in/lorenbaker/) of The Search Engine Journal Show
- [Crystal Carter](https://www.linkedin.com/in/crystalontheweb/) of SERP's UP
- [Jack Chambers-Ward](https://www.linkedin.com/in/jlwchambers/) of Search with Candour
- [Aleyda Solís](https://www.linkedin.com/in/aleyda/) of Crawling Mondays
- [Mordy Oberstein](https://www.linkedin.com/in/mordyoberstein/) of The SEO Rant
- [Michael Costin](https://www.linkedin.com/in/digitalmarketingsydney/) of The SEO Show
- [Sarah McDowell](https://www.linkedin.com/in/sarahmcduk/) of The SEO Mindset
- [Nate Matherson](https://www.linkedin.com/in/natematherson/) of Optimize
- [Erin Sparks](https://www.linkedin.com/in/erinsparks/) of EDGE of the Web
- [Vince Nero](https://www.linkedin.com/in/vinnero/) of The BuzzStream Podcast
- [Gael Breton](https://www.linkedin.com/in/gael-breton-78305118/) of The Authority Hacker Podcast

# SEO Newsletters
- [SEOFOMO](https://seofomo.co/)
- [WTF is SEO?](https://www.seoforjournalism.com/)
- [SEO Notebook](https://seonotebook.com/)
- [Women in Tech SEO](https://www.womenintechseo.com/newsletter/)
- [The SEO MBA](https://newsletter.seomba.com/about)
- [Detailed](https://detailed.com/#newsletter)
- [Search Engine Journal Newsletter](https://www.searchenginejournal.com/newsletter-sign-up/)
- [Niche Pursuits](https://www.nichepursuits.com/join-newsletter/)
- [SEO Jobs](https://www.seojobs.com/)

# Marketing Ideas
- [@boringmarketer: 10 sentences that will 10x your organic growth](https://x.com/boringmarketer/status/1848443423516471796)

# SEO Pricing Articles and Resources
- [How Much Does SEO Cost in 2024?](https://www.siegemedia.com/seo/pricing)

# Technical Search Engine Optimization (Technical SEO) Articles and Videos
- [Why is Technical SEO Important?](https://thospfuller.com/2023/01/25/why-is-technical-seo-important/) -- "Learn about the benefits that Technical SEO can deliver to your business website or digital marketing campaign."
- [Mastering SEO for Developers](https://www.git-tower.com/blog/seo-for-developers/)
- [How to Find and Eliminate Render-Blocking Resources Affecting Your Core Web Vitals](https://prerender.io/blog/how-to-find-and-eliminate-render-blocking-resources/) -- Explore what render-blocking resources are, why you should care about them.

# Technical Search Engine Optimization (Technical SEO) Testing Tools
- [WebPagetest.org](https://www.webpagetest.org/) -- see also [WPO Foundation on GitHub](https://github.com/WPO-Foundation)
- [Google PageSpeed Insights](https://pagespeed.web.dev/) -- Make your web pages fast on all devices
- [Chrome Developer Tools Lighthouse](https://developers.google.com/web/tools/lighthouse)
- [Google Rich Results Test](https://search.google.com/test/rich-results)
- [Facebook for Developers : Sharing Debugger ](https://developers.facebook.com/tools/debug/)
- [Twitter Card Validator](https://cards-dev.twitter.com/validator)
- [LinkedIn Post Inspector](https://www.linkedin.com/post-inspector/)
- [KeyCDN http2-test](https://tools.keycdn.com/http2-test)
- [KeyCDN brotli-test](https://tools.keycdn.com/brotli-test)
- [KeyCDN Performance Tools](https://tools.keycdn.com/performance)
- [Neustar UltraTools DNS Speed Test](https://www.ultratools.com/tools/dnsHostingSpeedResult)
- [GZIP and Brotli Compression Test](https://www.giftofspeed.com/gzip-test/)
- [CDN77 TLS Checker](https://www.cdn77.com/tls-test)
- [dunp lab PWA tester online](https://www.dunplab.it/pwa-tester-online) -- Note that the Chrome browser Lighthouse testing tool also has PWA auditing.
- [Small SEO Tools : Keyword Rank Checker](https://smallseotools.com/keyword-position/)
- [Google AMP Test](https://search.google.com/test/amp)
- [AMP Project Validator](https://validator.ampproject.org/)
- [Google Webmaster Tools Robots.txt testing tool](https://www.google.com/webmasters/tools/robots-testing-tool)
- [Crawler Test](https://crawler-test.com/) -- Used to test how custom crawlers handle edge cases such as JavaScript or Cyrilic URLs.
- [Bing Webmaster Tools](https://www.bing.com/webmasters/)
- [Netcraft Site Report: What's that site running? Find out the infrastructure and technologies used by any site.](https://sitereport.netcraft.com/)
- [BuiltWith](https://builtwith.com/) -- Find out what websites are built with.
- [httpstatus.io is a popular bulk HTTP status checker, redirect checker and header checker.](https://httpstatus.io/)
- [Local SERP Checker: Check Google SERPs for any keyword. View localized search results for any country, city or ZIP code on Google and Google Maps.](https://www.brightlocal.com/local-search-results-checker/)

# SEO Tools
- [SERP Preview: Preview how your page could look in search results.](https://seotoolbelt.co/tools/serp-preview/)
- [CookUp.ai: Discover AI apps for every usecase and 10X your creativity & productivity](https://cookup.ai/apps/?q=SEO)
- [Similarweb: Effortlessly Analyze Your Competitive Landscape](https://www.similarweb.com/)
- [Google Trends](https://trends.google.com/) -- "Explore what the world is searching [for]".
- [SEO Learning Center / On-Site SEO / Title Tag](https://moz.com/learn/seo/title-tag)
- [Ahrefs Website "Authority" Checker](https://ahrefs.com/website-authority-checker)
- [Ahrefs Broken Link Checker](https://ahrefs.com/broken-link-checker)
- [Ahrefs Backlink Checker](https://ahrefs.com/backlink-checker)
- [TechnicalSEO.com/tools](https://technicalseo.com/tools/)
- [LinkWhisper: Building Smart Internal Links Just Got Easier](https://linkwhisper.com/)
- [FREE Hobo SEO Checklist & Task Manager (V1 .1) SEO audit template compliments of Shaun Anderson](https://docs.google.com/spreadsheets/d/1Pr0kjCQc93qrDFJyLA-FuhIOLeFFGNCDPOkGzeQxo-8/)
- [MonsterInsights.com Headline Analyzer tool enables you to write irresistible SEO headlines that drive traffic, shares, and rank better in search results.](https://www.monsterinsights.com/headline-analyzer/)
- [SiteLiner: Siteliner is a free service that lets you explore your website, revealing key issues that affect your site's quality and search engine rankings:](https://www.siteliner.com/)
- [Simple ML for Sheets](https://workspace.google.com/marketplace/app/simple_ml_for_sheets/) -- "With Simple ML for Sheets everyone can use Machine Learning in Google Sheets without knowing ML, without coding, and without sharing data with third parties."

# On-Page SEO Tools
- [Moz.com SEO Learning Center -> On-Site SEO -> Title Tag -> Title Tag Preview Tool](https://moz.com/learn/seo/title-tag)

# Local SEO Tools
- [Moz Local](https://moz.com/products/local) -- Moz Local helps you easily create and manage your local business listings on Google, Facebook, and other sites to help consumers find and choose your business; see also: [What is Local SEO?](https://moz.com/learn/seo/local).
- [Localo (previously SurferLocal)](https://localo.com/) -- Localo is an AI-powered local SEO tool for optimizing Google Business Profiles, boosting local visibility, reaching new customers, and monitoring.

# Local SEO
- [brightlocal.com: Local SEO Ranking Factors 2023](https://www.brightlocal.com/learn/local-seo/introduction-to-local-seo/ranking-factors/)
- [Local SEO: A Simple (But Complete) Guide](https://ahrefs.com/blog/local-seo/) See quote re Places "there will be an option to import data from Google My Business."
- [How To Dominate The Google Snack Pack & Local SEO](https://youtu.be/ZeTXEwt6nRo)

# Image SEO
- [@hridoyreh: Several tips pertaining to Image SEO](https://twitter.com/hridoyreh/status/1655573377451450375)

# Keyword Research Tools
- [WebFX: KeywordsFX Free Keyword Suggestion Tool](https://www.webfx.com/tools/keywordsfx/)

# Content Generation Tools
- [ScaleNut.com](https://scalenut.com/) Scalenut gives you a simple and scalable way to produce content that serves your business goals.
- [copy.ai](https://copy.ai) Experience the full power of an AI content generator that delivers premium results in seconds.

# Event Announcements
- Moz Local has a publish button -- TBD regarding how effective this is at event announcements.
- Meetup.com
- Google My Business -> Posts -> Add Event
- Dev.to
- LinkedIn
- Slack Communities
- [13 Ways to Use Facebook Events for Your Brand](https://sproutsocial.com/insights/facebook-events/)

# SEO Experts on Twitter
- [Patrick Stox](https://twitter.com/patrickstox)
- [Dan Taylor](https://twitter.com/TaylorDanRW)
- [Malte Landwehr](https://twitter.com/MalteLandwehr)
- [Dr. Marie Haynes](https://twitter.com/Marie_Haynes)
- [Kristina Azarenko](https://twitter.com/azarchick)
- [Keith Goode](https://twitter.com/keithgoode)
- [Carolyn Shelby](https://twitter.com/cshel)
- [Chris Silver Smith](https://twitter.com/si1very)
- [Barry Adams](https://twitter.com/badams)
- [Emily Dyson](https://mobile.twitter.com/theemilydyson)
- [Sam Underwood](https://mobile.twitter.com/samunderwooduk)
- [Daniel Waisberg](https://twitter.com/danielwaisberg)
- [Cyrus Shepard](https://twitter.com/CyrusShepard)
- [Shaun Anderson](https://twitter.com/Hobo_Web)
- [Brodie Clark](https://twitter.com/brodieseo)
- [Matt Diggity](https://twitter.com/mattdiggityseo)
- [Ryan Stewart](https://twitter.com/ryanwashere)
- [Nathan Gotch](https://twitter.com/nathangotch)
- [Charles Floate](https://twitter.com/Charles_SEO)
- [Ryan Darani](https://twitter.com/SearchForRyan)
- [Brian Dean](https://twitter.com/BrianEDean)
- [Jacky Chou](https://twitter.com/indexsy)
- [Hasib Alic](https://twitter.com/HasibStrevio)
- [Anne Moss](https://twitter.com/AnneMossYeys)
- [Fat Stacks](https://twitter.com/FatStacksBlog)
- [Tejas Rane](https://twitter.com/tejas3732)
- [VictoriaSEO](https://twitter.com/VictoriaSEO_)
- [Niche Site Lady](https://twitter.com/NicheSiteLady)
- [Spencer Haws](https://twitter.com/nichepursuits)
- [Ryan Kane](https://twitter.com/heyryankane)
- [Aisha Preece](https://twitter.com/AishaPreece)
- [jared bauman](https://twitter.com/jaredbauman)
- [Zak Kann](https://twitter.com/zrkann)
- [Mike (Niche Twins)](https://twitter.com/NicheDown)
- [Keith (Niche Twins)](https://twitter.com/patientpublish)
- [Joe (Niche Campus)](https://twitter.com/NicheCampus)
- [Dan (Niche Site Builder)](https://twitter.com/Niche_Lion)
- [Denis / Passive Sphere](https://twitter.com/PassiveSphere)
- [robert](https://twitter.com/robert_walden)
- [KK (Income Twins)](https://twitter.com/kksniche)
- [Arielle Phoenix](https://twitter.com/ArielleCPX)
- [Siry](https://twitter.com/NicheSiteSiry)
- [Shawn Hill](https://twitter.com/shwnhll)
- [Nina Clapperton](https://twitter.com/NinaClapperton)

# SEO Posts on LinkedIn
- [Andrew Holland: 17 SEO Techniques that Work.](https://www.linkedin.com/posts/andrew-holland-seo_seo-activity-7045043708039176194-4b64/)
- [Andrew Holland: Paid vs Organic SERP CTR comparisons](https://www.linkedin.com/posts/andrew-holland-seo_understanding-the-discounting-effect-of-ppc-activity-7081556819227090945-WKHL)

# SEO Experts on LinkedIn
- [Jorge Castro](https://www.linkedin.com/in/growthmarketing-se/)
- [Kapil Ochani](https://www.linkedin.com/in/kapilochani/)
- [Dmytro Sokhach](https://www.linkedin.com/in/dmytro-sokhach-b13aaa75/)
- [Alex Savy](https://www.linkedin.com/in/alex-savy/)
- [Oleg Galeev](https://www.linkedin.com/in/ogaleev/)
- [Aaron A.](https://www.linkedin.com/in/link-builder-aaron/)
- [Jake Ward](https://www.linkedin.com/in/jakezward/)
- [Connor Gillivan](https://www.linkedin.com/in/connorgillivan/)
- [Peter Rota](https://www.linkedin.com/in/peterrota/)
- [Liam Fallen](https://www.linkedin.com/in/technical-seo/)
- [Taylor Scher](https://www.linkedin.com/in/taylorjosephscher/)
- [Anna York](https://www.linkedin.com/in/anna-york-seo/)
- [Lily Ray](https://www.linkedin.com/in/lily-ray-44755615/)
- [Ross Hudgens](https://www.linkedin.com/in/rosshudgens/)
- [Louis Smith](https://www.linkedin.com/in/louis-smith-b968a5b5/)
- [Manish Chauhan](https://www.linkedin.com/in/manish1485/)
- [Devendra Saini](https://www.linkedin.com/in/devendrasaini/)
- [Nitin Manchanda](https://www.linkedin.com/in/nitman/)
- [Daniel Foley Carter](https://www.linkedin.com/in/daniel-foley-assertive/)
- [Nik Ranger](https://www.linkedin.com/in/nik-ranger/)
- [Kristina Azarenko](https://www.linkedin.com/in/kristinaazarenko/)
- [Steve Toth](https://www.linkedin.com/in/stevetothjr/)
- [Andrew Holland](https://www.linkedin.com/in/andrew-holland-seo/)
- [John Mueller](https://www.linkedin.com/in/johnmu/)
- [Sandy Rowley](https://www.linkedin.com/in/seo-consultant-best/)
- [Fery Kaszoni](https://www.linkedin.com/in/ferenczkaszoni/)
- [Nick LeRoy](https://www.linkedin.com/in/nickleroyseo/)
- [Eli Schwartz](https://www.linkedin.com/in/schwartze/)
- [Aleyda Solís](https://www.linkedin.com/in/aleyda/)
- [Eric Reinach](https://www.linkedin.com/in/eric-reinach/)
- [Zoe Ashbridge](https://www.linkedin.com/in/zoeashbridge/)
- [Jagadeesh J.](https://www.linkedin.com/in/jagadeesh-j/)
- [Umar Tazkeer](https://www.linkedin.com/in/umartazkeer/)
- [Chris Countey](https://www.linkedin.com/in/chriscountey/)
- [David Monaghan](https://www.linkedin.com/in/david-monaghan-seo-specialist/)
- [Tom Critchlow](https://www.linkedin.com/in/tomcritchlow/)
- [Tim Hanson](https://www.linkedin.com/in/tihanson/)
- [Alex Galinos](https://www.linkedin.com/in/alexgalinos/)
- [Nathan Gotch](https://www.linkedin.com/in/nathangotch/)
- [Cyrus S.](https://www.linkedin.com/in/cyrusshepard/)
- [Samantha North](https://www.linkedin.com/in/northsamantha/)
- [Brian Dean](https://www.linkedin.com/in/brianedean/)
- [Gordana Sretenovic](https://www.linkedin.com/in/gordanasretenovic923/)
- [Nick Jordan](https://www.linkedin.com/in/nickfromseattle/)

# SEO Channels on YouTube
- [SEMrush](https://www.youtube.com/@semrush)
- [Ahrefs](https://www.youtube.com/@AhrefsCom)
- [Matt Diggity](https://www.youtube.com/@MattDiggity)
- [Jacky Chou from Indexsy](https://www.youtube.com/@indexsy)
- [Brian Dean](https://www.youtube.com/@BrianDean)

# SEO Threads on Twitter
- [@DarrenShaw: hourly ranking data](https://twitter.com/DarrenShaw_/status/1735036555063124364) which includes some interesting findings.
- [@bloggersarvesh: This SEO hack lets you STEAL 35% more Google clicks](https://twitter.com/bloggersarvesh/status/1725029911948316780) see 4/5 and 5/5 on featured snippets, in particular.
- [@adcrookes: SEO Blog Outline Example](https://twitter.com/adcrookes/status/1722041565785301243)
- [@Charles_SEO: Advanced SEO Techniques That Aren't Just Meaningless Industry Jargon, And Actually Mean or Do Something](https://twitter.com/Charles_SEO/status/1717866197696524613)
- [@thepatwalls How Pat Walls built StarterStory.](https://twitter.com/thepatwalls/status/1716854579781144617)
- [@mich_adediran: Forget everything you've learned about how to use Alt text.](https://twitter.com/mich_adediran/status/1708843566846361753)
- [@FeryKaszoni: This website published 20K pages in 2 months, generating 12 million organic traffic, and they make over £60K per month in passive income.](https://twitter.com/FeryKaszoni/status/1704241895616979093)
- [@nichealchemist: Forum sniping on Reddit](https://twitter.com/nichealchemist/status/1701727868252762260)
- [@ConnorGillivan: 11 Conversion Tactics](https://x.com/ConnorGillivan/status/1833852345676931138)
- [@theandreboso: Amateurs focus on getting traffic from top of the funnel keywords with high search volume they find on tools, professionals focus on getting conversions from bottom of the funnel keywords with low to no search volume they find on Reddit.](https://twitter.com/theandreboso/status/1701238108757377263)
- [@dannypostmaa: I've just removed all AI-generated articles from my website.](https://twitter.com/dannypostmaa/status/1699375720030753020) -- This has been my experience as well: Content that’s been mostly generated via AI has, generally speaking, not performed well.
- [@TimStodz: 8 ingredients for 8-figure websites](https://twitter.com/TimStodz/status/1691801560362234009)
- [@iannuttall: Writing more content around the long-tail keywords you already rank for can 10x your traffic.](https://twitter.com/iannuttall/status/1643246625442222087)
- [@NicheRanger: This is what you DON'T want to see in your Search Console reports: Many impressions but few clicks.](https://twitter.com/NicheRanger/status/1639960837094875138)
- [@SEOKeval: If you don't understand search intent, you'll never rank in Google.](https://twitter.com/SEOKeval/status/1639668175502561280)
- [@Nick_zv_: 15 tips to write SEO content that ranks every time.](https://twitter.com/Nick_zv_/status/1638887573644013568)
- [@NicheSiteLady: One of my favourite ways to use ChatGPT is for keyword research...](https://twitter.com/NicheSiteLady/status/1632669741348208642)
- [@nichegrades: How to write well-structured blog posts.](https://twitter.com/nichegrades/status/1628901763175661568)
- [@AbdelrhmnHenedy: A real data-driven approach to Semantic SEO 🧵 (Practical step-by-step thread)](https://twitter.com/AbdelrhmnHenedy/status/1626588292870459392)
- [@Nick_zv_: 10 Link-Building Tactics That REALLY Work 🚀](https://twitter.com/Nick_zv_/status/1621145668101484546)
- [@GaelBreton: Here’s exactly how you can find low-competition long-tail keywords using ChatGPT.](https://twitter.com/GaelBreton/status/1620421723874299914)
- [@ahrefs: "Our blog ranks on the first page of Google for >13,600 keywords--and using these tips helped us get there."](https://twitter.com/ahrefs/status/1610123817447219201)
- [@fatjoedavies: The fastest and most effective way to increase organic traffic?](https://twitter.com/fatjoedavies/status/1546438161957535751)
- [@jaredbauman: "The easiest way to get organic backlinks is to write a blog post based on statistics or include statistics in your post. If you can incorporate your own data, even better."](https://twitter.com/jaredbauman/status/1552644043531845639)
- [@azarchick: "The difference between fragments and hashbangs in the URLs. # vs #!"](https://twitter.com/azarchick/status/1580991816056197122)
- [@azarchick: "What's the most underrated SEO tip?"](https://twitter.com/azarchick/status/1591029470391021569)
- [@alexgarcia_atx: "Here are the 5 ways you should categorize your SEO-optimized articles for maximum ROI"](https://twitter.com/alexgarcia_atx/status/1581670860472975361)
- [@KaiCromwell: Topical Authority](https://twitter.com/KaiCromwell/status/1612501969234497543)
- [@acquireconvert: "Statistics posts are such a killer way to get high quality #backlinks for #SEO"](https://twitter.com/acquireconvert/status/1613188992102502407)
- [@joehall: How do you typically handle Category/Tag archive pages for SEO?](https://twitter.com/joehall/status/1680993465109295105)

# Niche Site-Related Threads
- [How I Built A Site For Less Than $2000 Which Now Makes $1,000/month](https://www.reddit.com/r/juststart/comments/mcaodn/how_i_built_a_site_for_less_than_2000_which_now/)
- [@shwnhll: "When I started my site 22 months ago, my dream goal was to make $500/month. It’s now making about $500/day. Dream bigger."](https://twitter.com/shwnhll/status/1577343861155840002)
- [@harveymeale: A good 90% of my niche site income can be attributed to roundup articles (”best x for y”).](https://twitter.com/harveymeale/status/1678588189454499840)

# SEO Case Studies
- [The SEO Case Studies page on ThosPFuller.com](https://thospfuller.com/2024/11/27/seo-case-studies/)
- [@IvanPlanic: Niche site case study](https://twitter.com/IvanPlanic/status/1678724546474508289)

# Artificial Intelligence (AI) / ChatGPT Prompts and SEO
- [@tonythill: A simple ChatGPT and SEO tip for more search traffic using AI to generate other ways to say each part of an article's main keyword phrase.](https://twitter.com/tonythill/status/1676245995795935232)

# Digital Marketing Threads on Twitter
- [Aazar Shad](https://twitter.com/Aazarshad/status/1546494541661736961)

# Other Tools
- [tiny jpg](https://tinyjpg.com/) -- Don't assume that images are compressed prior to uploading them. Uncompressed images can place a significant drag on a web server so it will behoove you to compress the image before uploading it.
- [15 Awesome SEO Competitor Analysis Tools](https://mention.com/en/blog/competitor-seo-tools/)
- [@serpinsider: A simple way to find solid expired domains for your new projects or for resale](https://twitter.com/serpinsider/status/1674546788840407040)

# SEO Communities
- [BigSEO Slack Community Registration Form](https://docs.google.com/forms/d/e/1FAIpQLSfRAnvSg83SQD8v6zYn69WPw_1SJXdPzr4YvT6jVs1KUH0zwA/viewform)

# SEO-Related Websites
- [Search Engine Roundtable](https://www.seroundtable.com/)

# Writing Ideas
- [Here are 7 storytelling tricks to hook your reader](https://twitter.com/writes_eve/status/1667939987650691072)

# Advertising
- [Advertise Your Content With Blaze](https://wordpress.com/advertising/)
- [What does it mean if I don't get any conversions (sales) from the landing page?](https://twitter.com/Ldnbox/status/1784501809802825744) -- this is specific to Facebook ads.

# See Also
- [Google Search Console: How Accurate is the Average Position Metric?](https://www.searchenginejournal.com/google-search-console-how-accurate-is-the-average-position-metric/403368/) -- "We learn from Mueller that the average position metric is based on real data. It’s a reliable measurement, even if it doesn’t always match up with what site owners see when they check their own ranking positions."
- [Controversial: Should I disable the indexing of tags in Wordpress?](https://moz.com/community/q/topic/68981/should-i-disable-the-indexing-of-tags-in-wordpress/)
- [28 Social Media Backlinks To Increase Your Rankings In 2020](https://www.matthewwoodward.co.uk/seo/link-building/social-media-backlinks/)
- [How to Find 50 Backlink Opportunities in Just 20 Minutes](https://neilpatel.com/blog/backlink-opportunities/)
- [What are Backlinks? And How to Build Them in 2020](https://backlinko.com/hub/seo/backlinks)
- [20 SEO Link Building Methods for 2020](https://smart.linkresearchtools.com/linkthing/case-studies/link-building-techniques)
- [How to Find Who Links to Your Website (and What to Do Next)](https://ahrefs.com/blog/who-links-to-my-site/)
- [9 EASY Link Building Strategies (That ANYONE Can Use)](https://ahrefs.com/blog/link-building-strategies/)
- [Search Engine Optimization (SEO)](https://github.com/marcobiedermann/search-engine-optimization)
- [How to Create SEO Friendly URLs](https://neilpatel.com/blog/seo-urls/)
- [15 Smart Ways to Find Guest Posting Opportunities](https://moz.com/ugc/15-smart-ways-to-find-guest-posting-opportunities)
- [How to Build High-Quality Backlinks When Nobody Knows Your Name](http://neilpatel.com/blog/build-high-quality-backlinks/)
- [SEO Hidden Gem: How do you find out which questions your site ranks for?](https://thospfuller.com/2021/04/19/seo-how-do-you-find-out-which-keywords-your-site-ranks-for/)
- [17 Tips to Create Content 10x Better Than Your Competitors [Infographic]](https://www.impactplus.com/blog/how-to-create-content-better-than-your-competitors-infographic)
