---
description: Choose the right rollout for your feature flag. 
---
# 🚀 Rollouts

## Overview
A critical part of every new feature release is orchestrating the actual launch schedule between Product, Engineering, and Marketing teams.

Delivering powerful user experiences typically requires software teams to manage complex releases and make manual updates at inconvenient times. But it doesn’t have to! Having a complex rollout strategy allows you to have lifecycle for your flags.

## Releasing features with GO Feature Flag

The following table compares functionality that GO Feature Flag provides for releasing features:

| Release Option                                                      | Description                                                                                                                                                                                                                                                                                                                   | Example                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
|---------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [**Percentages rollout**](./rollout-strategies/percentage)          | Whether configured in a flag's targeting rule or the default rule, this option controls the percentage of evaluation contexts that receive a specific flag variation.                                                                                                                                                         | <p>Use percentage rollouts if you want to affect randomly variations depending on the evaluation context, this percentage will increase automatically in a time range.</p><p>Considering an evaluation context you will always have the same variation.</p><p>If you later change the percentage in the percentage rollout, the flag variation that any particular customer receives may change each time you change the percentage. To learn more, read [Percentage rollout page.](./rollout-strategies/percentage)</p> |
| [**Progressive rollout**](./rollout-strategies/progressive)         | <p>Whether configured in a flag's targeting rule or the default rule, this option controls the percentage of evaluation contexts that receive a specific flag variation.</p><p>With this option, the percentage of customers receiving a variation automatically increases over time.</p>                                     | <p>Use progressive rollouts if you want to affect randomly variations depending on the evaluation context.</p><p>It works the same way as a percentage rollout, but as the rollout progresses, the flag variation that any particular customer receives changes only once.</p>                                                                                                                                                                                                                                           |
| [**Experimentation rollout**](./rollout-strategies/experimentation) | <p>Serves a feature flag for a determined time.</p><p>The feature flag will be enabled during a certain period and will automatically **disabled** after the end date.</p>                                                                                                                                                    | <p>Use experimentation rollouts if you want to test a new feature for some times and analyse the results afterward.</p><p>Considering an evaluation context you will have an evaluation happening only during the experimentation, before or after you will receive the default value.</p>                                                                                                                                                                                                                               |
| [**Scheduled rollout**](./rollout-strategies/scheduled)             | <p>Scheduled rollout offer a structured, multi-stage approach to flag deployment, automating the rollout to specific environments and audiences.</p><p>At each stage happening on a specific date, you can modify your feature flags as you want allowing to change the target audiance of your flag as much as you want.</p> | <p>Use scheduled rollout if you want to change the audience in the time, by adding new targeting rules, changing percentages etc ...</p>                                                                                                                                                                                                                                                                                                                                                                                 |
