---
sidebar_position: 3
---

# S3 Bucket
The [**S3 Retriever v2**](https://pkg.go.dev/github.com/thomaspoignant/go-feature-flag@v1.23.1/retriever/s3retrieverv2) will use the [aws-sdk-go-v2](https://github.com/aws/aws-sdk-go-v2) to access your flag in an S3 bucket.

The [**S3 Retriever v1**](https://pkg.go.dev/github.com/thomaspoignant/go-feature-flag@v1.23.1/retriever/s3retriever) will use the deprecated [aws-sdk-go](https://github.com/aws/aws-sdk-go) to access your flag in an S3 bucket.

[AWS has announce end-of-support for AWS SDK for Go v1](https://aws.amazon.com/blogs/developer/announcing-end-of-support-for-aws-sdk-for-go-v1-on-july-31-2025/), and it's recommended to migrate from S3 Retriever v1 to v2.

## Example
```go showLineNumbers
awsConfig, _ := config.LoadDefaultConfig(context.Background())
err := ffclient.Init(ffclient.Config{
    PollingInterval: 3 * time.Second,
    Retriever: &s3retrieverv2.Retriever{
        Bucket: "tpoi-test",
        Item:   "flag-config.goff.yaml",
        AwsConfig: &awsConfig,
    },
})
defer ffclient.Close()
```

## Configuration fields
To configure your S3 file location:

| Field           | Description                                                                                                                                                                                    |
|-----------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **`Bucket`**    | The name of your bucket.                                                                                                                                                                       |
| **`Item`**      | The location of your file in the bucket.                                                                                                                                                       |
| **`AwsConfig`** | An instance of `aws.Config` that configure your access to AWS <br/>*check [this documentation for more info](https://docs.aws.amazon.com/sdk-for-go/v1/developer-guide/configuring-sdk.html)*. |
