---
sidebar_position: 20
description: What is a flag and how you can create them.
---

import Tabs from "@theme/Tabs";
import TabItem from "@theme/TabItem";

# How to configure a flag

**GO Feature Flag** core feature is to centralize all your feature flags in a source file, and to avoid hosting and maintaining a backend server to manage them.

Your file must be a valid `YAML`, `JSON` or `TOML` file with a list of flags
_(examples: [`YAML`](https://github.com/thomaspoignant/go-feature-flag/tree/main/testdata/flag-config.yaml),
[`JSON`](https://github.com/thomaspoignant/go-feature-flag/tree/main/testdata/flag-config.json),
[`TOML`](https://github.com/thomaspoignant/go-feature-flag/tree/main/testdata/flag-config.toml))_.

:::tip
The easiest way to create your configuration file is to used
[**GO Feature Flag Editor** available at [https://editor.gofeatureflag.org](https://editor.gofeatureflag.org).

If you prefer to do it manually please follow instruction bellow.
:::

## Editor

Creating the first version of the flag is not always pleasant, that's why we have created
[**GO Feature Flag Editor**](https://editor.gofeatureflag.org) a simple editor to create your files.

## Example

A flag configuration looks like:

<Tabs groupId="code">
  <TabItem value="yaml" label="YAML">

```yaml
# This is your configuration for your first flag
first-flag:
  variations: # All possible return value for your feature flag
    A: false
    B: true
  targeting: # If you want to target a subset of your users in particular
    - query: key eq "random-key"
      percentage:
        A: 0
        B: 100
  defaultRule: # When no targeting match we use the defaultRule
    variation: A
  metadata:
    issue_link: https://github.com/thomaspoignant/go-feature-flag/issues/XXX
    description: this is my first feature flag

# A second example of a flag configuration
second-flag:
  variations:
    A: "valueA"
    B: "valueB"
    defaultValue: "a default value"
  targeting:
    - name: rule1
      query: key eq "not-a-key"
      percentage:
        A: 10
        B: 90
  defaultRule:
    name: defaultRule
    variation: defaultValue
  version: "12"
  experimentation:
    start: 2021-03-20T00:00:00.1-05:00
    end: 2021-03-21T00:00:00.1-05:00
```

  </TabItem>
  <TabItem value="json" label="JSON">

```json
{
  "first-flag": {
    "variations": {
      "A": false,
      "B": true
    },
    "targeting": [
      {
        "query": "key eq \"random-key\"",
        "percentage": {
          "A": 0,
          "B": 100
        }
      }
    ],
    "defaultRule": {
      "variation": "A"
    },
    "metadata": {
      "issue_link": "https://github.com/thomaspoignant/go-feature-flag/issues/XXX",
      "description": "this is my first feature flag"
    }
  },

  "second-flag": {
    "variations": {
      "A": "valueA",
      "B": "valueB",
      "defaultValue": "a default value"
    },
    "targeting": [
      {
        "name": "rule1",
        "query": "key eq \"not-a-key\"",
        "percentage": {
          "A": 10,
          "B": 90
        }
      }
    ],
    "defaultRule": {
      "name": "defaultRule",
      "variation": "defaultValue"
    },
    "version": "12",
    "experimentation": {
      "start": "2021-03-20T05:00:00.100Z",
      "end": "2021-03-21T05:00:00.100Z"
    }
  }
}
```

  </TabItem>
  <TabItem value="toml" label="TOML">

```toml
[first-flag.variations]
A = false
B = true

[[first-flag.targeting]]
query = 'key eq "random-key"'

  [first-flag.targeting.percentage]
  A = 0
  B = 100

[first-flag.defaultRule]
variation = "A"

[first-flag.metadata]
issue_link = "https://github.com/thomaspoignant/go-feature-flag/issues/XXX"
description = "this is my first feature flag"

[second-flag]
version = "12"

  [second-flag.variations]
  A = "valueA"
  B = "valueB"
  defaultValue = "a default value"

  [[second-flag.targeting]]
  name = "rule1"
  query = 'key eq "not-a-key"'

    [second-flag.targeting.percentage]
    A = 10
    B = 90

  [second-flag.defaultRule]
  name = "defaultRule"
  variation = "defaultValue"

  [second-flag.experimentation]
  start = 2021-03-20T05:00:00.100Z
  end = 2021-03-21T05:00:00.100Z
```

  </TabItem>
</Tabs>

## Format details

<table>
  <thead>
    <tr>
      <th>Field</th>
      <th>Description</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td width="20%">
        <strong>flag-key</strong>
      </td>
      <td>
        Name of your flag.
        <br />
        <i>
          It must be unique.
          <br />
          On the example the flag keys are <code>test-flag</code> and{" "}
          <code>test-flag2</code>.
        </i>
      </td>
    </tr>
    <tr>
      <td>
        <code>variations</code>
      </td>
      <td>
        <p>Variations are all the variations available for this flag.</p>
        <p>
          It is represented as a key/value element. The key is the name of the
          variation and the value could be any types available (
          <code>string</code>, <code>float</code>, <code>int</code>,{" "}
          <code>map</code>, <code>array</code>, <code>bool</code>).
        </p>
        <p>You can have as many variation as needed.</p>
        <pre>
          # Some examples
          <br />
          variationString: test
          <br />
          variationBool: true
          <br />
          variationInt: 1000
          <br />
          variationFloat: 1000.23
          <br />
          variationArray: <br /> - item1
          <br /> - item2
          <br />
          variationObj:
          <br /> item1: 123
          <br /> item2: this is a string
          <br /> item3: false
          <br />
        </pre>
      </td>
    </tr>
    <tr>
      <td>
        <code>targeting</code>
        <br />
        <i>(optional)</i>
      </td>
      <td>
        <p>
          Targeting contains the list of rules you have to target a subset of
          your users.
          <br />
          You can have as many target as needed.
        </p>
        <p>
          This field is an <code>array</code> and contains a list of rules.
        </p>
        <p>
          <i>
            See <a href="./rule_format">rules format</a> to have more info on
            how to write a rule.
          </i>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <code>defaultRule</code>
      </td>
      <td>
        <p>
          DefaultRule is the rule that is applied if the user does not match in
          any targeting.
        </p>
        <p>
          <i>
            See <a href="./rule_format">rules format</a> to have more info on
            how to write a rule.
          </i>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <code>trackEvents</code>
        <br />
        <i>(optional)</i>
      </td>
      <td>
        <p>
          <code>false</code> if you don't want to export the data in your data
          exporter.
        </p>
        <p>
          <b>Default:</b> <code>true</code>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <code>disable</code>
        <br />
        <i>(optional)</i>
      </td>
      <td>
        <p>
          <code>true</code> if the flag is disabled.
        </p>
        <p>
          <b>Default:</b> <code>false</code>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <code>version</code>
        <br />
        <i>(optional)</i>
      </td>
      <td>
        <p>
          The version is the version of your flag.
          <br />
          This string is used to display the information in the notifiers and
          data collection, you have to update it your self.
        </p>
        <p>
          <b>Default:</b> <code>""</code>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <code>metadata</code>
        <br />
        <i>(optional)</i>
      </td>
      <td>
        <p>
          This field allows adding a wealth of information about a particular
          feature flag, such as a configuration URL or the originating Jira
          issue.
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <code>scheduledRollout</code>
        <br />
        <i>(optional)</i>
      </td>
      <td>
        <p>Scheduled allow to patch your flag over time.</p>
        <p>
          You can add several steps that updates the flag, this is typically
          used if you want to gradually add more user in your flag.
        </p>
        <p>
          <i>
            See <a href="./rollout/scheduled/">Scheduled rollout</a> to have
            more info on how to use it.
          </i>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <code>experimentation</code>
        <br />
        <i>(optional)</i>
      </td>
      <td>
        <p>
          Experimentation allow you to configure a start date and an end date
          for your flag. When the experimentation is not running, the flag will
          serve the default value.
        </p>
        <p>
          <i>
            See <a href="./rollout/experimentation/">Experimentation rollout</a>{" "}
            to have more info on how to use it.
          </i>
        </p>
      </td>
    </tr>
  </tbody>
</table>

## Advanced configurations

You can have advanced configurations for your flag to have specific behavior for them, such as:

- [Specific rollout strategies](../category/rollout-strategies/)
- [Don't track a flag](../go_module/data_collection/index.md#dont-track-a-flag)
