# S3 Bucket
The [**S3Retriever**](https://pkg.go.dev/github.com/thomaspoignant/go-feature-flag#S3Retriever) will use the [aws-sdk](https://github.com/aws/aws-sdk-go) to access your flag in an S3 bucket.

## Example
```go linenums="1"
err := ffclient.Init(ffclient.Config{
    PollingInterval: 3 * time.Second,
    Retriever: &ffclient.S3Retriever{
        Bucket: "tpoi-test",
        Item:   "flag-config.yaml",
        AwsConfig: aws.Config{
            Region: aws.String("eu-west-1"),
        },
    },
})
defer ffclient.Close()
```

## Configuration fields
To configure your S3 file location:

| Field | Description |
|---|---|
|**`Bucket`**| The name of your bucket.|
|**`Item`**| The location of your file in the bucket.|
|**`AwsConfig`**| An instance of `aws.Config` that configure your access to AWS <br/>*check [this documentation for more info](https://docs.aws.amazon.com/sdk-for-go/v1/developer-guide/configuring-sdk.html)*.|
