import React from 'react';
import styles from './styles.module.css';
import clsx from 'clsx';
import useDocusaurusContext from '@docusaurus/useDocusaurusContext';
import Link from '@docusaurus/Link';

import chapatiSystems from '@site/static/img/using-it/chapati.systems.png';
import lyft from '@site/static/img/using-it/lyft.png';
import tencent from '@site/static/img/using-it/tencent.png';
import minder from '@site/static/img/using-it/minder.png';

export function UsingIt() {
  const {siteConfig} = useDocusaurusContext();
  return (
    <section className={styles.usingit}>
      <div className="grid grid-pad">
        <div className={clsx('col-1-1')}>
          <span className={clsx(styles.mainTitle)}>
            Who is using GO Feature Flag?
          </span>
          <div
            className={
              'grid grid-cols-1 sm:grid-cols-2 md:grid-cols-5 xl:grid-cols-6 mt-12 items-center gap-y-4'
            }>
            <div>
              <Link to={'https://agentero.com'}>
                <svg
                  viewBox="0 0 154 44"
                  width="190"
                  height="70"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                  className="Logo_logo__csB_s"
                  role="img"
                  aria-label="Agentero">
                  <g clipPath="url(#logo-agentero_svg__a)" fill="#2DBC90">
                    <path d="M34.056 44a17.76 17.76 0 0 1-5.866-.885 12.342 12.342 0 0 1-4.28-2.518c-2.174-1.94-3.839-4.707-5.413-8.973l-2.729-7.662-4.79-13.612-.515-1.457-.51 1.457L5.56 22.782l10.123 2.502.159.34H0L6.641 8.303A3.6 3.6 0 0 1 9.987 6h1.003a3.766 3.766 0 0 1 3.533 2.461l8.39 22.494c3.131 7.266 6.613 8.854 11.222 9.075h.402c3.46 0 5.628-2.121 5.73-4.175a2.887 2.887 0 0 0-.974-2.32 5.798 5.798 0 0 0-3.397-1.292c-2.078-.205-4.666-.46-6.562-1.135-2.095-.72-3.103-1.854-3.103-3.476a2.84 2.84 0 0 1 .736-2.054 4.606 4.606 0 0 1 2.265-1.134 5.264 5.264 0 0 1-2.361-2.268 6.054 6.054 0 0 1-.657-2.808c0-2.37.6-4.027 1.891-5.2 1.568-1.43 4.173-2.128 7.927-2.128h8.826v2.938l-2.83-.102a3.718 3.718 0 0 1 1.568 1.628c.447.9.67 1.894.65 2.898 0 2.37-.565 3.97-1.754 5.105-1.427 1.332-3.828 1.979-7.36 1.979-1.314 0-3.149-.08-3.166-.08-1.664.21-2.004.517-2.004.908 0 .89 1.45 1.083 5.317 1.594l.736.096c4.104.533 8.39 1.622 9.058 5.711.12.878.023 1.772-.283 2.604a8.68 8.68 0 0 1-1.596 2.756 10.721 10.721 0 0 1-3.613 2.79A13.116 13.116 0 0 1 34.056 44Zm1.132-28.494c-4.144 0-4.7 1.888-4.7 3.743 0 1.356.29 2.269.9 2.932.748.783 2.005 1.134 3.84 1.134 1.834 0 3.034-.368 3.776-1.134.629-.646.928-1.588.928-2.966-.01-1.911-.588-3.71-4.75-3.71h.006ZM78.97 11.944c-4.365 0-6.397 1.826-7.037 3.284l-.029-2.99h-3.051v21.258h4.025V21.66c0-3.822.867-6.023 4.966-6.023s4.705 2.269 4.705 6.023v11.837h3.991V22.04c0-6.023-1.245-10.095-7.57-10.095ZM93.651 7.934h-4.195v5.07h-2.904v3.403h2.904v11.055c0 4.792 2.83 6.375 9.54 5.978v-3.403c-4.41.198-5.209-.675-5.209-2.575V16.407h5.21v-3.402h-5.329l-.017-5.07ZM126.218 15.182V12.24h-3.041v21.257h3.964V21.7c0-3.448.781-5.898 4.756-5.898.334 0 .707.085 1.081.085v-3.97h-.628c-3.72 0-5.538 1.826-6.132 3.238M143.243 33.496a10.746 10.746 0 0 1-6.817-2.458 10.792 10.792 0 0 1-2.642-13.409 10.763 10.763 0 0 1 5.373-4.868 10.741 10.741 0 0 1 13.054 3.974 10.786 10.786 0 0 1-4.838 15.944c-1.309.542-2.713.82-4.13.817Zm0-17.582c-1.344 0-2.658.4-3.775 1.147a6.803 6.803 0 0 0-2.502 3.054 6.82 6.82 0 0 0-.387 3.933 6.803 6.803 0 0 0 5.338 5.347 6.784 6.784 0 0 0 6.975-2.894 6.819 6.819 0 0 0-.845-8.594 6.787 6.787 0 0 0-4.804-1.993ZM56.986 33.496a14.987 14.987 0 0 1-5.464-.902 8.296 8.296 0 0 1-3.397-2.405 9.08 9.08 0 0 1-1.698-3.454 15.672 15.672 0 0 1-.482-4.06 15.411 15.411 0 0 1 .487-4.044 8.968 8.968 0 0 1 1.733-3.403 8.284 8.284 0 0 1 3.357-2.422 14.967 14.967 0 0 1 5.441-.89c3.244 0 5.741.935 7.434 2.779 1.959 2.138 2.83 5.501 2.446 9.72H50.684c.272 3.784 2.333 5.672 6.126 5.672 2.961 0 4.682-1.1 5.266-3.363h4.83a6.668 6.668 0 0 1-2.503 4.696c-1.699 1.395-4.196 2.076-7.417 2.076Zm-.476-18.15c-3.674 0-5.514 1.782-5.78 5.616h11.323v-.068c0-.034 0 0 0 0a5.626 5.626 0 0 0-1.404-4.067c-.934-.992-2.333-1.48-4.139-1.48ZM110.62 33.496a14.99 14.99 0 0 1-5.481-.902 8.294 8.294 0 0 1-3.397-2.405 9.084 9.084 0 0 1-1.698-3.454 15.647 15.647 0 0 1-.482-4.06 15.42 15.42 0 0 1 .487-4.044 8.972 8.972 0 0 1 1.733-3.403 8.283 8.283 0 0 1 3.397-2.377 14.974 14.974 0 0 1 5.441-.89c3.244 0 5.741.936 7.434 2.779 1.959 2.138 2.83 5.501 2.445 9.721h-16.136c.272 3.783 2.333 5.672 6.126 5.672 2.962 0 4.683-1.1 5.266-3.363h4.835a6.673 6.673 0 0 1-2.502 4.696c-1.744 1.35-4.241 2.03-7.468 2.03Zm-.476-18.15c-3.674 0-5.514 1.782-5.781 5.616h11.324v-.068c0-.034 0 0 0 0a5.61 5.61 0 0 0-1.404-4.067c-.929-.992-2.327-1.48-4.133-1.48h-.006Z"></path>
                  </g>
                  <defs>
                    <clipPath id="logo-agentero_svg__a">
                      <path
                        fill="#fff"
                        transform="translate(0 6)"
                        d="M0 0h154v38H0z"></path>
                    </clipPath>
                  </defs>
                </svg>
              </Link>
            </div>
            <div>
              <Link to={'https://github.com/lyft/atlantis'}>
                <img src={lyft} alt={'Lyft'} />
              </Link>
            </div>
            <div>
              <Link to={'https://cast.ai'}>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="144.5"
                  height="58.5"
                  fill="none"
                  viewBox="0 0 289 117">
                  <path
                    fill="#000"
                    d="M85.769 67.888a16.836 16.836 0 0 1 1.159 6.178c0 2.1-.377 4.186-1.16 6.179a16.314 16.314 0 0 1-3.522 5.421L57.26 111.355a15.87 15.87 0 0 1-5.283 3.599 15.648 15.648 0 0 1-12.042 0 16.072 16.072 0 0 1-5.299-3.599l-3.236-3.321L4.922 80.847A17.505 17.505 0 0 1 1.4 75.642C.542 73.68 0 71.502 0 69.232V46.586c.15-4.233 1.776-8.11 4.59-10.998L34.576 4.804C37.691 1.622 41.8-.016 45.88 0c2.047 0 4.079.386 6.02 1.19a16.05 16.05 0 0 1 5.3 3.613l25.138 25.811a16.193 16.193 0 0 1 3.507 5.422 16.796 16.796 0 0 1 1.174 6.178 17.16 17.16 0 0 1-1.159 6.18 16.537 16.537 0 0 1-3.522 5.436l-4.23 4.34-6.262 6.426L57.2 79.627a15.866 15.866 0 0 1-5.283 3.599 15.7 15.7 0 0 1-6.021 1.205c-2.017 0-4.08-.402-6.021-1.205a16.025 16.025 0 0 1-5.284-3.6l-2.604-2.61-6.954-7.136a16.536 16.536 0 0 1-3.522-5.437 17.092 17.092 0 0 1-1.16-6.179c0-2.1.392-4.186 1.16-6.178a16.536 16.536 0 0 1 3.522-5.437l9.573-9.824a16.148 16.148 0 0 1 5.284-3.615 15.628 15.628 0 0 1 6.02-1.19c2.048 0 4.08.387 6.022 1.19a16.24 16.24 0 0 1 5.298 3.6l9.423 9.669-6.247 6.41-9.423-9.654a7.214 7.214 0 0 0-2.378-1.622 6.778 6.778 0 0 0-2.694-.54c-.918 0-1.837.17-2.695.54a7.26 7.26 0 0 0-2.378 1.622l-9.558 9.84a7.427 7.427 0 0 0-1.58 2.44 7.275 7.275 0 0 0-.528 2.765c0 .942.181 1.884.527 2.765.361.88.858 1.699 1.58 2.44l6.955 7.137 2.589 2.656a7.31 7.31 0 0 0 2.363 1.622c.858.371 1.776.54 2.695.54a6.77 6.77 0 0 0 2.694-.54 7.799 7.799 0 0 0 2.378-1.622l1.942-1.992 23.361-23.973-.015-.016a7.36 7.36 0 0 0 1.43-2.27 7.26 7.26 0 0 0 .527-2.765 7.26 7.26 0 0 0-.527-2.765 7.506 7.506 0 0 0-1.58-2.44L50.952 11.26a7.37 7.37 0 0 0-2.378-1.622 6.818 6.818 0 0 0-2.724-.54c-.919 0-1.837.169-2.695.54a7.563 7.563 0 0 0-2.363 1.622L10.988 42.015c-1.325 1.359-2.077 3.089-2.153 4.865v22.336c0 .911.226 1.792.618 2.688.391.88.978 1.776 1.7 2.517l26.478 27.171 3.236 3.321a7.074 7.074 0 0 0 2.363 1.622 6.79 6.79 0 0 0 2.695.54 7.06 7.06 0 0 0 2.694-.54 7.298 7.298 0 0 0 2.378-1.622l24.987-25.641a7.428 7.428 0 0 0 1.581-2.44c.361-.881.527-1.824.527-2.766s-.166-1.884-.527-2.765c-.15-.37-.316-.71-.527-1.035l6.337-6.503c1.009 1.282 1.822 2.657 2.394 4.125Zm65.788-1.073c-.602 3.12-1.656 5.9-3.221 8.372-1.536 2.456-3.432 4.541-5.645 6.194-2.198 1.668-4.636 2.92-7.27 3.815-2.68.85-5.374 1.313-8.174 1.313-3.823 0-7.27-.726-10.356-2.147a24.091 24.091 0 0 1-7.932-5.885c-2.213-2.502-3.914-5.468-5.118-8.882-1.205-3.429-1.807-7.136-1.807-11.136 0-4.001.602-7.708 1.807-11.138 1.204-3.429 2.92-6.41 5.148-8.928a23.19 23.19 0 0 1 8.128-5.916c3.191-1.436 6.713-2.147 10.582-2.147 2.845 0 5.599.448 8.234 1.39a23.639 23.639 0 0 1 7.044 3.94c2.077 1.668 3.823 3.738 5.253 6.116 1.174 1.977 2.048 4.17 2.604 6.596H139.53c-.692-2.194-1.912-4.016-3.718-5.484-2.213-1.791-4.907-2.687-8.083-2.687-1.821 0-3.537.34-5.208 1.035-1.656.71-3.116 1.791-4.365 3.305-1.28 1.483-2.288 3.352-3.011 5.623-.738 2.27-1.129 4.974-1.129 8.186 0 3.198.391 5.916 1.129 8.233.738 2.286 1.746 4.17 3.011 5.7 1.279 1.483 2.724 2.595 4.335 3.29a12.13 12.13 0 0 0 4.952 1.035c1.43 0 2.83-.17 4.2-.494 1.369-.325 2.619-.912 3.808-1.668a12.13 12.13 0 0 0 3.01-3.043c.828-1.236 1.445-2.75 1.837-4.542h11.259v-.046Zm17.958 19.607c-2.363-.772-4.411-1.854-6.127-3.244a14.383 14.383 0 0 1-3.988-5.035c-.934-1.962-1.4-4.171-1.4-6.642 0-3.322.933-6.102 2.814-8.295 1.867-2.194 4.426-4 7.632-5.391 3.206-1.406 6.939-2.456 11.184-3.197 4.26-.727 8.776-1.36 13.562-1.9v-1.004c0-2.271-.286-4.171-.888-5.731-.587-1.56-1.385-2.796-2.378-3.692-1.009-.911-2.168-1.544-3.507-1.946a14.219 14.219 0 0 0-4.14-.602c-2.92 0-5.358.803-7.345 2.41-1.987 1.59-3.041 4.015-3.161 7.29h-11.38c.181-2.734.888-5.236 2.047-7.476a18.52 18.52 0 0 1 4.666-5.839c1.942-1.637 4.23-2.889 6.864-3.784 2.634-.896 5.525-1.344 8.701-1.344 3.116 0 6.036.401 8.745 1.19 2.725.802 5.103 2.1 7.105 3.876 2.002 1.792 3.567 4.17 4.666 7.136 1.099 2.966 1.626 6.58 1.551 10.829 0 .68-.015 1.544-.061 2.595-.03 1.05-.06 2.224-.06 3.506 0 1.267-.015 2.58-.06 3.939-.03 1.36-.06 2.657-.06 3.846 0 3.383.135 6.735.391 10.04.256 3.29.662 6.07 1.159 8.326h-10.612c-.18-1.128-.376-2.147-.542-3.09-.165-.926-.301-2.332-.436-4.186-1.686 2.92-4.004 5.098-6.955 6.488-2.935 1.406-6.367 2.1-10.25 2.1-2.755-.03-5.374-.4-7.737-1.173Zm13.381-24.004c-2.92.54-5.328 1.19-7.195 1.993-1.866.803-3.266 1.745-4.139 2.842-.888 1.096-1.31 2.41-1.31 3.939 0 2.332.888 4.155 2.619 5.483 1.747 1.329 4.08 1.993 7.015 1.993 4.275 0 7.632-1.112 10.025-3.352 2.393-2.225 3.597-5.638 3.597-10.226v-4.093c-4.169.417-7.706.896-10.612 1.421Zm58.284-21.506c-2.047-1.035-4.515-1.544-7.436-1.544-2.528 0-4.771.54-6.758 1.59-1.972 1.05-2.966 2.503-2.966 4.295 0 1.791.603 3.197 1.807 4.186 1.204 1.004 2.935 1.73 5.208 2.193l7.391 1.498a70.06 70.06 0 0 1 7.39 1.9c2.273.726 4.26 1.715 5.946 2.935 1.686 1.236 2.996 2.75 3.929 4.541.933 1.792 1.4 4.001 1.4 6.58 0 2.796-.602 5.268-1.807 7.446-1.204 2.147-2.814 3.985-4.846 5.437-2.033 1.452-4.381 2.58-7.045 3.352-2.664.772-5.479 1.158-8.475 1.158-3.236 0-6.171-.448-8.805-1.343-2.619-.912-4.907-2.132-6.864-3.692a18.955 18.955 0 0 1-4.727-5.592c-1.204-2.147-1.972-4.495-2.288-7.043h11.275c.526 2.795 1.746 4.942 3.688 6.44 1.941 1.5 4.636 2.256 8.083 2.256 3.055 0 5.569-.618 7.526-1.854 1.972-1.235 2.965-2.934 2.965-5.128 0-2.193-.858-3.846-2.589-4.943-1.731-1.096-3.883-1.9-6.472-2.44l-7.873-1.591a36.83 36.83 0 0 1-6.186-1.854c-1.912-.772-3.583-1.776-4.998-2.996-1.43-1.236-2.544-2.734-3.356-4.48-.813-1.776-1.22-3.877-1.22-6.349 0-2.41.587-4.54 1.746-6.44 1.159-1.9 2.725-3.523 4.667-4.882 1.941-1.36 4.199-2.41 6.758-3.135 2.559-.726 5.269-1.097 8.113-1.097 2.529 0 4.983.309 7.391.942 2.394.633 4.576 1.622 6.518 2.935 1.942 1.328 3.598 2.997 4.967 5.005 1.37 2.008 2.303 4.325 2.815 6.981h-10.883c-.617-2.502-1.942-4.232-3.989-5.267Zm37.328.459v32.732h10.491v11.075h-13.441c-4.772 0-8.64-3.985-8.64-8.867v-34.94h-7.527V31.27h7.527V20.163h11.575V31.27h10.491v10.1h-10.476Z"
                  />
                </svg>
              </Link>
            </div>
            <div>
              <img src={chapatiSystems} alt={'chapati systems'} width="70" />
            </div>
            <div>
              <svg
                fill="none"
                height="38"
                viewBox="0 0 160 32"
                xmlns="http://www.w3.org/2000/svg">
                <path
                  d="M14.1203 8.93457C14.1203 11.0404 13.5771 13.1099 12.5501 14.9339L0.662109 36H8.51737L13.6643 27.2265C15.306 24.4281 16.1704 21.2272 16.1704 17.9658V0H14.1164V8.93457H14.1203Z"
                  fill="#ffffff"></path>
                <path
                  d="M19.8763 8.93457V0H17.8223V17.9617C17.8223 21.2231 18.6907 24.4241 20.3283 27.2225L25.4753 35.996H33.3306L21.4426 14.9299C20.4116 13.1059 19.8723 11.0363 19.8723 8.93054L19.8763 8.93457Z"
                  fill="#ffffff"></path>
                <path
                  d="M43.3682 15H40.9339L45.3661 2.41043H48.1815L52.6199 15H50.1855L46.823 4.99227H46.7246L43.3682 15ZM43.4482 10.0638H50.0872V11.8956H43.4482V10.0638ZM56.405 2.41043V15H54.1797V2.41043H56.405ZM63.4083 5.55782V7.27905H57.9803V5.55782H63.4083ZM59.3204 3.29563H61.5457V12.16C61.5457 12.4591 61.5907 12.6886 61.6809 12.8485C61.7752 13.0042 61.8981 13.1107 62.0497 13.1681C62.2014 13.2255 62.3694 13.2542 62.5538 13.2542C62.6931 13.2542 62.8202 13.2439 62.9349 13.2234C63.0538 13.203 63.1439 13.1845 63.2054 13.1681L63.5804 14.9078C63.4616 14.9488 63.2915 14.9939 63.0702 15.043C62.853 15.0922 62.5866 15.1209 62.271 15.1291C61.7137 15.1455 61.2117 15.0615 60.765 14.8771C60.3183 14.6885 59.9638 14.3976 59.7015 14.0041C59.4433 13.6107 59.3163 13.1189 59.3204 12.5288V3.29563ZM69.3481 15.1844C68.4014 15.1844 67.5838 14.9877 66.8953 14.5943C66.2109 14.1968 65.6843 13.6353 65.3155 12.9099C64.9466 12.1805 64.7622 11.3219 64.7622 10.3342C64.7622 9.36297 64.9466 8.51055 65.3155 7.77698C65.6884 7.03931 66.2089 6.46556 66.8769 6.05575C67.5449 5.64183 68.3297 5.43488 69.2313 5.43488C69.8132 5.43488 70.3624 5.52913 70.8787 5.71765C71.3992 5.90207 71.8582 6.18894 72.2557 6.57826C72.6573 6.96759 72.9729 7.46347 73.2024 8.0659C73.4319 8.66423 73.5466 9.37731 73.5466 10.2051V10.8875H65.8072V9.38756H71.4135C71.4094 8.96135 71.3172 8.58227 71.1369 8.25032C70.9566 7.91427 70.7046 7.64994 70.3808 7.45732C70.0611 7.26471 69.6882 7.1684 69.262 7.1684C68.8071 7.1684 68.4075 7.27905 68.0633 7.50035C67.719 7.71756 67.4506 8.00443 67.258 8.36097C67.0695 8.71341 66.9732 9.10069 66.9691 9.5228V10.8322C66.9691 11.3813 67.0695 11.8526 67.2703 12.246C67.4711 12.6354 67.7518 12.9345 68.1125 13.1435C68.4731 13.3484 68.8952 13.4509 69.3788 13.4509C69.7026 13.4509 69.9956 13.4058 70.2579 13.3157C70.5201 13.2214 70.7476 13.0841 70.9402 12.9038C71.1328 12.7235 71.2783 12.5001 71.3767 12.2337L73.4544 12.4673C73.3233 13.0165 73.0733 13.496 72.7045 13.9058C72.3397 14.3115 71.8725 14.6271 71.3029 14.8525C70.7332 15.0738 70.0816 15.1844 69.3481 15.1844ZM75.4292 15V5.55782H77.5869V7.13152H77.6853C77.8574 6.58646 78.1525 6.1664 78.5705 5.87133C78.9926 5.57216 79.4741 5.42258 80.0151 5.42258C80.138 5.42258 80.2753 5.42873 80.4269 5.44102C80.5827 5.44922 80.7118 5.46356 80.8142 5.48405V7.53109C80.72 7.4983 80.5704 7.46962 80.3655 7.44503C80.1647 7.41634 79.97 7.402 79.7815 7.402C79.3758 7.402 79.011 7.49011 78.6873 7.66633C78.3676 7.83845 78.1156 8.07819 77.9312 8.38556C77.7467 8.69292 77.6545 9.04741 77.6545 9.44903V15H75.4292ZM84.5179 9.46747V15H82.2926V5.55782H84.4196V7.16225H84.5302C84.7474 6.63359 85.0937 6.21353 85.5691 5.90207C86.0486 5.59061 86.6408 5.43488 87.3457 5.43488C87.9973 5.43488 88.5649 5.57421 89.0485 5.85289C89.5361 6.13156 89.9132 6.53523 90.1796 7.0639C90.45 7.59256 90.5832 8.23392 90.5791 8.98799V15H88.3538V9.33223C88.3538 8.70112 88.1899 8.20729 87.862 7.85075C87.5383 7.49421 87.0895 7.31593 86.5158 7.31593C86.1265 7.31593 85.7802 7.402 85.4769 7.57412C85.1777 7.74214 84.9421 7.98599 84.77 8.30564C84.602 8.6253 84.5179 9.01258 84.5179 9.46747ZM95.5584 15.1906C94.9601 15.1906 94.4212 15.084 93.9417 14.8709C93.4663 14.6537 93.0893 14.334 92.8106 13.9119C92.536 13.4898 92.3987 12.9694 92.3987 12.3505C92.3987 11.8178 92.4971 11.3772 92.6938 11.0289C92.8905 10.6805 93.1589 10.4019 93.4991 10.1928C93.8392 9.98384 94.2224 9.82606 94.6486 9.71951C95.0789 9.60886 95.5236 9.52895 95.9826 9.47977C96.5358 9.42239 96.9846 9.37117 97.3288 9.32609C97.6731 9.27691 97.9231 9.20314 98.0788 9.10479C98.2386 9.00233 98.3185 8.84455 98.3185 8.63145V8.59456C98.3185 8.13147 98.1812 7.77288 97.9067 7.51879C97.6321 7.26471 97.2366 7.13766 96.7202 7.13766C96.1752 7.13766 95.7428 7.25651 95.4232 7.49421C95.1076 7.7319 94.8945 8.01262 94.7839 8.33638L92.7061 8.04131C92.87 7.46757 93.1405 6.98808 93.5175 6.60285C93.8946 6.21353 94.3556 5.92256 94.9007 5.72994C95.4457 5.53323 96.0481 5.43488 96.7079 5.43488C97.1628 5.43488 97.6157 5.48815 98.0665 5.5947C98.5173 5.70126 98.9292 5.87748 99.3021 6.12337C99.675 6.36516 99.9742 6.69506 100.2 7.11308C100.429 7.53109 100.544 8.05361 100.544 8.68062V15H98.4046V13.7029H98.3308C98.1956 13.9652 98.005 14.2111 97.7591 14.4406C97.5173 14.666 97.212 14.8484 96.8432 14.9877C96.4784 15.1229 96.0502 15.1906 95.5584 15.1906ZM96.1362 13.5554C96.5829 13.5554 96.9702 13.4673 97.2981 13.2911C97.6259 13.1107 97.878 12.8731 98.0542 12.578C98.2345 12.2829 98.3247 11.9612 98.3247 11.6129V10.5002C98.255 10.5576 98.1362 10.6109 97.9681 10.66C97.8042 10.7092 97.6198 10.7522 97.4149 10.7891C97.21 10.826 97.0071 10.8588 96.8063 10.8875C96.6055 10.9162 96.4313 10.9408 96.2838 10.9613C95.9518 11.0063 95.6547 11.0801 95.3924 11.1826C95.1301 11.285 94.9232 11.4284 94.7716 11.6129C94.6199 11.7932 94.5441 12.0268 94.5441 12.3137C94.5441 12.7235 94.6937 13.0329 94.9929 13.2419C95.292 13.4509 95.6732 13.5554 96.1362 13.5554ZM107.496 5.55782V7.27905H102.068V5.55782H107.496ZM103.408 3.29563H105.634V12.16C105.634 12.4591 105.679 12.6886 105.769 12.8485C105.863 13.0042 105.986 13.1107 106.138 13.1681C106.289 13.2255 106.457 13.2542 106.642 13.2542C106.781 13.2542 106.908 13.2439 107.023 13.2234C107.142 13.203 107.232 13.1845 107.294 13.1681L107.668 14.9078C107.55 14.9488 107.38 14.9939 107.158 15.043C106.941 15.0922 106.675 15.1209 106.359 15.1291C105.802 15.1455 105.3 15.0615 104.853 14.8771C104.406 14.6885 104.052 14.3976 103.79 14.0041C103.531 13.6107 103.404 13.1189 103.408 12.5288V3.29563ZM109.357 15V5.55782H111.583V15H109.357ZM110.476 4.21772C110.124 4.21772 109.821 4.10092 109.566 3.86733C109.312 3.62963 109.185 3.34481 109.185 3.01286C109.185 2.67681 109.312 2.39199 109.566 2.15839C109.821 1.9207 110.124 1.80185 110.476 1.80185C110.833 1.80185 111.136 1.9207 111.386 2.15839C111.64 2.39199 111.767 2.67681 111.767 3.01286C111.767 3.34481 111.64 3.62963 111.386 3.86733C111.136 4.10092 110.833 4.21772 110.476 4.21772ZM122.305 5.55782L118.943 15H116.484L113.121 5.55782H115.494L117.664 12.5718H117.762L119.938 5.55782H122.305ZM127.704 15.1844C126.757 15.1844 125.94 14.9877 125.251 14.5943C124.567 14.1968 124.04 13.6353 123.671 12.9099C123.302 12.1805 123.118 11.3219 123.118 10.3342C123.118 9.36297 123.302 8.51055 123.671 7.77698C124.044 7.03931 124.565 6.46556 125.233 6.05575C125.901 5.64183 126.686 5.43488 127.587 5.43488C128.169 5.43488 128.718 5.52913 129.235 5.71765C129.755 5.90207 130.214 6.18894 130.612 6.57826C131.013 6.96759 131.329 7.46347 131.558 8.0659C131.788 8.66423 131.902 9.37731 131.902 10.2051V10.8875H124.163V9.38756H129.769C129.765 8.96135 129.673 8.58227 129.493 8.25032C129.312 7.91427 129.06 7.64994 128.737 7.45732C128.417 7.26471 128.044 7.1684 127.618 7.1684C127.163 7.1684 126.763 7.27905 126.419 7.50035C126.075 7.71756 125.806 8.00443 125.614 8.36097C125.425 8.71341 125.329 9.10069 125.325 9.5228V10.8322C125.325 11.3813 125.425 11.8526 125.626 12.246C125.827 12.6354 126.108 12.9345 126.468 13.1435C126.829 13.3484 127.251 13.4509 127.735 13.4509C128.058 13.4509 128.351 13.4058 128.614 13.3157C128.876 13.2214 129.103 13.0841 129.296 12.9038C129.489 12.7235 129.634 12.5001 129.733 12.2337L131.81 12.4673C131.679 13.0165 131.429 13.496 131.06 13.9058C130.696 14.3115 130.228 14.6271 129.659 14.8525C129.089 15.0738 128.437 15.1844 127.704 15.1844Z"
                  fill="white"></path>
                <path
                  d="M41.7515 32V19.4104H46.4726C47.4398 19.4104 48.2512 19.5907 48.9069 19.9514C49.5667 20.312 50.0646 20.8079 50.4007 21.439C50.7408 22.066 50.9109 22.7791 50.9109 23.5783C50.9109 24.3856 50.7408 25.1028 50.4007 25.7298C50.0605 26.3568 49.5585 26.8507 48.8946 27.2113C48.2307 27.5678 47.4131 27.7461 46.4419 27.7461H43.3129V25.8712H46.1345C46.7 25.8712 47.1631 25.7728 47.5238 25.5761C47.8844 25.3794 48.1508 25.1089 48.3229 24.7647C48.4991 24.4204 48.5873 24.025 48.5873 23.5783C48.5873 23.1316 48.4991 22.7381 48.3229 22.398C48.1508 22.0578 47.8824 21.7935 47.5176 21.605C47.157 21.4124 46.6919 21.3161 46.1222 21.3161H44.0321V32H41.7515ZM55.3415 32.1906C54.7432 32.1906 54.2043 32.084 53.7248 31.8709C53.2494 31.6537 52.8724 31.334 52.5937 30.9119C52.3191 30.4898 52.1819 29.9694 52.1819 29.3505C52.1819 28.8178 52.2802 28.3772 52.4769 28.0289C52.6736 27.6805 52.9421 27.4019 53.2822 27.1928C53.6224 26.9838 54.0055 26.8261 54.4318 26.7195C54.8621 26.6089 55.3067 26.5289 55.7657 26.4798C56.319 26.4224 56.7677 26.3712 57.112 26.3261C57.4562 26.2769 57.7062 26.2031 57.8619 26.1048C58.0217 26.0023 58.1017 25.8446 58.1017 25.6314V25.5946C58.1017 25.1315 57.9644 24.7729 57.6898 24.5188C57.4152 24.2647 57.0197 24.1377 56.5034 24.1377C55.9583 24.1377 55.526 24.2565 55.2063 24.4942C54.8907 24.7319 54.6776 25.0126 54.567 25.3364L52.4892 25.0413C52.6531 24.4676 52.9236 23.9881 53.3007 23.6029C53.6777 23.2135 54.1387 22.9226 54.6838 22.7299C55.2288 22.5332 55.8313 22.4349 56.4911 22.4349C56.946 22.4349 57.3988 22.4882 57.8496 22.5947C58.3004 22.7013 58.7123 22.8775 59.0852 23.1234C59.4582 23.3652 59.7573 23.6951 59.9827 24.1131C60.2122 24.5311 60.327 25.0536 60.327 25.6806V32H58.1877V30.7029H58.114C57.9787 30.9652 57.7882 31.2111 57.5423 31.4406C57.3005 31.666 56.9952 31.8484 56.6263 31.9877C56.2616 32.1229 55.8333 32.1906 55.3415 32.1906ZM55.9194 30.5554C56.3661 30.5554 56.7534 30.4673 57.0812 30.2911C57.4091 30.1107 57.6611 29.8731 57.8373 29.578C58.0177 29.2829 58.1078 28.9612 58.1078 28.6129V27.5002C58.0381 27.5576 57.9193 27.6109 57.7513 27.66C57.5873 27.7092 57.4029 27.7522 57.198 27.7891C56.9931 27.826 56.7902 27.8588 56.5894 27.8875C56.3886 27.9162 56.2145 27.9408 56.0669 27.9613C55.735 28.0063 55.4379 28.0801 55.1756 28.1826C54.9133 28.285 54.7063 28.4284 54.5547 28.6129C54.4031 28.7932 54.3273 29.0268 54.3273 29.3137C54.3273 29.7235 54.4768 30.0329 54.776 30.2419C55.0752 30.4509 55.4563 30.5554 55.9194 30.5554ZM63.6096 35.5408C63.3063 35.5408 63.0256 35.5162 62.7674 35.4671C62.5133 35.422 62.3105 35.3687 62.1588 35.3072L62.6752 33.5737C62.999 33.668 63.2879 33.713 63.542 33.7089C63.7961 33.7048 64.0194 33.6249 64.212 33.4692C64.4087 33.3176 64.5747 33.0635 64.71 32.7069L64.9005 32.1967L61.4765 22.5578H63.837L66.0132 29.6886H66.1115L68.2938 22.5578H70.6605L66.8799 33.1434C66.7037 33.6434 66.4701 34.0716 66.1792 34.4282C65.8882 34.7888 65.5316 35.0634 65.1095 35.2519C64.6915 35.4445 64.1915 35.5408 63.6096 35.5408ZM72.2004 32V22.5578H74.3273V24.1623H74.438C74.6347 23.6213 74.9605 23.1992 75.4154 22.8959C75.8703 22.5886 76.4133 22.4349 77.0444 22.4349C77.6837 22.4349 78.2226 22.5906 78.6611 22.9021C79.1038 23.2094 79.4152 23.6295 79.5955 24.1623H79.6939C79.9029 23.6377 80.2553 23.2197 80.7512 22.9082C81.2512 22.5927 81.8434 22.4349 82.5278 22.4349C83.3966 22.4349 84.1056 22.7095 84.6547 23.2586C85.2039 23.8078 85.4785 24.609 85.4785 25.6622V32H83.247V26.0064C83.247 25.4204 83.0913 24.9921 82.7798 24.7217C82.4683 24.4471 82.0872 24.3098 81.6364 24.3098C81.0996 24.3098 80.6795 24.4778 80.3762 24.8139C80.0771 25.1458 79.9275 25.5782 79.9275 26.1109V32H77.7452V25.9142C77.7452 25.4265 77.5977 25.0372 77.3026 24.7462C77.0116 24.4553 76.6305 24.3098 76.1592 24.3098C75.8396 24.3098 75.5486 24.3918 75.2863 24.5557C75.024 24.7155 74.815 24.943 74.6593 25.238C74.5036 25.529 74.4257 25.8691 74.4257 26.2585V32H72.2004ZM91.9162 32.1844C90.9695 32.1844 90.1519 31.9877 89.4634 31.5943C88.779 31.1968 88.2524 30.6353 87.8836 29.9099C87.5147 29.1805 87.3303 28.3219 87.3303 27.3342C87.3303 26.363 87.5147 25.5106 87.8836 24.777C88.2565 24.0393 88.777 23.4656 89.445 23.0557C90.113 22.6418 90.8978 22.4349 91.7994 22.4349C92.3813 22.4349 92.9305 22.5291 93.4468 22.7176C93.9673 22.9021 94.4263 23.1889 94.8238 23.5783C95.2254 23.9676 95.541 24.4635 95.7705 25.0659C96 25.6642 96.1147 26.3773 96.1147 27.2051V27.8875H88.3753V26.3876H93.9816C93.9775 25.9613 93.8853 25.5823 93.705 25.2503C93.5247 24.9143 93.2727 24.6499 92.9489 24.4573C92.6292 24.2647 92.2563 24.1684 91.8301 24.1684C91.3752 24.1684 90.9756 24.2791 90.6314 24.5004C90.2871 24.7176 90.0187 25.0044 89.8261 25.361C89.6376 25.7134 89.5413 26.1007 89.5372 26.5228V27.8322C89.5372 28.3813 89.6376 28.8526 89.8384 29.246C90.0392 29.6354 90.3199 29.9345 90.6806 30.1435C91.0412 30.3484 91.4633 30.4509 91.9469 30.4509C92.2707 30.4509 92.5637 30.4058 92.826 30.3157C93.0882 30.2214 93.3157 30.0841 93.5083 29.9038C93.7009 29.7235 93.8464 29.5001 93.9448 29.2337L96.0225 29.4673C95.8914 30.0165 95.6414 30.496 95.2726 30.9058C94.9078 31.3115 94.4406 31.6271 93.871 31.8525C93.3013 32.0738 92.6497 32.1844 91.9162 32.1844ZM100.223 26.4675V32H97.9973V22.5578H100.124V24.1623H100.235C100.452 23.6336 100.798 23.2135 101.274 22.9021C101.753 22.5906 102.345 22.4349 103.05 22.4349C103.702 22.4349 104.27 22.5742 104.753 22.8529C105.241 23.1316 105.618 23.5352 105.884 24.0639C106.155 24.5926 106.288 25.2339 106.284 25.988V32H104.059V26.3322C104.059 25.7011 103.895 25.2073 103.567 24.8507C103.243 24.4942 102.794 24.3159 102.22 24.3159C101.831 24.3159 101.485 24.402 101.182 24.5741C100.882 24.7421 100.647 24.986 100.475 25.3056C100.307 25.6253 100.223 26.0126 100.223 26.4675ZM113.261 22.5578V24.2791H107.833V22.5578H113.261ZM109.173 20.2956H111.398V29.16C111.398 29.4591 111.443 29.6886 111.534 29.8485C111.628 30.0042 111.751 30.1107 111.902 30.1681C112.054 30.2255 112.222 30.2542 112.406 30.2542C112.546 30.2542 112.673 30.2439 112.788 30.2234C112.906 30.203 112.997 30.1845 113.058 30.1681L113.433 31.9078C113.314 31.9488 113.144 31.9939 112.923 32.043C112.706 32.0922 112.439 32.1209 112.124 32.1291C111.566 32.1455 111.064 32.0615 110.618 31.8771C110.171 31.6885 109.816 31.3976 109.554 31.0041C109.296 30.6107 109.169 30.1189 109.173 29.5288V20.2956ZM122.45 25.0536L120.421 25.2749C120.364 25.07 120.263 24.8774 120.12 24.6971C119.98 24.5167 119.792 24.3713 119.554 24.2606C119.317 24.15 119.026 24.0946 118.681 24.0946C118.218 24.0946 117.829 24.195 117.513 24.3958C117.202 24.5967 117.048 24.8569 117.052 25.1766C117.048 25.4511 117.149 25.6745 117.353 25.8466C117.562 26.0187 117.907 26.1601 118.386 26.2708L119.997 26.615C120.89 26.8076 121.554 27.1129 121.989 27.5309C122.427 27.949 122.648 28.4961 122.652 29.1723C122.648 29.7665 122.474 30.2911 122.13 30.746C121.79 31.1968 121.316 31.5492 120.71 31.8033C120.103 32.0574 119.407 32.1844 118.62 32.1844C117.464 32.1844 116.534 31.9426 115.829 31.459C115.124 30.9714 114.704 30.2931 114.569 29.4243L116.739 29.2153C116.837 29.6415 117.046 29.9632 117.366 30.1804C117.685 30.3976 118.101 30.5062 118.614 30.5062C119.142 30.5062 119.566 30.3976 119.886 30.1804C120.21 29.9632 120.372 29.6948 120.372 29.3751C120.372 29.1046 120.267 28.8813 120.058 28.7051C119.853 28.5289 119.534 28.3936 119.099 28.2994L117.489 27.9613C116.583 27.7727 115.913 27.4551 115.479 27.0084C115.044 26.5576 114.829 25.988 114.833 25.2995C114.829 24.7176 114.987 24.2135 115.306 23.7873C115.63 23.357 116.079 23.025 116.653 22.7914C117.231 22.5537 117.896 22.4349 118.651 22.4349C119.757 22.4349 120.628 22.6705 121.263 23.1418C121.902 23.6131 122.298 24.2504 122.45 25.0536Z"
                  fill="white"
                  fillOpacity="0.6"></path>
              </svg>
            </div>
            <div>
              <svg
                fill="none"
                height="38"
                viewBox="0 0 160 32"
                xmlns="http://www.w3.org/2000/svg">
                <clipPath id="a">
                  <path d="m0 .533203h160v30.9333h-160z" />
                </clipPath>
                <g clipPath="url(#a)">
                  <path
                    d="m20.8257 31.4028 20.3751-20.3764v13.0238l-7.3513 7.3526zm-.1224-30.552214-20.375175 20.375114v-13.02381l7.351305-7.351304z"
                    fill="#59cfa8"
                  />
                  <path
                    d="m41.2009 11.0267-.0103-10.176114h-10.1773l-10.1774 10.176114zm-40.872775 10.1989.011498 10.1773h10.176077l10.1773-10.1773z"
                    fill="#00bbbe"
                  />
                  <path
                    d="m31.0127 21.2139v-10.1875h10.1876zm-20.497-10.1758v10.1876h-10.187575zm91.1883 1.4592c.076-.7359.338-3.11729.338-3.11729-1.201-.47655-2.4923-.71546-3.7584-.71546-1.3964 0-2.7609.28874-3.9337.86749-2.361 1.16386-3.769 3.63346-3.7664 6.60776-.0026 2.9755 1.4041 5.4451 3.7664 6.609 2.2345 1.1 5.1666 1.1549 7.6911.152 0 0-.262-2.3814-.339-3.1173-1.608.4331-3.0671.7103-4.5095.1431-1.4628-.5749-2.2741-1.919-2.2856-3.7855.0115-1.8692.8228-3.2132 2.2856-3.7881 1.4424-.566 2.9015-.2888 4.5095.1431zm19.027-6.64348v17.31278h4.393v-18.52012zm-3.307 3.23232h-3.717l-4.967 6.10056v-10.54022l-4.392 1.20861v17.31151h4.392v-3.4163l1.722-2.1145 3.778 5.5308h4.702l-5.925-8.6698zm37.551 14.08046h4.701l-5.923-8.6698 4.406-5.41066h-3.717l-4.968 6.09926v-10.53892l-4.392 1.20861v17.31151h4.392v-3.4163l1.723-2.1145zm-19.785-14.54648c-3.063 0-4.885 1.17922-5.874 2.16938-1.18 1.183-1.856 2.7851-1.855 4.3962v1.8934c-.001 1.6123.675 3.2144 1.855 4.3962.989.9902 2.811 2.1694 5.874 2.1694 3.062 0 4.883-1.1792 5.87-2.1694 1.181-1.183 1.858-2.7839 1.855-4.3962v-1.8934c.002-1.6123-.674-3.2144-1.855-4.3962-.987-.99016-2.809-2.16938-5.87-2.16938zm2.173 11.13168c-.542.543-1.273.8177-2.173.8177-.901 0-1.633-.276-2.175-.8189-.74-.7411-1.111-1.9586-1.108-3.6195-.003-1.6596.37-2.8771 1.108-3.6181.542-.543 1.274-.819 2.175-.819.9 0 1.631.276 2.173.8177.74.741 1.111 1.9585 1.107 3.6194.004 1.6596-.369 2.8784-1.107 3.6182zm-64.433-10.66694h-4.0181v-4.43838l-4.3924 1.20861v12.27391c0 2.6766 1.2661 4.6223 3.3857 5.2049 1.5063.414 3.1697.3769 5.0248-.0971v-3.0624c-.5788.1201-1.1882.1776-1.8947.1623-1.0706-.0281-2.0825-1.0962-2.0825-2.2001l-.0422-6.2129h4.0194zm-11.3197 7.21084c-1.5651-1.6775-4.5304-1.5178-6.5848-2.2128-.649-.2197-1.4654-.7793-1.0284-1.5625.3206-.5749 1.0795-.7027 1.68-.7461 2.1349-.1559 4.1816.3539 6.0073.8394l.3168-2.88993c-3.3562-1.07319-8.8652-2.09399-11.5546.95433-1.321 1.4974-1.3504 3.9235-.0639 5.2982 1.5664 1.6737 4.5304 1.5153 6.5822 2.2103.5583.1891 1.2227.5583 1.1409 1.2444-.0971.824-1.1166 1.0144-1.7924 1.0642-2.1336.1584-4.1804-.3526-6.0073-.8394l-.3169 2.8899c3.3576 1.0745 8.864 2.0953 11.5546-.9543 1.3198-1.4961 1.3517-3.9184.0678-5.2944zm26.76-3.0585c0-.934-.3654-1.887-1.003-2.6166-1.1319-1.29544-3.0598-1.95979-5.7287-1.9764-1.7031-.00894-3.7983.35773-5.8259 1.01314l.3169 2.91936c1.5957-.4293 3.3601-.8765 5.2049-.8765.7921 0 1.9662.0435 2.4849.7576.5469.7525-.396 1.3862-1.0323 1.6034-1.5229.5213-3.1339.764-4.6938 1.1524-1.8628.4638-3.2886 2.4249-3.2503 4.4652.0218 1.1575.5379 2.255 1.3798 2.9372 2.1324 1.7261 5.8412 1.123 7.9608-1.0067l.2849 1.5561h3.9337l-.0319-9.9295zm-4.1931 6.1861c-1.1192 1.0157-2.5782 1.4756-4.0628 1.1332-.7934-.1827-1.2865-.9786-1.146-1.8525.1942-1.2188 1.5063-1.5587 2.1362-1.7222l3.079-.7742z"
                    fill="#002a3e"
                  />
                </g>
              </svg>
            </div>
            <div>
              <img src={tencent} alt={'Tencent'} />
            </div>
            <div>
              <img
                src={minder}
                alt={'Minder'}
                width="200"
                className={'h-auto w-auto max-w-full'}
              />
            </div>
            <div>
              <img
                src={
                  'https://cdn.prod.website-files.com/6442e2f4040ecfa14be6f956/6442e2f4040ecf6f02e6f9f5_HWCS-black.svg'
                }
                height="38"
                alt={'Hello world CS'}
                className={'h-auto max-w-full'}
              />
            </div>
            <div>
              <img
                src={
                  'https://cdn.prod.website-files.com/651ee12be761a2b4e1f200a4/651f4411c38fa448e826429a_LOGO_MECENA-08.png'
                }
                alt={'Mecena'}
                className={'h-auto max-w-full'}
              />
            </div>
            <div>
              <img
                src={
                  'https://www.landsend.com/pps/static/assets/global-header/LE_COMFY_LOGO_DesktopNavy.svg'
                }
                alt={"Lands'end"}
                className={'h-auto max-w-full'}
              />
            </div>
          </div>
        </div>
        <div className={styles.contactUs}>
          Want to be listed here?{' '}
          <Link to={'mailto:contact@gofeatureflag.org'}>Contact us</Link> or add
          yourself to our{' '}
          <Link
            to={
              'https://github.com/thomaspoignant/go-feature-flag/blob/main/ADOPTERS.md'
            }>
            adopters
          </Link>{' '}
          list.
        </div>
      </div>
    </section>
  );
}
