export const sdk = [
  {
    name: 'GO',
    paradigm: ['Server'],
    faLogo: 'devicon-go-original-wordmark colored',
    badgeUrl:
      'https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fproxy.golang.org%2Fgithub.com%2Fopen-feature%2Fgo-sdk-contrib%2Fproviders%2Fgo-feature-flag%2F%40latest&query=%24.Version&label=GO&color=blue&style=flat-square&log=go',
    docLink: 'server_providers/openfeature_go',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'Java',
    paradigm: ['Server'],
    faLogo: 'devicon-java-plain colored',
    badgeUrl:
      'https://img.shields.io/maven-central/v/dev.openfeature.contrib.providers/go-feature-flag?color=blue&style=flat-square&logo=java',
    docLink: 'server_providers/openfeature_java',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'Kotlin',
    paradigm: ['Server'],
    faLogo: 'devicon-kotlin-plain colored',
    badgeUrl:
      'https://img.shields.io/maven-central/v/dev.openfeature.contrib.providers/go-feature-flag?color=blue&style=flat-square&logo=java',
    docLink: 'server_providers/openfeature_java',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: '.NET',
    paradigm: ['Server'],
    faLogo: 'devicon-dot-net-plain-wordmark colored',
    badgeUrl:
      'https://img.shields.io/nuget/v/OpenFeature.Contrib.GOFeatureFlag?color=blue&style=flat-square&logo=nuget',
    docLink: 'server_providers/openfeature_dotnet',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'not implemented',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'not implemented',
      },
    ],
  },
  {
    name: 'Python',
    paradigm: ['Server'],
    faLogo: 'devicon-python-plain colored',
    badgeUrl:
      'https://img.shields.io/pypi/v/gofeatureflag-python-provider?color=blue&style=flat-square&logo=pypi',
    docLink: 'server_providers/openfeature_python',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'Javascript',
    paradigm: ['Client'],
    faLogo: 'devicon-javascript-plain colored',
    badgeUrl:
      'https://img.shields.io/npm/v/%40openfeature%2Fgo-feature-flag-web-provider?color=blue&style=flat-square&logo=npm',
    docLink: 'client_providers/openfeature_javascript',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'Typescript',
    paradigm: ['Client'],
    faLogo: 'devicon-typescript-plain colored',
    badgeUrl:
      'https://img.shields.io/npm/v/%40openfeature%2Fgo-feature-flag-web-provider?color=blue&style=flat-square&logo=npm',
    docLink: 'client_providers/openfeature_javascript',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'React',
    paradigm: ['Client'],
    faLogo: 'devicon-react-original colored',
    badgeUrl:
      'https://img.shields.io/npm/v/%40openfeature%2Fgo-feature-flag-web-provider?color=blue&style=flat-square&logo=npm',
    docLink: 'client_providers/openfeature_react',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'Swift',
    paradigm: ['Client'],
    faLogo: 'devicon-swift-plain colored',
    docLink: 'client_providers/openfeature_swift',
    badgeUrl:
      'https://img.shields.io/github/v/release/go-feature-flag/openfeature-swift-provider?label=Swift&amp;display_name=tag&style=flat-square&logo=Swift',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'Kotlin / Android',
    paradigm: ['Client'],
    faLogo: 'devicon-android-plain colored',
    docLink: 'client_providers/openfeature_android',
    badgeUrl:
      'https://img.shields.io/maven-central/v/org.gofeatureflag.openfeature/gofeatureflag-kotlin-provider?color=blue&style=flat-square&logo=android',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'Node.JS',
    paradigm: ['Server'],
    faLogo: 'devicon-nodejs-plain colored',
    docLink: 'server_providers/openfeature_javascript',
    badgeUrl:
      'https://img.shields.io/npm/v/%40openfeature%2Fgo-feature-flag-provider?color=blue&style=flat-square&logo=npm',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'done',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'done',
      },
    ],
  },
  {
    name: 'PHP',
    paradigm: ['Server'],
    faLogo: 'devicon-php-plain colored',
    badgeUrl:
      'https://img.shields.io/packagist/v/open-feature/go-feature-flag-provider?logo=php&color=blue&style=flat-square',
    docLink: 'server_providers/openfeature_php',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'not implemented',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'not implemented',
      },
    ],
  },
  {
    name: 'Ruby',
    paradigm: ['Server'],
    faLogo: 'devicon-ruby-plain colored',
    badgeUrl:
      'https://img.shields.io/gem/v/openfeature-go-feature-flag-provider?color=blue&style=flat-square&logo=ruby',
    docLink: 'server_providers/openfeature_ruby',
    featureList: [
      {
        name: 'Remote Evaluation',
        status: 'done',
      },
      {
        name: 'Local Cache',
        status: 'not implemented',
      },
      {
        name: 'Dynamic Cache Refresh',
        status: 'not implemented',
      },
    ],
  },
];
