# GO Feature Flag Examples

## Overview
GO Feature Flag offers a multitude of usage pathways, adaptable to your intended purposes.

On this page, we will highlight the various utilization methods, aiming to assist you in getting started. Our objective is to enhance your feature flagging experience and make it more seamless for you.

## Complete demo
- [**demo**](./demo) - A GO application serving a webpage using GO Feature Flag module and demonstrating how you can manage multiple users in the same application.

## Use GO Feature Flag with OpenFeature
- [**Use GO Feature Flag in your browser**](./openfeature_web) - Use GO Feature Flag with OpenFeature in your browser.
- [**Use GO Feature Flag with react**](./openfeature_react) - Use GO Feature Flag with OpenFeature in your React application.
- [**Use GO Feature Flag with Node.js**](./openfeature_nodejs) - A simple application using GO Feature Flag with OpenFeature in Node.js.
- [**Use GO Feature Flag with Kotlin in the Server**](./openfeature_kotlin_server) - A simple application using GO Feature Flag with OpenFeature in Kotlin.
- [**Use GO Feature Flag in your iOS app**](./openfeature_kotlin_server) - A simple iOS app using GO Feature Flag with OpenFeature in Swift.

## Use GO Feature Flag server
- [**Deploy GO Feature Flag as an AWS Lambda**](./rollout_experimentation) - An example configuration on how to run GO Feature Flag as a serverless application using AWS Lambda.

## Code snippet using the GO Module
- [**Retrieve config from Kubernetes**](./retriever_configmap) - A small set up with a test application that explain how to retrieve your configuration from a **configMap** in Kubernetes.
- [**Retrieve config from a file**](./retriever_file) - A code snippet to see how to retrieve your configuration from a local file.
- [**Retrieve config from GitHub**](./retriever_file) - A code snippet to see how to retrieve your configuration from GitHub.
- [**Retrieve config from AWS S3**](./retriever_file) - A code snippet to see how to retrieve your configuration from AWS S3.
- [**Retrieve config from an HTTP endpoint**](./retriever_file) - A code snippet to see how to retrieve your configuration from any HTTP endpoint.
- [**Retrieve config from MongoDB**](./retriever_mongodb) - A small set up with a test application that explain how to retrieve your configuration from a **MongoDB** database.
- [**Use multiple configuration file**](./retriever_file) - A code snippet to see how to use multiple configuration file.
- [**Export data to a file**](./data_export_file) - A code snippet to see how to export the usage of your flags in a file.
- [**Export data to AWS S3**](./data_export_s3) - A code snippet to see how to export the usage of your flags in AWS S3.
- [**Export data to Google Cloud Storage**](./data_export_googlecloudstorage) - A code snippet to see how to export the usage of your flags in Google Cloud Storage.
- [**Rollout an experimentation**](./rollout_experimentation) - A code snippet to see how to configure an experimentation.
- [**Progressive Rollout**](./rollout_progressive) - A code snippet to see how to configure a flag that will progressively apply to more users.
- [**Scheduled Rollout**](./rollout_scheduled) - A code snippet to see how to configure a flag that change over time.
