---
# generated by https://github.com/hashicorp/terraform-plugin-docs
page_title: "pinecone Provider"
subcategory: ""
description: |-
  A Terraform provider for managing your pinecone.io https://www.pinecone.io/ infrastructure as code.
  Example Usage
  ```hcl
  provider "pinecone" {}
  data "pinecone_collection" "existing-collection" {
    name = "testindex"
  }
  resource "pinecone_index" "my-first-index" {
    name   = "testidx"
    metric = "cosine"
    pods   = 1
  sourcecollection = data.pineconecollection.existing-collection.name
    dimension = data.pinecone_collection.existing-collection.dimension
  }
  ```
---

# pinecone Provider

A Terraform provider for managing your [pinecone.io](https://www.pinecone.io/) infrastructure as code.
		
## Example Usage
```hcl
provider "pinecone" {}

data "pinecone_collection" "existing-collection" {
  name = "testindex"
}

resource "pinecone_index" "my-first-index" {
  name   = "testidx"
  metric = "cosine"
  pods   = 1

  source_collection = data.pinecone_collection.existing-collection.name
  dimension = data.pinecone_collection.existing-collection.dimension
}
```



<!-- schema generated by tfplugindocs -->
## Schema

### Optional

- `apikey` (String, Sensitive) Will use the `PINECONE_API_KEY` environment variable if not set.
- `environment` (String) Will use the `PINECONE_ENVIRONMENT` environment variable if not set.
