# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

## [3.1.0](https://github.com/theodorusclarence/theodorusclarence.com/compare/v3.0.0...v3.1.0) (2023-01-01)


### Features

* add cache header to spotify and newsletter ([292dc43](https://github.com/theodorusclarence/theodorusclarence.com/commit/292dc436fd6188e32aa630760d2bced1f5ba24e5))
* add zod validation for api param ([2f26272](https://github.com/theodorusclarence/theodorusclarence.com/commit/2f26272f82fdbc8dac51f8e2f0aac194583adf8c))
* always use light mode for TweetCard ([4cde5f4](https://github.com/theodorusclarence/theodorusclarence.com/commit/4cde5f438adf6e7ff661bc557b6c1c55a1acbf45))
* **blog:** add 2022-retrospective ([ada9dd5](https://github.com/theodorusclarence/theodorusclarence.com/commit/ada9dd5ac6d8d14687e92f18c64ac4077632b7fa))
* **blog:** add react-core-concept-useeffect ([fd3221f](https://github.com/theodorusclarence/theodorusclarence.com/commit/fd3221fc35c64dd7564d6968d901739d2844b79d))
* change about picture ([040a039](https://github.com/theodorusclarence/theodorusclarence.com/commit/040a039863f0da27bde6d3eda153d90e5d5e3b02))
* move public id to env ([15af1af](https://github.com/theodorusclarence/theodorusclarence.com/commit/15af1af836a9d85d459b910722b26b2026c0b4b7))
* **proj:** add hexcape ([00997a1](https://github.com/theodorusclarence/theodorusclarence.com/commit/00997a10c436815c1c9b77a54c7b0c3402c75c2b))
* **proj:** add media coverage to hexcape ([2d5b022](https://github.com/theodorusclarence/theodorusclarence.com/commit/2d5b022a973e2517f588c6d9de31ce26aa32a8fa))
* update trf bca and add mandiri ([f56ae81](https://github.com/theodorusclarence/theodorusclarence.com/commit/f56ae81af92f8c4fb964799504f772a8a85b17bd))

## [3.0.0](https://github.com/theodorusclarence/theodorusclarence.com/compare/v2.0.0...v3.0.0) (2022-09-02)


### ⚠ BREAKING CHANGES

* add prisma as counter

### Features

* add prisma as counter ([3ba27d8](https://github.com/theodorusclarence/theodorusclarence.com/commit/3ba27d8a4702fac5fa65790e67d1814d244912d9))
* change image shadow from sm to default ([a1b4b53](https://github.com/theodorusclarence/theodorusclarence.com/commit/a1b4b533b32c69c1e5fdddd5315fcf113a3aaeda))
* remove fauna ([46be220](https://github.com/theodorusclarence/theodorusclarence.com/commit/46be2200de52e7966570b96c48a83fe8fca196e3))


### Bug Fixes

* mdx class isn't using className syntax ([ead648d](https://github.com/theodorusclarence/theodorusclarence.com/commit/ead648daa68cc260b345bdfc5941b9252bf1335e))
* typo in conventional-commit english part ([490276f](https://github.com/theodorusclarence/theodorusclarence.com/commit/490276fcdc183ccdc38c51290a5eaef6bc12b578))

## [2.0.0](https://github.com/theodorusclarence/theodorusclarence.com/compare/v1.1.1...v2.0.0) (2022-07-23)


### ⚠ BREAKING CHANGES

* use revue for newsletter

### Features

* add AMA link on guestbook ([d400e63](https://github.com/theodorusclarence/theodorusclarence.com/commit/d400e63acf9e3fc42c56d4217f1838f03c31287e))
* add copywrite and status for dev ([713105e](https://github.com/theodorusclarence/theodorusclarence.com/commit/713105ecc2e27359c1af3b2876be2a2f73661c88))
* add date to Seo for blog and projects ([7f3e9d5](https://github.com/theodorusclarence/theodorusclarence.com/commit/7f3e9d5210e986646fda145122440390b77e837b))
* add design page ([a36aec5](https://github.com/theodorusclarence/theodorusclarence.com/commit/a36aec5cf196cd639cf3ccc556fd18fbef78dfc1))
* add devtoViews tooltip ([26c721b](https://github.com/theodorusclarence/theodorusclarence.com/commit/26c721bd8f7581fec4ac7a116a5010e7934491f7))
* add feedback widget ([605128b](https://github.com/theodorusclarence/theodorusclarence.com/commit/605128b9fd9bb635ce1df477d4cb5c166c9b6406))
* add filter to statistics ([1033941](https://github.com/theodorusclarence/theodorusclarence.com/commit/103394154624d127b8070e912c039edac940e597))
* add footer total to statistics ([1137e5e](https://github.com/theodorusclarence/theodorusclarence.com/commit/1137e5e78944e21dfb5021e1e9b1e8c4f87c105b))
* add github card ([48a7961](https://github.com/theodorusclarence/theodorusclarence.com/commit/48a7961f6ae2c6cb684fd2d4a095a25b8e95ae2d))
* add localeString to view count ([dde26fa](https://github.com/theodorusclarence/theodorusclarence.com/commit/dde26fa9a3cbee707357d5c463b478b6d523fa2d))
* add motion safe animation ([0c32b09](https://github.com/theodorusclarence/theodorusclarence.com/commit/0c32b09a58c746e6b4e9e4d1aff5a9296849c1fa))
* add nprogress ([ae46104](https://github.com/theodorusclarence/theodorusclarence.com/commit/ae4610460abaa9aba65c195393985e6d0bf8b256))
* add right align to the statistics table ([47e6322](https://github.com/theodorusclarence/theodorusclarence.com/commit/47e6322f41acda702631da0b50ae969958345e36))
* add rss ([d9bab3c](https://github.com/theodorusclarence/theodorusclarence.com/commit/d9bab3cedbb75c34599acc6f3d4892ddaf02902b))
* add script to generate markdown ([d626e91](https://github.com/theodorusclarence/theodorusclarence.com/commit/d626e91cc6d2fa7aa20a59acc8d78b6148671173))
* add share tweet button to blog ([10ff4cf](https://github.com/theodorusclarence/theodorusclarence.com/commit/10ff4cf7510c80f7c12f384c4173d0f4793f388b))
* add skip nav ([578f3dd](https://github.com/theodorusclarence/theodorusclarence.com/commit/578f3ddf51f9f990f237f117684daa264e1cce0a))
* add skip tags ([7373bfe](https://github.com/theodorusclarence/theodorusclarence.com/commit/7373bfe916ad2b0f691df25f9a40d7962ae84541))
* add social link on hero ([9fd11e2](https://github.com/theodorusclarence/theodorusclarence.com/commit/9fd11e24ab05d7f9dcd45d4a78f811a9fc39d5dd))
* add source code to footer ([d642167](https://github.com/theodorusclarence/theodorusclarence.com/commit/d642167a812b7a88fc415061f45e86656d6a4bf1))
* add stat card count ([2cc5a66](https://github.com/theodorusclarence/theodorusclarence.com/commit/2cc5a6696aa68dcb8f4b5f8856fc03f72bdc8c74))
* add statistic cards ([f80cbf1](https://github.com/theodorusclarence/theodorusclarence.com/commit/f80cbf1a1265af225a1fbc2243f8abcc89498df2))
* add statistics ([6667826](https://github.com/theodorusclarence/theodorusclarence.com/commit/66678265558c4befe58da7e7acfafd3b3399710c))
* add subscribe to footer and remove polywork ([867d943](https://github.com/theodorusclarence/theodorusclarence.com/commit/867d943dbf1384339df32cc8e78195981473dd34))
* add tooltip to footer links ([221c178](https://github.com/theodorusclarence/theodorusclarence.com/commit/221c178ca36e0b53587b3d9fb1182e7c99b783da))
* add TwitterCard embed ([f8b01bc](https://github.com/theodorusclarence/theodorusclarence.com/commit/f8b01bc4ba142518b9bc16519c600b9cc32aec43))
* block increment views except on main domain ([76982eb](https://github.com/theodorusclarence/theodorusclarence.com/commit/76982eb3684056fc2fa458f0339c4d531d2ac961))
* **blog:** add 2021-retrospective ([68bac6d](https://github.com/theodorusclarence/theodorusclarence.com/commit/68bac6dfb978e869b165337feb8c8fa89182ec80))
* **blog:** add a disclaimer to tw-best-practice ([854ef38](https://github.com/theodorusclarence/theodorusclarence.com/commit/854ef38fcc2ee0180c71e173c9aa6f51164e8fbf))
* **blog:** add nextjs-storybook-tailwind ([d7ae7dc](https://github.com/theodorusclarence/theodorusclarence.com/commit/d7ae7dc246f9934634e0b066598fad5e7726dce1))
* **blog:** add one-stop-starter ([338ea26](https://github.com/theodorusclarence/theodorusclarence.com/commit/338ea26e5030e7ebf01804f302f9df5d06882d10))
* **blog:** add see changes button ([bdf1c5b](https://github.com/theodorusclarence/theodorusclarence.com/commit/bdf1c5b5b14ccbad818e1919385a0164453e4fe8))
* **blog:** add swift-value-reference ([9454631](https://github.com/theodorusclarence/theodorusclarence.com/commit/9454631cabf2b1d5fd8b7bb1f8a5318a9709518f))
* **blog:** move proof order in reference value ([e193fab](https://github.com/theodorusclarence/theodorusclarence.com/commit/e193fabf4be3f87f5f9d92c62d2358a122d1d5fb))
* **blog:** update swift-value-reference ([3f87ffb](https://github.com/theodorusclarence/theodorusclarence.com/commit/3f87ffb23b9a31e8f3e86af98a2343676bb7a596))
* **proj:** add notiolink ([d1e2063](https://github.com/theodorusclarence/theodorusclarence.com/commit/d1e20639f917d36287becc2e892a3c8b57233772))
* remove hotjar ([0255faa](https://github.com/theodorusclarence/theodorusclarence.com/commit/0255faa01966a405f43930a6527cb98f9d1c60da))
* remove portfolio from site title ([83ed445](https://github.com/theodorusclarence/theodorusclarence.com/commit/83ed445d74af30a8c23a35cf7e8e2582c61b88ad))
* remove seasforus link and change demo to hash ([293f9dc](https://github.com/theodorusclarence/theodorusclarence.com/commit/293f9dcf6b4b2c7e61ca64629227182410b14b6a))
* turn on double opt in ([65edae9](https://github.com/theodorusclarence/theodorusclarence.com/commit/65edae9b9c7707e3eb7e4f4772cb30bb13385fa2))
* use revue for newsletter ([4157510](https://github.com/theodorusclarence/theodorusclarence.com/commit/41575104b57440384b4216c4f460968b69499dbb))


### Bug Fixes

* **blog:** typo on nextjs-storybook-tailwing ([3d14180](https://github.com/theodorusclarence/theodorusclarence.com/commit/3d14180be2114640547a9ec83d0894ad6cb36f7b))
* broken link on rhf post ([2596298](https://github.com/theodorusclarence/theodorusclarence.com/commit/25962980fd3a06082f5a7b0ce87286b9c28c5fb2))
* bullet list on side-projects ([8c78bbc](https://github.com/theodorusclarence/theodorusclarence.com/commit/8c78bbcc0b8367d270a7a3f3130dce078e9b98c3))
* false image and link not working ([e3fac94](https://github.com/theodorusclarence/theodorusclarence.com/commit/e3fac9475c41ebb4d19dd6247e8d86ed199c3f1b))
* giscus not rerendering when changing route ([44c0f32](https://github.com/theodorusclarence/theodorusclarence.com/commit/44c0f32e41d4b43fe20cafe86995ffe092766ab9))
* **lib:** sticky-nav demo won't load ([c3ec889](https://github.com/theodorusclarence/theodorusclarence.com/commit/c3ec8897e7be6d7c35300fdb92c87ebcda038bcc))
* mdx h4 don't have scroll margin ([605d920](https://github.com/theodorusclarence/theodorusclarence.com/commit/605d920eadad969bd992bd39b187bee7a1ee1349))
* preview still increment meta on first visit ([b499a75](https://github.com/theodorusclarence/theodorusclarence.com/commit/b499a75a30fff05ce32c05f5844f4942e61ad948))
* projects can't be opened on ios ([f4da26b](https://github.com/theodorusclarence/theodorusclarence.com/commit/f4da26bfe7e7372e53b203df716ce649147c38f4))
* rss publish date wrong format ([c71cac9](https://github.com/theodorusclarence/theodorusclarence.com/commit/c71cac90498a3d25114b3fa30a7eff7a7d80a724))
* skip to content button is transparent ([bd74911](https://github.com/theodorusclarence/theodorusclarence.com/commit/bd749115f9ac35ba0ec55db9ab8181c93e4d143f))
* tech icons on project have discs ([e3e5512](https://github.com/theodorusclarence/theodorusclarence.com/commit/e3e55125ab346bebbc2b9fafee9f0d3fb5f01dcd))

### [1.1.1](https://github.com/theodorusclarence/theodorusclarence.com/compare/v1.1.0...v1.1.1) (2021-12-23)


### Features

* add custom blog og ([0831dec](https://github.com/theodorusclarence/theodorusclarence.com/commit/0831dec9103970ea1d2bcdff0a1f206b04c6313b))
* add whitespace to cards ([865b243](https://github.com/theodorusclarence/theodorusclarence.com/commit/865b2433cbbf5cc336aa4a6319e73c50741ddecc))
* **blog:** add complex use of clsx for tailwind ([70dff74](https://github.com/theodorusclarence/theodorusclarence.com/commit/70dff74ef7bf9d505657c644f6a52f372981df9b))
* **blog:** update tailwindcss-best-practice ([46b4d3d](https://github.com/theodorusclarence/theodorusclarence.com/commit/46b4d3d1318e36bfb377f13ed8918e1c21c2cfa8))
* change email to domain alias ([1dce872](https://github.com/theodorusclarence/theodorusclarence.com/commit/1dce872b990b483b81155b9bc141231844ac1d04))
* **proj:** add seasforus ([af19d8b](https://github.com/theodorusclarence/theodorusclarence.com/commit/af19d8b6e04d8ef726debd7ac7ac2cfe59d1f345))


### Bug Fixes

* mdx date broke safari ([4187191](https://github.com/theodorusclarence/theodorusclarence.com/commit/41871916e7cfd7a67f263b8283e733fd463f4a63))
* table of contents not updating ([854d813](https://github.com/theodorusclarence/theodorusclarence.com/commit/854d8133a4b9e1427cce67d1f92756df52e9872d))

## [1.1.0](https://github.com/theodorusclarence/theodorusclarence.com/compare/v1.0.1...v1.1.0) (2021-11-29)


### Features

* add description to guestbook Seo ([b548172](https://github.com/theodorusclarence/theodorusclarence.com/commit/b548172df293f216e4143f8373bdd64dde8b8fae))
* add gradient illustration ([b7ca2a9](https://github.com/theodorusclarence/theodorusclarence.com/commit/b7ca2a9cf361e88d0899d86b35062b9f10a41cb2))
* add gradient to sayHello ([fbac61e](https://github.com/theodorusclarence/theodorusclarence.com/commit/fbac61ea64e7a056012bdbb8d81bb2111f0a82bc))
* add guestbook ([946425a](https://github.com/theodorusclarence/theodorusclarence.com/commit/946425a9e64961cf1788a1e6b3e8e84d3669966a))
* add incrementMetaFlag ([886345e](https://github.com/theodorusclarence/theodorusclarence.com/commit/886345ebd533fe3aa152358c9e475b7a006286a5))
* add initial sayHello ([1390fa3](https://github.com/theodorusclarence/theodorusclarence.com/commit/1390fa33e1a1b3d66204aa2ce5087fd8a674c5bc))
* add Quiz component ([72b42d2](https://github.com/theodorusclarence/theodorusclarence.com/commit/72b42d27ed356d0d357dc2a6d0b1c8c8a042bec8))
* add ReloadDevtool ([e326768](https://github.com/theodorusclarence/theodorusclarence.com/commit/e326768627503da2ee7c04ed7e47730b94b350c8))
* add sayHelloFlag ([ae97fbd](https://github.com/theodorusclarence/theodorusclarence.com/commit/ae97fbdd7085a9e9515008d8a4adc8d6fb26eacf))
* **blog:** add react-core-concept-I ([27651e9](https://github.com/theodorusclarence/theodorusclarence.com/commit/27651e99d3362923033879a5efe052d5325d6020))
* **blog:** add react-loading-state-pattern ([3caacc9](https://github.com/theodorusclarence/theodorusclarence.com/commit/3caacc98961429af0eda1e83c6a9a5884f5f3d4b))
* **lib:** add component and hooks to toast ([b7101c5](https://github.com/theodorusclarence/theodorusclarence.com/commit/b7101c51b11eae1c25275a7b5b4986395865d8d3))
* make highlight full block ([5f12164](https://github.com/theodorusclarence/theodorusclarence.com/commit/5f121642b4022f9e3a1928083f3774d0fe559c73))
* revamp landing and about page ([2990d17](https://github.com/theodorusclarence/theodorusclarence.com/commit/2990d179539151311863bbc771046669d818b788))
* track recommendation click rate ([dec2e06](https://github.com/theodorusclarence/theodorusclarence.com/commit/dec2e06fcd2d5447236d9d1a8640665d3869ccbe))
* use separate variable for intro post ([e73c95d](https://github.com/theodorusclarence/theodorusclarence.com/commit/e73c95d53cf5f1f492c382592dc600d33eb9ef67))

### [1.0.1](https://github.com/theodorusclarence/theodorusclarence.com/compare/v1.0.0...v1.0.1) (2021-11-12)


### Features

* add Seo description to pages ([43e8416](https://github.com/theodorusclarence/theodorusclarence.com/commit/43e841632229e003019f35dda37e5e4d547d8eda))
* **blog:** add editorial on nextjs-fetch-usecase ([77b3e3e](https://github.com/theodorusclarence/theodorusclarence.com/commit/77b3e3e18d799dfb7b055147f84c37d8e68fe614))
* **blog:** update spotify-now-playing ([f21d807](https://github.com/theodorusclarence/theodorusclarence.com/commit/f21d807fc1f2c779bbb2084f403fe3843f9ea5f3))
* order blogs by lastUpdated ([f897452](https://github.com/theodorusclarence/theodorusclarence.com/commit/f897452790564d6730f8988302973d2f4f38e8e9))
* remove header trackEvent ([987477b](https://github.com/theodorusclarence/theodorusclarence.com/commit/987477b7341195099e626991863fe6ab51cf1fbd))
* remove url on Seo title ([8e6c5df](https://github.com/theodorusclarence/theodorusclarence.com/commit/8e6c5dfde264804cb31a3795177d98f65ca9f70f))
* reorder header ([a4e6b72](https://github.com/theodorusclarence/theodorusclarence.com/commit/a4e6b72c345e8535a8e0331c60bef88e5ce4685a))
* use gradient og ([180b818](https://github.com/theodorusclarence/theodorusclarence.com/commit/180b81830bb628b39276ef41e46089f873de68fd))


### Bug Fixes

* project links not showing on ios ([29b9450](https://github.com/theodorusclarence/theodorusclarence.com/commit/29b9450f598b557c107aafd4d8015a00f096755a))
* recommendations have no view count ([b44fa4f](https://github.com/theodorusclarence/theodorusclarence.com/commit/b44fa4fc19d7e58365e3a3a988bab1062e84b56a))
* scrollspy not highlighted when visiting link ([29c18a2](https://github.com/theodorusclarence/theodorusclarence.com/commit/29c18a26fa1392906aa3e15f5f864bd74e3230a2))

## [1.0.0](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.3.0...v1.0.0) (2021-11-09)


### ⚠ BREAKING CHANGES

* typescript initial commit

### Features

* add 20-javascript ([2a1cbb6](https://github.com/theodorusclarence/theodorusclarence.com/commit/2a1cbb69eac2808c20785a1bbc2bb1913af67a54))
* add all blogs ([02d2b09](https://github.com/theodorusclarence/theodorusclarence.com/commit/02d2b09ad2f1cb8f85f91254a55bd12d5bde1a32))
* add all library ([e60c15e](https://github.com/theodorusclarence/theodorusclarence.com/commit/e60c15ec1ad99c24505d8d4456c54110d6ba9f01))
* add all projects ([f8e9aef](https://github.com/theodorusclarence/theodorusclarence.com/commit/f8e9aef3c88304e51021b2b6ca7c6ca017444d94))
* add animation to all pages ([5729206](https://github.com/theodorusclarence/theodorusclarence.com/commit/57292068060b11cef3904307a814c0fe81fbb444))
* add blog recommendation ([f12f1e3](https://github.com/theodorusclarence/theodorusclarence.com/commit/f12f1e35dece38491e9ac1267ec0e82476f29ac4))
* add CloudinaryImage and about ([79a3b38](https://github.com/theodorusclarence/theodorusclarence.com/commit/79a3b3873d8a4bee932f84fe2c043e56082ee87d))
* add CloudinaryImg mdx props ([9149a04](https://github.com/theodorusclarence/theodorusclarence.com/commit/9149a04b2f902cd20ed3d0b8b70819156f313906))
* add content meta to projects ([7a454f7](https://github.com/theodorusclarence/theodorusclarence.com/commit/7a454f73b76974326ae52ed99e6eda2097eaf6a9))
* add docs to footer link ([faf1974](https://github.com/theodorusclarence/theodorusclarence.com/commit/faf1974c250f1a4e22d8d7986b5a0ab45154341f))
* add featuredPosts to home ([e222ce3](https://github.com/theodorusclarence/theodorusclarence.com/commit/e222ce3db7a6ee908f06b9517538dc1fc3c11d0a))
* add footer ([77e9135](https://github.com/theodorusclarence/theodorusclarence.com/commit/77e91355e570768c2608590bcad119294437db8d))
* add get all content api ([64c2360](https://github.com/theodorusclarence/theodorusclarence.com/commit/64c2360148eab9bfb80ce0895e8dfb2fac0e32ae))
* add index animation ([fa3237b](https://github.com/theodorusclarence/theodorusclarence.com/commit/fa3237bcf6ae45ddb251a76d129c9488d5beed0b))
* add index first section ([0b7ae35](https://github.com/theodorusclarence/theodorusclarence.com/commit/0b7ae35af414cd4aa2d55d1e9da9cac188291f3f))
* add intro section ([3292986](https://github.com/theodorusclarence/theodorusclarence.com/commit/3292986d433f3835969a3fc7a913074b74e60dc7))
* add isProd constant ([a409b00](https://github.com/theodorusclarence/theodorusclarence.com/commit/a409b0088e34f5dc7ba47172fc8638d9c081e78b))
* add library ([d6b9d35](https://github.com/theodorusclarence/theodorusclarence.com/commit/d6b9d356d0b2bcdd5ae992348a15f851ab08038e))
* add library and refactor toc ([f493d52](https://github.com/theodorusclarence/theodorusclarence.com/commit/f493d52e42028145ce0ae96f1c10e58e5eff1075))
* add like functionality ([b08c8f1](https://github.com/theodorusclarence/theodorusclarence.com/commit/b08c8f13cc9fcea4e0377555e11e56faa33eb9db))
* add likes to library card ([955f9a8](https://github.com/theodorusclarence/theodorusclarence.com/commit/955f9a8c087a3e35ae30d573b638d055f5ab08ac))
* add new tab cursor ([1c6b73e](https://github.com/theodorusclarence/theodorusclarence.com/commit/1c6b73e1f4f5fe25b3a56429c50d896765ad2da2))
* add newsletter subscribe ([b0a8f5b](https://github.com/theodorusclarence/theodorusclarence.com/commit/b0a8f5b86e4f21ea64cc43e6faf34987722646c6))
* add og from thcl ([dc30073](https://github.com/theodorusclarence/theodorusclarence.com/commit/dc300737801ddb36cff5830417687ca088513492))
* add project page ([b2ea6ce](https://github.com/theodorusclarence/theodorusclarence.com/commit/b2ea6ce2006a3cb83af25db81d3bcef775495f4d))
* add projects and library to home ([1b54862](https://github.com/theodorusclarence/theodorusclarence.com/commit/1b54862d285f464137cbd82bfa0e9208fbf2aef1))
* add search and language to blog ([303c2ac](https://github.com/theodorusclarence/theodorusclarence.com/commit/303c2ac3fc3b1d1008732079f749daa41de314cc))
* add search and tags to library ([ad724a5](https://github.com/theodorusclarence/theodorusclarence.com/commit/ad724a596a38b76455fd5686ab1f4bb38717f8a9))
* add selection style ([ba2127b](https://github.com/theodorusclarence/theodorusclarence.com/commit/ba2127b313f68ced263710f35010cc6dbd496668))
* add self-host og ([aa415c3](https://github.com/theodorusclarence/theodorusclarence.com/commit/aa415c32ba81f2e0f5ad03d131ea46d7198cd953))
* add single blog post ([5a330c4](https://github.com/theodorusclarence/theodorusclarence.com/commit/5a330c4bed62b4990609926139a37ad08e1056ac))
* add single content meta api ([6bfe14f](https://github.com/theodorusclarence/theodorusclarence.com/commit/6bfe14f4cd96da4b5a172fe1c5d8c222dd20ba43))
* add single project page ([5fb79ef](https://github.com/theodorusclarence/theodorusclarence.com/commit/5fb79ef784dae8452238841df52e407530f8f7e7))
* add spotify ([91962e8](https://github.com/theodorusclarence/theodorusclarence.com/commit/91962e81dddebf6dd37cc58a2920b4aecfb75264))
* add subscribe page ([4e9727f](https://github.com/theodorusclarence/theodorusclarence.com/commit/4e9727f92966478a3bb55ab3e5c2924ffcb177ff))
* add tag logic ([b833a6c](https://github.com/theodorusclarence/theodorusclarence.com/commit/b833a6c2eec9badce149335249d5022743040ff5))
* add tags on blog ([cf9274d](https://github.com/theodorusclarence/theodorusclarence.com/commit/cf9274d78cb178851f2c784302423c7f90211c85))
* add tooltip component ([0feb852](https://github.com/theodorusclarence/theodorusclarence.com/commit/0feb8526d41c00c5745853c33a7209851f218145))
* add transition to image blur ([88e715a](https://github.com/theodorusclarence/theodorusclarence.com/commit/88e715a7df6ffbf9cbbcef782c403bdba8bea89c))
* add trf page and side-projects ([a298283](https://github.com/theodorusclarence/theodorusclarence.com/commit/a298283fed1e51b9c6b14afa5488849678ba4f0b))
* add ui for sort blog ([74122a0](https://github.com/theodorusclarence/theodorusclarence.com/commit/74122a0f57ad30c2a3c8192cc2e4f05bde390aea))
* add umami analytics ([e45e86e](https://github.com/theodorusclarence/theodorusclarence.com/commit/e45e86e7a3be4185636875ad840ebac847b9fd76))
* add upsert like API ([5c7ec2c](https://github.com/theodorusclarence/theodorusclarence.com/commit/5c7ec2c63c82b256210464873a8e84020d86f365))
* **blog:** add mindful-commit-message ([c4401c4](https://github.com/theodorusclarence/theodorusclarence.com/commit/c4401c44c571cd43678e1c4eb72edd225116532f))
* **blog:** add newsletter cta ([b89e929](https://github.com/theodorusclarence/theodorusclarence.com/commit/b89e929770ec866cea0be2d892c46273b824f4d5))
* change about photo ([6bb6f68](https://github.com/theodorusclarence/theodorusclarence.com/commit/6bb6f6852c8aa71ea9f43188b5112b50a6366f64))
* change color and add header ([9e303fa](https://github.com/theodorusclarence/theodorusclarence.com/commit/9e303fa18a9101b1328f477d2f68577f90133c05))
* change footer to flex-wrap ([c81034f](https://github.com/theodorusclarence/theodorusclarence.com/commit/c81034f465b4d3eb51d6316c7967d482a45e7c11))
* change highlight color ([07c5496](https://github.com/theodorusclarence/theodorusclarence.com/commit/07c5496b351b0f16ba93811678a5baf5d9b5ca54))
* change og image ([1737f8e](https://github.com/theodorusclarence/theodorusclarence.com/commit/1737f8ef8fad3748962e473521d1b41bc85b4eca))
* change Seo ([a565947](https://github.com/theodorusclarence/theodorusclarence.com/commit/a5659478278963af1790e260a888df790ec34f83))
* change tag copywrite ([0c8318d](https://github.com/theodorusclarence/theodorusclarence.com/commit/0c8318d3a141fb5520ef8ad6e0e01a5255178617))
* dedupe tags by occurence ([5242935](https://github.com/theodorusclarence/theodorusclarence.com/commit/52429353451b394069eeabf62ec053cddb93cc82))
* increment views on visit ([94caf38](https://github.com/theodorusclarence/theodorusclarence.com/commit/94caf381d4b8b0aa99b2ff063fff6a2230ebb47e))
* inject views to blog ([60f8851](https://github.com/theodorusclarence/theodorusclarence.com/commit/60f88512dc926eba9162a89da9eb7a37a5ffdbdc))
* lower scale for card with image ([ea36f15](https://github.com/theodorusclarence/theodorusclarence.com/commit/ea36f15c2be4c1474589ed87c6aaa8f15a6fc93f))
* mutate count after subscribe ([a0e4d09](https://github.com/theodorusclarence/theodorusclarence.com/commit/a0e4d09d44e7166cba16a423c0ca69a66112644b))
* only show available tags ([bf4d10b](https://github.com/theodorusclarence/theodorusclarence.com/commit/bf4d10bfbe85472b754d0013c8b6d755d97d2bc4))
* polish some elements ([dcd73d9](https://github.com/theodorusclarence/theodorusclarence.com/commit/dcd73d92d4b1f5aa3e1c94d802174a87d45b8fa9))
* remove debounce on search ([8cfe04b](https://github.com/theodorusclarence/theodorusclarence.com/commit/8cfe04bf17389dd1aadd1c12e93751fae07ea3bf))
* remove image transition ([e3153ee](https://github.com/theodorusclarence/theodorusclarence.com/commit/e3153eefbbe2238e81a55200877e8fd5109f932d))
* remove og gradient outline ([a8a049a](https://github.com/theodorusclarence/theodorusclarence.com/commit/a8a049a8b35f16203ef751fe4662d3e09a87ce54))
* rename files ([2101224](https://github.com/theodorusclarence/theodorusclarence.com/commit/2101224dbad9f454b1c7d8d1e8c22fbfed3bcb2e))
* save sort preference and add icon ([e71c92d](https://github.com/theodorusclarence/theodorusclarence.com/commit/e71c92ddbf76958636484492117b9dd3f99e9835))
* scroll into view TOC ([530fb7a](https://github.com/theodorusclarence/theodorusclarence.com/commit/530fb7aefa944733d21f4ec07b6b481849d4668f))
* typescript initial commit ([d6f5fdf](https://github.com/theodorusclarence/theodorusclarence.com/commit/d6f5fdf7e0940d626f17073aaa5ddc35a2d95a7b))
* update intro section ([88a3cb4](https://github.com/theodorusclarence/theodorusclarence.com/commit/88a3cb4b13a8345a691e7d60afe6f017e022624b))
* update og ([3d10ecc](https://github.com/theodorusclarence/theodorusclarence.com/commit/3d10eccef21999264ba6526a75e15a22cad12b19))
* use onLoad and lower transition time ([6762728](https://github.com/theodorusclarence/theodorusclarence.com/commit/6762728084e864c6cde4666e0ac2577bdd3c447b))


### Bug Fixes

* change Cloudinary mdx props to optional ([e461281](https://github.com/theodorusclarence/theodorusclarence.com/commit/e4612812060587c3834ac5c62673ed258b514209))
* code block copy button scrolls ([82ccc02](https://github.com/theodorusclarence/theodorusclarence.com/commit/82ccc023c8b0df48bbf843548610f607f3c9fdc0))
* like button briefly jumps to 0 ([b1af8e4](https://github.com/theodorusclarence/theodorusclarence.com/commit/b1af8e4c94114397ad9059333751f3d00972788c))
* react-icons breaking changes ([916f18b](https://github.com/theodorusclarence/theodorusclarence.com/commit/916f18bce53884fa31bb3f8f9953fc648d6bf961))
* spotify error when playing podcast ([7eac807](https://github.com/theodorusclarence/theodorusclarence.com/commit/7eac807b9aee6d477afa57140699545c58e23c0e))
* spotify still show when not playing ([7514e13](https://github.com/theodorusclarence/theodorusclarence.com/commit/7514e13230a11bb2db1aa0984b0e83f24716efd7))
* tag spacing & still highlighted when disabled ([f76baab](https://github.com/theodorusclarence/theodorusclarence.com/commit/f76baab960d1315bc0769c7d8b4c7d66512a7a10))
* tag still selected on lang toggle ([667827c](https://github.com/theodorusclarence/theodorusclarence.com/commit/667827c8f930a952da04b83c30e59bf7f382a7f1))

## [0.3.0](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.2.4...v0.3.0) (2021-09-12)


### ⚠ BREAKING CHANGES

* add scrollspy to library
* add scrollspy to blog

### Features

* add large footer & change photo ([8154133](https://github.com/theodorusclarence/theodorusclarence.com/commit/8154133cd6d2b847a07bfd099d4da8aebb758680))
* add redirect for `/link` ([3536eb1](https://github.com/theodorusclarence/theodorusclarence.com/commit/3536eb117cc6af64805a35361c870f21684059c0))
* add scrollspy to blog ([3083621](https://github.com/theodorusclarence/theodorusclarence.com/commit/308362118f82840fece49d80f0083b5f8db4b496))
* add scrollspy to library ([fe2aa00](https://github.com/theodorusclarence/theodorusclarence.com/commit/fe2aa00a711f8f79e497d4cde2c1f5d74afa51b6))
* **blog:** add introduction heading ([c3adbc7](https://github.com/theodorusclarence/theodorusclarence.com/commit/c3adbc7803ea74fbe56b6b19efffb3fe2e8b1d4d))
* **blog:** make bahasa button to right align ([c5afded](https://github.com/theodorusclarence/theodorusclarence.com/commit/c5afded65de5ecf9015fcbca95ecdda4a73fc276))
* make larger layout ([540c5f2](https://github.com/theodorusclarence/theodorusclarence.com/commit/540c5f2c1cdbdf982effc9b51dcfd2b95e7e9512))


### Bug Fixes

* about page has conflicting color ([555e4de](https://github.com/theodorusclarence/theodorusclarence.com/commit/555e4debc96d604db9f4f866f49e3006695c1462))
* article not full width ([930ff76](https://github.com/theodorusclarence/theodorusclarence.com/commit/930ff7656733d85ea77ee842c16d045993f3db15))
* **blog:** conflicting hash and link on heading ([e5066ad](https://github.com/theodorusclarence/theodorusclarence.com/commit/e5066addfb2440b19bb4c021d89d338983646f25))
* code blocks overflow ([ae90c5a](https://github.com/theodorusclarence/theodorusclarence.com/commit/ae90c5aa5b9d51d1a78ba4ee219185d7c1e72cfa))

### [0.2.4](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.2.3...v0.2.4) (2021-09-08)


### Features

* change light mode accent ([92bb3d9](https://github.com/theodorusclarence/theodorusclarence.com/commit/92bb3d9bcaba55335d8fa427931245084732de76))
* change text & heading to lighter color ([33287c4](https://github.com/theodorusclarence/theodorusclarence.com/commit/33287c4206b8f838a6273755260cbb656496e8ce))

### [0.2.3](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.2.2...v0.2.3) (2021-09-07)


### Features

* **admin:** split devto views ([19e0275](https://github.com/theodorusclarence/theodorusclarence.com/commit/19e0275cc52095f8e2621dff43b5892c3025aee2))


### Bug Fixes

* add mt to spotify card ([aa30474](https://github.com/theodorusclarence/theodorusclarence.com/commit/aa304747b63f8487bfdefbd3c866c3012d8f7617))
* post request devto not synced ([49b8b9b](https://github.com/theodorusclarence/theodorusclarence.com/commit/49b8b9bf6dc91e94569f4b61a550ddde585266be))

### [0.2.2](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.2.1...v0.2.2) (2021-09-04)


### Features

* add devto views ([f92719e](https://github.com/theodorusclarence/theodorusclarence.com/commit/f92719e42ffa3163a4022f1ee9efbc8995911890))


### Bug Fixes

* header overlap with sort button ([aab913f](https://github.com/theodorusclarence/theodorusclarence.com/commit/aab913f5d38a4f8c2cbb9974369e985f054712b7))
* likes and views not showing on homepage ([5804a01](https://github.com/theodorusclarence/theodorusclarence.com/commit/5804a01fe85ebab12d2086b66698070895f4b1c4))

### [0.2.1](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.2.0...v0.2.1) (2021-09-04)


### Features

* add `library-sort` to session ([13b2ab9](https://github.com/theodorusclarence/theodorusclarence.com/commit/13b2ab97dad667fdee15eb86b1436bb67cbbcec9))
* **blog:** add sort feature ([7ba0700](https://github.com/theodorusclarence/theodorusclarence.com/commit/7ba07004b9628ede051c38cb4da4347f7b7b0c18))
* **library:** add sort listbox ([1fba2af](https://github.com/theodorusclarence/theodorusclarence.com/commit/1fba2afd5b1b55036125f7c2fcc487656380557f))


### Bug Fixes

* **library:** remove padding on search bar ([b6a0a81](https://github.com/theodorusclarence/theodorusclarence.com/commit/b6a0a81230e834570577f64625853e3c0b31af0d))

## [0.2.0](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.1.1...v0.2.0) (2021-09-04)


### ⚠ BREAKING CHANGES

* use mdx-bundler

### Features

* add ts to `PickTech` ([ca84686](https://github.com/theodorusclarence/theodorusclarence.com/commit/ca84686dc0be934848928a943749940e5a42bfd5))
* **blog:** add nextjs-fetch-method ([5b07681](https://github.com/theodorusclarence/theodorusclarence.com/commit/5b07681b6c7396a526c6345aab86e26a007f03ab))
* change dark typography to lighter color ([0042b3d](https://github.com/theodorusclarence/theodorusclarence.com/commit/0042b3d3343b4fc8a4ad8b70104f854576ad65bf))
* change og bg color ([f15ee0d](https://github.com/theodorusclarence/theodorusclarence.com/commit/f15ee0d66cc55968b03636867633bf564599896e))
* **library:** add js & ts logo to auth-context ([03b89ea](https://github.com/theodorusclarence/theodorusclarence.com/commit/03b89eadac8c4ee13acb12f80809d221e763103c))
* **library:** add new link for conditional-link ([4627a2b](https://github.com/theodorusclarence/theodorusclarence.com/commit/4627a2bc642c1dd4ffade64f0902bde5255cedea))
* **library:** add swr hook for toast ([7432a51](https://github.com/theodorusclarence/theodorusclarence.com/commit/7432a5123fbfe2e27f89c290004459cf9f047a09))
* **library:** add tailwind config to basestyle ([38585a2](https://github.com/theodorusclarence/theodorusclarence.com/commit/38585a2ac069524b44fb4001bcc1c9c641842fb3))
* **library:** add ts version to seo ([cde9836](https://github.com/theodorusclarence/theodorusclarence.com/commit/cde9836f809f4e48abc6a0e2b7056ad932bea68a))
* **projects:** add github link for sxceosleague ([464f0a8](https://github.com/theodorusclarence/theodorusclarence.com/commit/464f0a8ab493fdcb6156bd41aae30d0981eedfa2))
* remove next-mdx-remote file ([e83ce80](https://github.com/theodorusclarence/theodorusclarence.com/commit/e83ce80e3e5f0d734bd669f100908f7706b2166d))
* use mdx-bundler ([7269137](https://github.com/theodorusclarence/theodorusclarence.com/commit/72691371b7c759fa12320390df810fe491eda2d6))


### Bug Fixes

* add text lang to blank code blocks ([72e43d2](https://github.com/theodorusclarence/theodorusclarence.com/commit/72e43d2b9ceffd7f849e76e6a8ee8feb521fc8e1))
* **blog:** typo on nextjs-fetch-method ([98ed9d6](https://github.com/theodorusclarence/theodorusclarence.com/commit/98ed9d60faae7db4d174105b23c8ed76fc0e2ebe))
* edit on github link full width ([f5d1c16](https://github.com/theodorusclarence/theodorusclarence.com/commit/f5d1c16071d2e1fefeb72d256b69deb7f1996898))
* tailwind css spelling ([17235ee](https://github.com/theodorusclarence/theodorusclarence.com/commit/17235eee9d10136a359fc95e24a1f24e13355a12))
* typo on footer ([a3cd4a7](https://github.com/theodorusclarence/theodorusclarence.com/commit/a3cd4a77554ad4679c8ca44a8181eec71ee7e9bb))

### [0.1.3](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.1.2...v0.1.3) (2021-09-02)


### Features

* **blog:** add nextjs-fetch-method ([b62b030](https://github.com/theodorusclarence/theodorusclarence.com/commit/b62b03075421b8b89cd0ffe852145879726efde6))
* change dark typography to lighter color ([f835603](https://github.com/theodorusclarence/theodorusclarence.com/commit/f8356031ff44694429b37099d3f52f1997783587))


### Bug Fixes

* **blog:** typo on nextjs-fetch-method ([6a8b260](https://github.com/theodorusclarence/theodorusclarence.com/commit/6a8b260c869d6f0d3f7b839ac8d0eeb8ca2e59af))

### [0.1.2](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.1.1...v0.1.2) (2021-08-30)


### Features

* add ts to `PickTech` ([ca84686](https://github.com/theodorusclarence/theodorusclarence.com/commit/ca84686dc0be934848928a943749940e5a42bfd5))
* **library:** add js & ts logo to auth-context ([03b89ea](https://github.com/theodorusclarence/theodorusclarence.com/commit/03b89eadac8c4ee13acb12f80809d221e763103c))
* **library:** add new link for conditional-link ([4627a2b](https://github.com/theodorusclarence/theodorusclarence.com/commit/4627a2bc642c1dd4ffade64f0902bde5255cedea))
* **library:** add swr hook for toast ([7432a51](https://github.com/theodorusclarence/theodorusclarence.com/commit/7432a5123fbfe2e27f89c290004459cf9f047a09))
* **library:** add tailwind config to basestyle ([38585a2](https://github.com/theodorusclarence/theodorusclarence.com/commit/38585a2ac069524b44fb4001bcc1c9c641842fb3))
* **library:** add ts version to seo ([cde9836](https://github.com/theodorusclarence/theodorusclarence.com/commit/cde9836f809f4e48abc6a0e2b7056ad932bea68a))
* **projects:** add github link for sxceosleague ([464f0a8](https://github.com/theodorusclarence/theodorusclarence.com/commit/464f0a8ab493fdcb6156bd41aae30d0981eedfa2))


### Bug Fixes

* edit on github link full width ([f5d1c16](https://github.com/theodorusclarence/theodorusclarence.com/commit/f5d1c16071d2e1fefeb72d256b69deb7f1996898))
* tailwind css spelling ([17235ee](https://github.com/theodorusclarence/theodorusclarence.com/commit/17235eee9d10136a359fc95e24a1f24e13355a12))

### [0.1.1](https://github.com/theodorusclarence/theodorusclarence.com/compare/v0.1.0...v0.1.1) (2021-08-29)


### Features

* add footer links and twitter ([67cdfca](https://github.com/theodorusclarence/theodorusclarence.com/commit/67cdfca04a1ad6a036d54d578f3f7e73bbfd72b9))

## 0.1.0 (2021-08-29)


### ⚠ BREAKING CHANGES

* add cloudinary image for projects

### Features

* add cloudinary image for projects ([8ea43b2](https://github.com/theodorusclarence/theodorusclarence.com/commit/8ea43b2fe93e00c22c0d0100c39ac3d53c63dc25))
* add cloudinary on about photos ([944396b](https://github.com/theodorusclarence/theodorusclarence.com/commit/944396b8282b93b5bec17e1e15863329b062f446))
* add cloudinary on project details ([4fb255e](https://github.com/theodorusclarence/theodorusclarence.com/commit/4fb255e183d4dadc5b83801b01d78e05c84556ca))
* add cloudinary to all blog images ([f9e1ce4](https://github.com/theodorusclarence/theodorusclarence.com/commit/f9e1ce48fd185297a093bd3b7cc0f301827db341))
* add cloudinary to trf ([040f33b](https://github.com/theodorusclarence/theodorusclarence.com/commit/040f33bef22298a49f413386931cd03002c5b345))
* add CloudinaryImg component ([ccadb7f](https://github.com/theodorusclarence/theodorusclarence.com/commit/ccadb7f6f055c1ef4a3665ecfa063468b4ba8022))
* add conditional setIsLoaded ([242fb6b](https://github.com/theodorusclarence/theodorusclarence.com/commit/242fb6bc8c58fd9f7b2eff6f15f351d92b466952))
* add content and like api route ([f8aca63](https://github.com/theodorusclarence/theodorusclarence.com/commit/f8aca6388bfef0c02350aedd6e962351b4e4c673))
* add content dashboard ([1c0d6f5](https://github.com/theodorusclarence/theodorusclarence.com/commit/1c0d6f5f74cc4ee089256d18d367efc25be05ead))
* add cv to public folder ([439a845](https://github.com/theodorusclarence/theodorusclarence.com/commit/439a845242bce8defd4b4a249aad41782dc9a572))
* add dynamic image opengraph ([9f3581a](https://github.com/theodorusclarence/theodorusclarence.com/commit/9f3581a3acbba3e1d331f7c639fe74c8d667893d))
* add edit on github button ([f36801e](https://github.com/theodorusclarence/theodorusclarence.com/commit/f36801e65891be716ee478f01830ffea94be40fe))
* add env example ([baabd4d](https://github.com/theodorusclarence/theodorusclarence.com/commit/baabd4decd5ae6f055d07a63b738ffb7be1df7ae))
* add focus state for LikeButton ([655ec03](https://github.com/theodorusclarence/theodorusclarence.com/commit/655ec03db033998fdebcba92d128c42e3bb7b5d9))
* add git icon on PickTech ([8023eeb](https://github.com/theodorusclarence/theodorusclarence.com/commit/8023eeb58ea3772f19f5baa07f0b2619788b91d6))
* add image preview with lightbox ([58f5dd2](https://github.com/theodorusclarence/theodorusclarence.com/commit/58f5dd21fe94478573ef505c7376e6b17746fe9b))
* add isLoaded to useLoadingWithPreload hook ([3e0b4a1](https://github.com/theodorusclarence/theodorusclarence.com/commit/3e0b4a18b33aaf7a3af5727fae5cfacff01e0911))
* add jit mode ([b49219b](https://github.com/theodorusclarence/theodorusclarence.com/commit/b49219bb48a880fadd2e9581f961e7cd028a84a8))
* add lightbulb to 404 page ([1c63a74](https://github.com/theodorusclarence/theodorusclarence.com/commit/1c63a74014f14a0a077c13158028295c17aebcca))
* add LikeButton ([10f3e0b](https://github.com/theodorusclarence/theodorusclarence.com/commit/10f3e0b1554f8977510b204ade9d05c7bf4271f6))
* add loading useEffect for index ([b72fed7](https://github.com/theodorusclarence/theodorusclarence.com/commit/b72fed74a1314324640c77ed929b6b0e8f794c81))
* add min-width to library card ([0b00996](https://github.com/theodorusclarence/theodorusclarence.com/commit/0b00996facbd9b9dd444f4186af859bc45d5c80b))
* add model and migrate ([ac1b509](https://github.com/theodorusclarence/theodorusclarence.com/commit/ac1b509d684e4dffbc7d9c8b9888573020d7d75b))
* add preload hook to all animated pages ([e8d3433](https://github.com/theodorusclarence/theodorusclarence.com/commit/e8d34332b566fcadccd0bc2daf117abdc0955fa0))
* add propType on CloudinaryImg ([1190f5b](https://github.com/theodorusclarence/theodorusclarence.com/commit/1190f5bc8bb5a319db0ba1bd17c60c565111b034))
* add remark-slug anchor and dynamic smooth ([0bee1b8](https://github.com/theodorusclarence/theodorusclarence.com/commit/0bee1b8e4a8bf0bbdd550ca2e4722b3593d61ed5))
* add splitbee analytics ([836742f](https://github.com/theodorusclarence/theodorusclarence.com/commit/836742f9a017b1b3ac0e8acc98ec511c1aea4108))
* add syntax highlight for token dom ([0c5b5a9](https://github.com/theodorusclarence/theodorusclarence.com/commit/0c5b5a9efabf061ed79a4508bdbcb7c5c22e0bfc))
* add typescript to current stack ([6e33358](https://github.com/theodorusclarence/theodorusclarence.com/commit/6e33358aa6b9471ed36da988699077f28e82ef58))
* add useContentMeta hook ([24c1100](https://github.com/theodorusclarence/theodorusclarence.com/commit/24c11007c1c29578c0f94c148d1af521d87b683b))
* add utterances to lib and blog ([8517282](https://github.com/theodorusclarence/theodorusclarence.com/commit/8517282b93b6877d3a2ac143303a1b5061bc961c))
* add vite-cra post ([a3d4fe9](https://github.com/theodorusclarence/theodorusclarence.com/commit/a3d4fe9241537583cdd9cc613d92498715650a1b))
* add vite-cra to featured ([9366130](https://github.com/theodorusclarence/theodorusclarence.com/commit/93661301b60fdf147676eb26f0b9e3be2373c4ed))
* **blog:** add accent for reading time and views ([0aabbb5](https://github.com/theodorusclarence/theodorusclarence.com/commit/0aabbb59e785bc9aadec44196b12b63d28e80b71))
* **blog:** add conditional englishOnly ([50bacbb](https://github.com/theodorusclarence/theodorusclarence.com/commit/50bacbba33b549360c1e8ac76ae16cc1764b95e2))
* **blog:** add my-addons post ([c17868e](https://github.com/theodorusclarence/theodorusclarence.com/commit/c17868efb43300b670993cf869fb49866e7de547))
* **blog:** add nextjs-redirect-no-flashing ([2842c1a](https://github.com/theodorusclarence/theodorusclarence.com/commit/2842c1a9391f1d382d5d8cb482b24ccc2d06a982))
* **blog:** add rhf ([6b9be2f](https://github.com/theodorusclarence/theodorusclarence.com/commit/6b9be2f7a6d56d23c493c24bcadb6a561c6e4d03))
* **blog:** add tailwindcss-best-practice ([dceda38](https://github.com/theodorusclarence/theodorusclarence.com/commit/dceda38da76e03e48b81843c20111f386b6b9901))
* **blog:** update youtube-list ([cc939d7](https://github.com/theodorusclarence/theodorusclarence.com/commit/cc939d7f066effcc1479c4d16cecc2a26035bb12))
* change api to use faunadb ([0dcca8d](https://github.com/theodorusclarence/theodorusclarence.com/commit/0dcca8d3c9a05ea18a7a54fdc653399dba3babca))
* change color scheme from [#333](https://github.com/theodorusclarence/theodorusclarence.com/issues/333) to [#222](https://github.com/theodorusclarence/theodorusclarence.com/issues/222) ([fc3583b](https://github.com/theodorusclarence/theodorusclarence.com/commit/fc3583bb951a6c94a774167895ab691feb9e5194))
* change dark border color to more muted ([ab40aff](https://github.com/theodorusclarence/theodorusclarence.com/commit/ab40aff492eaf1b875fcb7ec2d35f0a8e7860f84))
* change method from framer to css transform for card scale ([5c1e66c](https://github.com/theodorusclarence/theodorusclarence.com/commit/5c1e66c530ac296a3f621bb72ff63202145b20ba))
* change preload timeout to 200ms ([86e51ef](https://github.com/theodorusclarence/theodorusclarence.com/commit/86e51efe58a3caf87f90447101554664aeb5c358))
* change title of vite-cra ([c9bd751](https://github.com/theodorusclarence/theodorusclarence.com/commit/c9bd7518c6b34e68ff58974e7e2dbfca6d8b0f01))
* change to variable fonts latin ([69010f3](https://github.com/theodorusclarence/theodorusclarence.com/commit/69010f31cfe185fbd6f31f936600c96355a0005d))
* conditionally increment count ([4da79a3](https://github.com/theodorusclarence/theodorusclarence.com/commit/4da79a3823a1d7f8dcb1795db2dfb18dcf1fcdf8))
* feature tailwindcss-best-practice ([89e86a4](https://github.com/theodorusclarence/theodorusclarence.com/commit/89e86a48a7a309c151b82041bbbc9dd9b7d645a8))
* fix some typo ([0bb63d4](https://github.com/theodorusclarence/theodorusclarence.com/commit/0bb63d4295d9c8a670a27c2063fbac8d1b876c8f))
* implement useContentMeta to blog ([f3d9280](https://github.com/theodorusclarence/theodorusclarence.com/commit/f3d9280b9c94739d512e78d7ee5f6112acd7e8fb))
* implement useContentMeta to library ([b4834e7](https://github.com/theodorusclarence/theodorusclarence.com/commit/b4834e712cff2168e84c10d0c68a8524dadf4d20))
* implement useContentMeta to projects ([8ef5f0e](https://github.com/theodorusclarence/theodorusclarence.com/commit/8ef5f0e6965a7ea6fadbf4b57915f167db536455))
* **library:** add absolute-import for CRA ([ec8b0be](https://github.com/theodorusclarence/theodorusclarence.com/commit/ec8b0be1aa69154dc578392def8581e89d0269ef))
* **library:** add btb-flex-mental-model ([42fb985](https://github.com/theodorusclarence/theodorusclarence.com/commit/42fb985ae9a3e5741ecd11aa53a29785ea4d4d9c))
* **library:** add cloudinary-blur-loader ([76819bb](https://github.com/theodorusclarence/theodorusclarence.com/commit/76819bb090d16ea5dbe90628d66cf1082c469f8c))
* **library:** add conventional-commit-readme ([58a5cd3](https://github.com/theodorusclarence/theodorusclarence.com/commit/58a5cd358a4de5126771f0f68b7330605e8e55ff))
* **library:** add demo link to rhf-input ([c6a3905](https://github.com/theodorusclarence/theodorusclarence.com/commit/c6a390536660fb1e74d9a9700a05090081693bd5))
* **library:** add get-local-storage ([cd8ac7d](https://github.com/theodorusclarence/theodorusclarence.com/commit/cd8ac7da66013260c59349b64c3f19b97810c1b1))
* **library:** add html css json to husky-commitlint-prettier ([8f5f9fb](https://github.com/theodorusclarence/theodorusclarence.com/commit/8f5f9fb7d70ba63d8156189634e80cdf23bdfb64))
* **library:** add husky-commitlint-prettier ([5c96036](https://github.com/theodorusclarence/theodorusclarence.com/commit/5c9603621a1d85485caa5afb6c8edc71be61fc33))
* **library:** add link for css-tricks ([32915a1](https://github.com/theodorusclarence/theodorusclarence.com/commit/32915a1f4ee59fd7e12570faa09eff20ce852875))
* **library:** add missing header in absolute-import ([df9ff15](https://github.com/theodorusclarence/theodorusclarence.com/commit/df9ff15023ce327e4c1e023b197c7da84539e459))
* **library:** add postmerge hook on husky-commitlint-prettier ([a914c20](https://github.com/theodorusclarence/theodorusclarence.com/commit/a914c20cfa7713b5ee7328f2fe4051df536f6295))
* **library:** add rhf-input ([a7cfd63](https://github.com/theodorusclarence/theodorusclarence.com/commit/a7cfd63eaa6d4c64f630e9ebaf476bf181eec574))
* **library:** add seo ([3cd9172](https://github.com/theodorusclarence/theodorusclarence.com/commit/3cd9172e8c16f8ed0725fc401a9d95a8c133be88))
* **library:** add tailwindcss-basestyle ([7ffb5ee](https://github.com/theodorusclarence/theodorusclarence.com/commit/7ffb5ee394feb68b10cf442b83518ac7852a5b2c))
* **library:** add toast ([251301f](https://github.com/theodorusclarence/theodorusclarence.com/commit/251301f78eae424fb300d43216c353bf1cbfa5d4))
* **library:** add youtube-embed ([264897e](https://github.com/theodorusclarence/theodorusclarence.com/commit/264897eba38eb2e302f0bee9b7d67c0abb26eca9))
* **library:** change quality snippet on cloudinary-blur-loader ([8a954e7](https://github.com/theodorusclarence/theodorusclarence.com/commit/8a954e726fef35782ddcda990889ddc3db3ee939))
* **library:** change tailwindcss-basestyle ([c6e1d0b](https://github.com/theodorusclarence/theodorusclarence.com/commit/c6e1d0b1b8d6b2eda124b5afe7adcffed4533605))
* **library:** feature btb-flex-mental-model ([0e7c6f5](https://github.com/theodorusclarence/theodorusclarence.com/commit/0e7c6f55f875436819b4f601bee5afd54692f57e))
* **library:** remove rhf-input ([b4ae188](https://github.com/theodorusclarence/theodorusclarence.com/commit/b4ae18807135d99bac203d973c0243944b717300))
* **library:** sort result alphabetically ([5a51c8f](https://github.com/theodorusclarence/theodorusclarence.com/commit/5a51c8febb6e3dd376014ebbde3108fed735faea))
* **library:** update absolute-import for next ([94c7c0a](https://github.com/theodorusclarence/theodorusclarence.com/commit/94c7c0adb966e67bb0bea6ea5faab51ee6b34802))
* **library:** update auth-context ([5e96610](https://github.com/theodorusclarence/theodorusclarence.com/commit/5e966109b4a8a43b7e6d1986a5123f18465a85d9))
* **library:** update conditional-link ([97bd346](https://github.com/theodorusclarence/theodorusclarence.com/commit/97bd3462177a89ea5b5b4ebb80180e3dfbb60397))
* **library:** update conditional-link for next ([7231886](https://github.com/theodorusclarence/theodorusclarence.com/commit/72318862931e2cd1f110cfcd0e41a3e64b1267a6))
* **library:** update conditional-link to have cra code ([d5cf780](https://github.com/theodorusclarence/theodorusclarence.com/commit/d5cf780d1d6f80769edfc83a57f92d967abaee56))
* **library:** update content ([797e373](https://github.com/theodorusclarence/theodorusclarence.com/commit/797e373534923491c1512857c9316ad2433f4eb5))
* **library:** update conventional-commit-readme to have english version ([b58ffec](https://github.com/theodorusclarence/theodorusclarence.com/commit/b58ffec58f30b3cf2361ac45babddb50848f52d7))
* make white mode gradient more visible ([b760ef3](https://github.com/theodorusclarence/theodorusclarence.com/commit/b760ef3761bb3c0ff3bd1073ce1d45161011db15))
* **project:** add sxceosleague ([e9ce85d](https://github.com/theodorusclarence/theodorusclarence.com/commit/e9ce85d803968840842011a2ada8151d57137fe1))
* **project:** add winner tag on love4heroes ([2735760](https://github.com/theodorusclarence/theodorusclarence.com/commit/273576007762dcfacc3ac6dcb61af561d196c20b))
* **project:** remove personal-web-1 ([a7b65e9](https://github.com/theodorusclarence/theodorusclarence.com/commit/a7b65e9479db0394f40c2aaf637abf4368e57850))
* **projects:** add ppdbsumsel ([61f0043](https://github.com/theodorusclarence/theodorusclarence.com/commit/61f0043e9756b0d7aa842a4692c7a3da0818963c))
* **projects:** add side-projects ([a81e2ae](https://github.com/theodorusclarence/theodorusclarence.com/commit/a81e2aec66a0007625905c7faf1698a97817e331))
* remove hash-anchor underline animation ([1ddd354](https://github.com/theodorusclarence/theodorusclarence.com/commit/1ddd354747b4e3fbe0127f5ccff2b64a298589fb))
* remove personal-web-2 and spotify-now-playing from projects ([64d32b0](https://github.com/theodorusclarence/theodorusclarence.com/commit/64d32b0405958e7db97a5ef338452698847ab354))
* remove prisma utils ([a31a423](https://github.com/theodorusclarence/theodorusclarence.com/commit/a31a42326d68a5270489c1339e1cea1902701e39))
* sort featured posts newest first ([fccc0c6](https://github.com/theodorusclarence/theodorusclarence.com/commit/fccc0c6ab9cbed5eaeda3bd38a9208088511a0b2))
* temporary remove layoutId animation ([a2bb644](https://github.com/theodorusclarence/theodorusclarence.com/commit/a2bb644cfaba38c4682a3b9e8255779bed0bf0a5))
* use css transform for stagger ([03f1145](https://github.com/theodorusclarence/theodorusclarence.com/commit/03f1145b818a59fd9de53ff666bcdbeb3976321b))
* use fit-content for mdx headings ([71e67bb](https://github.com/theodorusclarence/theodorusclarence.com/commit/71e67bb2eaf1a0a4caed1554c778fdb8772c3963))
* use preloader in PreloadContext for index ([90bbf68](https://github.com/theodorusclarence/theodorusclarence.com/commit/90bbf689d95f49af7c971882f1c8954b63aa340c))
* use production database url ([8f7a8a5](https://github.com/theodorusclarence/theodorusclarence.com/commit/8f7a8a5ec0f34c2b27642b165eee9c9f5e30f50e))
* use rewrite for splitbee ([fa7f600](https://github.com/theodorusclarence/theodorusclarence.com/commit/fa7f600ffd2eae5fde67af7748c36554350fc59f))
* user promise in mutate ([11b6018](https://github.com/theodorusclarence/theodorusclarence.com/commit/11b6018f99af40f22effb10604f80dec0a68ee05))


### Bug Fixes

* addLike not mutated optimistically ([ff61473](https://github.com/theodorusclarence/theodorusclarence.com/commit/ff614735ba8505972a97b83070610b4cb74dff11))
* adjust scroll for arrow button ([b80e007](https://github.com/theodorusclarence/theodorusclarence.com/commit/b80e007acc2a1275fb9df3a0ec0d212068734f6a))
* back button don't have ring-vis ([c2aec63](https://github.com/theodorusclarence/theodorusclarence.com/commit/c2aec636b2384112a4c21a6b9c55562d4692af15))
* **blog:** blog render animation scrambles ([d4913c7](https://github.com/theodorusclarence/theodorusclarence.com/commit/d4913c711af9bbe6ff775c9f2b9cb0b332d701c6))
* **blog:** link overflows in nextjs-redirect ([5b7fb08](https://github.com/theodorusclarence/theodorusclarence.com/commit/5b7fb0882f42fed7ef12ce7fb04b1505bef23993))
* **blog:** rhf link to demo clashes with hash link ([7bc95c7](https://github.com/theodorusclarence/theodorusclarence.com/commit/7bc95c768f53b54c84c6d773643166b9de48caa0))
* **blog:** typo ([ed7835b](https://github.com/theodorusclarence/theodorusclarence.com/commit/ed7835ba226df99ccd2be86d26ef4585b265c0d5))
* **blog:** typo in btb-flex-mental-model ([fb860ba](https://github.com/theodorusclarence/theodorusclarence.com/commit/fb860baced5eccac231ae10a9d47cbf55c638e03))
* blur quality not working ([5a4465e](https://github.com/theodorusclarence/theodorusclarence.com/commit/5a4465e010ffb5d0a9cfeb3c3c83548c253e2f70))
* can't open ProjectCard side link ([9fbe32e](https://github.com/theodorusclarence/theodorusclarence.com/commit/9fbe32e3d6c336f1a8be7f96a50c9ac4ed52d0c2))
* cloudinary image overflowing ([146c203](https://github.com/theodorusclarence/theodorusclarence.com/commit/146c20380b13a6c1542f578e2a6b87a9e547219c))
* copy to clipboard not working on android ([8fe9e5e](https://github.com/theodorusclarence/theodorusclarence.com/commit/8fe9e5e5660097e5864d267cec108a55b0e8b0a9))
* debounce mutation ([cb02f0d](https://github.com/theodorusclarence/theodorusclarence.com/commit/cb02f0d106749a391fe43566de4ab1668f67ce60))
* hash-anchor overflows on mobile ([bb304b5](https://github.com/theodorusclarence/theodorusclarence.com/commit/bb304b5fd0f96b8b455a87cb458785451095d8fd))
* input shadow on safari mobile ([88059ee](https://github.com/theodorusclarence/theodorusclarence.com/commit/88059ee6f49a9cf4bff09d835c8e1eb558bf47a7))
* **library:** description is not defined ([abc6192](https://github.com/theodorusclarence/theodorusclarence.com/commit/abc619221a40766a4dabe3ba1d8bc80aa6a51c37))
* **library:** quote on description ([e44c58c](https://github.com/theodorusclarence/theodorusclarence.com/commit/e44c58cbdcc8313ab27569e0c8f7b1e6d9d7f40a))
* **library:** typo description rhf ([5b6410c](https://github.com/theodorusclarence/theodorusclarence.com/commit/5b6410c0709b257984bad4f1450165c90f56b065))
* min-h without header and transform overriding ([e0597f9](https://github.com/theodorusclarence/theodorusclarence.com/commit/e0597f9b8f384eb62417dede9dc3d34cccf06bd4))
* only add heading style for hash anchor ([e1ceea1](https://github.com/theodorusclarence/theodorusclarence.com/commit/e1ceea1f0ab1ff500184a90c88397d5c8ed3f2ce))
* react-icons bug on IconContext ([013266a](https://github.com/theodorusclarence/theodorusclarence.com/commit/013266a38c62f8bafcc9d1dd4086894571b2f429))
* seo image not working in linkedin ([6e55865](https://github.com/theodorusclarence/theodorusclarence.com/commit/6e558653074e9892e927b8d07ffa34b7e9b486c7))
