<p align="center">
    <img src="src/images/empathy.svg?sanitize=true" alt="Empathy" title="Empathy" width="350"/>
</p>
<p align="center">Lightweight admin panel components build with Tailwindcss, PurgeCSS, Vuejs, Fontawesome 5</p>
<br>

## Why Empathy?
Empathy is a component-based package. It can works smoothly with every backend language. It is primarily built using Tailwindcss CSS utilities. It is different because it doesn't require you to clone the repository before you start your project like other admin panels. All you need is your `package.json` and your assets bundler. Install the package from NPM, set up the main components, set up your desired other components (in a fully customized fashion way) and you're finished. With purgeCSS, you can get a light and small-sized result.


![Empathy demo screenshot](https://raw.githubusercontent.com/the94air/empathy/new/src/images/empathy-screenshopt.png)

## Components
1. Navbar component.
2. Footer component.
3. Panel component.
4. Breadcrumb component.
5. Form components.
6. Alert components.
7. Button components.
8. Notification component.
9. Table component.
10. DataTable component.
11. [**Add a new component**](#contirbute).

## installation
Install with NPM:
```bash
$ npm install @codolog/empathy --save
```
Or if you like Yarn:
```bash
$ yarn add @codolog/empathy
```

## Docs & Demo
The documentation: [https://empathy.js.org](https://empathy.js.org).  
The demo: [https://empathy.js.org/demo](https://empathy.js.org/demo).

## Dependancies
Empathy depends on the next tools:
1. Tailwindcss library.
2. Vue JavaScript framework.
3. PurgeCSS to reduce CSS file size.
4. Fontawesome 5 icons.
5. `vue-slideout` Vue plugin.
6. `vue-slide-up-down` Vue plugin.
7. `vue-notification` Vue plugin.
8. `vue-good-table` Vue plugin.
9. `webfontloader` for loading fonts.

## Contirbute
You can contribute and add your favorite component to the package by opening a new [issue](https://github.com/the94air/empathy/issues) with an example before making a [pull request](https://github.com/the94air/empathy/pulls). if you also found a bug, send me a pull request.  
Contributes are also welcome by making the components with another javascript framework.

## License
This project is [MIT](https://github.com/the94air/empathy/blob/master/LICENSE) licensed.  
Project by [Abdalla Arbab](https://abdalla.js.org).