TERMUX_PKG_HOMEPAGE=https://fishshell.com/
TERMUX_PKG_DESCRIPTION="The user-friendly command line shell"
TERMUX_PKG_LICENSE="GPL-2.0"
TERMUX_PKG_MAINTAINER="@termux"
TERMUX_PKG_VERSION="3.7.1"
TERMUX_PKG_REVISION=2
TERMUX_PKG_SRCURL=https://github.com/fish-shell/fish-shell/releases/download/$TERMUX_PKG_VERSION/fish-${TERMUX_PKG_VERSION}.tar.xz
TERMUX_PKG_SHA256=614c9f5643cd0799df391395fa6bbc3649427bb839722ce3b114d3bbc1a3b250
TERMUX_PKG_AUTO_UPDATE=true
# fish calls 'tput' from ncurses-utils, at least when cancelling (Ctrl+C) a command line.
# man is needed since fish calls apropos during command completion.
TERMUX_PKG_DEPENDS="bc, libandroid-support, libandroid-spawn, libc++, ncurses, ncurses-utils, man, pcre2"
TERMUX_PKG_BUILD_IN_SRC=true
TERMUX_PKG_EXTRA_CONFIGURE_ARGS="
-DBUILD_DOCS=OFF
"

termux_step_pre_configure() {
	# fish releases tarballs that conflict with the way the toolchain
	# currently is by putting a file in the tarball
	# named "version" (not visible directly in the source code on github,
	# generated by this code in fish's release workflow:
	# https://github.com/fish-shell/fish-shell/blob/master/build_tools/make_tarball.sh#L69 )
	# and, crucially, also placing the folder containing that file named "version"
	# in the include path of building fish (since right next to this in the same folder,
	# fish does have a file named "config.h" that it uses)
	# here is the upstream, conflicting instance of file in internal llvm
	# include path named "version" that is probably what propogates into the NDK's
	# equivalent file,
	# /home/builder/.termux-build/_cache/android-r27b-api-24-v1/sysroot/usr/include/c++/v1/version
	# https://github.com/llvm/llvm-project/blob/main/libcxx/include/version
	mv version fish_version
	find build_tools -type f -exec sed -i {} \
		-e 's/cat version/cat fish_version/g' \
		-e 's/test -f version/test -f fish_version/g' \;
	CXXFLAGS+=" $CPPFLAGS"
}

termux_step_post_make_install() {
	cat >> $TERMUX_PREFIX/etc/fish/config.fish <<HERE
function __fish_command_not_found_handler --on-event fish_command_not_found
	$TERMUX_PREFIX/libexec/termux/command-not-found \$argv[1]
end
HERE
}
