#!/bin/bash
# Copyright 2018 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================

set -eu

. wmtm16_lib.sh

mkdir -p "${ROOT}/raw"
# ============================================================================
# Download WMT data.
# From the WMT16 Multimodal website (En-De):
echo "
http://www.quest.dcs.shef.ac.uk/wmt16_files_mmt/training.tar.gz
http://www.quest.dcs.shef.ac.uk/wmt16_files_mmt/validation.tar.gz
http://www.quest.dcs.shef.ac.uk/wmt16_files_mmt/mmt16_task1_test.tar.gz" \
  | aria2c -x16 -s16 --dir="${ROOT}/raw" -i -
