# Copyright 2018 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Tests for simple_wer."""

from lingvo.core import test_utils
from lingvo.tasks.asr.tools import simple_wer


class SimpleWerTest(test_utils.TestCase):

  def testWerIgnorePunctuation(self):
    hyp = 'hello  world. today is a good day, how are you'
    ref = '(Hello world)!    [Today] is a good day! How are you?'
    errs, nw, _ = simple_wer.ComputeWER(hyp, ref)
    self.assertEqual(sum(errs.values()), 0)
    self.assertEqual(nw, 10)


if __name__ == '__main__':
  test_utils.main()
