# Copyright 2018 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Tests for base_model_params."""

from lingvo.core import base_model_params
from lingvo.core import test_utils


class TestModelParams(base_model_params.SingleTaskModelParams):

  def GetAllDatasetParams(self):
    raise NotImplementedError('test error')


class PartialDatasetParams(base_model_params.SingleTaskModelParams):

  def GetAllDatasetParams(self):
    return dict(Test_X1=self.Test())

  def Test_X2(self):
    pass


class BaseModelParamsTest(test_utils.TestCase):

  def testGetDatasetParams_SingleTaskModelParams(self):
    dummy_model = base_model_params.SingleTaskModelParams()
    self.assertEqual(dummy_model.Train(), dummy_model.GetDatasetParams('Train'))
    self.assertEqual(dummy_model.Dev(), dummy_model.GetDatasetParams('Dev'))
    self.assertEqual(dummy_model.Test(), dummy_model.GetDatasetParams('Test'))
    with self.assertRaises(base_model_params.DatasetError):
      dummy_model.GetDatasetParams('Invalid')

  def testGetDatasetParams_MultiTaskModelParams(self):
    dummy_model = base_model_params.MultiTaskModelParams()
    self.assertEqual(dummy_model.Train(), dummy_model.GetDatasetParams('Train'))
    self.assertEqual(dummy_model.Dev(), dummy_model.GetDatasetParams('Dev'))
    self.assertEqual(dummy_model.Test(), dummy_model.GetDatasetParams('Test'))
    with self.assertRaises(base_model_params.DatasetError):
      dummy_model.GetDatasetParams('Invalid')

  def testGetDatasetParams_NotImplementedError(self):
    dummy_model = TestModelParams()
    with self.assertRaisesRegexp(NotImplementedError, 'test error'):
      dummy_model.GetDatasetParams('Train')

  def testGetDatasetParams_PartialDatasetParams(self):
    dummy_model = PartialDatasetParams()
    self.assertEqual(dummy_model.Test(),
                     dummy_model.GetDatasetParams('Test_X1'))
    with self.assertRaises(base_model_params.DatasetError):
      dummy_model.GetDatasetParams('Test_X2')


if __name__ == '__main__':
  test_utils.main()
